/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.utils.ItemUtils;
import java.time.Instant;
import lombok.Generated;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_3417;

public class FetchurManager {
    private static final FetchurManager instance = new FetchurManager();
    private static final long MILLISECONDS_IN_A_DAY = 86400000L;
    private final String fetchurTaskCompletedPhrase = "thanks thats probably what i needed";
    private final String fetchurAlreadyDidTaskPhrase = "come back another time, maybe tmrw";
    private static final FetchurItem[] items = new FetchurItem[]{new FetchurItem(new class_1799((class_1935)class_1802.field_8095.method_8389(), 20), "Yellow Stained Glass"), new FetchurItem(class_1802.field_8251.method_7854(), "Compass"), new FetchurItem(new class_1799((class_1935)class_1802.field_8434, 20), "Mithril"), new FetchurItem(class_1802.field_8639.method_7854(), "Firework Rocket"), new FetchurItem(ItemUtils.getTexturedHead("CHEAP_COFFEE"), "Cheap Coffee"), new FetchurItem(class_1802.field_8691.method_7854(), "Wooden Door"), new FetchurItem(new class_1799((class_1935)class_1802.field_8073, 3), "Rabbit's Feet"), new FetchurItem(class_2246.field_10375.method_8389().method_7854(), "Superboom TNT"), new FetchurItem(class_2246.field_46282.method_8389().method_7854(), "Pumpkin"), new FetchurItem(class_1802.field_8884.method_7854(), "Flint and Steel"), new FetchurItem(new class_1799((class_1935)class_1802.field_8687, 50), "Emerald"), new FetchurItem(new class_1799((class_1935)class_2246.field_10314.method_8389(), 50), "Red Wool")};
    private FetchurItem currentItemSaved = null;

    public FetchurItem getCurrentFetchurItem() {
        int dayIdx = this.getFetchurDayOfMonth(System.currentTimeMillis()) - 1;
        return items[dayIdx % items.length];
    }

    public boolean hasFetchedToday() {
        long lastTimeFetched = SkyblockAddons.getInstance().getPersistentValuesManager().getPersistentValues().getLastTimeFetchur();
        long currTime = System.currentTimeMillis();
        return currTime - lastTimeFetched < 86400000L && this.getFetchurDayOfMonth(lastTimeFetched) == this.getFetchurDayOfMonth(currTime);
    }

    private int getFetchurDayOfMonth(long currTimeMillis) {
        return Instant.ofEpochMilli(currTimeMillis).atZone(SkyblockAddons.getHypixelZoneId()).getDayOfMonth();
    }

    public void recalculateFetchurItem() {
        FetchurItem item = this.getCurrentFetchurItem();
        if (!item.equals(this.currentItemSaved)) {
            this.currentItemSaved = item;
            SkyblockAddons main = SkyblockAddons.getInstance();
            if (Feature.FETCHUR_TODAY.isEnabled(FeatureSetting.WARN_WHEN_FETCHUR_CHANGES)) {
                main.getUtils().playLoudSound(class_3417.field_14627, 0.5);
                main.getRenderListener().setTitleFeature(Feature.FETCHUR_TODAY);
            }
        }
    }

    public void saveLastTimeFetched() {
        SkyblockAddons.getInstance().getPersistentValuesManager().setLastTimeFetchur(System.currentTimeMillis());
    }

    public void postPersistentConfigLoad(long lastTimeFetched) {
        boolean hasFetchedToday;
        long currTime = System.currentTimeMillis();
        boolean bl = hasFetchedToday = currTime - lastTimeFetched < 86400000L && this.getFetchurDayOfMonth(lastTimeFetched) == this.getFetchurDayOfMonth(currTime);
        if (hasFetchedToday) {
            this.currentItemSaved = this.getCurrentFetchurItem();
        }
    }

    @Generated
    public static FetchurManager getInstance() {
        return instance;
    }

    @Generated
    public String getFetchurTaskCompletedPhrase() {
        return this.fetchurTaskCompletedPhrase;
    }

    @Generated
    public String getFetchurAlreadyDidTaskPhrase() {
        return this.fetchurAlreadyDidTaskPhrase;
    }

    @Generated
    public FetchurItem getCurrentItemSaved() {
        return this.currentItemSaved;
    }

    @Generated
    public void setCurrentItemSaved(FetchurItem currentItemSaved) {
        this.currentItemSaved = currentItemSaved;
    }

    public record FetchurItem(class_1799 itemStack, String itemText) {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object anotherObject) {
            class_1799 stack;
            Object object;
            if (!(anotherObject instanceof FetchurItem)) return false;
            FetchurItem fetchurItem = (FetchurItem)anotherObject;
            try {
                object = fetchurItem.itemStack();
                stack = object;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            Object text = object = fetchurItem.itemText();
            if (!((String)text).equals(this.itemText())) return false;
            if (!class_1799.method_7973((class_1799)stack, (class_1799)this.itemStack())) return false;
            return true;
        }
    }
}

