/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features;

import com.fix3dll.skyblockaddons.utils.ItemUtils;
import com.fix3dll.skyblockaddons.utils.TextUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1531;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class JerryPresent {
    private static final Pattern FROM_TO_PATTERN = Pattern.compile("(?:From:|To:) (?:\\[.*?] )?(?<name>\\w{1,16})");
    private static final Map<UUID, JerryPresent> jerryPresents = new HashMap<UUID, JerryPresent>();
    private final class_1531 presentStand;
    private final class_1531 fromLineStand;
    private final class_1531 toLineStand;
    private final boolean isForPlayer;
    private final boolean isFromPlayer;
    private final PresentType presentType;

    public JerryPresent(class_1531 present, class_1531 fromLine, class_1531 toLine, PresentType color) {
        this.presentStand = present;
        this.fromLineStand = fromLine;
        this.toLineStand = toLine;
        class_2561 fromLineComponent = fromLine.method_5797();
        if (fromLineComponent != null) {
            String playerName = class_310.method_1551().field_1724.method_5477().getString();
            Matcher matcher = FROM_TO_PATTERN.matcher(TextUtils.stripColor(fromLineComponent.getString()));
            this.isFromPlayer = matcher.matches() && playerName.equals(matcher.group("name"));
        } else {
            this.isFromPlayer = false;
        }
        class_2561 toLineComponent = toLine.method_5797();
        this.isForPlayer = toLineComponent != null ? "CLICK TO OPEN".equals(TextUtils.stripColor(toLineComponent.getString())) : false;
        this.presentType = color;
    }

    public boolean shouldHide() {
        return !this.isForPlayer && !this.isFromPlayer;
    }

    public static void detectJerryPresent(class_1297 targetEntity) {
        if (!(targetEntity instanceof class_1531) || !targetEntity.method_5767() || class_310.method_1551().field_1687 == null) {
            return;
        }
        if (jerryPresents.containsKey(targetEntity.method_5667())) {
            return;
        }
        List stands = class_310.method_1551().field_1687.method_18467(class_1531.class, new class_238(targetEntity.method_23317() - 0.1, targetEntity.method_23318() - 2.0, targetEntity.method_23321() - 0.1, targetEntity.method_23317() + 0.1, targetEntity.method_23318() + 2.0, targetEntity.method_23321() + 0.1));
        class_1531 present = null;
        class_1531 fromLine = null;
        class_1531 toLine = null;
        PresentType presentType = null;
        for (class_1531 stand : stands) {
            PresentType standType;
            if (stand.method_5797() != null) {
                String name = TextUtils.stripColor(stand.method_5797().getString());
                if (name.startsWith("From: ")) {
                    fromLine = stand;
                    continue;
                }
                if (!name.equals("CLICK TO OPEN") && !name.startsWith("To: ")) continue;
                toLine = stand;
                continue;
            }
            String skullID = ItemUtils.getSkullOwnerID(stand.method_6118(class_1304.field_6169));
            if (skullID == null || (standType = PresentType.fromSkullID(skullID)) == null) continue;
            present = stand;
            presentType = standType;
        }
        if (present == null || fromLine == null || toLine == null || present.method_23318() > fromLine.method_23318() || fromLine.method_23318() > toLine.method_23318()) {
            return;
        }
        JerryPresent jerryPresent = new JerryPresent(present, fromLine, toLine, presentType);
        jerryPresents.put(present.method_5667(), jerryPresent);
        jerryPresents.put(fromLine.method_5667(), jerryPresent);
        jerryPresents.put(toLine.method_5667(), jerryPresent);
    }

    @Generated
    public class_1531 getPresentStand() {
        return this.presentStand;
    }

    @Generated
    public class_1531 getFromLineStand() {
        return this.fromLineStand;
    }

    @Generated
    public class_1531 getToLineStand() {
        return this.toLineStand;
    }

    @Generated
    public boolean isForPlayer() {
        return this.isForPlayer;
    }

    @Generated
    public boolean isFromPlayer() {
        return this.isFromPlayer;
    }

    @Generated
    public PresentType getPresentType() {
        return this.presentType;
    }

    @Generated
    public static Map<UUID, JerryPresent> getJerryPresents() {
        return jerryPresents;
    }

    public static enum PresentType {
        WHITE("3047a516-415b-3bf4-b597-b78fd2a9ccf4"),
        GREEN("5fa813c0-5519-30c4-a53c-955945e93e10"),
        RED("4afe5d71-918f-3741-a969-5f785c5b2945"),
        PARTY("7709e502-6eb4-34f7-9566-264606689fb2"),
        STRAWBERRY("3150a961-c8a0-3b97-90d2-0b46d58cf67a"),
        RED_VELVET("feda593e-3195-309a-a080-2a34f0499815"),
        GREEN_VELVET("be14aa93-494e-33c7-960f-7c22639e998e"),
        CHEESECAKE("10b96870-8c24-3c83-ae17-269eca761d11"),
        BLUEBERRY("d653d288-163c-36ac-ba4b-87a0cefa42b5");

        private final String skullID;

        private PresentType(String skullID) {
            this.skullID = skullID;
        }

        public static PresentType fromSkullID(String skullID) {
            for (PresentType presentColor : PresentType.values()) {
                if (!presentColor.skullID.equals(skullID)) continue;
                return presentColor;
            }
            return null;
        }
    }
}

