/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features.backpacks;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.InventoryType;
import com.fix3dll.skyblockaddons.core.SkyblockKeyBinding;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.features.backpacks.BackpackColor;
import com.fix3dll.skyblockaddons.features.backpacks.CompressedStorage;
import com.fix3dll.skyblockaddons.features.backpacks.ContainerPreview;
import com.fix3dll.skyblockaddons.listeners.RenderListener;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import com.fix3dll.skyblockaddons.utils.ItemUtils;
import com.fix3dll.skyblockaddons.utils.TextUtils;
import com.fix3dll.skyblockaddons.utils.data.skyblockdata.ContainerData;
import com.fix3dll.skyblockaddons.utils.data.skyblockdata.LegacyIdItemMapData;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import net.minecraft.class_10799;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2479;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import net.minecraft.class_9848;
import org.apache.logging.log4j.Logger;

public class ContainerPreviewManager {
    private static final class_310 MC = class_310.method_1551();
    private static final Logger LOGGER = SkyblockAddons.getLogger();
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    private static final class_2960 CHEST_GUI_TEXTURE = SkyblockAddons.resourceLocation("containerpreview.png");
    private static final Pattern BACKPACK_STORAGE_PATTERN = Pattern.compile("Backpack Slot (?<slot>\\d+)");
    private static final Pattern ENDERCHEST_STORAGE_PATTERN = Pattern.compile("Ender Chest Page (?<page>\\d+)");
    private static ContainerPreview currentContainerPreview;
    private static UUID cachedBackpackUuid;
    private static ContainerPreview cachedContainerPreview;
    private static class_1277 containerInventory;
    private static String storageKey;
    private static boolean frozen;
    private static boolean drawingFrozenItemTooltip;

    public static ContainerPreview getFromItem(class_1799 stack) {
        if (stack == null) {
            return null;
        }
        class_2487 extraAttributes = ItemUtils.getExtraAttributes(stack);
        String skyblockID = ItemUtils.getSkyblockItemID(extraAttributes);
        ContainerData containerData = ItemUtils.getContainerData(skyblockID);
        if (extraAttributes != null && containerData != null) {
            class_2561 customName;
            List<Object> items;
            int containerSize = containerData.getSize();
            String compressedDataTag = containerData.getCompressedItemStacksTag();
            List<String> dataTags = containerData.getItemStackDataTags();
            if (compressedDataTag != null && extraAttributes.method_10545(compressedDataTag)) {
                byte[] bytes = extraAttributes.method_10547(compressedDataTag).orElse(null);
                items = ContainerPreviewManager.decompressItems(bytes);
            } else if (dataTags != null) {
                items = new ArrayList(containerSize);
                Iterator<String> dataTagsIterator = dataTags.iterator();
                for (int itemNumber = 0; itemNumber < containerSize && dataTagsIterator.hasNext(); ++itemNumber) {
                    String key = dataTagsIterator.next();
                    if (extraAttributes.method_10545(key)) {
                        extraAttributes.method_10558(key).ifPresent(id -> items.add(ItemUtils.getPersonalCompactorItemStack(id)));
                        continue;
                    }
                    class_1799 pane = class_2246.field_10305.method_8389().method_7854();
                    pane.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)("\u00a7aAuto-Craft Slot #" + (itemNumber + 1))));
                    items.add(pane);
                }
            } else {
                return null;
            }
            BackpackColor color = ItemUtils.getBackpackColor(stack);
            ContainerData.ContainerType type = containerData.getType();
            String name = type == ContainerData.ContainerType.PERSONAL_COMPACTOR || type == ContainerData.ContainerType.PERSONAL_DELETOR ? null : ((customName = stack.method_65130()) == null ? null : TextUtils.stripColor(customName.getString()));
            boolean active = extraAttributes.method_68566("PERSONAL_DELETOR_ACTIVE", false);
            return new ContainerPreview(items, name, color, containerData.getNumRows(), containerData.getNumCols(), type, active);
        }
        return null;
    }

    public static void onContainerClose() {
        if (containerInventory != null) {
            ContainerPreviewManager.saveStorageContainerInventory();
            main.getInventoryUtils().setInventoryPageNum(0);
        }
        frozen = false;
    }

    public static void onContainerOpen(@NonNull class_1277 containerInventory) {
        if (containerInventory == null) {
            throw new NullPointerException("containerInventory is marked non-null but is null");
        }
        ContainerPreviewManager.containerInventory = containerInventory;
        storageKey = main.getInventoryUtils().getInventoryKey();
    }

    public static List<class_1799> decompressItems(byte[] bytes) {
        ArrayList<class_1799> items = null;
        try {
            class_2487 decompressedData = class_2507.method_10629((InputStream)new ByteArrayInputStream(bytes), (class_2505)class_2505.method_53898());
            class_2499 list = decompressedData.method_10554("i").orElse(null);
            if (list == null || list.isEmpty()) {
                throw new Exception("Decompressed container list has no item tags");
            }
            int size = Math.min(list.size(), 54);
            items = new ArrayList<class_1799>(size);
            for (int i = 0; i < size; ++i) {
                class_2487 itemTag = list.method_68582(i);
                short itemID = itemTag.method_68565("id", (short)0);
                if (itemID == 142) {
                    itemTag.method_10575("id", (short)392);
                } else if (itemID == 141) {
                    itemTag.method_10575("id", (short)391);
                }
                if (itemTag.method_10545("tag") && itemID != 0) {
                    Object legacyId = String.valueOf(itemID);
                    short meta = itemTag.method_68565("Damage", (short)0);
                    if (meta != 0) {
                        legacyId = (String)legacyId + ":" + meta;
                    }
                    class_1799 modernItem = LegacyIdItemMapData.getItemStack((String)legacyId, itemTag.method_68565("Count", (short)1));
                    class_2487 nbt = itemTag.method_68568("tag");
                    class_9279 extraAttributes = class_9279.method_57456((class_2487)nbt.method_68568("ExtraAttributes"));
                    modernItem.method_57379(class_9334.field_49628, (Object)extraAttributes);
                    class_2487 display = nbt.method_68568("display");
                    display.method_10558("Name").ifPresent(s -> modernItem.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)s)));
                    Optional lore = display.method_10554("Lore");
                    if (lore.isPresent()) {
                        class_2499 loreTag = (class_2499)lore.get();
                        ArrayList loreCompound = new ArrayList(loreTag.size());
                        for (class_2520 item : loreTag) {
                            item.method_68658().ifPresent(s -> loreCompound.add(class_2561.method_43470((String)s)));
                        }
                        modernItem.method_57379(class_9334.field_49632, (Object)new class_9290(loreCompound));
                    }
                    items.add(i, modernItem);
                    continue;
                }
                Optional<class_1799> itemStack = ItemUtils.parseTag((class_2520)itemTag);
                items.add(i, itemStack.orElse(class_1799.field_8037));
            }
        }
        catch (Exception ex) {
            LOGGER.error("There was an error decompressing container data.", (Throwable)ex);
        }
        return items;
    }

    public static void drawContainerPreviews(class_332 graphics, class_437 screen, int mouseX, int mouseY) {
        Feature backpackPreview = Feature.SHOW_BACKPACK_PREVIEW;
        if (currentContainerPreview == null) {
            return;
        }
        graphics.method_71048();
        int x = currentContainerPreview.getX();
        int y = currentContainerPreview.getY();
        List<class_1799> items = currentContainerPreview.getItems();
        int length = items.size();
        int rows = currentContainerPreview.getNumRows();
        int cols = currentContainerPreview.getNumCols();
        int screenHeight = screen.field_22790;
        class_1799 tooltipItem = class_1799.field_8037;
        if (backpackPreview.get(FeatureSetting.BACKPACK_STYLE) == EnumUtils.BackpackStyle.GUI) {
            int textColor = -12566464;
            int containerColor = -1;
            if (backpackPreview.isEnabled(FeatureSetting.MAKE_INVENTORY_COLORED)) {
                BackpackColor color = currentContainerPreview.getBackpackColor();
                ContainerData.ContainerType type = currentContainerPreview.getContainerType();
                if (color != null && color != BackpackColor.DEFAULT) {
                    containerColor = class_9848.method_61318((float)1.0f, (float)color.getR(), (float)color.getG(), (float)color.getB());
                    textColor = color.getInventoryTextColor();
                } else if (type == ContainerData.ContainerType.PERSONAL_COMPACTOR || type == ContainerData.ContainerType.PERSONAL_DELETOR) {
                    containerColor = currentContainerPreview.isActive() ? class_9848.method_61318((float)1.0f, (float)0.306f, (float)0.533f, (float)0.173f) : class_9848.method_61318((float)1.0f, (float)0.733f, (float)0.227f, (float)0.176f);
                }
            }
            int textureBorder = 7;
            int textureTopBorder = 17;
            int textureItemSquare = 18;
            int topBorder = currentContainerPreview.getName() == null ? 7 : 17;
            int totalWidth = cols * 18 + 14;
            int totalHeight = rows * 18 + topBorder + 7;
            int squaresEndWidth = totalWidth - 7;
            int squaresEndHeight = totalHeight - 7;
            if (x + totalWidth > screen.field_22789) {
                x -= totalWidth;
            }
            if (y + totalHeight > screenHeight) {
                y = screenHeight - totalHeight;
            }
            if (currentContainerPreview.getName() == null) {
                graphics.method_25291(class_10799.field_56883, CHEST_GUI_TEXTURE, x, y, 0.0f, 0.0f, squaresEndWidth, topBorder, 256, 256, containerColor);
                graphics.method_25291(class_10799.field_56883, CHEST_GUI_TEXTURE, x, y + topBorder, 0.0f, 17.0f, squaresEndWidth, squaresEndHeight - topBorder, 256, 256, containerColor);
            } else {
                graphics.method_25291(class_10799.field_56883, CHEST_GUI_TEXTURE, x, y, 0.0f, 0.0f, squaresEndWidth, squaresEndHeight, 256, 256, containerColor);
            }
            graphics.method_25291(class_10799.field_56883, CHEST_GUI_TEXTURE, x + squaresEndWidth, y, 169.0f, 0.0f, 7, squaresEndHeight, 256, 256, containerColor);
            graphics.method_25291(class_10799.field_56883, CHEST_GUI_TEXTURE, x, y + squaresEndHeight, 0.0f, 125.0f, squaresEndWidth, 7, 256, 256, containerColor);
            graphics.method_25291(class_10799.field_56883, CHEST_GUI_TEXTURE, x + squaresEndWidth, y + squaresEndHeight, 169.0f, 125.0f, 7, 7, 256, 256, containerColor);
            if (currentContainerPreview.getName() != null) {
                Object name = currentContainerPreview.getName();
                if (main.getUtils().isUsingFSRcontainerPreviewTexture()) {
                    name = String.valueOf(ColorCode.GOLD) + TextUtils.stripColor((String)name);
                }
                graphics.method_51433(ContainerPreviewManager.MC.field_1772, (String)name, x + 8, y + 6, textColor, false);
            }
            int itemStartX = x + 7 + 1;
            int itemStartY = y + topBorder + 1;
            for (int i = 0; i < length; ++i) {
                class_1799 item = items.get(i);
                if (item == null) continue;
                int itemX = itemStartX + i % cols * 18;
                int itemY = itemStartY + i / cols * 18;
                RenderListener.renderItemAndOverlay(graphics, item, null, itemX, itemY);
                if (!frozen || mouseX <= itemX || mouseX >= itemX + 16 || mouseY <= itemY || mouseY >= itemY + 16) continue;
                tooltipItem = item;
            }
        } else {
            int totalHeight;
            int totalWidth = 16 * cols + 3;
            if (x + totalWidth > screen.field_22789) {
                x -= totalWidth;
            }
            if (y + (totalHeight = 16 * rows + 3) > screenHeight) {
                y = screenHeight - totalHeight;
            }
            graphics.method_48196(class_10799.field_56879, x - 3, y - 3, x + totalWidth, y + totalHeight, ContainerPreviewManager.getRectColor());
            for (int i = 0; i < length; ++i) {
                class_1799 item = items.get(i);
                if (item == null) continue;
                int itemX = x + i % cols * 16;
                int itemY = y + i / cols * 16;
                RenderListener.renderItemAndOverlay(graphics, item, null, itemX, itemY);
                if (!frozen || mouseX <= itemX || mouseX >= itemX + 16 || mouseY <= itemY || mouseY >= itemY + 16) continue;
                tooltipItem = item;
            }
        }
        if (!tooltipItem.method_7960()) {
            graphics.method_71048();
            drawingFrozenItemTooltip = true;
            graphics.method_51446(ContainerPreviewManager.MC.field_1772, tooltipItem, mouseX, mouseY);
            drawingFrozenItemTooltip = false;
        }
        if (!frozen) {
            currentContainerPreview = null;
        }
    }

    public static ContainerPreview getFromStorageBackpack(class_1799 stack, List<class_1799> items) {
        if (items == null) {
            return null;
        }
        String stackName = stack.method_65130() == null ? "?" : stack.method_65130().getString();
        BackpackColor color = ItemUtils.getBackpackColor(stack);
        String skyblockID = TextUtils.getBackpackIDFromLore(ItemUtils.getItemLore(stack).getFirst());
        ContainerData containerData = ItemUtils.getContainerData(skyblockID);
        int rows = 6;
        int cols = 9;
        ContainerData.ContainerType containerType = null;
        if (containerData != null) {
            rows = Math.min(containerData.getNumRows(), 5);
            cols = containerData.getNumCols();
            containerType = containerData.getType();
        } else if (stackName.toUpperCase(Locale.US).startsWith("ENDER CHEST")) {
            rows = Math.min(5, (int)Math.ceil((float)items.size() / 9.0f));
            containerType = ContainerData.ContainerType.BACKPACK;
        }
        return new ContainerPreview(items, stackName, color, rows, cols, containerType);
    }

    public static void onContainerKeyTyped(int keyCode) {
        if (keyCode == 1 || keyCode == ContainerPreviewManager.MC.field_1690.field_1822.field_1655.method_1444()) {
            frozen = false;
            currentContainerPreview = null;
            cachedContainerPreview = null;
        }
        if (cachedContainerPreview != null && keyCode == SkyblockKeyBinding.FREEZE_BACKPACK.getKeyCode()) {
            frozen = !frozen;
            currentContainerPreview = cachedContainerPreview;
        }
    }

    public static boolean onRenderTooltip(class_1799 itemStack, int x, int y) {
        if (frozen && !drawingFrozenItemTooltip) {
            return true;
        }
        if (Feature.SHOW_BACKPACK_PREVIEW.isDisabled()) {
            return false;
        }
        Feature backpackPreview = Feature.SHOW_BACKPACK_PREVIEW;
        if (backpackPreview.isEnabled(FeatureSetting.SHOW_ONLY_WHEN_HOLDING_SHIFT) && !MC.method_74187()) {
            return false;
        }
        UUID newUuid = ItemUtils.getUuid(itemStack);
        String hoverName = itemStack.method_7964().getString();
        Matcher m = ENDERCHEST_STORAGE_PATTERN.matcher(hoverName);
        if (newUuid == null && !m.find()) {
            return false;
        }
        if (cachedBackpackUuid == null || !cachedBackpackUuid.equals(newUuid)) {
            cachedBackpackUuid = newUuid;
            cachedContainerPreview = null;
            if (main.getInventoryUtils().getInventoryType() == InventoryType.STORAGE) {
                Map<String, CompressedStorage> cache;
                String storageKey = null;
                if (m.hasMatch()) {
                    int enderChestPage = Integer.parseInt(m.group("page"));
                    storageKey = InventoryType.ENDER_CHEST.getInventoryName() + enderChestPage;
                } else {
                    m = BACKPACK_STORAGE_PATTERN.matcher(hoverName);
                    if (m.matches()) {
                        int pageNum = Integer.parseInt(m.group("slot"));
                        storageKey = InventoryType.STORAGE_BACKPACK.getInventoryName() + pageNum;
                    }
                }
                if (storageKey != null && (cache = SkyblockAddons.getInstance().getPersistentValuesManager().getPersistentValues().getStorageCache()).get(storageKey) != null) {
                    byte[] bytes = cache.get(storageKey).getStorage();
                    List<class_1799> items = ContainerPreviewManager.decompressItems(bytes);
                    items = items.subList(9, items.size());
                    cachedContainerPreview = ContainerPreviewManager.getFromStorageBackpack(itemStack, items);
                }
            }
            if (cachedContainerPreview == null) {
                class_476 cScreen;
                class_1703 class_17032;
                ContainerData containerData = ItemUtils.getContainerData(ItemUtils.getSkyblockItemID(itemStack));
                if (containerData == null || containerData.isCakeBag() && backpackPreview.isDisabled(FeatureSetting.CAKE_BAG_PREVIEW) || (containerData.isBuildersRuler() || containerData.isBuildersWand()) && backpackPreview.isDisabled(FeatureSetting.BUILDERS_TOOL_PREVIEW) || (containerData.isPersonalCompactor() || containerData.isPersonalDeletor()) && backpackPreview.isDisabled(FeatureSetting.PERSONAL_COMPACTOR_PREVIEW) || (containerData.isBasketOfSeeds() || containerData.isNetherWartPouch()) && backpackPreview.isDisabled(FeatureSetting.FARMING_TOOLS_PREVIEW)) {
                    return false;
                }
                class_437 screen = ContainerPreviewManager.MC.field_1755;
                if (screen instanceof class_476 && (class_17032 = (cScreen = (class_476)screen).method_17577()) instanceof class_1707) {
                    class_1707 chestMenu = (class_1707)class_17032;
                    class_1263 chestInventory = chestMenu.method_7629();
                    String chestName = cScreen.method_25440().getString();
                    if (!chestName.isEmpty() && (chestName.contains("Auction") || "Your Bids".equals(chestName))) {
                        for (int slotNumber = 0; slotNumber < chestInventory.method_5439(); ++slotNumber) {
                            if (chestInventory.method_5438(slotNumber) != itemStack) continue;
                            return false;
                        }
                    }
                }
                cachedContainerPreview = ContainerPreviewManager.getFromItem(itemStack);
            }
        }
        if (cachedContainerPreview != null) {
            cachedContainerPreview.setX(x);
            cachedContainerPreview.setY(y);
            if (!frozen) {
                currentContainerPreview = cachedContainerPreview;
            }
            return true;
        }
        return frozen;
    }

    public static class_2479 getCompressedInventoryContents(class_1263 inventory) {
        if (inventory == null) {
            return null;
        }
        class_1799[] list = new class_1799[inventory.method_5439()];
        for (int slotNumber = 0; slotNumber < inventory.method_5439(); ++slotNumber) {
            list[slotNumber] = inventory.method_5438(slotNumber);
        }
        return ItemUtils.getCompressedNBT(list);
    }

    public static void saveStorageContainerInventory(class_1277 inventory, String storageKey) {
        if (inventory == null) {
            throw new NullPointerException("Cannot save contents of a null inventory.");
        }
        if (storageKey == null) {
            throw new NullPointerException("Storage key is required to save the container's inventory.");
        }
        if (!storageKey.equals(ContainerPreviewManager.storageKey)) {
            if (containerInventory != null) {
                ContainerPreviewManager.saveStorageContainerInventory();
            }
            ContainerPreviewManager.storageKey = storageKey;
        } else {
            boolean dirty;
            Map<String, CompressedStorage> cache = SkyblockAddons.getInstance().getPersistentValuesManager().getPersistentValues().getStorageCache();
            CompressedStorage cachedContainer = cache.get(storageKey);
            byte[] previousCache = cachedContainer == null ? null : cachedContainer.getStorage();
            byte[] inventoryContents = ContainerPreviewManager.getCompressedInventoryContents((class_1263)inventory).method_10521();
            boolean bl = dirty = previousCache == null || !Arrays.equals(previousCache, inventoryContents);
            if (dirty) {
                if (cachedContainer == null) {
                    cache.put(storageKey, new CompressedStorage(inventoryContents));
                    LOGGER.info("Cached new container {}.", (Object)storageKey);
                } else {
                    cachedContainer.setStorage(inventoryContents);
                    LOGGER.info("Refreshed cache for container {}.", (Object)storageKey);
                }
                SkyblockAddons.getInstance().getPersistentValuesManager().saveValues();
            }
            ContainerPreviewManager.resetCurrentContainer();
        }
    }

    public static void saveStorageContainerInventory() {
        ContainerPreviewManager.saveStorageContainerInventory(containerInventory, storageKey);
    }

    private static void resetCurrentContainer() {
        containerInventory = null;
        storageKey = null;
    }

    private static int getRectColor() {
        ContainerData.ContainerType type;
        int rectColor = ColorCode.DARK_GRAY.getColor(250);
        if (Feature.SHOW_BACKPACK_PREVIEW.isEnabled(FeatureSetting.MAKE_INVENTORY_COLORED) && ((type = currentContainerPreview.getContainerType()) == ContainerData.ContainerType.PERSONAL_COMPACTOR || type == ContainerData.ContainerType.PERSONAL_DELETOR)) {
            rectColor = currentContainerPreview.isActive() ? ColorCode.DARK_GREEN.getColor(250) : ColorCode.DARK_RED.getColor(250);
        }
        return rectColor;
    }

    @Generated
    public static boolean isFrozen() {
        return frozen;
    }
}

