/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features.enchants;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.InventoryType;
import com.fix3dll.skyblockaddons.core.Translations;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.features.enchants.EnchantLayout;
import com.fix3dll.skyblockaddons.utils.DrawUtils;
import com.fix3dll.skyblockaddons.utils.ItemUtils;
import com.fix3dll.skyblockaddons.utils.RomanNumeralParser;
import com.fix3dll.skyblockaddons.utils.TextUtils;
import com.fix3dll.skyblockaddons.utils.data.skyblockdata.EnchantmentsData;
import com.fix3dll.skyblockaddons.utils.objects.RegistrableEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.minecraft.class_1041;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_9304;

public class EnchantManager {
    private static final Pattern ENCHANTMENT_PATTERN = Pattern.compile("(?<enchant>[A-Za-z][A-Za-z -]+) (?<levelNumeral>[IVXLCDM]+)(?=, |$| [\\d,]+$)");
    private static final Pattern GREY_ENCHANT_PATTERN = Pattern.compile("^(Respiration|Aqua Affinity|Depth Strider|Efficiency).*");
    private static final String COMMA = ", ";
    private static final Cache LORE_CACHE = new Cache();
    private static EnchantmentsData enchants = new EnchantmentsData();
    private static final Pattern ENCHANT_SPLITTER = Pattern.compile("\u00a7.(?:\u00a7.)?[^\u00a7]*");
    public static Function<String, class_5250> CREATE_STYLED_COMPONENT = enchantString -> {
        class_5250 component = class_2561.method_43473();
        Matcher m = ENCHANT_SPLITTER.matcher((CharSequence)enchantString);
        while (m.find()) {
            String part = m.group();
            if (part.contains(ColorCode.CHROMA.toString())) {
                component.method_10852((class_2561)class_2561.method_43470((String)part).method_27696(class_2583.field_24360.method_27703(DrawUtils.CHROMA_TEXT_COLOR)));
                continue;
            }
            component.method_27693(part);
        }
        return component.method_10855().isEmpty() ? class_2561.method_43470((String)enchantString) : component;
    };

    /*
     * WARNING - void declaration
     */
    public static void parseEnchants(List<class_2561> loreList, class_1799 item) {
        ArrayList<class_2561> insertEnchants;
        int i;
        Map<String, Integer> enchantments = ItemUtils.getEnchantments(item);
        if (enchantments.isEmpty() && SkyblockAddons.getInstance().getInventoryUtils().getInventoryType() != InventoryType.SUPERPAIRS) {
            return;
        }
        if (LORE_CACHE.isCached(loreList)) {
            loreList.clear();
            loreList.addAll(LORE_CACHE.getCachedAfter());
            return;
        }
        LORE_CACHE.updateBefore(loreList);
        Feature feature = Feature.ENCHANTMENT_LORE_PARSING;
        class_327 font = class_310.method_1551().field_1772;
        int startEnchant = -1;
        int endEnchant = -1;
        int maxTooltipWidth = 0;
        int indexOfLastGreyEnchant = EnchantManager.accountForAndRemoveGreyEnchants(loreList, item);
        int n = i = indexOfLastGreyEnchant == -1 ? 0 : indexOfLastGreyEnchant + 1;
        while (i < loreList.size()) {
            class_2561 line = loreList.get(i);
            String strippedLine = TextUtils.stripColor(line.getString());
            if (startEnchant == -1) {
                if (EnchantManager.containsEnchantment(item, strippedLine)) {
                    startEnchant = i;
                }
            } else if (strippedLine.trim().isEmpty() && endEnchant == -1) {
                endEnchant = i - 1;
            }
            if (startEnchant == -1 || endEnchant != -1) {
                maxTooltipWidth = Math.max(font.method_27525((class_5348)loreList.get(i)), maxTooltipWidth);
            }
            ++i;
        }
        if (enchantments.isEmpty() && endEnchant == -1) {
            endEnchant = startEnchant;
        }
        if (endEnchant == -1) {
            LORE_CACHE.updateAfter(loreList);
            return;
        }
        maxTooltipWidth = EnchantManager.correctTooltipWidth(maxTooltipWidth);
        boolean hasLore = false;
        TreeSet<FormattedEnchant> orderedEnchants = new TreeSet<FormattedEnchant>();
        FormattedEnchant lastEnchant = null;
        for (int i2 = startEnchant; i2 <= endEnchant; ++i2) {
            String unformattedLine = TextUtils.stripColor(loreList.get(i2).getString());
            Matcher m = ENCHANTMENT_PATTERN.matcher(unformattedLine);
            boolean containsEnchant = false;
            while (m.find()) {
                EnchantmentsData.Enchant enchant = enchants.getFromLore(m.group("enchant"));
                int level = RomanNumeralParser.parseNumeral(m.group("levelNumeral"));
                if (enchant == null) continue;
                String inputFormatEnchant = "null";
                if (feature.isDisabled(FeatureSetting.HIGHLIGHT_ENCHANTMENTS)) {
                    inputFormatEnchant = TextUtils.getFormattedString(loreList.get(i2).getString(), m.group());
                }
                if (!orderedEnchants.add(lastEnchant = new FormattedEnchant(enchant, level, inputFormatEnchant))) {
                    for (FormattedEnchant e : orderedEnchants) {
                        if (e.compareTo(lastEnchant) != 0) continue;
                        lastEnchant = e;
                        break;
                    }
                }
                containsEnchant = true;
            }
            if (containsEnchant || lastEnchant == null) continue;
            lastEnchant.addLore(loreList.get(i2));
            hasLore = true;
        }
        int numEnchants = orderedEnchants.size();
        for (FormattedEnchant enchant : orderedEnchants) {
            maxTooltipWidth = Math.max(enchant.getRenderLength(), maxTooltipWidth);
        }
        if (orderedEnchants.isEmpty()) {
            LORE_CACHE.updateAfter(loreList);
            return;
        }
        loreList.subList(startEnchant, endEnchant + 1).clear();
        RegistrableEnum layout = feature.getAsEnum(FeatureSetting.ENCHANT_LAYOUT);
        if (layout == EnchantLayout.COMPRESS && numEnchants != 1) {
            insertEnchants = new ArrayList<class_2561>();
            String comma = String.valueOf(feature.getAsEnum(FeatureSetting.COMMA_ENCHANT_COLOR)) + COMMA;
            int n2 = font.method_1727(comma);
            int sum = 0;
            StringBuilder builder = new StringBuilder(maxTooltipWidth);
            for (FormattedEnchant enchant : orderedEnchants) {
                if (sum + enchant.getRenderLength() > maxTooltipWidth) {
                    builder.delete(builder.length() - comma.length(), builder.length());
                    insertEnchants.add((class_2561)CREATE_STYLED_COMPONENT.apply(builder.toString()));
                    builder = new StringBuilder(maxTooltipWidth);
                    sum = 0;
                }
                builder.append(enchant.getFormattedString()).append(comma);
                sum += enchant.getRenderLength() + n2;
            }
            if (builder.length() >= comma.length()) {
                builder.delete(builder.length() - comma.length(), builder.length());
                insertEnchants.add((class_2561)CREATE_STYLED_COMPONENT.apply(builder.toString()));
            }
        } else if (layout == EnchantLayout.NORMAL && !hasLore) {
            insertEnchants = new ArrayList();
            Object comma = feature.isEnabled(FeatureSetting.HIGHLIGHT_ENCHANTMENTS) ? String.valueOf(feature.getAsEnum(FeatureSetting.COMMA_ENCHANT_COLOR)) + COMMA : COMMA;
            boolean bl = false;
            StringBuilder builder = new StringBuilder(maxTooltipWidth);
            for (FormattedEnchant enchant : orderedEnchants) {
                void var16_23;
                builder.append(enchant.getFormattedString());
                if (var16_23 % 2 == false) {
                    builder.append((String)comma);
                } else {
                    insertEnchants.add((class_2561)CREATE_STYLED_COMPONENT.apply(builder.toString()));
                    builder = new StringBuilder(maxTooltipWidth);
                }
                ++var16_23;
            }
            if (builder.length() >= ((String)comma).length()) {
                builder.delete(builder.length() - ((String)comma).length(), builder.length());
                insertEnchants.add((class_2561)CREATE_STYLED_COMPONENT.apply(builder.toString()));
            }
        } else if (feature.isDisabled(FeatureSetting.HIDE_ENCHANTMENT_LORE)) {
            insertEnchants = new ArrayList((hasLore ? 3 : 1) * numEnchants);
            for (FormattedEnchant formattedEnchant : orderedEnchants) {
                insertEnchants.add((class_2561)CREATE_STYLED_COMPONENT.apply(formattedEnchant.getFormattedString()));
                insertEnchants.addAll(formattedEnchant.getLore());
            }
        } else {
            insertEnchants = new ArrayList(numEnchants);
            for (FormattedEnchant formattedEnchant : orderedEnchants) {
                insertEnchants.add((class_2561)CREATE_STYLED_COMPONENT.apply(formattedEnchant.getFormattedString()));
            }
        }
        loreList.addAll(startEnchant, insertEnchants);
        LORE_CACHE.updateAfter(loreList);
    }

    public static int insertStackingEnchantProgress(List<class_2561> loreList, class_2487 extraAttributes, int insertAt) {
        if (extraAttributes == null || Feature.SHOW_STACKING_ENCHANT_PROGRESS.isDisabled()) {
            return insertAt;
        }
        for (EnchantmentsData.Enchant.Stacking enchant : enchants.getStacking().values()) {
            if (!extraAttributes.method_10545(enchant.getNbtNum())) continue;
            long stackedEnchantNum = extraAttributes.method_68080(enchant.getNbtNum(), 0L);
            Long nextLevel = enchant.getStackLevel().higher(stackedEnchantNum);
            String statLabel = Translations.getMessage("enchants." + enchant.getStatLabel(), new Object[0]);
            ColorCode colorCode = Feature.SHOW_STACKING_ENCHANT_PROGRESS.getRestrictedColor();
            StringBuilder b = new StringBuilder();
            b.append("\u00a77").append(statLabel).append(": ").append(colorCode);
            if (nextLevel == null) {
                b.append(TextUtils.abbreviate(stackedEnchantNum)).append(" \u00a77(").append(Translations.getMessage("enchants.maxed", new Object[0])).append(")");
            } else {
                String format = TextUtils.formatNumber(stackedEnchantNum);
                b.append(format).append(" \u00a77/ ").append(TextUtils.abbreviate(nextLevel));
            }
            loreList.add(insertAt++, (class_2561)class_2561.method_43470((String)b.toString()));
        }
        return insertAt;
    }

    public static boolean containsEnchantment(class_1799 itemStack, String strippedLine) {
        Map<String, Integer> enchantments = ItemUtils.getEnchantments(itemStack);
        Map<String, Integer> attributes = ItemUtils.getAttributes(itemStack);
        Matcher m = ENCHANTMENT_PATTERN.matcher(strippedLine);
        while (m.find()) {
            EnchantmentsData.Enchant enchant = enchants.getFromLore(m.group("enchant"));
            if (enchantments != null && !enchantments.containsKey(enchant.getNbtName()) || attributes != null && attributes.containsKey(enchant.getNbtName())) continue;
            return true;
        }
        return false;
    }

    private static int accountForAndRemoveGreyEnchants(List<class_2561> tooltip, class_1799 item) {
        if (item.method_58657() == class_9304.field_49385 || item.method_58657().method_57543()) {
            return -1;
        }
        int lastGreyEnchant = -1;
        boolean removeGreyEnchants = Feature.ENCHANTMENT_LORE_PARSING.isEnabled(FeatureSetting.HIDE_GREY_ENCHANTS);
        int i = 1;
        for (int total = 0; total < 1 + item.method_58657().method_57541() && i < tooltip.size(); ++total) {
            String line = tooltip.get(i).getString();
            if (GREY_ENCHANT_PATTERN.matcher(line).matches()) {
                lastGreyEnchant = i;
                if (!removeGreyEnchants) continue;
                tooltip.remove(i);
                continue;
            }
            ++i;
        }
        return removeGreyEnchants ? -1 : lastGreyEnchant;
    }

    private static int correctTooltipWidth(int maxTooltipWidth) {
        class_1041 window = class_310.method_1551().method_22683();
        int mouseX = (int)class_310.method_1551().field_1729.method_1603();
        int tooltipX = mouseX + 12;
        if (tooltipX + maxTooltipWidth + 4 > window.method_4486() && (tooltipX = mouseX - 16 - maxTooltipWidth) < 4) {
            maxTooltipWidth = mouseX > window.method_4486() / 2 ? mouseX - 12 - 8 : window.method_4486() - 16 - mouseX;
        }
        if (window.method_4486() > 0 && maxTooltipWidth > window.method_4486()) {
            maxTooltipWidth = window.method_4486();
        }
        return maxTooltipWidth;
    }

    public static void markCacheDirty() {
        EnchantManager.LORE_CACHE.configChanged = true;
    }

    @Generated
    public static void setEnchants(EnchantmentsData enchants) {
        EnchantManager.enchants = enchants;
    }

    static class Cache {
        ArrayList<class_2561> cachedAfter = new ArrayList();
        boolean configChanged;
        private ArrayList<class_2561> cachedBefore = new ArrayList();

        public void updateBefore(List<class_2561> loreBeforeModifications) {
            this.cachedBefore = new ArrayList<class_2561>(loreBeforeModifications);
        }

        public void updateAfter(List<class_2561> loreAfterModifications) {
            this.cachedAfter = new ArrayList<class_2561>(loreAfterModifications);
            this.configChanged = false;
        }

        public boolean isCached(List<class_2561> loreBeforeModifications) {
            if (this.configChanged || loreBeforeModifications.size() != this.cachedBefore.size()) {
                return false;
            }
            for (int i = 0; i < loreBeforeModifications.size(); ++i) {
                if (loreBeforeModifications.get(i).equals((Object)this.cachedBefore.get(i))) continue;
                return false;
            }
            return true;
        }

        @Generated
        public ArrayList<class_2561> getCachedAfter() {
            return this.cachedAfter;
        }

        @Generated
        public ArrayList<class_2561> getCachedBefore() {
            return this.cachedBefore;
        }
    }

    static class FormattedEnchant
    implements Comparable<FormattedEnchant> {
        EnchantmentsData.Enchant enchant;
        int level;
        List<class_2561> loreDescription;
        String inputFormattedString;

        public FormattedEnchant(EnchantmentsData.Enchant theEnchant, int theLevel, String theFormattedEnchant) {
            this.enchant = theEnchant;
            this.level = theLevel;
            this.inputFormattedString = theFormattedEnchant;
            this.loreDescription = new ArrayList<class_2561>();
        }

        public void addLore(class_2561 lineOfEnchantLore) {
            this.loreDescription.add(lineOfEnchantLore);
        }

        public List<class_2561> getLore() {
            return this.loreDescription;
        }

        @Override
        public int compareTo(FormattedEnchant o) {
            return this.enchant.compareTo(o.enchant);
        }

        public int getRenderLength() {
            return class_310.method_1551().field_1772.method_1727(this.getFormattedString());
        }

        public String getFormattedString() {
            StringBuilder b = new StringBuilder();
            if (!Feature.ENCHANTMENT_LORE_PARSING.isEnabled(FeatureSetting.HIGHLIGHT_ENCHANTMENTS)) {
                return this.inputFormattedString;
            }
            b.append(this.enchant.getFormattedName(this.level));
            b.append(" ");
            if (Feature.REPLACE_ROMAN_NUMERALS_WITH_NUMBERS.isEnabled()) {
                b.append(this.level);
            } else {
                b.append(RomanNumeralParser.integerToRoman(this.level));
            }
            return b.toString();
        }
    }
}

