/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features.healingcircle;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.features.healingcircle.HealingCircle;
import com.fix3dll.skyblockaddons.features.healingcircle.HealingCircleParticle;
import com.fix3dll.skyblockaddons.utils.ColorUtils;
import com.fix3dll.skyblockaddons.utils.DrawUtils;
import com.fix3dll.skyblockaddons.utils.MathUtils;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.geom.Point2D;
import java.util.Iterator;
import java.util.Set;
import lombok.Generated;
import net.minecraft.class_10799;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class HealingCircleManager {
    public static final RenderPipeline HEALING_CIRCLE_PIPELINE = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_60125}).withLocation("sba_healing_circle").withVertexShader("core/position_color").withFragmentShader("core/position_color").withBlend(BlendFunction.TRANSLUCENT).withCull(false).withDepthWrite(true).withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27382).build());
    private static final class_1921 HEALING_CIRCLE = class_1921.method_24049((String)"sba_healing_circle", (int)1536, (boolean)true, (boolean)true, (RenderPipeline)HEALING_CIRCLE_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23617(false));
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    private static final Set<HealingCircle> healingCircles = Sets.newConcurrentHashSet();

    public static void addHealingCircleParticle(HealingCircleParticle healingCircleParticle) {
        HealingCircle nearbyHealingCircle = null;
        for (HealingCircle healingCircle : healingCircles) {
            if (healingCircle.hasCachedCenterPoint()) {
                Point2D.Double circleCenter = healingCircle.getCircleCenter();
                if (!(healingCircleParticle.getPoint().distance(circleCenter.getX(), circleCenter.getY()) < (double)((HealingCircle.getDiameter() + 2.0f) / 2.0f))) continue;
                nearbyHealingCircle = healingCircle;
                break;
            }
            if (!(healingCircleParticle.getPoint().distance(healingCircle.getAverageX(), healingCircle.getAverageZ()) < (double)(HealingCircle.getDiameter() + 2.0f))) continue;
            nearbyHealingCircle = healingCircle;
            break;
        }
        if (nearbyHealingCircle != null) {
            nearbyHealingCircle.addPoint(healingCircleParticle);
        } else {
            healingCircles.add(new HealingCircle(healingCircleParticle));
        }
    }

    public static void renderHealingCircleOverlays(class_4597.class_4598 source, class_4587 poseStack) {
        Feature feature = Feature.SHOW_HEALING_CIRCLE_WALL;
        if (main.getUtils().isOnSkyblock() && feature.isEnabled()) {
            Iterator<HealingCircle> healingCircleIterator = healingCircles.iterator();
            while (healingCircleIterator.hasNext()) {
                HealingCircle healingCircle = healingCircleIterator.next();
                healingCircle.removeOldParticles();
                if (System.currentTimeMillis() - healingCircle.getCreation() > 1000L && healingCircle.getParticlesPerSecond() < 10.0) {
                    healingCircleIterator.remove();
                    continue;
                }
                Point2D.Double circleCenter = healingCircle.getCircleCenter();
                if (circleCenter == null || Double.isNaN(circleCenter.getX()) || Double.isNaN(circleCenter.getY()) || poseStack == null || source == null) continue;
                int color = feature.getColor(ColorUtils.getAlphaIntFromFloat(MathUtils.clamp(feature.getAsNumber(FeatureSetting.HEALING_CIRCLE_OPACITY).floatValue(), 0.0f, 1.0f)));
                DrawUtils.drawCylinder(poseStack, source.method_73477(HEALING_CIRCLE), circleCenter.getX(), 0.0, circleCenter.getY(), HealingCircle.getRadius(), 255.0f, ColorUtils.getDummySkyblockColor(color, feature.isChroma()));
            }
        }
    }

    @Generated
    public static Set<HealingCircle> getHealingCircles() {
        return healingCircles;
    }
}

