/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features.tablist;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.EssenceType;
import com.fix3dll.skyblockaddons.core.Island;
import com.fix3dll.skyblockaddons.core.SkillType;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.features.spooky.SpookyEventManager;
import com.fix3dll.skyblockaddons.features.tablist.ParsedTabColumn;
import com.fix3dll.skyblockaddons.features.tablist.ParsedTabSection;
import com.fix3dll.skyblockaddons.features.tablist.RenderColumn;
import com.fix3dll.skyblockaddons.features.tablist.TabLine;
import com.fix3dll.skyblockaddons.features.tablist.TabStringType;
import com.fix3dll.skyblockaddons.utils.LocationUtils;
import com.fix3dll.skyblockaddons.utils.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.minecraft.class_310;
import net.minecraft.class_355;
import net.minecraft.class_634;
import net.minecraft.class_640;

public class TabListParser {
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    public static final String HYPIXEL_ADVERTISEMENT_CONTAINS = "HYPIXEL.NET";
    private static final Pattern GOD_POTION_PATTERN = Pattern.compile("You have a God Potion active! (?<timer>[\\w ]+)");
    private static final Pattern ACTIVE_EFFECTS_PATTERN = Pattern.compile("Active Effects(?:\u00a7.)*(?:\\n(?:\u00a7.)*\u00a77.+)*");
    private static final Pattern EFFECT_COUNT_PATTERN = Pattern.compile("You have (?<effectCount>[0-9]+) active effect");
    private static final Pattern COOKIE_BUFF_PATTERN = Pattern.compile("Cookie Buff(?:\u00a7.)*(?:\\n(\u00a7.)*\u00a77.+)*");
    private static final Pattern UPGRADES_PATTERN = Pattern.compile("(?<firstPart>\u00a7e[A-Za-z ]+)(?<secondPart> \u00a7f[\\w ]+)");
    private static final Pattern CANDY_PATTERN = Pattern.compile("Your Candy: \u00a7r\u00a7a(?<green>[0-9,]+) Green\u00a7r\u00a77, \u00a7r\u00a75(?<purple>[0-9,]+) Purple \u00a7r\u00a77\\(\u00a7r\u00a76(?<points>[0-9,]+) \u00a7r\u00a77pts\\.\\)");
    private static final Pattern DUNGEON_BUFF_PATTERN = Pattern.compile("No Buffs active. Find them by exploring the Dungeon!");
    private static final Pattern RAIN_TIME_PATTERN = Pattern.compile("Rain: (?<time>[0-9dhms ]+)");
    private static final Pattern SKILL_LEVEL_PATTERN = Pattern.compile("(?<skill>[A-Za-z]+) (?<level>[0-9]+): (?:[0-9.,]+%|MAX)?");
    private static final Pattern OLD_SKILL_LEVEL_PATTERN = Pattern.compile("Skills: (?<skill>[A-Za-z]+) (?<level>[0-9]+).*");
    private static final Pattern JERRY_POWER_UPS_PATTERN = Pattern.compile("Active Power Ups(?:\u00a7.)*(?:\\n(\u00a7.)*\u00a77.+)*");
    private static List<RenderColumn> renderColumns;
    private static String parsedRainTime;
    private static final Pattern TABLIST_S;

    public static void parse() {
        class_310 mc = class_310.method_1551();
        if (!main.getUtils().isOnSkyblock() || TabListParser.isRelatedFeaturesDisabled()) {
            renderColumns = null;
            return;
        }
        if (mc.field_1724 == null || !mc.field_1724.field_3944.method_48106()) {
            renderColumns = null;
            return;
        }
        class_634 connection = mc.field_1724.field_3944;
        List<class_640> fullList = connection.method_45732().stream().sorted(Comparator.comparing(playerInfo -> playerInfo.method_2966().name())).toList();
        if (fullList.size() < 80) {
            renderColumns = null;
            return;
        }
        fullList = fullList.subList(0, 80);
        List<ParsedTabColumn> columns = TabListParser.parseColumns(fullList);
        ParsedTabColumn footerAsColumn = TabListParser.parseFooterAsColumn();
        if (footerAsColumn != null) {
            columns.add(footerAsColumn);
        }
        TabListParser.parseSections(columns);
        renderColumns = new LinkedList<RenderColumn>();
        RenderColumn renderColumn = new RenderColumn();
        renderColumns.add(renderColumn);
        TabListParser.combineColumnsToRender(columns, renderColumn);
    }

    public static ParsedTabColumn getColumnFromName(List<ParsedTabColumn> columns, String name) {
        for (ParsedTabColumn parsedTabColumn : columns) {
            if (!name.equals(parsedTabColumn.getTitle())) continue;
            return parsedTabColumn;
        }
        return null;
    }

    private static List<ParsedTabColumn> parseColumns(List<class_640> fullList) {
        class_355 tabList = class_310.method_1551().field_1705.method_1750();
        LinkedList<ParsedTabColumn> columns = new LinkedList<ParsedTabColumn>();
        for (int entry = 0; entry < fullList.size(); entry += 20) {
            String title = TextUtils.getFormattedText(tabList.method_1918(fullList.get(entry))).trim();
            ParsedTabColumn column = TabListParser.getColumnFromName(columns, title);
            if (column == null) {
                column = new ParsedTabColumn(title);
                columns.add(column);
            }
            for (int columnEntry = entry + 1; columnEntry < fullList.size() && columnEntry < entry + 20; ++columnEntry) {
                String legacyFormatted = TextUtils.getFormattedText(tabList.method_1918(fullList.get(columnEntry)));
                column.addLine(legacyFormatted);
            }
        }
        return columns;
    }

    /*
     * WARNING - void declaration
     */
    public static ParsedTabColumn parseFooterAsColumn() {
        class_355 tabList = class_310.method_1551().field_1705.method_1750();
        if (tabList.field_2154 == null) {
            return null;
        }
        ParsedTabColumn column = new ParsedTabColumn("\u00a72\u00a7lOthers");
        String legacyFormattedFooter = TextUtils.getFormattedText(tabList.field_2154);
        String footer = TABLIST_S.matcher(legacyFormattedFooter).replaceAll("");
        String strippedFooter = TextUtils.stripColor(footer);
        Matcher m = GOD_POTION_PATTERN.matcher(strippedFooter);
        footer = m.find() ? ACTIVE_EFFECTS_PATTERN.matcher(footer).replaceAll("Active Effects: \n\u00a7cGod Potion\u00a7r: " + m.group("timer")) : ((m = EFFECT_COUNT_PATTERN.matcher(strippedFooter)).find() ? ACTIVE_EFFECTS_PATTERN.matcher(footer).replaceAll("Active Effects: \u00a7r\u00a7e" + m.group("effectCount")) : ACTIVE_EFFECTS_PATTERN.matcher(footer).replaceAll("Active Effects: \u00a7r\u00a7e0"));
        m = CANDY_PATTERN.matcher(footer);
        if (m.find()) {
            SpookyEventManager.update(Integer.parseInt(m.group("green").replaceAll(",", "")), Integer.parseInt(m.group("purple").replaceAll(",", "")), Integer.parseInt(m.group("points").replaceAll(",", "")));
            footer = m.replaceAll("\u00a77Your Candy: (\u00a76" + m.group("points") + " \u00a77pts.)\n \u00a7a" + m.group("green") + " Green\n \u00a75" + m.group("purple") + " Purple");
        } else {
            SpookyEventManager.reset();
        }
        m = COOKIE_BUFF_PATTERN.matcher(footer);
        if (m.find() && m.group().contains("Not active!")) {
            footer = m.replaceAll("Cookie Buff \n\u00a7r\u00a77Not Active");
        }
        if (main.getUtils().getJerryWave() != -1 && (m = JERRY_POWER_UPS_PATTERN.matcher(footer)).find() && m.group().contains("No Power Ups")) {
            footer = m.replaceAll("Active Power Ups \n\u00a7r\u00a77No Power Ups");
        }
        if ((m = DUNGEON_BUFF_PATTERN.matcher(footer)).find()) {
            footer = m.replaceAll("No Buffs");
        }
        for (String string : new ArrayList<String>(Arrays.asList(footer.split("\n")))) {
            void var7_13;
            void var7_10;
            String string2;
            if (string.contains(HYPIXEL_ADVERTISEMENT_CONTAINS)) continue;
            m = UPGRADES_PATTERN.matcher(TextUtils.stripResets(string));
            if (m.matches()) {
                Object firstPart = TextUtils.trimWhitespaceAndResets(m.group("firstPart"));
                if (!((String)firstPart).contains("\u00a7l")) {
                    firstPart = " " + (String)firstPart;
                }
                column.addLine((String)firstPart);
                String string3 = m.group("secondPart");
            }
            if (!(string2 = TextUtils.trimWhitespaceAndResets((String)var7_10)).contains("\u00a7l")) {
                String string4 = " " + string2;
            }
            column.addLine((String)var7_13);
        }
        return column;
    }

    public static void parseSections(List<ParsedTabColumn> columns) {
        parsedRainTime = null;
        boolean foundEssenceSection = false;
        boolean foundSkillSection = false;
        boolean foundSkill = false;
        for (ParsedTabColumn column : columns) {
            ParsedTabSection currentSection = null;
            for (String line : column.getLines()) {
                Matcher m;
                if (TextUtils.trimWhitespaceAndResets(line).isEmpty()) {
                    foundSkillSection = false;
                    foundEssenceSection = false;
                    currentSection = null;
                    continue;
                }
                String stripped = TextUtils.stripColor(line).trim();
                if (!foundEssenceSection && Feature.DUNGEONS_COLLECTED_ESSENCES_DISPLAY.isEnabled(FeatureSetting.SHOW_SALVAGE_ESSENCES_COUNTER) && stripped.contains("Essence:")) {
                    foundEssenceSection = true;
                }
                if (foundEssenceSection) {
                    String num = stripped.substring(stripped.indexOf(" ") + 1);
                    for (EssenceType type : EssenceType.values()) {
                        if (!stripped.contains(type.getNiceName())) continue;
                        main.getDungeonManager().setSalvagedEssences(type, num);
                        break;
                    }
                }
                if (parsedRainTime == null && Feature.BIRCH_PARK_RAINMAKER_TIMER.isEnabled() && LocationUtils.isOn("Birch Park") && (m = RAIN_TIME_PATTERN.matcher(stripped)).matches()) {
                    parsedRainTime = m.group("time");
                }
                if (!foundSkillSection && !foundSkill) {
                    if (LocationUtils.isOn(Island.DUNGEON) && (m = OLD_SKILL_LEVEL_PATTERN.matcher(stripped)).matches()) {
                        skillType = SkillType.getFromString(m.group("skill"));
                        int level = Integer.parseInt(m.group("level"));
                        main.getSkillXpManager().setSkillLevel(skillType, level);
                        foundSkill = true;
                    } else if (stripped.startsWith("Skills:")) {
                        foundSkillSection = true;
                    }
                } else if (foundSkillSection && (m = SKILL_LEVEL_PATTERN.matcher(stripped)).matches()) {
                    skillType = SkillType.getFromString(m.group("skill"));
                    int level = Integer.parseInt(m.group("level"));
                    main.getSkillXpManager().setSkillLevel(skillType, level);
                }
                if (currentSection == null) {
                    currentSection = new ParsedTabSection(column);
                    column.addSection(currentSection);
                }
                currentSection.addLine(line);
            }
        }
    }

    public static void combineColumnsToRender(List<ParsedTabColumn> columns, RenderColumn initialColumn) {
        String lastTitle = null;
        for (ParsedTabColumn column : columns) {
            for (ParsedTabSection section : column.getSections()) {
                int sectionSize = section.size();
                boolean needsTitle = false;
                if (lastTitle != section.getColumn().getTitle()) {
                    needsTitle = true;
                    ++sectionSize;
                }
                int currentCount = initialColumn.size();
                if (sectionSize >= 11) {
                    if (currentCount >= 22) {
                        initialColumn = new RenderColumn();
                        renderColumns.add(initialColumn);
                        currentCount = 1;
                    } else if (initialColumn.size() > 0) {
                        initialColumn.addLine(new TabLine("", TabStringType.TEXT));
                    }
                    if (needsTitle) {
                        lastTitle = section.getColumn().getTitle();
                        initialColumn.addLine(new TabLine(lastTitle, TabStringType.TITLE));
                        ++currentCount;
                    }
                    for (String line : section.getLines()) {
                        if (currentCount >= 22) {
                            initialColumn = new RenderColumn();
                            renderColumns.add(initialColumn);
                            currentCount = 1;
                        }
                        initialColumn.addLine(new TabLine(line, TabStringType.fromLine(line)));
                        ++currentCount;
                    }
                    continue;
                }
                if (currentCount + sectionSize > 22) {
                    initialColumn = new RenderColumn();
                    renderColumns.add(initialColumn);
                } else if (initialColumn.size() > 0) {
                    initialColumn.addLine(new TabLine("", TabStringType.TEXT));
                }
                if (needsTitle) {
                    lastTitle = section.getColumn().getTitle();
                    initialColumn.addLine(new TabLine(lastTitle, TabStringType.TITLE));
                }
                for (String line : section.getLines()) {
                    initialColumn.addLine(new TabLine(line, TabStringType.fromLine(line)));
                }
            }
        }
    }

    private static boolean isRelatedFeaturesDisabled() {
        return Feature.COMPACT_TAB_LIST.isDisabled() && Feature.DUNGEONS_COLLECTED_ESSENCES_DISPLAY.isDisabled(FeatureSetting.SHOW_SALVAGE_ESSENCES_COUNTER) && Feature.BIRCH_PARK_RAINMAKER_TIMER.isDisabled() && Feature.CANDY_POINTS_COUNTER.isDisabled() && (Feature.SKILL_DISPLAY.isDisabled() || Feature.SKILL_DISPLAY.isEnabled(FeatureSetting.SHOW_SKILL_PERCENTAGE_INSTEAD_OF_XP));
    }

    @Generated
    public static List<RenderColumn> getRenderColumns() {
        return renderColumns;
    }

    @Generated
    public static String getParsedRainTime() {
        return parsedRainTime;
    }

    static {
        TABLIST_S = Pattern.compile("(?i)\u00a7S");
    }
}

