/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features.tablist;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.Island;
import com.fix3dll.skyblockaddons.features.dungeons.DungeonClass;
import com.fix3dll.skyblockaddons.features.dungeons.DungeonPlayer;
import com.fix3dll.skyblockaddons.utils.LocationUtils;
import com.fix3dll.skyblockaddons.utils.RomanNumeralParser;
import com.fix3dll.skyblockaddons.utils.TextUtils;
import com.fix3dll.skyblockaddons.utils.objects.Pair;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_310;
import net.minecraft.class_3544;
import net.minecraft.class_746;
import org.apache.logging.log4j.Logger;

public enum TabStringType {
    TITLE,
    SUB_TITLE,
    TEXT,
    PLAYER;

    private static final Logger LOGGER;
    private static final Pattern USERNAME_TAB_PATTERN;

    public static TabStringType fromLine(String line) {
        String strippedLine = TextUtils.stripColor(line);
        if (strippedLine.startsWith(" ")) {
            return TEXT;
        }
        Matcher matcher = USERNAME_TAB_PATTERN.matcher(strippedLine);
        if (matcher.find()) {
            if (LocationUtils.isOn(Island.DUNGEON)) {
                TabStringType.updateDungeonTeammateClass(matcher);
            }
            return PLAYER;
        }
        return SUB_TITLE;
    }

    public static String usernameFromLine(String input) {
        Matcher usernameMatcher = USERNAME_TAB_PATTERN.matcher(TextUtils.stripColor(input));
        if (usernameMatcher.find()) {
            return usernameMatcher.group("username");
        }
        return input;
    }

    private static void updateDungeonTeammateClass(Matcher matcher) {
        int classLevel;
        if (matcher.groupCount() < 4) {
            return;
        }
        String tabUsername = matcher.group("username");
        String levelString = matcher.group("classLevel");
        if (class_3544.method_15438((String)tabUsername) || class_3544.method_15438((String)levelString)) {
            return;
        }
        try {
            if (levelString.equals("0")) {
                return;
            }
            classLevel = RomanNumeralParser.parseNumeral(levelString);
        }
        catch (Exception ex) {
            LOGGER.error("Error parsing " + tabUsername + "'s class level:", (Throwable)ex);
            return;
        }
        SkyblockAddons main = SkyblockAddons.getInstance();
        Pair<DungeonClass, Integer> thePlayerClass = main.getDungeonManager().getThePlayerClass();
        class_746 player = class_310.method_1551().field_1724;
        if (thePlayerClass == null && player != null && tabUsername.equals(player.method_7334().name())) {
            DungeonClass dungeonClass;
            String dungeonClassString = matcher.group("class");
            if (!class_3544.method_15438((String)dungeonClassString) && (dungeonClass = DungeonClass.fromFirstLetter(dungeonClassString.charAt(0))) != null) {
                main.getDungeonManager().setThePlayerClass(new Pair<DungeonClass, Integer>(dungeonClass, classLevel));
            }
        } else {
            for (Map.Entry entry : main.getDungeonManager().getTeammates().entrySet()) {
                String teammateName = (String)entry.getKey();
                DungeonPlayer teammateData = (DungeonPlayer)entry.getValue();
                if (!tabUsername.equals(teammateName)) continue;
                teammateData.setClassLevel(classLevel);
            }
        }
    }

    static {
        LOGGER = SkyblockAddons.getLogger();
        USERNAME_TAB_PATTERN = Pattern.compile("^\\[(?<sblevel>\\d+)] (?:\\[\\w+] )?(?<username>\\w+)(?:\\s*.\\s*\\((?<class>\\w+) (?<classLevel>\\w+)\\))?");
    }
}

