/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.gui.buttons;

import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.render.state.BlitAbsoluteRenderState;
import com.fix3dll.skyblockaddons.core.render.state.SbaTextRenderState;
import com.fix3dll.skyblockaddons.gui.buttons.IslandMarkerButton;
import com.fix3dll.skyblockaddons.gui.buttons.SkyblockAddonsButton;
import com.fix3dll.skyblockaddons.gui.screens.IslandWarpGui;
import com.fix3dll.skyblockaddons.listeners.RenderListener;
import com.fix3dll.skyblockaddons.utils.objects.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import lombok.Generated;
import net.minecraft.class_10799;
import net.minecraft.class_11244;
import net.minecraft.class_11247;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_9848;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;

public class IslandButton
extends SkyblockAddonsButton {
    private final ObjectArrayList<IslandMarkerButton> markerButtons = new ObjectArrayList();
    private boolean disableHover = false;
    private long startedHover = -1L;
    private long stoppedHover = -1L;
    private final IslandWarpGui.Island island;
    private static final int ANIMATION_TIME = 200;

    public IslandButton(IslandWarpGui.Island island) {
        super(island.getX(), island.getY(), (class_2561)class_2561.method_43470((String)island.getLabel()));
        this.island = island;
        for (IslandWarpGui.Marker marker : IslandWarpGui.Marker.values()) {
            if (marker.getIsland() != island || marker == IslandWarpGui.Marker.CARNIVAL && !main.getElectionData().isPerkActive("Chivalrous Carnival")) continue;
            this.markerButtons.add((Object)new IslandMarkerButton(marker));
        }
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.drawButton(graphics, mouseX, mouseY, true);
    }

    public void drawButton(class_332 graphics, int mouseX, int mouseY, boolean actuallyDraw) {
        Pair<Integer, Integer> scaledMouseLocations = IslandWarpGui.getScaledMouseLocation(mouseX, mouseY);
        mouseX = scaledMouseLocations.getLeft();
        mouseY = scaledMouseLocations.getRight();
        float x = this.island.getX();
        float y = this.island.getY();
        float h = this.island.getH();
        float w = this.island.getW();
        float centerX = x + w / 2.0f;
        float centerY = y + h / 2.0f;
        float expansion = 1.0f;
        boolean hovered = false;
        int hoverTime = -1;
        if (this.isHovering()) {
            hoverTime = (int)(System.currentTimeMillis() - this.startedHover);
            if (hoverTime > 200) {
                hoverTime = 200;
            }
        } else if (this.isStoppingHovering()) {
            hoverTime = (int)(System.currentTimeMillis() - this.stoppedHover);
            if (hoverTime < 200) {
                hoverTime = 200 - hoverTime;
            } else {
                this.stoppedHover = -1L;
            }
        }
        if (hoverTime != -1) {
            expansion = (float)hoverTime / 200.0f * 0.1f + 1.0f;
            x = centerX - (w *= expansion) / 2.0f;
            y = centerY - (h *= expansion) / 2.0f;
        }
        if ((float)mouseX > x && (float)mouseY > y && (float)mouseX < x + w && (float)mouseY < y + h) {
            if (this.island.getNativeImage() != null) {
                int xPixel = Math.round(((float)mouseX - x) * IslandWarpGui.IMAGE_SCALED_DOWN_FACTOR / expansion);
                int yPixel = Math.round(((float)mouseY - y) * IslandWarpGui.IMAGE_SCALED_DOWN_FACTOR / expansion);
                try {
                    int rgb = this.island.getNativeImage().method_61940(xPixel, yPixel);
                    int alpha = (rgb & 0xFF000000) >> 24;
                    if (alpha != 0) {
                        hovered = true;
                    }
                }
                catch (IllegalArgumentException rgb) {}
            } else {
                hovered = true;
            }
        }
        if (this.disableHover) {
            this.disableHover = false;
            hovered = false;
        }
        if (hovered) {
            if (!this.isHovering()) {
                this.startedHover = System.currentTimeMillis();
                if (this.isStoppingHovering()) {
                    timeSoFar = (int)(System.currentTimeMillis() - this.stoppedHover);
                    if (timeSoFar > 200) {
                        timeSoFar = 200;
                    }
                    this.startedHover -= (long)(200 - timeSoFar);
                    this.stoppedHover = -1L;
                }
            }
        } else if (this.isHovering()) {
            this.stoppedHover = System.currentTimeMillis();
            timeSoFar = (int)(System.currentTimeMillis() - this.startedHover);
            if (timeSoFar > 200) {
                timeSoFar = 200;
            }
            this.stoppedHover -= (long)(200 - timeSoFar);
            this.startedHover = -1L;
        }
        if (actuallyDraw) {
            int color = hovered ? class_9848.method_61317((float)1.0f) : class_9848.method_61318((float)1.0f, (float)0.9f, (float)0.9f, (float)0.9f);
            Matrix3x2fStack poseStack = graphics.method_51448();
            graphics.field_59826.method_70919((class_11244)new BlitAbsoluteRenderState(class_10799.field_56883, RenderListener.textureSetup(this.island.getResourceLocation()), (Matrix3x2f)graphics.method_51448(), x, y, 0.0f, 0.0f, w, h, w, h, color, graphics.field_44659.method_70863()));
            for (IslandMarkerButton marker : this.markerButtons) {
                marker.drawButton(graphics, x, y, expansion, hovered);
            }
            poseStack.pushMatrix();
            float textScale = 3.0f * expansion;
            poseStack.scale(textScale);
            graphics.field_59826.method_70921((class_11247)new SbaTextRenderState(this.method_25369().method_30937(), (Matrix3x2f)graphics.method_51448(), centerX / textScale - (float)IslandButton.MC.field_1772.method_27525((class_5348)this.method_25369()) / 2.0f, centerY / textScale, ColorCode.WHITE.getColor(), 0, true, graphics.field_44659.method_70863()));
            poseStack.popMatrix();
        }
    }

    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        return false;
    }

    public boolean isHovering() {
        return this.startedHover != -1L;
    }

    private boolean isStoppingHovering() {
        return this.stoppedHover != -1L;
    }

    @Generated
    public ObjectArrayList<IslandMarkerButton> getMarkerButtons() {
        return this.markerButtons;
    }

    @Generated
    public void setDisableHover(boolean disableHover) {
        this.disableHover = disableHover;
    }
}

