/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.gui.screens;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.Translations;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.gui.buttons.ButtonColorBox;
import com.fix3dll.skyblockaddons.gui.buttons.ButtonSlider;
import com.fix3dll.skyblockaddons.gui.elements.CheckBox;
import com.fix3dll.skyblockaddons.gui.screens.SkyblockAddonsScreen;
import com.fix3dll.skyblockaddons.utils.ColorUtils;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import com.fix3dll.skyblockaddons.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1011;
import net.minecraft.class_10799;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_9848;

public class ColorSelectionGui
extends SkyblockAddonsScreen {
    private static final class_2960 COLOR_PICKER = SkyblockAddons.resourceLocation("gui/colorpicker.png");
    private static class_1011 COLOR_PICKER_IMAGE = ColorSelectionGui.loadColorPicker();
    private final Feature feature;
    private final FeatureSetting setting;
    private final EnumUtils.GUIType lastGUI;
    private final EnumUtils.GuiTab lastTab;
    private final int lastPage;
    private final boolean isRestricted;
    private final Supplier<Boolean> isChroma;
    private final Supplier<Integer> color;
    private final Consumer<Boolean> setChroma;
    private final Consumer<Integer> setColor;
    private int imageX;
    private int imageY;
    private class_342 hexColorField;
    private CheckBox chromaCheckbox;

    public ColorSelectionGui(Feature feature, EnumUtils.GUIType lastGUI, EnumUtils.GuiTab lastTab, int lastPage) {
        super((class_2561)class_2561.method_43473());
        this.feature = feature;
        this.setting = null;
        this.lastTab = lastTab;
        this.lastGUI = lastGUI;
        this.lastPage = lastPage;
        this.isRestricted = feature.isGuiFeature() && feature.getFeatureGuiData().isColorsRestricted();
        this.isChroma = feature::isChroma;
        this.color = feature::getColor;
        this.setColor = feature::setColor;
        this.setChroma = feature::setChroma;
    }

    public ColorSelectionGui(FeatureSetting setting, EnumUtils.GUIType lastGUI, EnumUtils.GuiTab lastTab, int lastPage) {
        super((class_2561)class_2561.method_43473());
        this.feature = setting.getRelatedFeature();
        this.setting = setting;
        this.lastTab = lastTab;
        this.lastGUI = lastGUI;
        this.lastPage = lastPage;
        if (this.feature == null) {
            throw new IllegalArgumentException("Feature cannot be null");
        }
        Object settingValue = this.feature.get(setting);
        if (!(settingValue instanceof ColorCode) && !(settingValue instanceof Number)) {
            throw new IllegalArgumentException("Setting value is not a ColorCode or a Number");
        }
        this.isRestricted = settingValue instanceof ColorCode;
        this.isChroma = () -> {
            if (this.isRestricted) {
                return this.feature.get(setting) == ColorCode.CHROMA;
            }
            return this.feature.getAsNumber(setting).intValue() == ColorCode.CHROMA.getColor();
        };
        this.color = () -> {
            if (this.isRestricted) {
                return ((ColorCode)this.feature.get(setting)).getColor();
            }
            return this.feature.getAsNumber(setting).intValue();
        };
        this.setColor = integer -> {
            if (this.isRestricted) {
                ColorCode colorCode = ColorCode.getByARGB(integer);
                if (colorCode != null) {
                    this.feature.set(setting, colorCode);
                }
            } else {
                this.feature.set(setting, integer);
            }
        };
        this.setChroma = setChroma -> {
            if (setChroma.booleanValue()) {
                if (this.isRestricted) {
                    this.feature.set(setting, ColorCode.CHROMA);
                } else {
                    this.feature.set(setting, ColorCode.CHROMA.getColor());
                }
            } else {
                main.getConfigValuesManager().setSettingToDefault(setting);
            }
        };
    }

    public void method_25426() {
        if (COLOR_PICKER_IMAGE == null) {
            COLOR_PICKER_IMAGE = ColorSelectionGui.loadColorPicker();
        }
        boolean isChroma = this.isChroma.get();
        if (this.chromaCheckbox == null) {
            this.chromaCheckbox = new CheckBox(this.field_22789 / 2 + 88, 170, 12, Translations.getMessage("messages.chroma", new Object[0]), false);
            this.chromaCheckbox.setValue(isChroma);
            this.chromaCheckbox.setOnToggleListener(value -> {
                this.setChroma.accept(value);
                this.removeChromaSliders();
                if (value) {
                    this.addChromaSliders();
                }
            });
        }
        if (this.hexColorField == null) {
            this.hexColorField = new class_342(ColorSelectionGui.MC.field_1772, this.field_22789 / 2 + 110 - 50, 220, 100, 15, (class_2561)class_2561.method_43473());
            this.hexColorField.method_1880(7);
        }
        this.setTextBoxHex(this.color.get());
        if (this.isRestricted) {
            int collumn = 1;
            int x = this.field_22789 / 2 - 160;
            int y = 120;
            for (ColorCode colorCode : ColorCode.values()) {
                if (!colorCode.isColor()) continue;
                this.method_37063((class_364)new ButtonColorBox(x, y, colorCode));
                if (collumn < 6) {
                    ++collumn;
                    x += 55;
                    continue;
                }
                y += 40;
                collumn = 1;
                x = this.field_22789 / 2 - 160;
            }
        }
        if (isChroma && !this.isRestricted) {
            this.addChromaSliders();
        }
        this.addSocials(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        super.method_25426();
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.drawGradientBackground(graphics, 128, 192);
        this.drawDefaultTitleText(graphics, this, 255);
        int defaultBlue = ColorUtils.getDefaultBlue(1);
        if (this.feature.isGuiFeature() || this.setting != null) {
            if (this.isRestricted) {
                ColorSelectionGui.drawScaledString(graphics, this, Translations.getMessage("messages.chooseAColor", new Object[0]), 90, defaultBlue, 1.5f, 0);
            } else {
                boolean isChroma = this.isChroma.get();
                int pickerWidth = COLOR_PICKER_IMAGE.method_4307();
                int pickerHeight = COLOR_PICKER_IMAGE.method_4323();
                this.imageX = this.field_22789 / 2 - 200;
                this.imageY = 90;
                int color = isChroma ? class_9848.method_61318((float)0.7f, (float)0.5f, (float)0.5f, (float)0.5f) : class_9848.method_61317((float)1.0f);
                graphics.method_25291(class_10799.field_56883, COLOR_PICKER, this.imageX, this.imageY, 0.0f, 0.0f, pickerWidth, pickerHeight, pickerWidth, pickerHeight, color);
                ColorSelectionGui.drawScaledString(graphics, this, Translations.getMessage("messages.selectedColor", new Object[0]), 120, defaultBlue, 1.5f, 75);
                int currentColor = this.color.get();
                if (this.setting == null && this.feature.isChroma() && Feature.CHROMA_MODE.getValue() == EnumUtils.ChromaMode.FADE) {
                    currentColor = ColorCode.CHROMA.getColor();
                }
                ButtonColorBox.drawColorRect(graphics, this.field_22789 / 2 + 90, 140, this.field_22789 / 2 + 130, 160, currentColor);
                if (this.chromaCheckbox != null) {
                    this.chromaCheckbox.draw(graphics);
                }
                if (!isChroma) {
                    ColorSelectionGui.drawScaledString(graphics, this, Translations.getMessage("messages.setHexColor", new Object[0]), 200, defaultBlue, 1.5f, 75);
                    this.hexColorField.method_48579(graphics, mouseX, mouseY, partialTick);
                }
                if (isChroma) {
                    ColorSelectionGui.drawScaledString(graphics, this, Translations.getMessage("settings.chromaSpeed", new Object[0]), 195, defaultBlue, 1.0f, 110);
                    ColorSelectionGui.drawScaledString(graphics, this, Translations.getMessage("settings.chromaFadeWidth", new Object[0]), 230, defaultBlue, 1.0f, 110);
                }
            }
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        Optional<class_364> optional;
        if (!this.isRestricted && !this.isChroma.get().booleanValue()) {
            int selectedColor;
            int xPixel = (int)event.comp_4798() - this.imageX;
            int yPixel = (int)event.comp_4799() - this.imageY;
            if (xPixel > 0 && xPixel < COLOR_PICKER_IMAGE.method_4307() && yPixel > 0 && yPixel < COLOR_PICKER_IMAGE.method_4323() && class_9848.method_61320((int)(selectedColor = COLOR_PICKER_IMAGE.method_61940(xPixel, yPixel))) == 255) {
                this.setColor.accept(selectedColor);
                this.setTextBoxHex(selectedColor);
                Utils.playSound((class_3414)class_3417.field_15015.comp_349(), 0.25, 1.0);
            }
            this.hexColorField.method_25402(event, isDoubleClick);
            this.hexColorField.method_25365(this.hexColorField.method_49606());
        }
        if (this.chromaCheckbox != null) {
            this.chromaCheckbox.onMouseClick(event, isDoubleClick);
        }
        if ((optional = this.method_19355(event.comp_4798(), event.comp_4799())).isEmpty()) {
            return false;
        }
        class_364 guiEventListener = optional.get();
        if (guiEventListener instanceof ButtonColorBox) {
            ButtonColorBox colorBox = (ButtonColorBox)guiEventListener;
            this.setChroma.accept(colorBox.getColor() == ColorCode.CHROMA);
            this.setColor.accept(colorBox.getColor().getColor());
            MC.method_1507(null);
        } else if (guiEventListener.method_25402(event, isDoubleClick)) {
            this.method_25395(guiEventListener);
            if (event.method_74245() == 0) {
                this.method_25398(true);
            }
        }
        return true;
    }

    private void setTextBoxHex(int color) {
        this.hexColorField.method_1852(String.format("#%02x%02x%02x", class_9848.method_61327((int)color), class_9848.method_61329((int)color), class_9848.method_61331((int)color)));
    }

    public boolean method_25404(class_11908 event) {
        if (this.hexColorField.method_25370()) {
            this.hexColorField.method_25404(event);
            if (!this.parseColor()) {
                return false;
            }
        } else {
            this.hexColorField.method_25365(true);
        }
        return super.method_25404(event);
    }

    public boolean method_25400(class_11905 event) {
        if (this.hexColorField.method_25370()) {
            this.hexColorField.method_25400(event);
            if (!this.parseColor()) {
                return false;
            }
        } else {
            this.hexColorField.method_25365(true);
        }
        return super.method_25400(event);
    }

    public void method_25432() {
        main.getRenderListener().setGuiToOpen(this.lastGUI, this.lastPage, this.lastTab, this.feature);
    }

    private void removeChromaSliders() {
        this.method_25396().removeIf(guiEventListener -> guiEventListener instanceof ButtonSlider);
        this.field_33816.removeIf(renderable -> renderable instanceof ButtonSlider);
    }

    private void addChromaSliders() {
        this.method_37063((class_364)new ButtonSlider((double)this.field_22789 / 2.0 + 76.0, 205.0, 70, 15, Feature.CHROMA_SPEED.numberValue().floatValue(), 0.5f, 20.0f, 0.5f, Feature.CHROMA_SPEED::setValue));
        this.method_37063((class_364)new ButtonSlider((double)this.field_22789 / 2.0 + 76.0, 240.0, 70, 15, Feature.CHROMA_SIZE.numberValue().floatValue(), 1.0f, 100.0f, 1.0f, Feature.CHROMA_SIZE::setValue));
    }

    private boolean parseColor() {
        String text = this.hexColorField.method_1882();
        if (text.startsWith("#")) {
            text = text.substring(1);
        }
        if (text.length() == 6) {
            int typedColor;
            try {
                typedColor = 0xFF000000 | Integer.parseInt(text, 16);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
                return false;
            }
            this.setColor.accept(typedColor);
        }
        return true;
    }

    private static class_1011 loadColorPicker() {
        Optional resource = class_310.method_1551().method_1478().method_14486(COLOR_PICKER);
        if (resource.isPresent()) {
            try {
                COLOR_PICKER_IMAGE = class_1011.method_4309((InputStream)((class_3298)resource.get()).method_14482());
                return COLOR_PICKER_IMAGE;
            }
            catch (IOException e) {
                SkyblockAddons.getLogger().catching((Throwable)e);
            }
        }
        return null;
    }
}

