/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.gui.screens;

import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.Translations;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.gui.buttons.ButtonArrow;
import com.fix3dll.skyblockaddons.gui.buttons.ButtonBanner;
import com.fix3dll.skyblockaddons.gui.buttons.ButtonCycling;
import com.fix3dll.skyblockaddons.gui.buttons.ButtonNewTag;
import com.fix3dll.skyblockaddons.gui.buttons.ButtonSlider;
import com.fix3dll.skyblockaddons.gui.buttons.ButtonStepper;
import com.fix3dll.skyblockaddons.gui.buttons.feature.ButtonCredit;
import com.fix3dll.skyblockaddons.gui.buttons.feature.ButtonFeatureToggle;
import com.fix3dll.skyblockaddons.gui.buttons.feature.ButtonSettings;
import com.fix3dll.skyblockaddons.gui.buttons.feature.FeatureBase;
import com.fix3dll.skyblockaddons.gui.screens.LocationEditGui;
import com.fix3dll.skyblockaddons.gui.screens.SettingsGui;
import com.fix3dll.skyblockaddons.gui.screens.SkyblockAddonsScreen;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import com.fix3dll.skyblockaddons.utils.objects.Pair;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.TreeSet;
import lombok.Generated;
import net.minecraft.class_1041;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_437;

public class SkyblockAddonsGui
extends SkyblockAddonsScreen {
    private static final HashSet<Feature> FEATURE_SET = Sets.newHashSet((Object[])Feature.values());
    public static final int BUTTON_MAX_WIDTH = 140;
    private static String searchString;
    private class_342 featureSearchBar;
    private final EnumUtils.GuiTab tab;
    private int page;
    private int row = 1;
    private int column = 1;
    private int displayCount;
    boolean reInit = false;
    private boolean cancelClose;
    private class_437 parent = null;
    private boolean showWarning = false;

    public SkyblockAddonsGui(int page, EnumUtils.GuiTab tab) {
        super((class_2561)class_2561.method_43473());
        this.tab = tab;
        this.page = page;
    }

    public void method_25426() {
        this.row = 1;
        this.column = 1;
        this.displayCount = this.findDisplayCount();
        this.addLanguageButton();
        this.addEditLocationsButton();
        this.addFeaturedBanner();
        this.addGeneralSettingsButton();
        if (this.featureSearchBar == null) {
            this.featureSearchBar = new class_342(SkyblockAddonsGui.MC.field_1772, this.field_22789 / 2 - 220, 69, 120, 15, (class_2561)class_2561.method_43473());
            this.featureSearchBar.method_1880(500);
            this.featureSearchBar.method_47404((class_2561)class_2561.method_43470((String)Translations.getMessage("messages.searchFeatures", new Object[0])).method_54663(ColorCode.DARK_GRAY.getColor()));
            if (searchString != null) {
                this.featureSearchBar.method_1852(searchString);
            }
        } else {
            this.featureSearchBar.method_46421(this.field_22789 / 2 - 220);
        }
        TreeSet<Feature> features = new TreeSet<Feature>(Comparator.comparing(Enum::ordinal).reversed());
        for (Feature feature : this.tab != EnumUtils.GuiTab.GENERAL_SETTINGS ? FEATURE_SET : Feature.getGeneralTabFeatures()) {
            if (Feature.getEditGuiFeatures().contains((Object)feature) || !feature.isActualFeature() && this.tab != EnumUtils.GuiTab.GENERAL_SETTINGS || feature.isRemoteDisabled()) continue;
            if (this.matchesSearch(feature.getMessage(new String[0]))) {
                features.add(feature);
                continue;
            }
            TreeMap<FeatureSetting, Object> settings = feature.getFeatureData().getSettings();
            if (settings == null) continue;
            for (FeatureSetting setting : settings.keySet()) {
                try {
                    if (!this.matchesSearch(setting.getMessage(new String[0]))) continue;
                    features.add(feature);
                }
                catch (Exception exception) {}
            }
        }
        if (this.tab != EnumUtils.GuiTab.GENERAL_SETTINGS) {
            for (Feature feature : Feature.values()) {
                if (Feature.getEditGuiFeatures().contains((Object)feature) || !feature.isRemoteDisabled() || !this.matchesSearch(feature.getMessage(new String[0]))) continue;
                features.add(feature);
            }
        }
        int skip = (this.page - 1) * this.displayCount;
        boolean max = this.page == 1;
        this.method_37063((class_364)new ButtonArrow((double)this.field_22789 / 2.0 - 15.0 - 50.0, this.field_22790 - 70, ButtonArrow.ArrowType.LEFT, max));
        max = features.size() - skip - this.displayCount <= 0;
        this.method_37063((class_364)new ButtonArrow((double)this.field_22789 / 2.0 - 15.0 + 50.0, this.field_22790 - 70, ButtonArrow.ArrowType.RIGHT, max));
        this.addSocials(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        block11: for (Feature feature : features) {
            if (skip == 0) {
                switch (feature) {
                    case GENERAL_SETTINGS: 
                    case EDIT_LOCATIONS: 
                    case LANGUAGE: {
                        continue block11;
                    }
                    case TEXT_STYLE: 
                    case CHROMA_MODE: 
                    case AUTO_UPDATE: {
                        this.addButton(feature, EnumUtils.ButtonType.CYCLING);
                        continue block11;
                    }
                    case WARNING_TIME: {
                        this.addButton(feature, EnumUtils.ButtonType.STEPPER);
                        continue block11;
                    }
                    case CHROMA_SPEED: 
                    case CHROMA_SIZE: 
                    case CHROMA_SATURATION: 
                    case CHROMA_BRIGHTNESS: {
                        this.addButton(feature, EnumUtils.ButtonType.CHROMA_SLIDER);
                        continue block11;
                    }
                }
                this.addButton(feature, EnumUtils.ButtonType.TOGGLE);
                continue;
            }
            --skip;
        }
    }

    private boolean matchesSearch(String textToSearch) {
        String searchBarText = this.featureSearchBar.method_1882();
        if (searchBarText.isEmpty()) {
            return true;
        }
        String[] searchTerms = searchBarText.toLowerCase().split(" ");
        textToSearch = textToSearch.toLowerCase();
        for (String searchTerm : searchTerms) {
            if (textToSearch.contains(searchTerm)) continue;
            return false;
        }
        return true;
    }

    private int findDisplayCount() {
        int maxX = MC.method_22683().method_4502() - 70 - 50;
        int displayCount = 0;
        for (int row = 1; row < 99; ++row) {
            if (this.getRowHeight(row) < (double)maxX) {
                displayCount += 3;
                continue;
            }
            return displayCount;
        }
        return displayCount;
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        if (this.reInit) {
            this.reInit = false;
            this.cancelClose = true;
            MC.method_1507((class_437)this);
            this.cancelClose = false;
        }
        float alphaMultiplier = this.calculateAlphaMultiplier();
        int alpha = (int)(255.0f * alphaMultiplier);
        this.drawGradientBackground(graphics, alpha);
        if (alpha < 4) {
            alpha = 4;
        }
        this.drawDefaultTitleText(graphics, this, alpha * 2);
        this.featureSearchBar.method_25394(graphics, mouseX, mouseY, partialTick);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        if (this.showWarning) {
            String warning = Translations.getMessage("settings.editLocationFromOutsideWarning", new Object[0]);
            graphics.method_51438(SkyblockAddonsGui.MC.field_1772, (class_2561)class_2561.method_43470((String)warning), this.field_22789 / 2 - SkyblockAddonsGui.MC.field_1772.method_1727(warning) / 2, this.field_22790 / 2);
        }
    }

    private void addButton(Feature feature, EnumUtils.ButtonType buttonType) {
        if (this.displayCount == 0) {
            return;
        }
        String text = feature.getMessage(new String[0]);
        int halfWidth = this.field_22789 / 2;
        int boxWidth = 140;
        int boxHeight = 50;
        int x = 0;
        if (this.column == 1) {
            x = halfWidth - 90 - boxWidth;
        } else if (this.column == 2) {
            x = halfWidth - boxWidth / 2;
        } else if (this.column == 3) {
            x = halfWidth + 90;
        }
        double y = this.getRowHeight(this.row);
        if (buttonType == EnumUtils.ButtonType.TOGGLE) {
            FeatureBase featureGui = new FeatureBase((double)x, y, text, feature);
            this.method_37063((class_364)featureGui);
            EnumUtils.FeatureCredit credit = EnumUtils.FeatureCredit.fromFeature(feature);
            if (credit != null) {
                Pair<Integer, Integer> coords = featureGui.getCreditsCoords(credit);
                this.method_37063((class_364)new ButtonCredit(coords.getLeft().intValue(), coords.getRight().intValue(), text, credit, feature, featureGui.isMultilineButton()));
            }
            if (feature.hasSettings() || feature.isColorFeature() || feature.couldBeXAllignment()) {
                this.method_37063((class_364)new ButtonSettings((double)(x + boxWidth - 33), y + (double)boxHeight - 20.0, text, feature));
            }
            this.method_37063((class_364)new ButtonFeatureToggle((float)x + (float)boxWidth / 2.0f - 15.5f, y + (double)boxHeight - 18.0, feature));
        } else if (buttonType == EnumUtils.ButtonType.CYCLING) {
            this.method_37063((class_364)new FeatureBase((double)x, y, text, feature));
            int bcX = x + 10;
            int bcY = (int)y + boxHeight - 23;
            int bcWidth = 120;
            int bcHeight = 15;
            switch (feature) {
                case TEXT_STYLE: {
                    this.method_37063((class_364)new ButtonCycling(bcX, bcY, bcWidth, bcHeight, Arrays.asList(EnumUtils.TextStyle.values()), ((EnumUtils.TextStyle)Feature.TEXT_STYLE.getValue()).ordinal(), index -> Feature.TEXT_STYLE.setValue(EnumUtils.TextStyle.values()[index])));
                    break;
                }
                case CHROMA_MODE: {
                    this.method_37063((class_364)new ButtonCycling(bcX, bcY, bcWidth, bcHeight, Arrays.asList(EnumUtils.ChromaMode.values()), ((EnumUtils.ChromaMode)Feature.CHROMA_MODE.getValue()).ordinal(), index -> Feature.CHROMA_MODE.setValue(EnumUtils.ChromaMode.values()[index])));
                    break;
                }
                case AUTO_UPDATE: {
                    this.method_37063((class_364)new ButtonCycling(bcX, bcY, bcWidth, bcHeight, Arrays.asList(EnumUtils.AutoUpdateMode.values()), ((EnumUtils.AutoUpdateMode)Feature.AUTO_UPDATE.getValue()).ordinal(), index -> Feature.AUTO_UPDATE.setValue(EnumUtils.AutoUpdateMode.values()[index])));
                }
            }
        } else if (buttonType == EnumUtils.ButtonType.STEPPER) {
            this.method_37063((class_364)new FeatureBase((double)x, y, text, feature));
            switch (feature) {
                case WARNING_TIME: {
                    int solidButtonX = x + boxWidth / 2 - 45;
                    int warningSeconds = Feature.WARNING_TIME.numberValue().intValue();
                    this.method_37063((class_364)new ButtonStepper(solidButtonX, y + (double)boxHeight - 23.0, 90, 15, warningSeconds + "s", modifier -> {
                        int seconds = Feature.WARNING_TIME.numberValue().intValue();
                        switch (modifier) {
                            case SUBTRACT: {
                                if (seconds <= 1) break;
                                Feature.WARNING_TIME.setValue(seconds - 1);
                                break;
                            }
                            case ADD: {
                                if (seconds >= 99) break;
                                Feature.WARNING_TIME.setValue(seconds + 1);
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        this.reInit = true;
                    }));
                }
            }
        } else if (buttonType == EnumUtils.ButtonType.CHROMA_SLIDER) {
            this.method_37063((class_364)new FeatureBase((double)x, y, text, feature));
            switch (feature) {
                case CHROMA_SPEED: {
                    this.method_37063((class_364)new ButtonSlider(x + 35, y + (double)boxHeight - 23.0, 70, 15, feature.numberValue().floatValue(), 0.5f, 20.0f, 0.5f, feature::setValue));
                    break;
                }
                case CHROMA_SIZE: {
                    this.method_37063((class_364)new ButtonSlider(x + 35, y + (double)boxHeight - 23.0, 70, 15, feature.numberValue().floatValue(), 1.0f, 100.0f, 1.0f, feature::setValue));
                    break;
                }
                case CHROMA_SATURATION: 
                case CHROMA_BRIGHTNESS: {
                    this.method_37063((class_364)new ButtonSlider(x + 35, y + (double)boxHeight - 23.0, 70, 15, feature.numberValue().floatValue(), 0.0f, 1.0f, 0.01f, feature::setValue));
                }
            }
        }
        if (feature.isNew()) {
            this.method_37060((class_4068)new ButtonNewTag(x + boxWidth - 15, (int)y + boxHeight - 10));
        }
        ++this.column;
        if (this.column > 3) {
            this.column = 1;
            ++this.row;
        }
        --this.displayCount;
    }

    private void addLanguageButton() {
        int halfWidth = this.field_22789 / 2;
        int boxWidth = 140;
        int boxHeight = 50;
        int x = halfWidth + 90;
        double y = this.getRowHeight((double)this.displayCount / 3.0 + 1.0);
        this.method_37063((class_364)new FeatureBase(x, y, boxWidth, boxHeight, Translations.getMessage("languageText", new Object[0]) + Feature.LANGUAGE.getMessage(new String[0]), Feature.LANGUAGE, button -> {
            main.getUtils().setFadingIn(false);
            MC.method_1507((class_437)new SettingsGui(Feature.LANGUAGE, 1, this.page, this.tab, EnumUtils.GUIType.MAIN));
        }));
    }

    private void addEditLocationsButton() {
        int halfWidth = this.field_22789 / 2;
        int boxWidth = 140;
        int boxHeight = 50;
        int x = halfWidth - 90 - boxWidth;
        double y = this.getRowHeight((double)this.displayCount / 3.0 + 1.0);
        this.method_37063((class_364)new FeatureBase(x, y, boxWidth, boxHeight, Feature.EDIT_LOCATIONS.getMessage(new String[0]), Feature.EDIT_LOCATIONS, button -> {
            if (SkyblockAddonsGui.MC.field_1724 == null) {
                this.showWarning = true;
                main.getScheduler().scheduleTask(scheduledTask -> {
                    this.showWarning = false;
                }, 60);
            } else {
                main.getUtils().setFadingIn(false);
                MC.method_1507((class_437)new LocationEditGui(this.page, this.tab));
            }
        }));
    }

    private void addGeneralSettingsButton() {
        int halfWidth = this.field_22789 / 2;
        int boxWidth = 140;
        int boxHeight = 15;
        int x = halfWidth + 90;
        double y = this.getRowHeight(1.0) - 25.0;
        this.method_37063((class_364)new FeatureBase(x, y, boxWidth, boxHeight, Translations.getMessage("settings.tab.generalSettings", new Object[0]), Feature.GENERAL_SETTINGS, button -> {
            searchString = "";
            this.featureSearchBar.method_1852(searchString);
            if (this.tab == EnumUtils.GuiTab.GENERAL_SETTINGS) {
                main.getUtils().setFadingIn(false);
                MC.method_1507((class_437)new SkyblockAddonsGui(1, EnumUtils.GuiTab.MAIN));
            } else {
                main.getUtils().setFadingIn(false);
                MC.method_1507((class_437)new SkyblockAddonsGui(1, EnumUtils.GuiTab.GENERAL_SETTINGS));
            }
        }));
    }

    private void addFeaturedBanner() {
        if (main.getOnlineData().getBannerImageURL() != null) {
            int halfWidth = this.field_22789 / 2;
            this.method_37063((class_364)new ButtonBanner(halfWidth - 170, 15.0));
        }
    }

    public boolean method_25404(class_11908 event) {
        if (this.parent != null && class_3675.method_15987((class_1041)MC.method_22683(), (int)event.comp_4795()) && event.comp_4795() == 256) {
            MC.method_1507(this.parent);
            return true;
        }
        if (this.featureSearchBar.method_25370()) {
            this.featureSearchBar.method_25404(event);
            if (event.comp_4795() == 259) {
                searchString = this.featureSearchBar.method_1882();
                main.getUtils().setFadingIn(false);
                this.method_37067();
                this.page = 1;
                this.method_25426();
            }
        } else {
            this.featureSearchBar.method_25365(true);
        }
        return super.method_25404(event);
    }

    public boolean method_25400(class_11905 event) {
        if (this.featureSearchBar.method_25370()) {
            this.featureSearchBar.method_25400(event);
            searchString = this.featureSearchBar.method_1882();
            main.getUtils().setFadingIn(false);
            this.method_37067();
            this.page = 1;
            this.method_25426();
        }
        return super.method_25400(event);
    }

    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        this.featureSearchBar.method_25402(event, isDoubleClick);
        this.featureSearchBar.method_25365(this.featureSearchBar.method_49606());
        return super.method_25402(event, isDoubleClick);
    }

    private double getRowHeight(double row) {
        return 95.0 + (row -= 1.0) * 60.0;
    }

    public void method_25432() {
        if (!this.cancelClose) {
            if (this.tab == EnumUtils.GuiTab.GENERAL_SETTINGS) {
                main.getRenderListener().setGuiToOpen(EnumUtils.GUIType.MAIN, 1, EnumUtils.GuiTab.MAIN);
            }
            main.getConfigValuesManager().saveConfig();
        }
    }

    public void method_25410(class_310 mc, int width, int height) {
        super.method_25410(mc, width, height);
        main.getUtils().setFadingIn(false);
    }

    @Generated
    public EnumUtils.GuiTab getTab() {
        return this.tab;
    }

    @Generated
    public int getPage() {
        return this.page;
    }

    @Generated
    public void setCancelClose(boolean cancelClose) {
        this.cancelClose = cancelClose;
    }

    static {
        FEATURE_SET.removeAll(Feature.getGeneralTabFeatures());
    }
}

