/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.listeners;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.config.PetCacheManager;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.InventoryType;
import com.fix3dll.skyblockaddons.core.SkyblockEquipment;
import com.fix3dll.skyblockaddons.core.SkyblockKeyBinding;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.scheduler.ScheduledTask;
import com.fix3dll.skyblockaddons.events.ClientEvents;
import com.fix3dll.skyblockaddons.events.SkyblockAddonsEvents;
import com.fix3dll.skyblockaddons.features.PetManager;
import com.fix3dll.skyblockaddons.features.backpacks.BackpackColor;
import com.fix3dll.skyblockaddons.features.backpacks.BackpackInventoryManager;
import com.fix3dll.skyblockaddons.features.backpacks.ContainerPreviewManager;
import com.fix3dll.skyblockaddons.gui.screens.SkyblockAddonsScreen;
import com.fix3dll.skyblockaddons.listeners.InventoryChangeListener;
import com.fix3dll.skyblockaddons.mixin.hooks.AbstractContainerScreenHook;
import com.fix3dll.skyblockaddons.utils.DevUtils;
import com.fix3dll.skyblockaddons.utils.ItemUtils;
import com.fix3dll.skyblockaddons.utils.TextUtils;
import com.fix3dll.skyblockaddons.utils.Utils;
import com.fix3dll.skyblockaddons.utils.data.DataUtils;
import com.fix3dll.skyblockaddons.utils.data.requests.MayorRequest;
import com.fix3dll.skyblockaddons.utils.objects.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenKeyboardEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1265;
import net.minecraft.class_1277;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3544;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_476;
import net.minecraft.class_9290;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.apache.logging.log4j.Logger;

public class ScreenListener {
    private final SkyblockAddons main = SkyblockAddons.getInstance();
    private static final class_310 MC = class_310.method_1551();
    private static final Logger LOGGER = SkyblockAddons.getLogger();
    private InventoryChangeListener inventoryChangeListener;
    private class_1277 listenedInventory;
    private ScheduledTask inventoryChangeTimeCheckTask;
    private long lastContainerCloseMs = -1L;
    private long lastBackpackOpenMs = -1L;
    private long lastInventoryChangeMs = -1L;

    public ScreenListener() {
        SkyblockAddonsEvents.INVENTORY_LOADING_DONE.register(this::onInventoryLoadingDone);
        ClientEvents.BEFORE_SET_SCREEN.register(this::onGuiOpen);
        ScreenEvents.BEFORE_INIT.register(this::beforeScreenInit);
    }

    public void beforeScreenInit(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        class_465 containerScreen;
        class_1703 class_17032;
        ScreenKeyboardEvents.beforeKeyPress((class_437)screen).register(this::beforeKeyPress);
        ScreenMouseEvents.allowMouseClick((class_437)screen).register(this::allowMouseClick);
        if (!this.main.getUtils().isOnSkyblock()) {
            return;
        }
        if (screen instanceof class_465 && (class_17032 = (containerScreen = (class_465)screen).method_17577()) instanceof class_1707) {
            class_1707 chestMenu = (class_1707)class_17032;
            class_2561 title = containerScreen.method_25440();
            InventoryType inventoryType = this.main.getInventoryUtils().updateInventoryType(title);
            class_1277 chestContainer = (class_1277)chestMenu.method_7629();
            this.addInventoryChangeListener(chestContainer);
            if (Feature.BACKPACK_OPENING_SOUND.isEnabled() && title.getString().contains("Backpack")) {
                this.lastBackpackOpenMs = System.currentTimeMillis();
                if (ThreadLocalRandom.current().nextInt(0, 2) == 0) {
                    Utils.playSound((class_3414)class_3417.field_15141.comp_349(), 0.5, 1.0);
                } else {
                    Utils.playSound((class_3414)class_3417.field_14704.comp_349(), 0.5, 1.0);
                }
            }
            if (Feature.SHOW_BACKPACK_PREVIEW.isEnabled() && (inventoryType == InventoryType.STORAGE_BACKPACK || inventoryType == InventoryType.ENDER_CHEST)) {
                ContainerPreviewManager.onContainerOpen(chestContainer);
            }
        }
    }

    private void beforeKeyPress(class_437 screen, class_11908 event) {
        class_437 class_4372;
        if (this.main.getUtils().isOnSkyblock()) {
            ContainerPreviewManager.onContainerKeyTyped(event.comp_4795());
        }
        if (Feature.DEVELOPER_MODE.isEnabled() && event.comp_4795() == SkyblockKeyBinding.DEVELOPER_COPY_NBT.getKeyCode() && (class_4372 = ScreenListener.MC.field_1755) instanceof class_465) {
            class_465 containerScreen = (class_465)class_4372;
            class_1735 currentSlot = containerScreen.field_2787;
            if (currentSlot != null && currentSlot.method_7681() && ScreenListener.MC.field_1687 != null) {
                DevUtils.setCopyMode(DevUtils.CopyMode.ITEM);
                if (currentSlot.method_7677().method_57826(class_9334.field_49617)) {
                    class_9296.field_49359.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)((class_9296)currentSlot.method_7677().method_58694(class_9334.field_49617))).result().ifPresent(arg_0 -> ((Logger)LOGGER).info(arg_0));
                }
                if (currentSlot.method_7677().method_57826(class_9334.field_49631)) {
                    LOGGER.info(TextUtils.componentToJson(currentSlot.method_7677().method_65130()));
                }
                DevUtils.copyNBTTagToClipboard(ItemUtils.encodeItemStack(currentSlot.method_7677()), String.valueOf(ColorCode.GREEN) + "Item data was copied to clipboard!");
            }
        }
    }

    public boolean onGuiOpen(class_437 screen) {
        if (!this.main.getUtils().isOnSkyblock()) {
            return false;
        }
        class_437 oldGuiScreen = ScreenListener.MC.field_1755;
        if (screen == null) {
            boolean closed;
            if (oldGuiScreen instanceof class_476) {
                class_476 containerScreen = (class_476)oldGuiScreen;
                InventoryType inventoryType = this.main.getInventoryUtils().getInventoryType();
                if (inventoryType == InventoryType.EQUIPMENT) {
                    this.setEquipments((class_1707)containerScreen.method_17577());
                } else if (inventoryType == InventoryType.SKYBLOCK_MENU && this.main.getUtils().isOnRift()) {
                    this.setRiftPet((class_1707)containerScreen.method_17577());
                }
                closed = true;
            } else {
                closed = oldGuiScreen instanceof SkyblockAddonsScreen;
            }
            if (closed) {
                this.lastContainerCloseMs = System.currentTimeMillis();
                this.main.getInventoryUtils().setInventoryType(null);
            }
        }
        if (oldGuiScreen instanceof class_476) {
            class_476 containerScreen = (class_476)oldGuiScreen;
            if (this.inventoryChangeListener != null) {
                this.removeInventoryChangeListener(this.listenedInventory);
            }
            ContainerPreviewManager.onContainerClose();
            this.setCurrentPet(containerScreen);
        }
        return false;
    }

    public void onInventoryLoadingDone() {
        class_465 containerScreen;
        class_1703 class_17032;
        class_437 screen = ScreenListener.MC.field_1755;
        InventoryType inventoryType = this.main.getInventoryUtils().getInventoryType();
        if (this.listenedInventory != null) {
            this.removeInventoryChangeListener(this.listenedInventory);
            this.lastInventoryChangeMs = -1L;
        }
        if (screen instanceof class_465 && (class_17032 = (containerScreen = (class_465)screen).method_17577()) instanceof class_1707) {
            class_9290 itemLore;
            class_1799 petMenuBone;
            class_1707 chestMenu = (class_1707)class_17032;
            class_1277 chestContainer = (class_1277)chestMenu.method_7629();
            if (inventoryType == InventoryType.STORAGE) {
                for (int i = 0; i < chestContainer.method_5439(); ++i) {
                    int slot;
                    BackpackColor backpackColor;
                    class_1799 item = chestContainer.method_5438(i);
                    if (item == class_1799.field_8037 || item.method_7909() != class_1802.field_8575 || (backpackColor = ItemUtils.getBackpackColor(item)) == null || (slot = ItemUtils.getBackpackSlot(item)) == 0) continue;
                    BackpackInventoryManager.getBackpackColor().put(slot, backpackColor);
                }
            } else if (inventoryType == InventoryType.CALENDAR) {
                for (int i = 0; i < chestContainer.method_5439(); ++i) {
                    class_2561 name;
                    class_1799 item = chestContainer.method_5438(i);
                    if (item == class_1799.field_8037 || item.method_7909() != class_1802.field_8575 || (name = item.method_65130()) == null || !name.getString().contains("Mayor ")) continue;
                    String mayorName = name.getString();
                    if (!(mayorName = mayorName.substring(mayorName.indexOf(32) + 1)).equals(this.main.getUtils().getMayor())) {
                        DataUtils.loadOnlineData(new MayorRequest(mayorName));
                        this.main.getUtils().setMayor(mayorName);
                        LOGGER.info("Mayor changed to {}", (Object)mayorName);
                    }
                    if (mayorName.contains("Jerry")) {
                        this.main.getMayorJerryData().parseMayorJerryPerkpocalypse(item);
                    }
                    break;
                }
            } else if (inventoryType == InventoryType.MAYOR) {
                String mayorName = this.main.getInventoryUtils().getInventoryMayorName();
                if (!class_3544.method_15438((String)mayorName)) {
                    if (!mayorName.equals(this.main.getUtils().getMayor())) {
                        DataUtils.loadOnlineData(new MayorRequest(mayorName));
                        this.main.getUtils().setMayor(mayorName);
                        LOGGER.info("Mayor changed to {}", (Object)mayorName);
                    }
                    if (mayorName.contains("Jerry")) {
                        for (int i = 0; i < chestContainer.method_5439(); ++i) {
                            class_2561 customName;
                            class_1799 item = chestContainer.method_5438(i);
                            if (item == class_1799.field_8037 || item.method_7909() != class_1802.field_8575 || (customName = item.method_65130()) == null || !customName.getString().contains("Mayor")) continue;
                            this.main.getMayorJerryData().parseMayorJerryPerkpocalypse(item);
                        }
                    }
                }
            } else if (inventoryType == InventoryType.EQUIPMENT) {
                this.setEquipments(chestMenu);
            } else if (inventoryType == InventoryType.SKYBLOCK_MENU) {
                if (this.main.getUtils().isOnRift()) {
                    this.setRiftPet(chestMenu);
                }
            } else if (inventoryType == InventoryType.PETS && (petMenuBone = chestMenu.method_7611(4).method_7677()).method_7909() == class_1802.field_8606 && (itemLore = (class_9290)petMenuBone.method_58694(class_9334.field_49632)) != null) {
                String selectedPet = null;
                for (class_2561 line : itemLore.comp_2400()) {
                    String lineString = line.getString();
                    if (!lineString.contains("Selected pet:")) continue;
                    int colonIndex = lineString.indexOf(58);
                    if (colonIndex == -1) break;
                    selectedPet = lineString.substring(colonIndex + 2);
                    break;
                }
                if (selectedPet != null) {
                    PetCacheManager petCacheManager = this.main.getPetCacheManager();
                    PetManager.Pet currentPet = petCacheManager.getCurrentPet();
                    if (selectedPet.contains("None")) {
                        petCacheManager.setCurrentPet(null);
                    } else if (currentPet != null && !currentPet.getDisplayName().endsWith(selectedPet)) {
                        PetManager.Pet petToSet = null;
                        for (PetManager.Pet pet : petCacheManager.getPetCache().getPetMap().values()) {
                            if (!pet.getDisplayName().endsWith(selectedPet)) continue;
                            if (petToSet == null) {
                                petToSet = pet;
                                continue;
                            }
                            petToSet = null;
                            break;
                        }
                        if (petToSet != null) {
                            petCacheManager.setCurrentPet(petToSet);
                        }
                    }
                }
            }
        }
    }

    public boolean allowMouseClick(class_437 screen, class_11909 event) {
        if (!this.main.getUtils().isOnSkyblock()) {
            return true;
        }
        ContainerPreviewManager.onContainerKeyTyped(event.method_74245());
        return true;
    }

    void containerChanged(class_1277 inventory) {
        if (inventory.method_5438(inventory.method_5439() - 1) != class_1799.field_8037) {
            ((SkyblockAddonsEvents.InventoryLoading)SkyblockAddonsEvents.INVENTORY_LOADING_DONE.invoker()).onInventoryLoadingDone();
        } else {
            this.lastInventoryChangeMs = System.currentTimeMillis();
        }
    }

    private void addInventoryChangeListener(class_1277 inventory) {
        if (inventory == null) {
            throw new NullPointerException("Tried to add listener to null inventory.");
        }
        this.lastInventoryChangeMs = System.currentTimeMillis();
        this.inventoryChangeListener = new InventoryChangeListener(this);
        inventory.method_5489((class_1265)this.inventoryChangeListener);
        this.listenedInventory = inventory;
        this.inventoryChangeTimeCheckTask = this.main.getScheduler().scheduleTask(scheduledTask -> this.checkLastInventoryChangeTime(), 20, 5);
    }

    private void checkLastInventoryChangeTime() {
        if (this.listenedInventory != null && this.lastInventoryChangeMs > -1L && System.currentTimeMillis() - this.lastInventoryChangeMs > 1000L) {
            ((SkyblockAddonsEvents.InventoryLoading)SkyblockAddonsEvents.INVENTORY_LOADING_DONE.invoker()).onInventoryLoadingDone();
        }
    }

    private void removeInventoryChangeListener(class_1277 inventory) {
        if (inventory == null) {
            throw new NullPointerException("Tried to remove listener from null inventory.");
        }
        if (this.inventoryChangeListener != null) {
            try {
                inventory.method_5488((class_1265)this.inventoryChangeListener);
            }
            catch (NullPointerException e) {
                LOGGER.catching((Throwable)e);
            }
            if (this.inventoryChangeTimeCheckTask != null && !this.inventoryChangeTimeCheckTask.isCanceled()) {
                this.inventoryChangeTimeCheckTask.cancel();
            }
            this.inventoryChangeListener = null;
            this.listenedInventory = null;
            this.inventoryChangeTimeCheckTask = null;
        }
    }

    private void setCurrentPet(class_476 containerScreen) {
        boolean isClosedGuiPets = InventoryType.PETS.getInventoryPattern().matcher(containerScreen.method_25440().getString()).matches();
        if (!isClosedGuiPets) {
            return;
        }
        PetCacheManager petCacheManager = this.main.getPetCacheManager();
        Int2ObjectOpenHashMap<PetManager.Pet> petMap = petCacheManager.getPetCache().getPetMap();
        Pair<Integer, Integer> clickedButton = AbstractContainerScreenHook.getLastClickedButtonOnPetsMenu();
        if (clickedButton == null || clickedButton.getLeft() >= 54) {
            return;
        }
        int pageNum = this.main.getInventoryUtils().getInventoryPageNum();
        int index = clickedButton.getLeft() + 45 * (pageNum == 0 ? 0 : pageNum - 1);
        if (petMap.containsKey(index)) {
            PetManager.Pet pet = (PetManager.Pet)petMap.get(index);
            if (pet.getPetInfo().isActive()) {
                petCacheManager.setCurrentPet(null);
            } else if (clickedButton.getRight() != 1) {
                petCacheManager.setCurrentPet(pet);
            }
            AbstractContainerScreenHook.setLastClickedButtonOnPetsMenu(null);
        }
    }

    private void setEquipments(class_1707 chestMenu) {
        SkyblockEquipment.NECKLACE.setItemStack(chestMenu.method_7611(10).method_7677());
        SkyblockEquipment.CLOAK.setItemStack(chestMenu.method_7611(19).method_7677());
        SkyblockEquipment.BELT.setItemStack(chestMenu.method_7611(28).method_7677());
        SkyblockEquipment.GLOVES_BRACELET.setItemStack(chestMenu.method_7611(37).method_7677());
        class_1799 petItem = chestMenu.method_7611(47).method_7677();
        if (petItem.method_31574(class_1802.field_8240)) {
            this.main.getPetCacheManager().setCurrentPet(null, false);
            SkyblockEquipment.PET.setItemStack(petItem);
        } else if (petItem.method_31574(class_1802.field_8575)) {
            PetManager.Pet newPet = PetManager.getInstance().getPetFromItemStack(petItem);
            Int2ObjectOpenHashMap<PetManager.Pet> petMap = this.main.getPetCacheManager().getPetCache().getPetMap();
            if (newPet != null) {
                for (Int2ObjectMap.Entry entry : petMap.int2ObjectEntrySet()) {
                    int entryKey = entry.getIntKey();
                    PetManager.Pet entryValue = (PetManager.Pet)petMap.get(entryKey);
                    if (!newPet.getPetInfo().getUniqueId().equals(entryValue.getPetInfo().getUniqueId())) continue;
                    petMap.put(entryKey, (Object)newPet);
                    this.main.getPetCacheManager().saveValues();
                    break;
                }
            }
            SkyblockEquipment.PET.setItemStack(petItem);
        }
        SkyblockEquipment.saveEquipments();
    }

    private void setRiftPet(class_1707 chestMenu) {
        class_1799 riftPet = chestMenu.method_7611(30).method_7677();
        if (riftPet.method_31574(class_1802.field_8575)) {
            SkyblockEquipment.PET.setItemStack(riftPet);
            SkyblockEquipment.saveEquipments();
        }
    }

    @Generated
    public long getLastContainerCloseMs() {
        return this.lastContainerCloseMs;
    }

    @Generated
    public long getLastBackpackOpenMs() {
        return this.lastBackpackOpenMs;
    }
}

