/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.SkyblockKeyBinding;
import com.fix3dll.skyblockaddons.core.Translations;
import com.fix3dll.skyblockaddons.utils.ReflectionUtils;
import com.fix3dll.skyblockaddons.utils.TextUtils;
import com.fix3dll.skyblockaddons.utils.Utils;
import com.fix3dll.skyblockaddons.utils.data.DataUtils;
import com.mojang.blaze3d.platform.GLX;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.minecraft.class_11362;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2479;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_266;
import net.minecraft.class_268;
import net.minecraft.class_2680;
import net.minecraft.class_269;
import net.minecraft.class_270;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3283;
import net.minecraft.class_329;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_8646;
import net.minecraft.class_8942;
import org.lwjgl.opengl.GL11;
import org.slf4j.Logger;

public class DevUtils {
    private static final class_310 MC = class_310.method_1551();
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    private static final org.apache.logging.log4j.Logger LOGGER = SkyblockAddons.getLogger();
    private static final Logger slf4jLogger = LogUtils.getLogger();
    public static final Object2ObjectOpenHashMap<String, Class<? extends class_1297>> ALL_ENTITIES = new Object2ObjectOpenHashMap();
    public static final int DEFAULT_ENTITY_COPY_RADIUS = 3;
    private static final List<Class<? extends class_1297>> DEFAULT_ENTITY_NAMES = Collections.singletonList(class_1309.class);
    private static final boolean DEFAULT_SIDEBAR_FORMATTED = false;
    private static boolean loggingActionBarMessages = false;
    private static boolean loggingSlayerTracker = false;
    private static boolean loggingSkyBlockOre = false;
    private static CopyMode copyMode = CopyMode.ENTITY;
    private static List<Class<? extends class_1297>> entityNames = DEFAULT_ENTITY_NAMES;
    private static int entityCopyRadius = 3;
    private static boolean sidebarFormatted = false;

    public static void copyScoreboardSideBar() {
        DevUtils.copyScoreboardSidebar(sidebarFormatted);
    }

    private static void copyScoreboardSidebar(boolean stripControlCodes) {
        if (DevUtils.MC.field_1687 == null) {
            return;
        }
        class_269 scoreboard = DevUtils.MC.field_1687.method_8428();
        if (scoreboard == null) {
            Utils.sendErrorMessage("Nothing is being displayed in the sidebar!");
            return;
        }
        class_266 sideBarObjective = scoreboard.method_1189(class_8646.field_45157);
        if (sideBarObjective == null) {
            Utils.sendErrorMessage("Nothing is being displayed in the sidebar!");
            return;
        }
        String title = stripControlCodes ? TextUtils.stripColor(sideBarObjective.method_1114().getString()) : TextUtils.getFormattedText(sideBarObjective.method_1114(), true);
        StringBuilder stringBuilder = new StringBuilder(title).append("\n");
        scoreboard.method_1184(sideBarObjective).stream().filter(scoreboardEntry -> !scoreboardEntry.method_55385()).sorted(class_329.field_47550).limit(15L).forEach(scoreboardEntry -> {
            String owner = scoreboardEntry.comp_2127();
            class_2561 name = scoreboardEntry.method_55387();
            class_268 team = scoreboard.method_1164(owner);
            class_5250 decoratedName = class_268.method_1142((class_270)team, (class_2561)name);
            String text = stripControlCodes ? TextUtils.stripColor(decoratedName.getString()) : TextUtils.getFormattedText((class_2561)decoratedName, true);
            stringBuilder.append(text.replace(owner, ""));
            if (!stripControlCodes) {
                stringBuilder.append(" [").append(scoreboardEntry.comp_2128()).append("]");
            }
            stringBuilder.append("\n");
        });
        DevUtils.copyStringToClipboard(stringBuilder.toString(), String.valueOf(ColorCode.GREEN) + "Sidebar copied to clipboard!");
    }

    private static void copyEntityData(List<Class<? extends class_1297>> includedEntityClasses, int copyRadius) {
        class_746 player = DevUtils.MC.field_1724;
        class_638 world = DevUtils.MC.field_1687;
        if (player == null || world == null) {
            return;
        }
        Iterator loadedEntitiesCopyIterator = world.method_18112().iterator();
        StringBuilder stringBuilder = new StringBuilder();
        while (loadedEntitiesCopyIterator.hasNext()) {
            class_2487 entityData;
            class_1297 entity = (class_1297)loadedEntitiesCopyIterator.next();
            boolean isPartOfIncludedClasses = false;
            if (entity.method_5739((class_1297)player) > (float)copyRadius) continue;
            for (Class<? extends class_1297> entityClass : includedEntityClasses) {
                if (!entityClass.isAssignableFrom(entity.getClass())) continue;
                isPartOfIncludedClasses = true;
            }
            if (!isPartOfIncludedClasses) continue;
            try (class_8942.class_11340 scopedCollector = new class_8942.class_11340(slf4jLogger);){
                class_11362 tagValueOutput = class_11362.method_71459((class_8942)scopedCollector, (class_7225.class_7874)entity.method_56673());
                entity.method_5647((class_11372)tagValueOutput);
                entityData = tagValueOutput.method_71475();
            }
            if (!stringBuilder.isEmpty()) {
                stringBuilder.append(System.lineSeparator()).append(System.lineSeparator());
            }
            stringBuilder.append("Class: ").append(entity.getClass().getSimpleName()).append(System.lineSeparator());
            if (entity.method_16914() || class_1657.class.isAssignableFrom(entity.getClass())) {
                stringBuilder.append("Name: ").append(entity.method_5477()).append(System.lineSeparator());
            }
            stringBuilder.append("NBT Data:").append(System.lineSeparator());
            stringBuilder.append(DevUtils.prettyPrintNBT((class_2520)entityData));
        }
        if (!stringBuilder.isEmpty()) {
            DevUtils.copyStringToClipboard(stringBuilder.toString(), String.valueOf(ColorCode.GREEN) + "Entity data was copied to clipboard!");
        } else {
            Utils.sendErrorMessage("No entities matching the given parameters were found.");
        }
    }

    public static void setEntityNamesFromString(String includedEntityNames) {
        List<Class<? extends class_1297>> entityClasses = DevUtils.getEntityClassListFromString(includedEntityNames);
        if (entityClasses == null || entityClasses.isEmpty()) {
            Utils.sendErrorMessage("The entity class list is not valid or is empty! Falling back to default.");
            DevUtils.resetEntityNamesToDefault();
        } else {
            entityNames = entityClasses;
        }
    }

    public static void setEntityCopyRadius(int copyRadius) {
        if (copyRadius <= 0) {
            Utils.sendErrorMessage("Radius cannot be negative! Falling back to 3.");
            DevUtils.resetEntityCopyRadiusToDefault();
        } else {
            entityCopyRadius = copyRadius;
        }
    }

    public static void resetEntityNamesToDefault() {
        entityNames = DEFAULT_ENTITY_NAMES;
    }

    public static void resetEntityCopyRadiusToDefault() {
        entityCopyRadius = 3;
    }

    public static void copyEntityData() {
        DevUtils.copyEntityData(entityNames, entityCopyRadius);
    }

    private static List<Class<? extends class_1297>> getEntityClassListFromString(String text) {
        String[] entityNamesArray;
        Matcher listMatcher = Pattern.compile("(^[A-Z_]+)(?:,[A-Z_]+)*$", 2).matcher(text);
        if (!listMatcher.matches()) {
            return null;
        }
        ArrayList<Class<? extends class_1297>> entityClasses = new ArrayList<Class<? extends class_1297>>();
        for (String entityName : entityNamesArray = text.split(",")) {
            if (ALL_ENTITIES.containsKey((Object)entityName)) {
                entityClasses.add((Class)ALL_ENTITIES.get((Object)entityName));
                continue;
            }
            Utils.sendErrorMessage("The entity name \"" + entityName + "\" is invalid. Skipping!");
        }
        return entityClasses;
    }

    public static void copyData() {
        switch (copyMode.ordinal()) {
            case 0: {
                DevUtils.copyBlockData();
                break;
            }
            case 1: {
                DevUtils.copyEntityData();
                break;
            }
            case 3: {
                DevUtils.copyScoreboardSideBar();
                break;
            }
            case 4: {
                DevUtils.copyTabListHeaderAndFooter();
            }
        }
    }

    public static void copyNBTTagToClipboard(class_2520 nbtTag, String message) {
        if (nbtTag == null) {
            Utils.sendErrorMessage("This item has no NBT data!");
            return;
        }
        DevUtils.writeToClipboard(DevUtils.prettyPrintNBT(nbtTag), message);
    }

    public static void copyTabListHeaderAndFooter() {
        class_2561 tabHeader = DevUtils.MC.field_1705.method_1750().field_2153;
        class_2561 tabFooter = DevUtils.MC.field_1705.method_1750().field_2154;
        if (tabHeader == null && tabFooter == null) {
            Utils.sendErrorMessage("There is no header or footer!");
            return;
        }
        StringBuilder output = new StringBuilder();
        if (tabHeader != null) {
            output.append("Header:").append("\n");
            output.append(TextUtils.getFormattedText(tabHeader));
            output.append("\n\n");
        }
        if (tabFooter != null) {
            output.append("Footer:").append("\n");
            output.append(TextUtils.getFormattedText(tabFooter));
        }
        DevUtils.copyStringToClipboard(output.toString(), String.valueOf(ColorCode.GREEN) + "Successfully copied the tab list header and footer to clipboard!");
    }

    public static void copyOpenGLLogs() {
        String gpu = GL11.glGetString((int)7937);
        String cpu = GLX._getCpuInfo();
        String output = "```\nCPU: %s\nGPU: %s\n```\n".formatted(cpu, gpu);
        DevUtils.copyStringToClipboard(output, String.valueOf(ColorCode.GREEN) + "Successfully copied the OpenGL logs to clipboard!");
    }

    public static void copyStringToClipboard(String string, String successMessage) {
        DevUtils.writeToClipboard(string, successMessage);
    }

    public static String getServerBrand() {
        class_634 networkHandler = MC.method_1562();
        if (!MC.method_1542() && networkHandler != null) {
            return networkHandler.method_52790();
        }
        return null;
    }

    public static void copyBlockData() {
        class_3965 blockTarget;
        class_239 crosshairTarget = DevUtils.MC.field_1765;
        if (!(crosshairTarget instanceof class_3965) || (blockTarget = (class_3965)crosshairTarget).method_17783() == class_239.class_240.field_1333 || DevUtils.MC.field_1687 == null) {
            Utils.sendErrorMessage("You are not looking at a block!");
            return;
        }
        class_2338 blockPos = blockTarget.method_17777();
        class_2680 blockState = DevUtils.MC.field_1687.method_8320(blockPos);
        if (!DevUtils.MC.field_1687.method_27982()) {
            blockState = blockState.method_26204().method_34725(blockState);
        }
        class_2586 blockEntity = DevUtils.MC.field_1687.method_8321(blockPos);
        class_2487 nbt = new class_2487();
        if (blockEntity != null) {
            nbt.method_10566("blockEntity", (class_2520)blockEntity.method_38242((class_7225.class_7874)DevUtils.MC.field_1687.method_30349()));
        } else {
            nbt.method_10582("id", class_7923.field_41175.method_10221((Object)blockState.method_26204()).toString());
            nbt.method_10569("x", blockPos.method_10263());
            nbt.method_10569("y", blockPos.method_10264());
            nbt.method_10569("z", blockPos.method_10260());
        }
        for (class_2769 property : blockState.method_28501()) {
            if (!blockState.method_28498(property)) continue;
            Optional value = blockState.method_28500(property);
            nbt.method_10582(property.method_11899(), value.isPresent() ? value.get().toString() : "");
        }
        DevUtils.writeToClipboard(DevUtils.prettyPrintNBT((class_2520)nbt), String.valueOf(ColorCode.GREEN) + "Successfully copied the block data!");
    }

    public static String prettyPrintNBT(class_2520 nbt) {
        String INDENT = "    ";
        byte tagID = nbt.method_10711();
        StringBuilder stringBuilder = new StringBuilder();
        if (tagID == 0) {
            stringBuilder.append('}');
        } else if (tagID == 7 || tagID == 11) {
            stringBuilder.append('[');
            if (tagID == 7) {
                class_2479 nbtByteArray = (class_2479)nbt;
                byte[] bytes = nbtByteArray.method_10521();
                for (int i = 0; i < bytes.length; ++i) {
                    stringBuilder.append(bytes[i]);
                    if (i >= bytes.length - 1) continue;
                    stringBuilder.append(", ");
                }
            } else {
                class_2495 nbtIntArray = (class_2495)nbt;
                int[] ints = nbtIntArray.method_10588();
                for (int i = 0; i < ints.length; ++i) {
                    stringBuilder.append(ints[i]);
                    if (i >= ints.length - 1) continue;
                    stringBuilder.append(", ");
                }
            }
            stringBuilder.append(']');
        } else if (tagID == 9) {
            class_2499 nbtTagList = (class_2499)nbt;
            stringBuilder.append('[');
            for (int i = 0; i < nbtTagList.size(); ++i) {
                class_2520 currentListElement = nbtTagList.method_10534(i);
                stringBuilder.append(DevUtils.prettyPrintNBT(currentListElement));
                if (i >= nbtTagList.size() - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append(']');
        } else if (tagID == 10) {
            class_2487 nbtTagCompound = (class_2487)nbt;
            stringBuilder.append('{');
            if (!nbtTagCompound.method_33133()) {
                Iterator iterator = nbtTagCompound.method_10541().iterator();
                stringBuilder.append(System.lineSeparator());
                while (iterator.hasNext()) {
                    String key = (String)iterator.next();
                    class_2520 currentCompoundTagElement = nbtTagCompound.method_10580(key);
                    stringBuilder.append(key).append(": ").append(DevUtils.prettyPrintNBT(currentCompoundTagElement));
                    if (key.contains("backpack_data") && currentCompoundTagElement instanceof class_2479) {
                        try {
                            class_2487 backpackData = class_2507.method_10629((InputStream)new ByteArrayInputStream(((class_2479)currentCompoundTagElement).method_10521()), (class_2505)class_2505.method_53898());
                            stringBuilder.append(",").append(System.lineSeparator());
                            stringBuilder.append(key).append("(decoded): ").append(DevUtils.prettyPrintNBT((class_2520)backpackData));
                        }
                        catch (IOException e) {
                            LOGGER.error("Couldn't decompress backpack data into NBT, skipping!", (Throwable)e);
                        }
                    }
                    if (!iterator.hasNext()) continue;
                    stringBuilder.append(",").append(System.lineSeparator());
                }
                String indentedString = stringBuilder.toString().replaceAll(System.lineSeparator(), System.lineSeparator() + "    ");
                stringBuilder = new StringBuilder(indentedString);
            }
            stringBuilder.append(System.lineSeparator()).append('}');
        } else {
            stringBuilder.append(nbt);
        }
        return stringBuilder.toString();
    }

    public static void reloadAll() {
        DevUtils.reloadConfig();
        DevUtils.reloadResources();
    }

    public static void reloadConfig() {
        Utils.sendMessageOrElseLog("Reloading settings...", LOGGER, false);
        main.getConfigValuesManager().loadValues();
        Utils.sendMessageOrElseLog("Settings reloaded.", LOGGER, false);
    }

    public static void reloadResources() {
        Utils.sendMessageOrElseLog(Translations.getMessage("messages.reloadingResources", new Object[0]), LOGGER, false);
        DataUtils.registerNewRemoteRequests();
        DataUtils.readLocalAndFetchOnline();
        main.getPersistentValuesManager().loadValues();
        main.getScheduler().scheduleAsyncTask(scheduledTask -> {
            if (!scheduledTask.isCanceled() && DataUtils.getExecutionServiceMetrics().getActiveConnectionCount() == 0L) {
                DataUtils.onSkyblockJoined();
                class_3283 packs = MC.method_1520();
                if (packs.method_29207("skyblockaddons") && packs.method_29210().contains("skyblockaddons")) {
                    MC.method_1521().whenComplete((unused, throwable) -> {
                        if (throwable == null) {
                            Utils.sendMessageOrElseLog(Translations.getMessage("messages.resourcesReloaded", new Object[0]), LOGGER, false);
                        } else {
                            Utils.sendMessageOrElseLog(throwable.getMessage(), LOGGER, false);
                        }
                    });
                } else {
                    Utils.sendMessageOrElseLog(Translations.getMessage("messages.resourcesReloaded", new Object[0]), LOGGER, false);
                }
                scheduledTask.cancel();
            }
        }, 0, 2);
    }

    private static void writeToClipboard(String text, String successMessage) {
        try {
            DevUtils.MC.field_1774.method_1455(text);
            if (successMessage != null) {
                Utils.sendMessage(successMessage);
            }
        }
        catch (IllegalStateException exception) {
            Utils.sendErrorMessage("Clipboard not available!");
        }
    }

    public static void setCopyMode(CopyMode copyMode) {
        if (DevUtils.copyMode != copyMode) {
            DevUtils.copyMode = copyMode;
            Utils.sendMessage(String.valueOf(ColorCode.GREEN) + Translations.getMessage("messages.copyModeSet", new Object[]{copyMode, SkyblockKeyBinding.DEVELOPER_COPY_NBT.getKeyBinding().method_16007().getString()}));
        }
    }

    @Generated
    public static boolean isLoggingActionBarMessages() {
        return loggingActionBarMessages;
    }

    @Generated
    public static void setLoggingActionBarMessages(boolean loggingActionBarMessages) {
        DevUtils.loggingActionBarMessages = loggingActionBarMessages;
    }

    @Generated
    public static boolean isLoggingSlayerTracker() {
        return loggingSlayerTracker;
    }

    @Generated
    public static void setLoggingSlayerTracker(boolean loggingSlayerTracker) {
        DevUtils.loggingSlayerTracker = loggingSlayerTracker;
    }

    @Generated
    public static boolean isLoggingSkyBlockOre() {
        return loggingSkyBlockOre;
    }

    @Generated
    public static void setLoggingSkyBlockOre(boolean loggingSkyBlockOre) {
        DevUtils.loggingSkyBlockOre = loggingSkyBlockOre;
    }

    @Generated
    public static void setSidebarFormatted(boolean sidebarFormatted) {
        DevUtils.sidebarFormatted = sidebarFormatted;
    }

    static {
        try {
            List<Class<?>> allEntities = ReflectionUtils.scanPackage("net.minecraft", class_310.class.getClassLoader(), class_1309.class);
            for (Class<?> entityClass : allEntities) {
                String entityName = entityClass.getSimpleName().replace("Entity", "");
                ALL_ENTITIES.put((Object)entityName, entityClass);
            }
        }
        catch (Exception ex) {
            LOGGER.catching((Throwable)ex);
        }
    }

    public static enum CopyMode {
        BLOCK,
        ENTITY,
        ITEM,
        SIDEBAR,
        TAB_LIST;

    }
}

