/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.render.chroma.ChromaRenderType;
import com.fix3dll.skyblockaddons.core.render.chroma.ManualChromaManager;
import com.fix3dll.skyblockaddons.core.render.state.CornerRenderState;
import com.fix3dll.skyblockaddons.core.render.state.FillAbsoluteRenderState;
import com.fix3dll.skyblockaddons.core.render.state.SbaTextRenderState;
import com.fix3dll.skyblockaddons.mixin.hooks.FontHook;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import com.fix3dll.skyblockaddons.utils.SkyblockColor;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.minecraft.class_10789;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_11247;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3544;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4668;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_9848;
import net.minecraft.class_9851;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix4f;

public class DrawUtils {
    private static final Pattern COLOR_CODE_PATTERN = Pattern.compile("(?i)\u00a7[0-9A-F]");
    public static final RenderPipeline TRIANGLE_FAN = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56860}).withUsePipelineDrawModeForGui(true).withLocation("pipeline/debug_triangle_fan").withCull(false).withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27381).build());
    public static final RenderPipeline CHROMA_STANDARD = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_60125}).withLocation(SkyblockAddons.resourceLocation("sba_chroma_standard")).withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27382).withVertexShader(SkyblockAddons.resourceLocation("chroma_standard")).withFragmentShader(SkyblockAddons.resourceLocation("chroma_standard")).withUniform("ChromaUniforms", class_10789.field_60031).withDepthWrite(true).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).build());
    public static final RenderPipeline CHROMA_TEXT = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_60125}).withLocation(SkyblockAddons.resourceLocation("sba_chroma_text")).withVertexFormat(class_290.field_1575, VertexFormat.class_5596.field_27382).withBlend(BlendFunction.TRANSLUCENT).withVertexShader(SkyblockAddons.resourceLocation("chroma_textured")).withFragmentShader(SkyblockAddons.resourceLocation("chroma_textured")).withUniform("ChromaUniforms", class_10789.field_60031).withSampler("Sampler0").withDepthWrite(true).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).build());
    private static final Function<class_2960, class_1921> CHROMA_TEXTURED = class_156.method_34866(texture -> new ChromaRenderType("sba_chroma_textured", 1536, false, false, CHROMA_TEXT, class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(texture, class_9851.field_52395.method_61348(false))).method_23617(false)));
    public static final class_5251 CHROMA_TEXT_COLOR = new class_5251(ColorCode.CHROMA.getColor(), "chroma");

    public static class_1921 getChromaTextured(class_2960 resourceLocation) {
        return CHROMA_TEXTURED.apply(resourceLocation);
    }

    public static void drawRoundedRect(class_332 graphics, int x, int y, int width, int height, int radius, int color) {
        class_11231 textureSetup = class_11231.method_70899();
        Matrix3x2fStack poseStack = graphics.method_51448();
        radius = Math.min(radius, Math.min(width, height) / 2);
        graphics.method_71048();
        graphics.field_59826.method_70919((class_11244)new CornerRenderState(TRIANGLE_FAN, textureSetup, (Matrix3x2f)poseStack, x + radius, y + radius, radius, CornerRenderState.RoundedRectCorner.TOP_LEFT, color, graphics.field_44659.method_70863()));
        graphics.method_71048();
        graphics.method_25294(x + radius, y, x + width - radius, y + height, color);
        graphics.field_59826.method_70919((class_11244)new CornerRenderState(TRIANGLE_FAN, textureSetup, (Matrix3x2f)poseStack, x + width - radius, y + radius, radius, CornerRenderState.RoundedRectCorner.TOP_RIGHT, color, null));
        graphics.method_25294(x + width - radius, y + radius, x + width, y + height - radius, color);
        graphics.field_59826.method_70919((class_11244)new CornerRenderState(TRIANGLE_FAN, textureSetup, (Matrix3x2f)poseStack, x + radius, y + height - radius, radius, CornerRenderState.RoundedRectCorner.BOTTOM_RIGHT, color, graphics.field_44659.method_70863()));
        graphics.method_71048();
        graphics.method_25294(x, y + radius, x + radius, y + height - radius, color);
        graphics.method_71048();
        graphics.field_59826.method_70919((class_11244)new CornerRenderState(TRIANGLE_FAN, textureSetup, (Matrix3x2f)poseStack, x + width - radius, y + height - radius, radius, CornerRenderState.RoundedRectCorner.BOTTOM_LEFT, color, null));
    }

    public static void drawCylinder(class_4587 poseStack, class_4588 vc, double x, double y, double z, float radius, float height, SkyblockColor color) {
        class_243 cam = class_310.method_1551().field_1773.method_19418().method_19326();
        poseStack.method_22903();
        poseStack.method_22904(x - cam.field_1352, y - cam.field_1351, z - cam.field_1350);
        Matrix4f pose = poseStack.method_23760().method_23761();
        int packed = 0xF000F0;
        int lu = 240;
        int lv = 240;
        boolean multi = color.drawMulticolorManually();
        int rI = 255;
        int gI = 255;
        int bI = 255;
        int aI = 255;
        if (!multi) {
            int argb = color.getColor();
            rI = class_9848.method_61327((int)argb);
            gI = class_9848.method_61329((int)argb);
            bI = class_9848.method_61331((int)argb);
            aI = class_9848.method_61320((int)argb);
        }
        double startAngle = Math.atan2(cam.field_1350 - z, cam.field_1352 - x) + Math.PI;
        int SEG = 64;
        double STEP = 0.09817477042468103;
        for (int seg = 0; seg < 32; ++seg) {
            DrawUtils.addQuad(vc, pose, startAngle + (double)seg * 0.09817477042468103, startAngle + (double)(seg + 1) * 0.09817477042468103, radius, height, color, multi, rI, gI, bI, aI, lu, lv);
            DrawUtils.addQuad(vc, pose, startAngle - (double)seg * 0.09817477042468103, startAngle - (double)(seg + 1) * 0.09817477042468103, radius, height, color, multi, rI, gI, bI, aI, lu, lv);
        }
        poseStack.method_22909();
    }

    public static void renderOutlineAbsolute(class_332 graphics, RenderPipeline renderPipeline, class_11231 textureSetup, float x, float y, float width, float height, int thickness, int color) {
        graphics.field_59826.method_70919((class_11244)new FillAbsoluteRenderState(renderPipeline, textureSetup, (Matrix3x2f)graphics.method_51448(), x - (float)thickness, y, x, y + height, color, graphics.field_44659.method_70863()));
        graphics.field_59826.method_70919((class_11244)new FillAbsoluteRenderState(renderPipeline, textureSetup, (Matrix3x2f)graphics.method_51448(), x - (float)thickness, y - (float)thickness, x + width + (float)thickness, y, color, graphics.field_44659.method_70863()));
        graphics.field_59826.method_70919((class_11244)new FillAbsoluteRenderState(renderPipeline, textureSetup, (Matrix3x2f)graphics.method_51448(), x + width, y, x + width + (float)thickness, y + height, color, graphics.field_44659.method_70863()));
        graphics.field_59826.method_70919((class_11244)new FillAbsoluteRenderState(renderPipeline, textureSetup, (Matrix3x2f)graphics.method_51448(), x - (float)thickness, y + height, x - (float)thickness + width + (float)(thickness * 2), y + height + (float)thickness, color, graphics.field_44659.method_70863()));
    }

    public static void drawCenteredText(class_332 graphics, String text, float x, float y, int color) {
        DrawUtils.drawText(graphics, text, x - (float)class_310.method_1551().field_1772.method_1727(text) / 2.0f, y, color);
    }

    public static void drawText(class_332 graphics, String text, float x, float y, int color) {
        DrawUtils.drawText(graphics, text, x, y, color, false);
    }

    public static void drawText(class_332 graphics, String text, float x, float y, int color, boolean chromaDisabled) {
        if (class_3544.method_15438((String)text)) {
            return;
        }
        boolean isChroma = !chromaDisabled && color == ManualChromaManager.getChromaColor(0.0f, 0.0f, class_9848.method_61320((int)color));
        boolean styleTwo = Feature.TEXT_STYLE.getValue() == EnumUtils.TextStyle.STYLE_TWO;
        Object strippedText = styleTwo || isChroma ? "\u00a7r" + COLOR_CODE_PATTERN.matcher(text).replaceAll("\u00a7r") : text;
        class_5250 component = isChroma && Feature.CHROMA_MODE.getValue() == EnumUtils.ChromaMode.FADE ? class_2561.method_43470((String)strippedText).method_27694(style -> style.method_27703(CHROMA_TEXT_COLOR)) : class_2561.method_43470((String)text);
        if (styleTwo) {
            int colorAlpha = Math.max(class_9848.method_61320((int)color), 4);
            int colorBlack = class_9848.method_61324((int)colorAlpha, (int)0, (int)0, (int)0);
            FontHook.setHaltChroma(true);
            class_5481 strippedFcs = class_2477.method_10517().method_30934(class_5348.method_29430((String)strippedText));
            graphics.field_59826.method_70921((class_11247)new SbaTextRenderState(strippedFcs, (Matrix3x2f)graphics.method_51448(), x + 1.0f, y, colorBlack, 0, false, graphics.field_44659.method_70863()));
            graphics.field_59826.method_70921((class_11247)new SbaTextRenderState(strippedFcs, (Matrix3x2f)graphics.method_51448(), x - 1.0f, y, colorBlack, 0, false, graphics.field_44659.method_70863()));
            graphics.field_59826.method_70921((class_11247)new SbaTextRenderState(strippedFcs, (Matrix3x2f)graphics.method_51448(), x, y + 1.0f, colorBlack, 0, false, graphics.field_44659.method_70863()));
            graphics.field_59826.method_70921((class_11247)new SbaTextRenderState(strippedFcs, (Matrix3x2f)graphics.method_51448(), x, y - 1.0f, colorBlack, 0, false, graphics.field_44659.method_70863()));
            FontHook.setHaltChroma(false);
            graphics.field_59826.method_70921((class_11247)new SbaTextRenderState(component.method_30937(), (Matrix3x2f)graphics.method_51448(), x, y, color, 0, false, graphics.field_44659.method_70863()));
        } else {
            graphics.field_59826.method_70921((class_11247)new SbaTextRenderState(component.method_30937(), (Matrix3x2f)graphics.method_51448(), x, y, color, 0, true, graphics.field_44659.method_70863()));
        }
    }

    public static void blitAbsolute(class_4587.class_4665 pose, class_4588 vertexConsumer, float x, float y, float uOffset, float vOffset, float uWidth, float vHeight, float textureWidth, float textureHeight, int color) {
        float x2 = x + uWidth;
        float y2 = y + vHeight;
        float minU = (uOffset + 0.0f) / textureWidth;
        float maxU = (uOffset + uWidth) / textureWidth;
        float minV = (vOffset + 0.0f) / textureHeight;
        float maxV = (vOffset + vHeight) / textureHeight;
        vertexConsumer.method_56824(pose, x, y, 0.0f).method_22913(minU, minV).method_39415(color);
        vertexConsumer.method_56824(pose, x, y2, 0.0f).method_22913(minU, maxV).method_39415(color);
        vertexConsumer.method_56824(pose, x2, y2, 0.0f).method_22913(maxU, maxV).method_39415(color);
        vertexConsumer.method_56824(pose, x2, y, 0.0f).method_22913(maxU, minV).method_39415(color);
    }

    private static void addQuad(class_4588 vc, Matrix4f pose, double ang0, double ang1, float radius, float h, SkyblockColor clr, boolean multi, int r, int g, int b, int a, int lu, int lv) {
        float x0 = (float)((double)radius * Math.cos(ang0));
        float z0 = (float)((double)radius * Math.sin(ang0));
        float x1 = (float)((double)radius * Math.cos(ang1));
        float z1 = (float)((double)radius * Math.sin(ang1));
        DrawUtils.push(vc, pose, x0, h, z0, clr, multi, r, g, b, 0, lu, lv);
        DrawUtils.push(vc, pose, x1, h, z1, clr, multi, r, g, b, 0, lu, lv);
        DrawUtils.push(vc, pose, x1, 0.0f, z1, clr, multi, r, g, b, a, lu, lv);
        DrawUtils.push(vc, pose, x0, 0.0f, z0, clr, multi, r, g, b, a, lu, lv);
    }

    private static void push(class_4588 vc, Matrix4f pose, float x, float y, float z, SkyblockColor clr, boolean multi, int r, int g, int b, int a, int lu, int lv) {
        if (multi) {
            int dyn = clr.getColorAtPosition(x, y, z);
            r = class_9848.method_61327((int)dyn);
            g = class_9848.method_61329((int)dyn);
            b = class_9848.method_61331((int)dyn);
            a = class_9848.method_61320((int)dyn);
        }
        vc.method_22918(pose, x, y, z).method_1336(r, g, b, a).method_22913(0.0f, 0.0f).method_22921(lu, lv).method_22914(0.0f, 1.0f, 0.0f);
    }
}

