/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils;

import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.Language;
import com.fix3dll.skyblockaddons.features.discordrpc.DiscordStatus;
import com.fix3dll.skyblockaddons.features.enchants.EnchantLayout;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import com.fix3dll.skyblockaddons.utils.objects.RegistrableEnum;
import java.util.HashMap;
import lombok.NonNull;

public class EnumRegistry {
    public static final HashMap<String, Class<? extends RegistrableEnum>> REGISTRY = new HashMap();

    public static RegistrableEnum getEnumValue(String enumType, String enumKey) {
        Class<? extends RegistrableEnum> enumClass = REGISTRY.get(enumType);
        if (enumClass == null) {
            throw new IllegalArgumentException("Unknown enum type: " + enumType);
        }
        try {
            Class<? extends RegistrableEnum> enumSubclass = enumClass;
            return Enum.valueOf(enumSubclass, enumKey);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid enum value for " + enumType + ": " + enumKey);
        }
    }

    public static Class<? extends Enum> getEnumClass(@NonNull String enumName) {
        if (enumName == null) {
            throw new NullPointerException("enumName is marked non-null but is null");
        }
        for (Class<? extends RegistrableEnum> enumClass : REGISTRY.values()) {
            for (RegistrableEnum enumType : enumClass.getEnumConstants()) {
                if (!enumName.equals(enumType.name())) continue;
                return enumClass.asSubclass(Enum.class);
            }
        }
        return null;
    }

    static {
        REGISTRY.put("ANCHOR_POINT", EnumUtils.AnchorPoint.class);
        REGISTRY.put("BACKPACK_STYLE", EnumUtils.BackpackStyle.class);
        REGISTRY.put("DEPLOYABLE_DISPLAY_STYLE", EnumUtils.DeployableDisplayStyle.class);
        REGISTRY.put("PET_ITEM_STYLE", EnumUtils.PetItemStyle.class);
        REGISTRY.put("TEXT_STYLE", EnumUtils.TextStyle.class);
        REGISTRY.put("CHROMA_MODE", EnumUtils.ChromaMode.class);
        REGISTRY.put("AUTO_UPDATE", EnumUtils.AutoUpdateMode.class);
        REGISTRY.put("COLOR_CODE", ColorCode.class);
        REGISTRY.put("ENCHANT_LAYOUT", EnchantLayout.class);
        REGISTRY.put("LANGUAGE", Language.class);
        REGISTRY.put("DISCORD_RP_STATE", DiscordStatus.class);
        REGISTRY.put("DISCORD_RP_DETAILS", DiscordStatus.class);
        REGISTRY.put("DISCORD_RP_AUTO_MODE", DiscordStatus.class);
        REGISTRY.put("COMMA_ENCHANT_COLOR", ColorCode.class);
        REGISTRY.put("POOR_ENCHANT_COLOR", ColorCode.class);
        REGISTRY.put("GOOD_ENCHANT_COLOR", ColorCode.class);
        REGISTRY.put("GREAT_ENCHANT_COLOR", ColorCode.class);
        REGISTRY.put("PERFECT_ENCHANT_COLOR", ColorCode.class);
        REGISTRY.put("HEALER_COLOR", ColorCode.class);
        REGISTRY.put("MAGE_COLOR", ColorCode.class);
        REGISTRY.put("BERSERK_COLOR", ColorCode.class);
        REGISTRY.put("ARCHER_COLOR", ColorCode.class);
        REGISTRY.put("TANK_COLOR", ColorCode.class);
    }
}

