/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.ItemType;
import com.fix3dll.skyblockaddons.core.PetInfo;
import com.fix3dll.skyblockaddons.core.SkyblockRarity;
import com.fix3dll.skyblockaddons.core.SkyblockRune;
import com.fix3dll.skyblockaddons.features.backpacks.BackpackColor;
import com.fix3dll.skyblockaddons.utils.TextUtils;
import com.fix3dll.skyblockaddons.utils.Utils;
import com.fix3dll.skyblockaddons.utils.data.skyblockdata.CompactorItem;
import com.fix3dll.skyblockaddons.utils.data.skyblockdata.ContainerData;
import com.fix3dll.skyblockaddons.utils.data.skyblockdata.TexturedHead;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2479;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.logging.log4j.Logger;

public class ItemUtils {
    private static final Logger LOGGER = SkyblockAddons.getLogger();
    private static final class_310 MC = class_310.method_1551();
    private static final Pattern ITEM_TYPE_AND_RARITY_PATTERN = Pattern.compile("\u00a7l(?<rarity>[A-Z]+(?: SPECIAL)?) ?(?<type>[A-Z ]+)?(?:\u00a7[0-9a-f]\u00a7l\u00a7ka)?(?:\u00a78\\(ID (?<id>[A-Z]+\\d+)\\))?$");
    private static final Pattern BACKPACK_SLOT_PATTERN = Pattern.compile("Backpack Slot (?<slot>\\d+)");
    private static Object2ObjectOpenHashMap<String, CompactorItem> compactorItems;
    private static Object2ObjectOpenHashMap<String, ContainerData> containers;
    private static Object2ObjectOpenHashMap<String, TexturedHead> texturedHeads;

    @NonNull
    public static class_1799 getTexturedHead(String identifier) {
        if (texturedHeads != null) {
            TexturedHead texturedHead = (TexturedHead)texturedHeads.get((Object)identifier);
            return texturedHead == null ? class_1802.field_8077.method_7854() : texturedHead.getItemStack();
        }
        return class_1802.field_8077.method_7854();
    }

    public static SkyblockRarity getRarity(class_1799 item) {
        if (item == null) {
            throw new NullPointerException("The item cannot be null!");
        }
        return ItemUtils.getRarity(ItemUtils.getItemLore(item));
    }

    public static ItemType getItemType(class_1799 item) {
        if (item == null) {
            throw new NullPointerException("The item cannot be null!");
        }
        return ItemUtils.getType(ItemUtils.getItemLore(item));
    }

    public static class_1799 getPersonalCompactorItemStack(String personalCompactorSkyblockID) {
        CompactorItem compactorItem = (CompactorItem)compactorItems.get((Object)personalCompactorSkyblockID);
        if (compactorItem != null) {
            return compactorItem.getItemStack();
        }
        class_1799 unknown = ItemUtils.createItemStack(class_1802.field_8077, String.valueOf(ColorCode.GOLD) + personalCompactorSkyblockID, personalCompactorSkyblockID, false);
        ItemUtils.setItemLore(unknown, Collections.singletonList(class_2561.method_43470((String)"SBA cannot found this item!").method_54663(ColorCode.RED.getColor())));
        return unknown;
    }

    public static ContainerData getContainerData(String skyblockID) {
        return (ContainerData)containers.get((Object)skyblockID);
    }

    public static class_2487 getExtraAttributes(class_1799 item) {
        if (item == null) {
            throw new NullPointerException("The item cannot be null!");
        }
        class_9279 customData = (class_9279)item.method_58694(class_9334.field_49628);
        return customData == null ? null : customData.method_57461();
    }

    public static Map<String, Integer> getEnchantments(class_1799 itemStack) {
        class_2487 extraAttributes = ItemUtils.getExtraAttributes(itemStack);
        return extraAttributes == null ? Collections.emptyMap() : ItemUtils.getEnchantments(extraAttributes);
    }

    public static Map<String, Integer> getEnchantments(class_2487 extraAttributes) {
        if (extraAttributes == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> enchantmentsMap = new HashMap<String, Integer>();
        extraAttributes.method_10562("enchantments").ifPresent(enchantments -> enchantments.method_59874().forEach(entry -> enchantmentsMap.put((String)entry.getKey(), ((class_2520)entry.getValue()).method_68602().orElse(0))));
        return enchantmentsMap;
    }

    public static Map<String, Integer> getAttributes(class_1799 itemStack) {
        class_2487 extraAttributes = ItemUtils.getExtraAttributes(itemStack);
        return extraAttributes == null ? Collections.emptyMap() : ItemUtils.getAttributes(extraAttributes);
    }

    public static Map<String, Integer> getAttributes(class_2487 extraAttributes) {
        if (extraAttributes == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Integer> attributesMap = new HashMap<String, Integer>();
        extraAttributes.method_10562("attributes").ifPresent(attributes -> attributes.method_59874().forEach(entry -> attributesMap.put((String)entry.getKey(), ((class_2520)entry.getValue()).method_68602().orElse(0))));
        return attributesMap;
    }

    public static String getReforge(class_1799 itemStack) {
        class_2487 extraAttributes = ItemUtils.getExtraAttributes(itemStack);
        if (extraAttributes == null) {
            return null;
        }
        Optional modifier = extraAttributes.method_10558("modifier");
        if (modifier.isPresent()) {
            String reforge = WordUtils.capitalizeFully((String)((String)modifier.get()));
            reforge = reforge.replace("_sword", "");
            reforge = reforge.replace("_bow", "");
            reforge = reforge.replace("Warped", "Hyper");
            return reforge;
        }
        return null;
    }

    public static boolean isMaterialForRecipe(class_1799 itemStack) {
        List<String> lore = ItemUtils.getItemLore(itemStack);
        for (String loreLine : lore) {
            if (!"Right-click to view recipes!".equals(TextUtils.stripColor(loreLine))) continue;
            return true;
        }
        return false;
    }

    public static boolean isMiningTool(class_1799 itemStack) {
        return itemStack.method_31573(class_3489.field_42614) || ItemUtils.isDrill(itemStack);
    }

    public static boolean isDrill(class_1799 itemStack) {
        if (itemStack == null) {
            return false;
        }
        class_2487 extraAttributes = ItemUtils.getExtraAttributes(itemStack);
        return extraAttributes != null && extraAttributes.method_10545("drill_fuel");
    }

    public static String getSkyblockItemID(class_1799 itemStack) {
        class_2487 extraAttributes = ItemUtils.getExtraAttributes(itemStack);
        return ItemUtils.getSkyblockItemID(extraAttributes);
    }

    public static String getSkyblockItemID(class_2487 extraAttributes) {
        return extraAttributes == null ? null : (String)extraAttributes.method_10558("id").orElse(null);
    }

    public static BackpackColor getBackpackColor(class_1799 stack) {
        Optional backpack_color;
        class_2487 extraAttributes = ItemUtils.getExtraAttributes(stack);
        if (extraAttributes != null && (backpack_color = extraAttributes.method_10558("backpack_color")).isPresent()) {
            try {
                return BackpackColor.valueOf((String)backpack_color.get());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return BackpackColor.DEFAULT;
    }

    public static int getBackpackSlot(class_1799 itemStack) {
        if (itemStack == null) {
            return 0;
        }
        Matcher matcher = BACKPACK_SLOT_PATTERN.matcher(itemStack.method_7954().getString());
        if (matcher.find()) {
            return Integer.parseInt(matcher.group("slot"));
        }
        return 0;
    }

    public static SkyblockRune getRuneData(class_2487 extraAttributes) {
        if (extraAttributes != null) {
            HashMap<String, Integer> runesMap = new HashMap<String, Integer>();
            extraAttributes.method_10562("runes").ifPresent(runes -> runes.method_59874().forEach(entry -> runesMap.put((String)entry.getKey(), ((class_2520)entry.getValue()).method_68602().orElse(0))));
            return new SkyblockRune(runesMap);
        }
        return null;
    }

    public static PetInfo getPetInfo(class_1799 itemStack) {
        class_2487 extraAttributes = ItemUtils.getExtraAttributes(itemStack);
        return ItemUtils.getPetInfo(extraAttributes);
    }

    public static PetInfo getPetInfo(class_2487 extraAttributes) {
        if (extraAttributes == null) {
            return null;
        }
        return extraAttributes.method_10558("petInfo").map(str -> SkyblockAddons.getGson().fromJson((String)str, PetInfo.class)).orElse(null);
    }

    public static List<String> getItemLore(class_1799 itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("Cannot get lore from null item!");
        }
        class_9290 itemLore = (class_9290)itemStack.method_58694(class_9334.field_49632);
        if (itemLore == null) {
            return Collections.emptyList();
        }
        List lore = itemLore.comp_2400();
        return lore.stream().map(component -> TextUtils.getFormattedText(component, true)).toList();
    }

    public static void setItemLore(class_1799 itemStack, List<class_2561> lore) {
        itemStack.method_57379(class_9334.field_49632, (Object)new class_9290(lore));
    }

    public static boolean isMenuItem(class_1799 itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("Item stack cannot be null!");
        }
        class_2487 extraAttributes = ItemUtils.getExtraAttributes(itemStack);
        return extraAttributes != null && !extraAttributes.method_10545("uuid");
    }

    public static class_1799 createItemStack(class_1792 item, boolean enchanted) {
        return ItemUtils.createItemStack(item, null, null, enchanted);
    }

    public static class_1799 createItemStack(class_1792 item, String name, String skyblockID, boolean enchanted) {
        class_1799 stack = item.method_7854();
        if (name != null) {
            stack.method_57379(class_9334.field_50239, (Object)class_2561.method_43470((String)name));
        }
        if (enchanted) {
            stack.method_57379(class_9334.field_49641, (Object)true);
        }
        if (skyblockID != null) {
            ItemUtils.setItemStackSkyblockID(stack, skyblockID);
        }
        return stack;
    }

    public static class_1799 createEnchantedBook(SkyblockRarity rarity, String enchantName, int enchantLevel) {
        String name = rarity == null ? "Enchanted Book" : String.valueOf(rarity.getColorCode()) + "Enchanted Book";
        class_1799 stack = ItemUtils.createItemStack(class_1802.field_8598, name, "ENCHANTED_BOOK", false);
        class_2487 enchantments = new class_2487();
        enchantments.method_10569(enchantName, enchantLevel);
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)enchantments));
        return stack;
    }

    public static class_1799 createSkullItemStack(@NonNull JsonElement profile, JsonElement customName, String skyblockId) {
        if (profile == null) {
            throw new NullPointerException("profile is marked non-null but is null");
        }
        class_1799 stack = new class_1799((class_1935)class_1802.field_8575);
        class_9296.field_49359.parse((DynamicOps)JsonOps.INSTANCE, (Object)profile).result().ifPresent(resolvableProfile -> stack.method_57379(class_9334.field_49617, resolvableProfile));
        class_5250 component = null;
        if (customName != null) {
            component = TextUtils.componentFromJson(customName);
        }
        if (component != null) {
            stack.method_57379(class_9334.field_49631, (Object)component);
        }
        if (skyblockId != null) {
            ItemUtils.setItemStackSkyblockID(stack, skyblockId);
        }
        return stack;
    }

    public static void setItemStackSkyblockID(class_1799 itemStack, String skyblockID) {
        class_9279 customData;
        class_2487 ea = ItemUtils.getExtraAttributes(itemStack);
        if (ea != null) {
            ea.method_10582("id", skyblockID);
            customData = class_9279.method_57456((class_2487)ea);
        } else {
            customData = class_9279.method_57456((class_2487)new class_2487());
        }
        itemStack.method_57379(class_9334.field_49628, (Object)customData);
    }

    public static String getSkullOwnerID(class_1799 skull) {
        if (skull == null) {
            return null;
        }
        class_9296 profile = (class_9296)skull.method_58694(class_9334.field_49617);
        if (profile != null) {
            return profile.method_73313().id().toString();
        }
        return null;
    }

    public static String getSkullTexture(class_1799 skull) {
        GameProfile gameProfile;
        Iterator textures;
        if (skull == null) {
            return null;
        }
        class_9296 profile = (class_9296)skull.method_58694(class_9334.field_49617);
        if (profile != null && (textures = (gameProfile = profile.method_73313()).properties().get((Object)"textures").iterator()).hasNext()) {
            return ((Property)textures.next()).value();
        }
        return null;
    }

    public static class_2479 getCompressedNBT(class_1799[] items) {
        class_2499 list = new class_2499();
        for (class_1799 item : items) {
            if (item == null || item == class_1799.field_8037) {
                list.add((Object)new class_2487());
                continue;
            }
            class_2520 listTag = ItemUtils.encodeItemStack(item);
            list.add((Object)listTag);
        }
        class_2487 nbt = new class_2487();
        nbt.method_10566("i", (class_2520)list);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try (ByteArrayOutputStream byteArrayOutputStream = stream;){
            class_2507.method_10634((class_2487)nbt, (OutputStream)stream);
        }
        catch (IOException e) {
            return null;
        }
        return new class_2479(stream.toByteArray());
    }

    public static class_2520 encodeItemStack(class_1799 itemStack) {
        class_5455 registryAccess = Utils.registryAccess();
        return (class_2520)class_1799.field_24671.encodeStart((DynamicOps)registryAccess.method_57093((DynamicOps)class_2509.field_11560), (Object)itemStack).getOrThrow();
    }

    public static Optional<class_1799> parseTag(class_2520 tag) {
        class_5455 registryAccess = Utils.registryAccess();
        return class_1799.field_24671.parse((DynamicOps)registryAccess.method_57093((DynamicOps)class_2509.field_11560), (Object)tag).resultOrPartial(string -> LOGGER.error("Tried to load invalid item: '{}'", string));
    }

    public static int getThunderCharge(class_1799 bottle) {
        class_2487 ea = ItemUtils.getExtraAttributes(bottle);
        return ea == null ? 0 : ea.method_68083("thunder_charge", 0);
    }

    public static UUID getUuid(class_1799 itemStack) {
        class_2487 extraAttributes = ItemUtils.getExtraAttributes(itemStack);
        return extraAttributes == null ? null : (UUID)extraAttributes.method_10558("uuid").map(UUID::fromString).orElse(null);
    }

    public static boolean isQuiverArrow(class_1799 itemStack) {
        class_2487 ea = ItemUtils.getExtraAttributes(itemStack);
        return ea != null && ea.method_68566("quiver_arrow", false);
    }

    private static SkyblockRarity getRarity(List<String> lore) {
        for (int i = lore.size() - 1; i >= 0; --i) {
            String currentLine = lore.get(i);
            Matcher rarityMatcher = ITEM_TYPE_AND_RARITY_PATTERN.matcher(currentLine);
            if (!rarityMatcher.find()) continue;
            String rarity = rarityMatcher.group("rarity");
            for (SkyblockRarity itemRarity : SkyblockRarity.values()) {
                if (!itemRarity.getLoreName().startsWith(rarity)) continue;
                return itemRarity;
            }
        }
        return null;
    }

    private static ItemType getType(List<String> lore) {
        for (int i = lore.size() - 1; i >= 0; --i) {
            String type;
            String currentLine = lore.get(i);
            Matcher itemTypeMatcher = ITEM_TYPE_AND_RARITY_PATTERN.matcher(currentLine);
            if (!itemTypeMatcher.find() || (type = itemTypeMatcher.group("type")) == null) continue;
            type = type.trim();
            for (ItemType itemType : ItemType.values()) {
                if (!itemType.getLoreName().startsWith(type)) continue;
                return itemType;
            }
        }
        return null;
    }

    @Generated
    public static Object2ObjectOpenHashMap<String, CompactorItem> getCompactorItems() {
        return compactorItems;
    }

    @Generated
    public static void setCompactorItems(Object2ObjectOpenHashMap<String, CompactorItem> compactorItems) {
        ItemUtils.compactorItems = compactorItems;
    }

    @Generated
    public static void setContainers(Object2ObjectOpenHashMap<String, ContainerData> containers) {
        ItemUtils.containers = containers;
    }

    @Generated
    public static void setTexturedHeads(Object2ObjectOpenHashMap<String, TexturedHead> texturedHeads) {
        ItemUtils.texturedHeads = texturedHeads;
    }
}

