/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils;

import net.minecraft.class_1297;
import net.minecraft.class_3532;

public class MathUtils {
    public static boolean isInside(int x, int y, int minX, int minY, int maxX, int maxY) {
        return x >= minX && x <= maxX && y > minY && y < maxY;
    }

    public static boolean isInside(float x, float y, float minX, float minY, float maxX, float maxY) {
        return x >= minX && x <= maxX && y > minY && y < maxY;
    }

    public static float normalizeSliderValue(float value, float min, float max, float step) {
        return MathUtils.clamp((MathUtils.snapToStep(value, step) - min) / (max - min), 0.0f, 1.0f);
    }

    public static float denormalizeSliderValue(float value, float min, float max, float step) {
        return MathUtils.clamp(MathUtils.snapToStep(min + (max - min) * MathUtils.clamp(value, 0.0f, 1.0f), step), min, max);
    }

    private static float snapToStep(float value, float step) {
        return step * (float)Math.round(value / step);
    }

    public static float clamp(float value, float min, float max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static double interpolateX(class_1297 entity, float partialTicks) {
        return MathUtils.interpolate(entity.field_6038, entity.method_23317(), partialTicks);
    }

    public static double interpolateY(class_1297 entity, float partialTicks) {
        return MathUtils.interpolate(entity.field_5971, entity.method_23318(), partialTicks);
    }

    public static double interpolateZ(class_1297 entity, float partialTicks) {
        return MathUtils.interpolate(entity.field_5989, entity.method_23321(), partialTicks);
    }

    public static double interpolate(double first, double second, float partialTicks) {
        return first + (second - first) * (double)partialTicks;
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return MathUtils.distance((float)x1, (float)y1, (float)z1, (float)x2, (float)y2, (float)z2);
    }

    public static double distance(float x1, float y1, float z1, float x2, float y2, float z2) {
        float deltaX = x1 - x2;
        float deltaY = y1 - y2;
        float deltaZ = z1 - z2;
        return class_3532.method_15355((float)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
    }

    public static double distance(double x1, double y1, double x2, double y2) {
        return MathUtils.distance((float)x1, (float)y1, (float)x2, (float)y2);
    }

    public static double distance(float x1, float y1, float x2, float y2) {
        float deltaX = x1 - x2;
        float deltaY = y1 - y2;
        return class_3532.method_15355((float)(deltaX * deltaX + deltaY * deltaY));
    }
}

