/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils;

import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.render.chroma.ManualChromaManager;
import com.fix3dll.skyblockaddons.utils.ColorUtils;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import java.awt.Color;
import java.util.LinkedList;
import lombok.Generated;
import net.minecraft.class_9848;

public class SkyblockColor {
    private static final int DEFAULT_COLOR = -1;
    private ColorAnimation colorAnimation = ColorAnimation.NONE;
    private final LinkedList<Integer> colors = new LinkedList();

    public SkyblockColor() {
        this(-1);
    }

    public SkyblockColor(int color) {
        this.colors.add(color);
    }

    public SkyblockColor(int color, float alpha) {
        this.colors.add(ColorUtils.setColorAlpha(color, alpha));
    }

    public SkyblockColor(int r, int g, int b, int a) {
        this.colors.add(class_9848.method_61324((int)a, (int)r, (int)g, (int)b));
    }

    public SkyblockColor(int r, int g, int b, float a) {
        this.colors.add(class_9848.method_61324((int)ColorUtils.getAlphaIntFromFloat(a), (int)r, (int)g, (int)b));
    }

    public int getColorAtPosition(float x, float y) {
        if (this.colorAnimation == ColorAnimation.CHROMA) {
            return ManualChromaManager.getChromaColor(x, y, class_9848.method_61320((int)this.getColor()));
        }
        return this.colors.getFirst();
    }

    public int getTintAtPosition(float x, float y) {
        if (this.colorAnimation == ColorAnimation.CHROMA) {
            return ManualChromaManager.getChromaColor(x, y, Color.RGBtoHSB(class_9848.method_61327((int)this.getColor()), class_9848.method_61329((int)this.getColor()), class_9848.method_61331((int)this.getColor()), null), class_9848.method_61320((int)this.getColor()));
        }
        return this.colors.getFirst();
    }

    public int getColorAtPosition(double x, double y, double z) {
        return this.getColorAtPosition((float)x, (float)y, (float)z);
    }

    public int getColorAtPosition(float x, float y, float z) {
        if (this.colorAnimation == ColorAnimation.CHROMA) {
            return ManualChromaManager.getChromaColor(x, y, z, class_9848.method_61320((int)this.getColor()));
        }
        return this.colors.getFirst();
    }

    public SkyblockColor setColor(int color) {
        return this.setColor(0, color);
    }

    public SkyblockColor setColor(int index, int color) {
        if (index >= this.colors.size()) {
            this.colors.add(color);
        } else {
            this.colors.set(index, color);
        }
        return this;
    }

    public boolean isMulticolor() {
        return this.colorAnimation != ColorAnimation.NONE;
    }

    public int getColor() {
        return this.getColorSafe(0);
    }

    private int getColorSafe(int index) {
        while (index >= this.colors.size()) {
            this.colors.add(-1);
        }
        return this.colors.get(index);
    }

    public boolean drawMulticolorManually() {
        return this.colorAnimation == ColorAnimation.CHROMA && !SkyblockColor.shouldUseChromaShaders();
    }

    public boolean drawMulticolorUsingShader() {
        return this.colorAnimation == ColorAnimation.CHROMA && SkyblockColor.shouldUseChromaShaders();
    }

    public static boolean shouldUseChromaShaders() {
        return Feature.CHROMA_MODE.getValue() != EnumUtils.ChromaMode.ALL_SAME_COLOR;
    }

    @Generated
    public ColorAnimation getColorAnimation() {
        return this.colorAnimation;
    }

    @Generated
    public SkyblockColor setColorAnimation(ColorAnimation colorAnimation) {
        this.colorAnimation = colorAnimation;
        return this;
    }

    public static enum ColorAnimation {
        NONE,
        CHROMA;

    }
}

