/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.Island;
import com.fix3dll.skyblockaddons.core.SkyblockDate;
import com.fix3dll.skyblockaddons.core.SkyblockEquipment;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.events.SkyblockEvents;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import com.fix3dll.skyblockaddons.utils.RomanNumeralParser;
import com.fix3dll.skyblockaddons.utils.ScoreboardManager;
import com.fix3dll.skyblockaddons.utils.TextUtils;
import com.fix3dll.skyblockaddons.utils.objects.Pair;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.FloatBuffer;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2504;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_9334;
import net.minecraft.class_9848;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Utils {
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    private static final Logger LOGGER = SkyblockAddons.getLogger();
    public static final String MESSAGE_PREFIX = String.valueOf(ColorCode.GRAY) + "[" + String.valueOf(ColorCode.AQUA) + SkyblockAddons.METADATA.getName() + String.valueOf(ColorCode.GRAY) + "] ";
    public static final String MESSAGE_PREFIX_SHORT = String.valueOf(ColorCode.GRAY) + "[" + String.valueOf(ColorCode.AQUA) + "SBA" + String.valueOf(ColorCode.GRAY) + "] " + String.valueOf(ColorCode.RESET);
    private static final Set<String> SKYBLOCK_IN_ALL_LANGUAGES = Sets.newHashSet((Object[])new String[]{"SKYBLOCK", "\u7a7a\u5c9b\u751f\u5b58", "\u7a7a\u5cf6\u751f\u5b58"});
    private static final Pattern SERVER_REGEX = Pattern.compile("^\\d+/\\d+/\\d+ (?<serverType>[Mm])(?<serverCode>[0-9]+[A-Z]+) ?(?:(?<x>-?\\d+),(?<z>-?\\d+))?(?<mineshaft>[A-Z]+\\d)?$");
    private static final Pattern SLAYER_TYPE_REGEX = Pattern.compile("(?<type>Tarantula Broodfather|Revenant Horror|Sven Packmaster|Voidgloom Seraph|Inferno Demonlord|Riftstalker Bloodfiend) (?<level>[IV]+)");
    private static final Pattern SLAYER_PROGRESS_REGEX = Pattern.compile("(?<progress>[0-9.k]*)/(?<total>[0-9.k]*) (?:Kills|Combat XP)$");
    private static final Pattern DATE_PATTERN = Pattern.compile("(?<month>[\\w ]+) (?<day>\\d{1,2})(?:th|st|nd|rd)");
    private static final Pattern TIME_PATTERN = Pattern.compile("(?<hour>\\d{1,2}):(?<minute>\\d{2})(?<period>am|pm)");
    private static final Pattern PEST_PATTERN = Pattern.compile(" \u0d60 x\\d");
    private static class_638 DUMMY_WORLD;
    public static final String USER_AGENT;
    public static boolean blockNextClick;
    private List<String> reforgeMatches = new LinkedList<String>();
    private List<String> reforgeExclusions = new LinkedList<String>();
    private boolean onSkyblock = false;
    private boolean onRift = false;
    private boolean isTrackingAnimal = false;
    private String location = "Unknown";
    private Island map = Island.UNKNOWN;
    private boolean isGuest = false;
    private String mode = "null";
    private String mayor = "Fix3dll";
    private Pair<String, String> ministerAndPerk = new Pair<String, String>("Fix3dll", "Spaghetti code");
    private String jerryMayor = "Fix3dll";
    private long jerryMayorUpdateTime = 0L;
    private String dungeonFloor = "0";
    private String plotName = "";
    private String profileName = "Unknown";
    private boolean playingLoudSound;
    private String serverID = "";
    private String mineshaftID = "";
    private int lastHoveredSlot = -1;
    private boolean usingFSRcontainerPreviewTexture = false;
    private SkyblockDate currentDate = new SkyblockDate(SkyblockDate.SkyblockMonth.EARLY_WINTER, 1, 1, 1, "am");
    private double purse = 0.0;
    private double bits = 0.0;
    private double motes = 0.0;
    private int jerryWave = -1;
    private boolean alpha;
    private boolean inDungeon;
    private boolean fadingIn;
    private EnumUtils.SlayerQuest slayerQuest;
    private int slayerQuestLevel = 1;
    private boolean slayerBossAlive;
    private boolean triggeredSlayerWarning = false;
    private float lastCompletion;
    private boolean depthEnabled;
    private boolean blendEnabled;
    private boolean alphaEnabled;
    private int blendFunctionSrcFactor;
    private int blendFunctionDstFactor;

    public static void sendMessage(class_2561 text, boolean prefix) {
        class_746 player;
        boolean eventCanceled;
        class_2561 message = prefix ? class_2561.method_43470((String)MESSAGE_PREFIX).method_10852(text) : text;
        boolean bl = eventCanceled = !((ClientReceiveMessageEvents.AllowGame)ClientReceiveMessageEvents.ALLOW_GAME.invoker()).allowReceiveGameMessage(message, false);
        if (!eventCanceled && (player = class_310.method_1551().field_1724) != null) {
            player.method_7353(message, false);
        }
    }

    public static void sendMessage(String string, boolean prefix) {
        Utils.sendMessage((class_2561)class_2561.method_43470((String)string), prefix);
    }

    public static void sendMessage(String string) {
        Utils.sendMessage(string, true);
    }

    public static void sendMessage(class_2561 text) {
        Utils.sendMessage(text, true);
    }

    public static void sendMessageOrElseLog(String message, Logger logger, boolean isError) {
        if (class_310.method_1551().field_1724 != null) {
            if (isError) {
                Utils.sendErrorMessage(message);
            } else {
                Utils.sendMessage(message);
            }
        } else if (isError) {
            logger.error(message);
        } else {
            logger.info(message);
        }
    }

    public static void sendErrorMessage(String errorText) {
        Utils.sendMessage((class_2561)class_2561.method_43470((String)"Error: ").method_27693(String.valueOf(ColorCode.RED) + errorText), false);
    }

    public boolean isOnHypixel() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        String brand = player.field_3944.method_52790();
        if (brand != null) {
            for (Pattern p : main.getOnlineData().getHypixelBrands()) {
                if (!p.matcher(brand).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public void parseSidebar() {
        boolean foundScoreboard = false;
        boolean foundSkyblockTitle = false;
        boolean foundServerID = false;
        boolean foundDate = false;
        boolean foundLocation = false;
        boolean foundPlot = false;
        boolean foundTime = false;
        boolean foundCoins = false;
        boolean foundBits = false;
        boolean foundTrackingAnimal = false;
        boolean foundJerryWave = false;
        boolean foundAlphaIP = false;
        boolean foundInDungeon = false;
        boolean foundSlayerQuest = false;
        boolean foundBossAlive = false;
        if (this.isOnHypixel() && ScoreboardManager.hasScoreboard()) {
            foundScoreboard = true;
            String strippedScoreboardTitle = ScoreboardManager.getStrippedScoreboardTitle();
            this.isGuest = strippedScoreboardTitle.endsWith("GUEST");
            for (String skyblock : SKYBLOCK_IN_ALL_LANGUAGES) {
                if (!strippedScoreboardTitle.startsWith(skyblock)) continue;
                foundSkyblockTitle = true;
                break;
            }
            if (foundSkyblockTitle) {
                if (!this.isOnSkyblock()) {
                    ((SkyblockEvents.SkyblockJoined)SkyblockEvents.JOINED.invoker()).onSkyblockJoined();
                }
                Matcher dateMatcher = null;
                for (int lineNumber = 0; lineNumber < ScoreboardManager.getNumberOfLines(); ++lineNumber) {
                    Matcher slayerMatcher;
                    Matcher dateM;
                    Matcher matcher;
                    String line = ScoreboardManager.getScoreboardLines().get(lineNumber);
                    String strippedLine = ScoreboardManager.getStrippedScoreboardLines().get(lineNumber);
                    if (strippedLine.isEmpty()) continue;
                    if (!foundServerID && lineNumber == 0 && (matcher = SERVER_REGEX.matcher(strippedLine)).find()) {
                        String serverType = matcher.group("serverType");
                        if (serverType.equals("m")) {
                            this.serverID = "mini" + matcher.group("serverCode");
                        } else if (serverType.equals("M")) {
                            this.serverID = "mega" + matcher.group("serverCode");
                        }
                        String mineshaft = matcher.group("mineshaft");
                        this.mineshaftID = mineshaft == null ? "" : mineshaft;
                        foundServerID = true;
                        continue;
                    }
                    if (!foundDate && lineNumber < 3 && (dateM = DATE_PATTERN.matcher(strippedLine)).find()) {
                        dateMatcher = dateM;
                        foundDate = true;
                        continue;
                    }
                    if (foundDate && !foundTime && lineNumber < 4) {
                        Matcher timeM = TIME_PATTERN.matcher(strippedLine);
                        if (timeM.find()) {
                            this.currentDate = SkyblockDate.parse(dateMatcher, timeM);
                            foundTime = true;
                            continue;
                        }
                        this.currentDate = SkyblockDate.parse(dateMatcher);
                    }
                    if (lineNumber < 6) {
                        if (!foundLocation && (strippedLine.contains("\u23e3") || strippedLine.contains("\u0444"))) {
                            this.onRift = strippedLine.contains("\u0444");
                            SkyblockEquipment.loadEquipments(this.onRift ? SkyblockEquipment.Type.RIFT : SkyblockEquipment.Type.MAIN);
                            this.location = strippedLine.substring(strippedLine.indexOf(32) + 1).trim();
                            if (this.map == Island.KUUDRA || this.map == Island.DUNGEON) {
                                this.dungeonFloor = strippedLine.substring(strippedLine.lastIndexOf(" "));
                            } else if (this.map == Island.GARDEN) {
                                this.location = "The Garden";
                            } else if (this.map == Island.CRIMSON_ISLE) {
                                class_746 player = class_310.method_1551().field_1724;
                                if (player == null) {
                                    return;
                                }
                                double x = player.field_6014;
                                double y = player.field_6036;
                                double z = player.field_5969;
                                if (-550.0 < x && x < -450.0 && 80.0 < y && y < 130.0 && -900.0 < z && z < -625.0) {
                                    this.location = "Burning Desert";
                                }
                            }
                            foundLocation = true;
                            continue;
                        }
                        if (!foundPlot && this.map == Island.GARDEN && strippedLine.contains("Plot -")) {
                            String rawPlotName = strippedLine.substring(strippedLine.indexOf(45) + 2);
                            this.plotName = PEST_PATTERN.matcher(rawPlotName).replaceAll("");
                            foundPlot = true;
                        }
                    }
                    if (!foundCoins && lineNumber < 9) {
                        if (!this.onRift && (strippedLine.startsWith("Piggy:") || strippedLine.contains("Purse:"))) {
                            String purseStr = strippedLine.substring(strippedLine.indexOf(32) + 1);
                            try {
                                this.purse = TextUtils.NUMBER_FORMAT.parse(purseStr).doubleValue();
                            }
                            catch (ParseException ex) {
                                this.purse = 0.0;
                            }
                            foundCoins = true;
                            continue;
                        }
                        if (this.onRift && strippedLine.startsWith("Motes:")) {
                            String motesStr = strippedLine.substring(strippedLine.indexOf(32) + 1);
                            try {
                                this.motes = TextUtils.NUMBER_FORMAT.parse(motesStr).doubleValue();
                            }
                            catch (ParseException ex) {
                                this.motes = 0.0;
                            }
                            foundCoins = true;
                            continue;
                        }
                    }
                    if (!this.onRift && !foundBits && lineNumber < 10 && strippedLine.startsWith("Bits:")) {
                        String bitsStr = strippedLine.substring(strippedLine.indexOf(32) + 1);
                        try {
                            this.bits = TextUtils.NUMBER_FORMAT.parse(bitsStr).doubleValue();
                        }
                        catch (ParseException ex) {
                            this.bits = 0.0;
                        }
                        foundBits = true;
                        continue;
                    }
                    if (!this.onRift && foundCoins && !foundTrackingAnimal && strippedLine.equals("Tracker Mob Location:")) {
                        this.isTrackingAnimal = true;
                        foundTrackingAnimal = true;
                        continue;
                    }
                    if (strippedLine.endsWith("Combat XP") || strippedLine.endsWith("Kills")) {
                        this.parseSlayerProgress(strippedLine);
                        continue;
                    }
                    if (!this.onRift && !foundJerryWave && this.map == Island.JERRYS_WORKSHOP && strippedLine.startsWith("Wave")) {
                        int newJerryWave;
                        foundJerryWave = true;
                        try {
                            newJerryWave = Integer.parseInt(TextUtils.keepIntegerCharactersOnly(strippedLine));
                        }
                        catch (NumberFormatException ignored) {
                            newJerryWave = 0;
                        }
                        if (this.jerryWave == newJerryWave) continue;
                        this.jerryWave = newJerryWave;
                        continue;
                    }
                    if (!this.onRift && !foundInDungeon && strippedLine.startsWith("Cleared: ")) {
                        foundInDungeon = true;
                        this.inDungeon = true;
                        String lastServer = main.getDungeonManager().getLastServerId();
                        if (lastServer != null && !lastServer.equals(this.serverID)) {
                            main.getDungeonManager().reset();
                        }
                        main.getDungeonManager().setLastServerId(this.serverID);
                        continue;
                    }
                    if (!foundSlayerQuest && (slayerMatcher = SLAYER_TYPE_REGEX.matcher(strippedLine)).matches()) {
                        String type = slayerMatcher.group("type");
                        String levelRomanNumeral = slayerMatcher.group("level");
                        EnumUtils.SlayerQuest detectedSlayerQuest = EnumUtils.SlayerQuest.fromName(type);
                        if (detectedSlayerQuest != null) {
                            try {
                                int level = RomanNumeralParser.parseNumeral(levelRomanNumeral);
                                this.slayerQuest = detectedSlayerQuest;
                                this.slayerQuestLevel = level;
                                foundSlayerQuest = true;
                                continue;
                            }
                            catch (IllegalArgumentException ex) {
                                LOGGER.error("Failed to parse slayer level (" + ex.getMessage() + ")", (Throwable)ex);
                            }
                        }
                    }
                    if (strippedLine.equals("Slay the boss!")) {
                        foundBossAlive = true;
                        this.slayerBossAlive = true;
                        continue;
                    }
                    if (this.inDungeon) {
                        try {
                            main.getDungeonManager().updateDungeonPlayer(line);
                        }
                        catch (NumberFormatException ex) {
                            LOGGER.error("Failed to update a dungeon player from the line " + line + ".", (Throwable)ex);
                        }
                    }
                    if (lineNumber != ScoreboardManager.getNumberOfLines() - 1 || foundAlphaIP || !strippedLine.contains("alpha.hypixel.net")) continue;
                    foundAlphaIP = true;
                    this.alpha = true;
                    this.profileName = "Alpha";
                }
            }
            if (!foundTrackingAnimal) {
                this.isTrackingAnimal = false;
            }
            if (!foundLocation) {
                this.location = "Unknown";
                this.dungeonFloor = "";
            }
            if (!foundPlot) {
                this.plotName = "";
            }
            if (!foundJerryWave) {
                this.jerryWave = -1;
            }
            if (!foundAlphaIP) {
                this.alpha = false;
            }
            if (!foundInDungeon) {
                this.inDungeon = false;
            }
            if (!foundSlayerQuest) {
                this.slayerQuestLevel = 1;
                this.slayerQuest = null;
            }
            if (!foundBossAlive) {
                this.slayerBossAlive = false;
            }
        }
        if (!foundSkyblockTitle && this.isOnSkyblock() && (foundScoreboard || System.currentTimeMillis() - ScoreboardManager.getLastFoundScoreboard() > 10000L)) {
            ((SkyblockEvents.SkyblockLeft)SkyblockEvents.LEFT.invoker()).onSkyblockLeft();
        }
    }

    private void parseSlayerProgress(String line) {
        if (Feature.BOSS_APPROACH_ALERT.isDisabled()) {
            return;
        }
        Matcher matcher = SLAYER_PROGRESS_REGEX.matcher(line);
        if (matcher.find()) {
            float completion;
            String progressString = matcher.group("progress");
            String totalString = matcher.group("total");
            float progress = Float.parseFloat(TextUtils.keepFloatCharactersOnly(progressString));
            float total = Float.parseFloat(TextUtils.keepFloatCharactersOnly(totalString));
            if (progressString.contains("k")) {
                progress *= 1000.0f;
            }
            if (totalString.contains("k")) {
                total *= 1000.0f;
            }
            if ((double)(completion = progress / total) > 0.85) {
                boolean repeating = Feature.BOSS_APPROACH_ALERT.isEnabled(FeatureSetting.REPEATING_BOSS_APPROACH_ALERT);
                if (!this.triggeredSlayerWarning || repeating && completion != this.lastCompletion) {
                    this.triggeredSlayerWarning = true;
                    main.getUtils().playLoudSound(class_3417.field_14627, 0.5);
                }
            } else {
                this.triggeredSlayerWarning = false;
            }
            this.lastCompletion = completion;
        }
    }

    public int getDefaultColor(float alphaFloat) {
        int alpha = (int)alphaFloat;
        return class_9848.method_61324((int)alpha, (int)150, (int)236, (int)255);
    }

    public void playLoudSound(class_3414 sound, double pitch) {
        this.playingLoudSound = true;
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        player.method_5783(sound, 1.0f, (float)pitch);
        this.playingLoudSound = false;
    }

    public static void playSound(class_3414 sound, double pitch) {
        Utils.playSound(sound, 1.0, pitch);
    }

    public static void playSound(class_3414 sound, double volume, double pitch) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        player.method_5783(sound, (float)volume, (float)pitch);
    }

    public boolean enchantReforgeMatches(String reforge) {
        reforge = reforge.trim().toLowerCase(Locale.US);
        for (String desiredReforge : this.reforgeMatches) {
            if (!StringUtils.isNotEmpty((CharSequence)(desiredReforge = desiredReforge.trim().toLowerCase(Locale.US))) || !reforge.contains(desiredReforge)) continue;
            boolean foundExclusion = false;
            for (String excludedReforge : this.reforgeExclusions) {
                if (!StringUtils.isNotEmpty((CharSequence)(excludedReforge = excludedReforge.trim().toLowerCase(Locale.US))) || !reforge.contains(excludedReforge)) continue;
                foundExclusion = true;
                break;
            }
            if (foundExclusion) continue;
            return true;
        }
        return false;
    }

    public File getSBAFolder() {
        Path container = FabricLoader.getInstance().getConfigDir();
        try {
            return container.resolve("skyblockaddons").toFile();
        }
        catch (Exception ignored) {
            return container.toFile();
        }
    }

    public boolean isHalloween() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 9 && calendar.get(5) == 31;
    }

    public String[] wrapSplitText(String text, int wrapLength) {
        return WordUtils.wrap((String)text, (int)wrapLength).replace("\r", "").split(Pattern.quote("\n"));
    }

    public boolean itemIsInHotbar(class_1799 itemStack) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        class_2371 inventory = player.method_31548().method_67533();
        for (int slot = 0; slot < 9; ++slot) {
            if (inventory.get(slot) != itemStack) continue;
            return true;
        }
        return false;
    }

    public boolean isModLoaded(String modId) {
        return this.isModLoaded(modId, null);
    }

    public boolean isModLoaded(String modId, String version) {
        boolean isLoaded = FabricLoader.getInstance().isModLoaded(modId);
        if (isLoaded && version != null) {
            for (ModContainer modContainer : FabricLoader.getInstance().getAllMods()) {
                ModMetadata modMetadata = modContainer.getMetadata();
                if (!modMetadata.getId().equals(modId) || !modMetadata.getVersion().toString().equals(version)) continue;
                return true;
            }
            return false;
        }
        return isLoaded;
    }

    public float[] getCurrentGLTransformations() {
        FloatBuffer buf = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloatv((int)2982, (FloatBuffer)buf);
        buf.rewind();
        Matrix4f mat = new Matrix4f();
        mat.get(buf);
        float x = mat.m30();
        float y = mat.m31();
        float z = mat.m32();
        float scale = (float)Math.sqrt(mat.m00() * mat.m00() + mat.m01() * mat.m01() + mat.m02() * mat.m02());
        return new float[]{x, y, z, scale};
    }

    public static class_1657 getPlayerFromName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level != null) {
            for (class_1657 player : level.method_18456()) {
                if (!name.equals(player.method_7334().name())) continue;
                return player;
            }
        }
        return null;
    }

    public boolean isBlankGlassPane(class_1799 itemStack) {
        if (itemStack == null || itemStack.method_7960()) {
            return false;
        }
        class_2248 block = class_2248.method_9503((class_1792)itemStack.method_7909());
        boolean isGlassPane = block == class_2246.field_10285 || block instanceof class_2504;
        boolean hasBlankDisplayName = itemStack.method_7964().getString().isBlank();
        return isGlassPane && hasBlankDisplayName;
    }

    public boolean isGlassPaneColor(class_1799 itemStack, class_1767 color) {
        return itemStack != null && itemStack.method_58695(class_9334.field_49645, (Object)-1) == color.method_7794();
    }

    public static float getPartialTicks() {
        return class_310.method_1551().method_61966().method_60637(true);
    }

    public static byte[] toByteArray(BufferedInputStream inputStream) throws IOException {
        byte[] bytes;
        try (BufferedInputStream bufferedInputStream = inputStream;){
            bytes = IOUtils.toByteArray((InputStream)inputStream);
        }
        return bytes;
    }

    public static class_1297 getEntityFromUUID(UUID uuid) {
        class_638 world = class_310.method_1551().field_1687;
        if (uuid == null || world == null) {
            return null;
        }
        for (class_1297 entity : world.method_18112()) {
            if (!entity.method_5667().equals(uuid)) continue;
            return entity;
        }
        return null;
    }

    public static class_5455 registryAccess() {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return class_5455.field_40585;
        }
        return world.method_30349();
    }

    @Generated
    public List<String> getReforgeMatches() {
        return this.reforgeMatches;
    }

    @Generated
    public List<String> getReforgeExclusions() {
        return this.reforgeExclusions;
    }

    @Generated
    public boolean isOnSkyblock() {
        return this.onSkyblock;
    }

    @Generated
    public boolean isOnRift() {
        return this.onRift;
    }

    @Generated
    public boolean isTrackingAnimal() {
        return this.isTrackingAnimal;
    }

    @Generated
    public String getLocation() {
        return this.location;
    }

    @Generated
    public Island getMap() {
        return this.map;
    }

    @Generated
    public boolean isGuest() {
        return this.isGuest;
    }

    @Generated
    public String getMode() {
        return this.mode;
    }

    @Generated
    public String getMayor() {
        return this.mayor;
    }

    @Generated
    public Pair<String, String> getMinisterAndPerk() {
        return this.ministerAndPerk;
    }

    @Generated
    public String getJerryMayor() {
        return this.jerryMayor;
    }

    @Generated
    public long getJerryMayorUpdateTime() {
        return this.jerryMayorUpdateTime;
    }

    @Generated
    public String getDungeonFloor() {
        return this.dungeonFloor;
    }

    @Generated
    public String getPlotName() {
        return this.plotName;
    }

    @Generated
    public String getProfileName() {
        return this.profileName;
    }

    @Generated
    public boolean isPlayingLoudSound() {
        return this.playingLoudSound;
    }

    @Generated
    public String getServerID() {
        return this.serverID;
    }

    @Generated
    public String getMineshaftID() {
        return this.mineshaftID;
    }

    @Generated
    public int getLastHoveredSlot() {
        return this.lastHoveredSlot;
    }

    @Generated
    public boolean isUsingFSRcontainerPreviewTexture() {
        return this.usingFSRcontainerPreviewTexture;
    }

    @Generated
    public SkyblockDate getCurrentDate() {
        return this.currentDate;
    }

    @Generated
    public double getPurse() {
        return this.purse;
    }

    @Generated
    public double getBits() {
        return this.bits;
    }

    @Generated
    public double getMotes() {
        return this.motes;
    }

    @Generated
    public int getJerryWave() {
        return this.jerryWave;
    }

    @Generated
    public boolean isAlpha() {
        return this.alpha;
    }

    @Generated
    public boolean isInDungeon() {
        return this.inDungeon;
    }

    @Generated
    public boolean isFadingIn() {
        return this.fadingIn;
    }

    @Generated
    public EnumUtils.SlayerQuest getSlayerQuest() {
        return this.slayerQuest;
    }

    @Generated
    public int getSlayerQuestLevel() {
        return this.slayerQuestLevel;
    }

    @Generated
    public boolean isSlayerBossAlive() {
        return this.slayerBossAlive;
    }

    @Generated
    public boolean isTriggeredSlayerWarning() {
        return this.triggeredSlayerWarning;
    }

    @Generated
    public float getLastCompletion() {
        return this.lastCompletion;
    }

    @Generated
    public boolean isDepthEnabled() {
        return this.depthEnabled;
    }

    @Generated
    public boolean isBlendEnabled() {
        return this.blendEnabled;
    }

    @Generated
    public boolean isAlphaEnabled() {
        return this.alphaEnabled;
    }

    @Generated
    public int getBlendFunctionSrcFactor() {
        return this.blendFunctionSrcFactor;
    }

    @Generated
    public int getBlendFunctionDstFactor() {
        return this.blendFunctionDstFactor;
    }

    @Generated
    public void setReforgeMatches(List<String> reforgeMatches) {
        this.reforgeMatches = reforgeMatches;
    }

    @Generated
    public void setReforgeExclusions(List<String> reforgeExclusions) {
        this.reforgeExclusions = reforgeExclusions;
    }

    @Generated
    public void setOnSkyblock(boolean onSkyblock) {
        this.onSkyblock = onSkyblock;
    }

    @Generated
    public void setOnRift(boolean onRift) {
        this.onRift = onRift;
    }

    @Generated
    public void setTrackingAnimal(boolean isTrackingAnimal) {
        this.isTrackingAnimal = isTrackingAnimal;
    }

    @Generated
    public void setLocation(String location) {
        this.location = location;
    }

    @Generated
    public void setMap(Island map) {
        this.map = map;
    }

    @Generated
    public void setGuest(boolean isGuest) {
        this.isGuest = isGuest;
    }

    @Generated
    public void setMode(String mode) {
        this.mode = mode;
    }

    @Generated
    public void setMayor(String mayor) {
        this.mayor = mayor;
    }

    @Generated
    public void setMinisterAndPerk(Pair<String, String> ministerAndPerk) {
        this.ministerAndPerk = ministerAndPerk;
    }

    @Generated
    public void setJerryMayor(String jerryMayor) {
        this.jerryMayor = jerryMayor;
    }

    @Generated
    public void setJerryMayorUpdateTime(long jerryMayorUpdateTime) {
        this.jerryMayorUpdateTime = jerryMayorUpdateTime;
    }

    @Generated
    public void setDungeonFloor(String dungeonFloor) {
        this.dungeonFloor = dungeonFloor;
    }

    @Generated
    public void setPlotName(String plotName) {
        this.plotName = plotName;
    }

    @Generated
    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    @Generated
    public void setPlayingLoudSound(boolean playingLoudSound) {
        this.playingLoudSound = playingLoudSound;
    }

    @Generated
    public void setServerID(String serverID) {
        this.serverID = serverID;
    }

    @Generated
    public void setMineshaftID(String mineshaftID) {
        this.mineshaftID = mineshaftID;
    }

    @Generated
    public void setLastHoveredSlot(int lastHoveredSlot) {
        this.lastHoveredSlot = lastHoveredSlot;
    }

    @Generated
    public void setUsingFSRcontainerPreviewTexture(boolean usingFSRcontainerPreviewTexture) {
        this.usingFSRcontainerPreviewTexture = usingFSRcontainerPreviewTexture;
    }

    @Generated
    public void setCurrentDate(SkyblockDate currentDate) {
        this.currentDate = currentDate;
    }

    @Generated
    public void setPurse(double purse) {
        this.purse = purse;
    }

    @Generated
    public void setBits(double bits) {
        this.bits = bits;
    }

    @Generated
    public void setMotes(double motes) {
        this.motes = motes;
    }

    @Generated
    public void setJerryWave(int jerryWave) {
        this.jerryWave = jerryWave;
    }

    @Generated
    public void setAlpha(boolean alpha) {
        this.alpha = alpha;
    }

    @Generated
    public void setInDungeon(boolean inDungeon) {
        this.inDungeon = inDungeon;
    }

    @Generated
    public void setFadingIn(boolean fadingIn) {
        this.fadingIn = fadingIn;
    }

    @Generated
    public void setSlayerQuest(EnumUtils.SlayerQuest slayerQuest) {
        this.slayerQuest = slayerQuest;
    }

    @Generated
    public void setSlayerQuestLevel(int slayerQuestLevel) {
        this.slayerQuestLevel = slayerQuestLevel;
    }

    @Generated
    public void setSlayerBossAlive(boolean slayerBossAlive) {
        this.slayerBossAlive = slayerBossAlive;
    }

    @Generated
    public void setTriggeredSlayerWarning(boolean triggeredSlayerWarning) {
        this.triggeredSlayerWarning = triggeredSlayerWarning;
    }

    @Generated
    public void setLastCompletion(float lastCompletion) {
        this.lastCompletion = lastCompletion;
    }

    @Generated
    public void setDepthEnabled(boolean depthEnabled) {
        this.depthEnabled = depthEnabled;
    }

    @Generated
    public void setBlendEnabled(boolean blendEnabled) {
        this.blendEnabled = blendEnabled;
    }

    @Generated
    public void setAlphaEnabled(boolean alphaEnabled) {
        this.alphaEnabled = alphaEnabled;
    }

    @Generated
    public void setBlendFunctionSrcFactor(int blendFunctionSrcFactor) {
        this.blendFunctionSrcFactor = blendFunctionSrcFactor;
    }

    @Generated
    public void setBlendFunctionDstFactor(int blendFunctionDstFactor) {
        this.blendFunctionDstFactor = blendFunctionDstFactor;
    }

    static {
        USER_AGENT = "SkyblockAddons/" + String.valueOf(SkyblockAddons.METADATA.getVersion());
    }
}

