/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils.data.requests;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.Language;
import com.fix3dll.skyblockaddons.core.Translations;
import com.fix3dll.skyblockaddons.utils.data.DataFetchCallback;
import com.fix3dll.skyblockaddons.utils.data.JSONResponseHandler;
import com.fix3dll.skyblockaddons.utils.data.RemoteFileRequest;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import lombok.NonNull;
import org.apache.logging.log4j.Logger;

public class LocalizationsRequest
extends RemoteFileRequest<JsonObject> {
    private static final Logger LOGGER = SkyblockAddons.getLogger();

    public LocalizationsRequest(@NonNull Language language) {
        super(String.format("https://cdn.jsdelivr.net/gh/Fix3dll/SkyblockAddons@1.21.5/src/main/resources/lang/%s.json", language.getPath()), new JSONResponseHandler((Type)((Object)JsonObject.class)), new LocalizationsCallback(String.format("https://cdn.jsdelivr.net/gh/Fix3dll/SkyblockAddons@1.21.5/src/main/resources/lang/%s.json", language.getPath())), false, true);
        if (language == null) {
            throw new NullPointerException("language is marked non-null but is null");
        }
    }

    public static class LocalizationsCallback
    extends DataFetchCallback<JsonObject> {
        public LocalizationsCallback(String path) {
            super(LOGGER, URI.create(path));
        }

        @Override
        public void completed(JsonObject result) {
            super.completed(result);
            LocalizationsCallback.overwriteCommonJsonMembers(Translations.getLanguageJson(), Objects.requireNonNull(result, "No data received for get request to \"%s\""));
        }

        private static void overwriteCommonJsonMembers(JsonObject baseObject, JsonObject otherObject) {
            for (Map.Entry<String, JsonElement> entry : otherObject.entrySet()) {
                String memberName = entry.getKey();
                JsonElement otherElement = entry.getValue();
                if (otherElement.isJsonObject()) {
                    JsonObject baseElementObject;
                    if (baseObject.has(memberName) && baseObject.get(memberName).isJsonObject()) {
                        baseElementObject = baseObject.getAsJsonObject(memberName);
                        LocalizationsCallback.overwriteCommonJsonMembers(baseElementObject, otherElement.getAsJsonObject());
                        continue;
                    }
                    baseElementObject = new JsonObject();
                    baseObject.add(memberName, baseElementObject);
                    LocalizationsCallback.overwriteCommonJsonMembers(baseElementObject, otherElement.getAsJsonObject());
                    continue;
                }
                if (!otherElement.isJsonPrimitive() || !otherElement.getAsJsonPrimitive().isString()) continue;
                baseObject.add(memberName, otherElement);
            }
        }
    }
}

