/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils.data.requests;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.Translations;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.scheduler.ScheduledTask;
import com.fix3dll.skyblockaddons.utils.Utils;
import com.fix3dll.skyblockaddons.utils.data.DataFetchCallback;
import com.fix3dll.skyblockaddons.utils.data.DataUtils;
import com.fix3dll.skyblockaddons.utils.data.JSONResponseHandler;
import com.fix3dll.skyblockaddons.utils.data.RemoteFileRequest;
import com.fix3dll.skyblockaddons.utils.data.skyblockdata.ElectionData;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Date;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;
import org.apache.logging.log4j.Logger;

public class MayorRequest
extends RemoteFileRequest<ElectionData> {
    private static final Logger LOGGER = SkyblockAddons.getLogger();
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    private static String newMayorName = "";
    private static ScheduledTask updateTask;
    private static ScheduledTask jerryMayorTask;

    public MayorRequest() {
        this("");
    }

    public MayorRequest(String newMayorName) {
        super("https://api.hypixel.net/v2/resources/skyblock/election", new JSONResponseHandler((Type)((Object)ElectionData.class)), new MayorCallback("https://api.hypixel.net/v2/resources/skyblock/election"), false, true);
        MayorRequest.newMayorName = newMayorName;
    }

    private static class MayorCallback
    extends DataFetchCallback<ElectionData> {
        public MayorCallback(String path) {
            super(LOGGER, URI.create(path));
        }

        @Override
        public void completed(ElectionData result) {
            super.completed(result);
            main.setElectionData(result);
            String mayorName = result.getMayor().getName();
            boolean isMayorJerry = "Jerry".equals(mayorName);
            if (Feature.DEVELOPER_MODE.isEnabled()) {
                LOGGER.info("lastUpdated: {}, mayor: {}", (Object)new Date(result.getLastUpdated()), (Object)mayorName);
            }
            if (newMayorName.isEmpty() || newMayorName.equals(mayorName)) {
                main.getUtils().setMayor(mayorName == null ? "Fix3dll" : mayorName);
            }
            if (isMayorJerry && jerryMayorTask == null) {
                jerryMayorTask = this.scheduleJerryMayorTask();
            } else if (!isMayorJerry && jerryMayorTask != null) {
                jerryMayorTask.cancel();
                jerryMayorTask = null;
            }
            if (!newMayorName.isEmpty() && !newMayorName.equals(mayorName) && updateTask == null) {
                updateTask = this.scheduleUpdateTask(newMayorName);
                LOGGER.info("Update task scheduled.");
            } else if (newMayorName.equals(mayorName)) {
                if (updateTask != null) {
                    updateTask.cancel();
                    updateTask = null;
                    LOGGER.info("Scheduled update task completed.");
                }
                newMayorName = "";
            }
        }

        private ScheduledTask scheduleUpdateTask(String expectedMayorName) {
            long nextUpdateTime = main.getElectionData().getLastUpdated() + 303000L;
            int delayTick = (int)(nextUpdateTime - System.currentTimeMillis()) / 50;
            return main.getScheduler().scheduleAsyncTask(scheduledTask -> DataUtils.loadOnlineData(new MayorRequest(expectedMayorName)), delayTick);
        }

        private ScheduledTask scheduleJerryMayorTask() {
            return main.getScheduler().scheduleAsyncTask(scheduledTask -> {
                if (!main.getUtils().isOnSkyblock()) {
                    return;
                }
                if (scheduledTask.updatePeriod(6000)) {
                    return;
                }
                if (System.currentTimeMillis() > main.getMayorJerryData().getNextSwitch()) {
                    class_5250 updateText = class_2561.method_43470((String)(String.valueOf(ColorCode.RED) + Translations.getMessage("messages.perkpocalypseUnknown", new Object[0])));
                    updateText.method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/calendar")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"\u00a77/calendar"))));
                    Utils.sendMessage((class_2561)updateText, true);
                }
            }, 0, 60);
        }
    }
}

