/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils.data.skyblockdata;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.SkyblockMayor;
import com.fix3dll.skyblockaddons.utils.data.skyblockdata.MayorJerryData;
import com.google.gson.annotations.SerializedName;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.logging.log4j.Logger;

public class ElectionData {
    private static final Logger LOGGER = SkyblockAddons.getLogger();
    @SerializedName(value="success")
    private boolean success = false;
    @SerializedName(value="lastUpdated")
    private long lastUpdated;
    @SerializedName(value="mayor")
    private Mayor mayor;
    @SerializedName(value="current")
    private Current current;

    public boolean isPerkActive(String perkName) {
        MayorJerryData mayorJerryData;
        if (perkName == null || perkName.isEmpty()) {
            LOGGER.error("\"perkName\" cannot be null or empty!");
            return false;
        }
        if (!this.success) {
            return false;
        }
        if (this.mayor != null) {
            for (Mayor.Perk perk : this.mayor.perks) {
                if (!perkName.equalsIgnoreCase(perk.name)) continue;
                return true;
            }
            if (this.mayor.minister != null && perkName.equalsIgnoreCase(this.mayor.minister.name)) {
                return true;
            }
        }
        if ((mayorJerryData = SkyblockAddons.getInstance().getMayorJerryData()) != null && mayorJerryData.hasMayorAndActive()) {
            return mayorJerryData.getMayor() == SkyblockMayor.getByPerkName(perkName);
        }
        return false;
    }

    public boolean isCandidateActive(String candidateName) {
        MayorJerryData mayorJerryData;
        if (candidateName == null || candidateName.isEmpty()) {
            LOGGER.error("\"candidateName\" cannot be null or empty!");
            return false;
        }
        if (!this.success) {
            return false;
        }
        if (this.mayor != null) {
            if (candidateName.equalsIgnoreCase(this.mayor.name)) {
                return true;
            }
            if (this.mayor.minister != null && candidateName.equalsIgnoreCase(this.mayor.minister.name)) {
                return true;
            }
        }
        return (mayorJerryData = SkyblockAddons.getInstance().getMayorJerryData()) != null && mayorJerryData.hasMayorAndActive() && candidateName.equalsIgnoreCase(mayorJerryData.getMayor().name());
    }

    @Generated
    public boolean isSuccess() {
        return this.success;
    }

    @Generated
    public long getLastUpdated() {
        return this.lastUpdated;
    }

    @Generated
    public Mayor getMayor() {
        return this.mayor;
    }

    @Generated
    public Current getCurrent() {
        return this.current;
    }

    public static class Mayor {
        @SerializedName(value="key")
        private String key;
        @SerializedName(value="name")
        private String name;
        @SerializedName(value="perks")
        private List<Perk> perks = Collections.emptyList();
        @SerializedName(value="minister")
        private Minister minister;
        @SerializedName(value="election")
        private Election election;

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public List<Perk> getPerks() {
            return this.perks;
        }

        @Generated
        public Minister getMinister() {
            return this.minister;
        }

        @Generated
        public Election getElection() {
            return this.election;
        }

        public static class Minister {
            @SerializedName(value="key")
            private String key;
            @SerializedName(value="name")
            private String name;
            @SerializedName(value="perk")
            private Perk perk;

            @Generated
            public String getKey() {
                return this.key;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public Perk getPerk() {
                return this.perk;
            }
        }

        public static class Election {
            @SerializedName(value="year")
            private int year;
            @SerializedName(value="candidates")
            private List<Candidate> candidates;

            @Generated
            public int getYear() {
                return this.year;
            }

            @Generated
            public List<Candidate> getCandidates() {
                return this.candidates;
            }

            public static class Candidate {
                @SerializedName(value="key")
                private String key;
                @SerializedName(value="name")
                private String name;
                @SerializedName(value="perks")
                private List<Perk> perks = Collections.emptyList();
                @SerializedName(value="votes")
                private int votes;

                @Generated
                public String getKey() {
                    return this.key;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public List<Perk> getPerks() {
                    return this.perks;
                }

                @Generated
                public int getVotes() {
                    return this.votes;
                }
            }
        }

        public static class Perk {
            @SerializedName(value="name")
            private String name;
            @SerializedName(value="description")
            private String description;

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getDescription() {
                return this.description;
            }
        }
    }

    public static class Current {
        @SerializedName(value="year")
        private int year;
        @SerializedName(value="candidates")
        private List<Candidate> candidates = Collections.emptyList();

        @Generated
        public int getYear() {
            return this.year;
        }

        @Generated
        public List<Candidate> getCandidates() {
            return this.candidates;
        }

        public static class Candidate {
            @SerializedName(value="key")
            private String key;
            @SerializedName(value="name")
            private String name;
            @SerializedName(value="perks")
            private List<Mayor.Perk> perks = Collections.emptyList();
            @SerializedName(value="votes")
            private int votes;

            @Generated
            public String getKey() {
                return this.key;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public List<Mayor.Perk> getPerks() {
                return this.perks;
            }

            @Generated
            public int getVotes() {
                return this.votes;
            }
        }
    }
}

