/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.utils.data.skyblockdata;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.utils.data.DataUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public final class LegacyIdItemMapData {
    private static final Map<String, class_1792> LEGACY_ID_ITEM_MAP = LegacyIdItemMapData.loadAndConvertMap();
    private static final String JSON_FILE_NAME = "legacyIdItemMap.json";

    private static Map<String, class_1792> loadAndConvertMap() {
        Gson gson = SkyblockAddons.getGson();
        HashMap tempMap = new HashMap();
        try (InputStream is = LegacyIdItemMapData.class.getClassLoader().getResourceAsStream(JSON_FILE_NAME);
             InputStreamReader inputStreamReader = new InputStreamReader(Objects.requireNonNull(is), StandardCharsets.UTF_8);){
            Map idMapping = (Map)gson.fromJson((Reader)inputStreamReader, new TypeToken<Map<String, String>>(){}.getType());
            for (Map.Entry entry : idMapping.entrySet()) {
                String legacyId = (String)entry.getKey();
                class_2960 modernId = class_2960.method_60656((String)((String)entry.getValue()));
                class_7923.field_41178.method_10223(modernId).ifPresentOrElse(modernItem -> tempMap.put(legacyId, (class_1792)modernItem.comp_349()), () -> tempMap.put(legacyId, class_1802.field_8077));
            }
        }
        catch (Exception ex) {
            DataUtils.handleLocalFileReadException(JSON_FILE_NAME, ex);
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(tempMap);
    }

    public static class_1799 getItemStack(String legacyId) {
        return LegacyIdItemMapData.getItemStack(legacyId, 1);
    }

    public static class_1799 getItemStack(String legacyId, int count) {
        class_1792 item = LEGACY_ID_ITEM_MAP.getOrDefault(legacyId, class_1802.field_8077);
        return new class_1799((class_1935)item, count);
    }
}

