/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.reflect;

import javax.annotation.ParametersAreNonnullByDefault;
import net.lenni0451.reflect.JVMConstants;
import net.lenni0451.reflect.Objects;
import net.lenni0451.reflect.accessor.UnsafeAccess;

@ParametersAreNonnullByDefault
public class Arrays {
    public static void setLength(Object array, int newLength) {
        if (!array.getClass().isArray()) {
            throw new IllegalArgumentException("Object is not an array");
        }
        UnsafeAccess.putInt(array, Objects.OBJECT_HEADER_SIZE, newLength);
    }

    public static void fill(byte[] array, byte value) {
        UnsafeAccess.setMemory(array, Objects.ARRAY_HEADER_SIZE, array.length, value);
    }

    public static void fill(short[] array, short value) {
        if (value == 0) {
            UnsafeAccess.setMemory(array, Objects.ARRAY_HEADER_SIZE, (long)array.length * 2L, (byte)0);
        } else {
            for (int i = 0; i < array.length * 2; i += 2) {
                UnsafeAccess.putShort(array, (long)Objects.ARRAY_HEADER_SIZE + (long)i, value);
            }
        }
    }

    public static void fill(char[] array, char value) {
        if (value == '\u0000') {
            UnsafeAccess.setMemory(array, Objects.ARRAY_HEADER_SIZE, (long)array.length * 2L, (byte)0);
        } else {
            for (int i = 0; i < array.length * 2; i += 2) {
                UnsafeAccess.putChar(array, (long)Objects.ARRAY_HEADER_SIZE + (long)i, value);
            }
        }
    }

    public static void fill(int[] array, int value) {
        if (value == 0) {
            UnsafeAccess.setMemory(array, Objects.ARRAY_HEADER_SIZE, (long)array.length * 4L, (byte)0);
        } else {
            for (int i = 0; i < array.length * 4; i += 4) {
                UnsafeAccess.putInt(array, (long)Objects.ARRAY_HEADER_SIZE + (long)i, value);
            }
        }
    }

    public static void fill(long[] array, long value) {
        if (value == 0L) {
            UnsafeAccess.setMemory(array, Objects.ARRAY_HEADER_SIZE, (long)array.length * 8L, (byte)0);
        } else {
            for (int i = 0; i < array.length * 8; i += 8) {
                UnsafeAccess.putLong(array, (long)Objects.ARRAY_HEADER_SIZE + (long)i, value);
            }
        }
    }

    public static void fill(float[] array, float value) {
        if (value == 0.0f) {
            UnsafeAccess.setMemory(array, Objects.ARRAY_HEADER_SIZE, (long)array.length * 4L, (byte)0);
        } else {
            for (int i = 0; i < array.length * 4; i += 4) {
                UnsafeAccess.putFloat(array, (long)Objects.ARRAY_HEADER_SIZE + (long)i, value);
            }
        }
    }

    public static void fill(double[] array, double value) {
        if (value == 0.0) {
            UnsafeAccess.setMemory(array, Objects.ARRAY_HEADER_SIZE, (long)array.length * 8L, (byte)0);
        } else {
            for (int i = 0; i < array.length * 8; i += 8) {
                UnsafeAccess.putDouble(array, (long)Objects.ARRAY_HEADER_SIZE + (long)i, value);
            }
        }
    }

    static {
        if (JVMConstants.OPENJ9_RUNTIME) {
            throw new UnsupportedOperationException("OpenJ9 is not supported");
        }
    }
}

