/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.reflect.bytecode.impl.asm;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.util.function.Consumer;
import net.lenni0451.reflect.JavaBypass;
import net.lenni0451.reflect.bytecode.builder.ClassBuilder;
import net.lenni0451.reflect.bytecode.builder.FieldBuilder;
import net.lenni0451.reflect.bytecode.builder.MethodBuilder;
import net.lenni0451.reflect.bytecode.impl.asm.ASMBuilder;
import net.lenni0451.reflect.bytecode.impl.asm.ASMFieldBuilder;
import net.lenni0451.reflect.bytecode.impl.asm.ASMMethodBuilder;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
class ASMClassBuilder
implements ClassBuilder {
    private final Object classWriter;
    private final String name;

    public ASMClassBuilder(Object classWriter, String name) {
        this.classWriter = classWriter;
        this.name = name;
    }

    public Object getClassWriter() {
        return this.classWriter;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void field(int access, String name, String descriptor, String signature, Object defaultValue, Consumer<FieldBuilder> consumer) {
        MethodHandle visitField = JavaBypass.TRUSTED_LOOKUP.findVirtual(ASMBuilder.CLASS_ClassWriter, "visitField", MethodType.methodType(ASMBuilder.CLASS_FieldVisitor, Integer.TYPE, String.class, String.class, String.class, Object.class));
        MethodHandle visitEnd = JavaBypass.TRUSTED_LOOKUP.findVirtual(ASMBuilder.CLASS_FieldVisitor, "visitEnd", MethodType.methodType(Void.TYPE));
        ASMFieldBuilder builder = new ASMFieldBuilder(visitField.invoke(this.classWriter, access, name, descriptor, signature, defaultValue));
        consumer.accept(builder);
        visitEnd.invoke(builder.getFieldVisitor());
    }

    @Override
    public void method(int access, String name, String descriptor, String signature, String[] exceptions, Consumer<MethodBuilder> consumer) {
        MethodHandle visitMethod = JavaBypass.TRUSTED_LOOKUP.findVirtual(ASMBuilder.CLASS_ClassWriter, "visitMethod", MethodType.methodType(ASMBuilder.CLASS_MethodVisitor, Integer.TYPE, String.class, String.class, String.class, String[].class));
        MethodHandle visitCode = JavaBypass.TRUSTED_LOOKUP.findVirtual(ASMBuilder.CLASS_MethodVisitor, "visitCode", MethodType.methodType(Void.TYPE));
        MethodHandle visitEnd = JavaBypass.TRUSTED_LOOKUP.findVirtual(ASMBuilder.CLASS_MethodVisitor, "visitEnd", MethodType.methodType(Void.TYPE));
        ASMMethodBuilder builder = new ASMMethodBuilder(visitMethod.invoke(this.classWriter, access, name, descriptor, signature, exceptions));
        visitCode.invoke(builder.getMethodVisitor());
        consumer.accept(builder);
        visitEnd.invoke(builder.getMethodVisitor());
    }
}

