/*
 * Decompiled with CFR 0.152.
 */
package net.lenni0451.reflect.stream.method;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.lenni0451.reflect.Methods;
import net.lenni0451.reflect.exceptions.MethodNotFoundException;
import net.lenni0451.reflect.stream.RStream;
import net.lenni0451.reflect.stream.method.MethodWrapper;

public class MethodStream {
    private final RStream parent;
    private final List<MethodWrapper> methods;

    public MethodStream(RStream parent, boolean withSuper) {
        this.parent = parent;
        this.methods = new ArrayList<MethodWrapper>();
        Class<?> clazz = parent.clazz();
        do {
            for (Method method : Methods.getDeclaredMethods(clazz)) {
                this.methods.add(new MethodWrapper(this, method));
            }
        } while (withSuper && (clazz = clazz.getSuperclass()) != null);
    }

    private MethodStream(RStream parent, List<MethodWrapper> methods) {
        this.parent = parent;
        this.methods = methods;
    }

    public RStream parent() {
        return this.parent;
    }

    public int size() {
        return this.methods.size();
    }

    public Optional<MethodWrapper> opt(String name) {
        for (MethodWrapper method : this.methods) {
            if (!method.name().equals(name)) continue;
            return Optional.of(method);
        }
        return Optional.empty();
    }

    public Optional<MethodWrapper> opt(Class<?> ... parameterTypes) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            for (MethodWrapper method : this.methods) {
                if (method.parameterCount() != 0) continue;
                return Optional.of(method);
            }
        } else {
            for (MethodWrapper method : this.methods) {
                if (!Arrays.equals(method.parameterTypes(), parameterTypes)) continue;
                return Optional.of(method);
            }
        }
        return Optional.empty();
    }

    public Optional<MethodWrapper> opt(String name, Class<?> ... parameterTypes) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            for (MethodWrapper method : this.methods) {
                if (!method.name().equals(name) || method.parameterCount() != 0) continue;
                return Optional.of(method);
            }
        } else {
            for (MethodWrapper method : this.methods) {
                if (!method.name().equals(name) || !Arrays.equals(method.parameterTypes(), parameterTypes)) continue;
                return Optional.of(method);
            }
        }
        return Optional.empty();
    }

    public Optional<MethodWrapper> opt(int index) {
        if (index < 0 || index >= this.methods.size()) {
            return Optional.empty();
        }
        return Optional.of(this.methods.get(index));
    }

    public MethodWrapper by(String name) {
        return this.opt(name).orElseThrow(() -> new MethodNotFoundException(this.parent.clazz().getName(), name));
    }

    public MethodWrapper by(Class<?> ... parameterTypes) {
        return this.opt(parameterTypes).orElseThrow(() -> new MethodNotFoundException(this.parent.clazz().getName(), null, parameterTypes));
    }

    public MethodWrapper by(String name, Class<?> ... parameterTypes) {
        return this.opt(name, parameterTypes).orElseThrow(() -> new MethodNotFoundException(this.parent.clazz().getName(), name, parameterTypes));
    }

    public MethodWrapper by(int index) {
        try {
            return this.methods.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MethodNotFoundException(this.parent.clazz().getName(), String.valueOf(index));
        }
    }

    public MethodStream filter(Predicate<MethodWrapper> filter) {
        this.methods.removeIf(filter.negate());
        return this;
    }

    public MethodStream filter(String name) {
        return this.filter((MethodWrapper method) -> method.name().equals(name));
    }

    public MethodStream filter(Collection<String> names) {
        return this.filter((MethodWrapper method) -> names.contains(method.name()));
    }

    public MethodStream filter(String ... names) {
        return this.filter(Arrays.asList(names));
    }

    public MethodStream filter(Class<?> ... parameterTypes) {
        if (parameterTypes == null || parameterTypes.length == 0) {
            return this.filter((MethodWrapper method) -> method.parameterCount() == 0);
        }
        return this.filter((MethodWrapper method) -> Arrays.equals(method.parameterTypes(), parameterTypes));
    }

    public MethodStream filter(boolean isStatic) {
        return this.filter((MethodWrapper method) -> method.modifier().isStatic() == isStatic);
    }

    public MethodStream filterAnnotation(Class<?> annotation) {
        return this.filter((MethodWrapper method) -> method.annotations().anyMatch(a -> a.annotationType().equals(annotation)));
    }

    public Iterator<MethodWrapper> iterator() {
        return this.methods.iterator();
    }

    public <T> Stream<T> map(Function<MethodWrapper, T> mapFunction) {
        return this.jstream().map(mapFunction);
    }

    public Stream<MethodWrapper> jstream() {
        return this.methods.stream();
    }

    public MethodStream forEach(Consumer<MethodWrapper> consumer) {
        this.methods.forEach(consumer);
        return this;
    }

    public MethodStream copy() {
        return new MethodStream(this.parent, new ArrayList<MethodWrapper>(this.methods));
    }
}

