/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons;

import com.fix3dll.skyblockaddons.commands.SkyblockAddonsCommand;
import com.fix3dll.skyblockaddons.config.ConfigValuesManager;
import com.fix3dll.skyblockaddons.config.PersistentValuesManager;
import com.fix3dll.skyblockaddons.config.PetCacheManager;
import com.fix3dll.skyblockaddons.core.SkyblockKeyBinding;
import com.fix3dll.skyblockaddons.core.SkyblockRarity;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureData;
import com.fix3dll.skyblockaddons.core.scheduler.Scheduler;
import com.fix3dll.skyblockaddons.core.updater.Updater;
import com.fix3dll.skyblockaddons.events.ClientEvents;
import com.fix3dll.skyblockaddons.features.SkillXpManager;
import com.fix3dll.skyblockaddons.features.discordrpc.DiscordRPCManager;
import com.fix3dll.skyblockaddons.features.dungeons.DungeonManager;
import com.fix3dll.skyblockaddons.gui.buttons.ButtonBanner;
import com.fix3dll.skyblockaddons.gui.screens.IslandWarpGui;
import com.fix3dll.skyblockaddons.listeners.NetworkListener;
import com.fix3dll.skyblockaddons.listeners.PlayerListener;
import com.fix3dll.skyblockaddons.listeners.RenderListener;
import com.fix3dll.skyblockaddons.listeners.ScreenListener;
import com.fix3dll.skyblockaddons.utils.DevUtils;
import com.fix3dll.skyblockaddons.utils.InventoryUtils;
import com.fix3dll.skyblockaddons.utils.SkyblockAddonsMessageFactory;
import com.fix3dll.skyblockaddons.utils.TextUtils;
import com.fix3dll.skyblockaddons.utils.Utils;
import com.fix3dll.skyblockaddons.utils.data.DataUtils;
import com.fix3dll.skyblockaddons.utils.data.skyblockdata.ElectionData;
import com.fix3dll.skyblockaddons.utils.data.skyblockdata.MayorJerryData;
import com.fix3dll.skyblockaddons.utils.data.skyblockdata.OnlineData;
import com.fix3dll.skyblockaddons.utils.gson.ConfigValuesAdapter;
import com.fix3dll.skyblockaddons.utils.gson.CustomExposeStrategy;
import com.fix3dll.skyblockaddons.utils.gson.FeatureDataAdapter;
import com.fix3dll.skyblockaddons.utils.gson.GsonInitializableTypeAdapter;
import com.fix3dll.skyblockaddons.utils.gson.PatternAdapter;
import com.fix3dll.skyblockaddons.utils.gson.SemanticVersionAdapter;
import com.fix3dll.skyblockaddons.utils.gson.SkyblockRarityAdapter;
import com.fix3dll.skyblockaddons.utils.gson.UuidAdapter;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import lombok.Generated;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.MessageFactory;

public class SkyblockAddons
implements ClientModInitializer {
    public static final String MOD_ID = "skyblockaddons";
    public static final ModMetadata METADATA = ((ModContainer)FabricLoader.getInstance().getModContainer("skyblockaddons").orElseThrow()).getMetadata();
    public static final String BUILD_NUMBER = METADATA.getCustomValue("skyblockaddons").getAsObject().get("buildNumber").getAsString();
    public static final class_304.class_11900 CATEGORY = new class_304.class_11900(SkyblockAddons.resourceLocation("skyblockaddons"));
    private static final Logger LOGGER = LogManager.getLogger((MessageFactory)new SkyblockAddonsMessageFactory(METADATA.getName()));
    private static final ThreadPoolExecutor THREAD_EXECUTOR = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat(METADATA.getName() + " - #%d").build());
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().addSerializationExclusionStrategy(new CustomExposeStrategy(true)).addDeserializationExclusionStrategy(new CustomExposeStrategy(false)).registerTypeAdapter((Type)((Object)EnumMap.class), type -> {
        Type[] types = ((ParameterizedType)type).getActualTypeArguments();
        return new EnumMap((Class)types[0]);
    }).registerTypeAdapterFactory(new GsonInitializableTypeAdapter()).registerTypeAdapter((Type)((Object)Pattern.class), new PatternAdapter()).registerTypeAdapter((Type)((Object)SemanticVersion.class), new SemanticVersionAdapter()).registerTypeAdapter((Type)((Object)SkyblockRarity.class), new SkyblockRarityAdapter()).registerTypeAdapter((Type)((Object)UUID.class), new UuidAdapter()).registerTypeAdapter((Type)((Object)FeatureData.class), new FeatureDataAdapter()).registerTypeAdapter((Type)((Object)ConfigValuesManager.ConfigValues.class), new ConfigValuesAdapter()).create();
    private boolean immediatelyFastLoaded = false;
    private boolean entityCullingLoaded = false;
    private static final ZoneId hypixelZoneId = ZoneId.of("America/New_York");
    private static SkyblockAddons instance;
    private boolean fullyInitialized = false;
    private final ConfigValuesManager configValuesManager;
    private final PersistentValuesManager persistentValuesManager;
    private final PetCacheManager petCacheManager;
    private final PlayerListener playerListener;
    private final DiscordRPCManager discordRPCManager;
    private final Utils utils;
    private final DungeonManager dungeonManager;
    private final Scheduler scheduler;
    private final Updater updater;
    private final RenderListener renderListener;
    private final InventoryUtils inventoryUtils;
    private final ScreenListener screenListener;
    private final NetworkListener networkListener;
    private final SkillXpManager skillXpManager;
    private OnlineData onlineData;
    private ElectionData electionData;
    private MayorJerryData mayorJerryData;
    private final HashSet<Integer> registeredFeatureIDs = new HashSet();

    public SkyblockAddons() {
        instance = this;
        DataUtils.readTexturedHeads();
        File configFile = FabricLoader.getInstance().getConfigDir().toFile();
        try {
            Files.createDirectories(Paths.get(configFile.getPath(), "/skyblockaddons"), new FileAttribute[0]);
        }
        catch (IOException ex) {
            LOGGER.error("Could not create SkyblockAddons folder", (Throwable)ex);
        }
        this.configValuesManager = new ConfigValuesManager(configFile);
        this.persistentValuesManager = new PersistentValuesManager(configFile);
        this.petCacheManager = new PetCacheManager(configFile);
        this.configValuesManager.loadValues();
        this.updater = new Updater();
        this.persistentValuesManager.loadValues();
        this.petCacheManager.loadValues();
        this.playerListener = new PlayerListener();
        this.discordRPCManager = new DiscordRPCManager();
        this.utils = new Utils();
        this.dungeonManager = new DungeonManager();
        this.scheduler = new Scheduler();
        this.renderListener = new RenderListener();
        this.inventoryUtils = new InventoryUtils();
        this.screenListener = new ScreenListener();
        this.networkListener = new NetworkListener();
        this.skillXpManager = new SkillXpManager();
        this.electionData = new ElectionData();
        this.mayorJerryData = new MayorJerryData();
        DataUtils.readLocalAndFetchOnline();
    }

    public void onInitializeClient() {
        LOGGER.info("Hello Fabric world!");
        SkyblockAddonsCommand.initialize();
        ClientEvents.AFTER_INITIALIZATION.register(client -> {
            SkyblockAddons.runAsync(ButtonBanner.REGISTER_BANNER);
            if (Feature.DEVELOPER_MODE.isDisabled()) {
                SkyblockKeyBinding.DEVELOPER_COPY_NBT.deRegister();
            }
            if (Feature.FANCY_WARP_MENU.isEnabled()) {
                for (IslandWarpGui.Island island : IslandWarpGui.Island.values()) {
                    class_310.method_1551().method_1531().method_4619(island.getResourceLocation());
                }
            }
            DevUtils.resetEntityNamesToDefault();
            NetworkListener.setupModAPI();
            this.immediatelyFastLoaded = this.utils.isModLoaded("immediatelyfast");
            this.entityCullingLoaded = this.utils.isModLoaded("entityculling");
            this.fullyInitialized = true;
            TextUtils.setInstanceLoaded(true);
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.configValuesManager.saveConfig();
            this.persistentValuesManager.saveValues();
            this.petCacheManager.saveValues();
            THREAD_EXECUTOR.shutdown();
            try {
                THREAD_EXECUTOR.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                THREAD_EXECUTOR.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }, "SkyblockAddons-Shutdown"));
    }

    public static Logger getLogger() {
        String fullClassName = new Throwable().getStackTrace()[1].getClassName();
        String simpleClassName = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
        return LogManager.getLogger((String)fullClassName, (MessageFactory)new SkyblockAddonsMessageFactory(simpleClassName));
    }

    public static ZonedDateTime getHypixelZonedDateTime() {
        return ZonedDateTime.now(hypixelZoneId);
    }

    public static void runAsync(Runnable runnable) {
        THREAD_EXECUTOR.execute(runnable);
    }

    public static class_2960 resourceLocation(String location) {
        return class_2960.method_60655((String)MOD_ID, (String)location);
    }

    @Generated
    public boolean isImmediatelyFastLoaded() {
        return this.immediatelyFastLoaded;
    }

    @Generated
    public boolean isEntityCullingLoaded() {
        return this.entityCullingLoaded;
    }

    @Generated
    public ConfigValuesManager getConfigValuesManager() {
        return this.configValuesManager;
    }

    @Generated
    public PersistentValuesManager getPersistentValuesManager() {
        return this.persistentValuesManager;
    }

    @Generated
    public PetCacheManager getPetCacheManager() {
        return this.petCacheManager;
    }

    @Generated
    public PlayerListener getPlayerListener() {
        return this.playerListener;
    }

    @Generated
    public DiscordRPCManager getDiscordRPCManager() {
        return this.discordRPCManager;
    }

    @Generated
    public Utils getUtils() {
        return this.utils;
    }

    @Generated
    public DungeonManager getDungeonManager() {
        return this.dungeonManager;
    }

    @Generated
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Generated
    public Updater getUpdater() {
        return this.updater;
    }

    @Generated
    public RenderListener getRenderListener() {
        return this.renderListener;
    }

    @Generated
    public InventoryUtils getInventoryUtils() {
        return this.inventoryUtils;
    }

    @Generated
    public ScreenListener getScreenListener() {
        return this.screenListener;
    }

    @Generated
    public NetworkListener getNetworkListener() {
        return this.networkListener;
    }

    @Generated
    public SkillXpManager getSkillXpManager() {
        return this.skillXpManager;
    }

    @Generated
    public OnlineData getOnlineData() {
        return this.onlineData;
    }

    @Generated
    public ElectionData getElectionData() {
        return this.electionData;
    }

    @Generated
    public MayorJerryData getMayorJerryData() {
        return this.mayorJerryData;
    }

    @Generated
    public HashSet<Integer> getRegisteredFeatureIDs() {
        return this.registeredFeatureIDs;
    }

    @Generated
    public static Gson getGson() {
        return gson;
    }

    @Generated
    public static ZoneId getHypixelZoneId() {
        return hypixelZoneId;
    }

    @Generated
    public static SkyblockAddons getInstance() {
        return instance;
    }

    @Generated
    public boolean isFullyInitialized() {
        return this.fullyInitialized;
    }

    @Generated
    public void setOnlineData(OnlineData onlineData) {
        this.onlineData = onlineData;
    }

    @Generated
    public void setElectionData(ElectionData electionData) {
        this.electionData = electionData;
    }

    @Generated
    public void setMayorJerryData(MayorJerryData mayorJerryData) {
        this.mayorJerryData = mayorJerryData;
    }
}

