/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.commands;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.SkyblockKeyBinding;
import com.fix3dll.skyblockaddons.core.Translations;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.features.slayertracker.SlayerBoss;
import com.fix3dll.skyblockaddons.features.slayertracker.SlayerDrop;
import com.fix3dll.skyblockaddons.features.slayertracker.SlayerTracker;
import com.fix3dll.skyblockaddons.utils.DevUtils;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import com.fix3dll.skyblockaddons.utils.Utils;
import com.google.common.base.CaseFormat;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import lombok.Generated;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;

public class SkyblockAddonsCommand {
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    private static final String HEADER = "\u00a77\u00a7m                \u00a77[ \u00a7b\u00a7lSkyblockAddons \u00a77]\u00a77\u00a7m                \u00a7r";
    private static final String FOOTER = "\u00a77\u00a7m                                                     \u00a7r";
    private static final String[] SUBCOMMANDS = new String[]{"help", "edit", "folder", "resetZealotCounter", "set", "slayer", "version", "reload", "reloadConfig", "reloadRes", "dev", "brand", "copyBlock", "copyEntity", "copySidebar", "copyTabList", "pd", "toggleActionBarLogging", "toggleSlayerTrackerLogging", "copyOpenGL", "toggleSkyBlockOreLogging"};

    public static void initialize() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            LiteralArgumentBuilder<FabricClientCommandSource> builder = SkyblockAddonsCommand.buildCommands();
            dispatcher.register(builder);
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"sba").executes(ctx -> {
                main.getUtils().setFadingIn(true);
                main.getRenderListener().setGuiToOpen(EnumUtils.GUIType.MAIN, 1, EnumUtils.GuiTab.MAIN);
                return 1;
            })).redirect((CommandNode)builder.build()));
        });
    }

    public static LiteralArgumentBuilder<FabricClientCommandSource> buildCommands() {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblockaddons").executes(ctx -> {
            main.getUtils().setFadingIn(true);
            main.getRenderListener().setGuiToOpen(EnumUtils.GUIType.MAIN, 1, EnumUtils.GuiTab.MAIN);
            return 1;
        });
        builder.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"help").executes(ctx -> {
            Utils.sendMessage(SkyblockAddonsCommand.getCommandUsage(), false);
            return 1;
        })).then(ClientCommandManager.argument((String)"command", (ArgumentType)StringArgumentType.word()).suggests((ctx, suggestionsBuilder) -> {
            for (String subcommand : SUBCOMMANDS) {
                suggestionsBuilder.suggest(subcommand);
            }
            return suggestionsBuilder.buildFuture();
        }).executes(ctx -> {
            String argument = (String)ctx.getArgument("command", String.class);
            try {
                Utils.sendMessage(SkyblockAddonsCommand.getSubCommandUsage(argument), false);
                return 1;
            }
            catch (IllegalArgumentException e) {
                Utils.sendErrorMessage(Translations.getMessage("commands.errors.wrongUsage.subCommandNotFound", argument));
                return 0;
            }
        })));
        builder.then(ClientCommandManager.literal((String)"edit").executes(ctx -> {
            main.getUtils().setFadingIn(false);
            main.getRenderListener().setGuiToOpen(EnumUtils.GUIType.EDIT_LOCATIONS, 0, null);
            return 1;
        }));
        LiteralArgumentBuilder set = (LiteralArgumentBuilder)ClientCommandManager.literal((String)"set").executes(ctx -> {
            Utils.sendErrorMessage(Translations.getMessage("commands.errors.wrongUsage.generic", new Object[0]));
            return 0;
        });
        set.then(ClientCommandManager.literal((String)"zealots").then(ClientCommandManager.argument((String)"number", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            int val = (Integer)ctx.getArgument("number", Integer.class);
            main.getPersistentValuesManager().getPersistentValues().setKills(val);
            main.getPersistentValuesManager().saveValues();
            Utils.sendMessage(Translations.getMessage("commands.responses.sba.set.zealotCounter.zealotsSet", val));
            return 1;
        })));
        set.then(ClientCommandManager.literal((String)"totalZealots").then(ClientCommandManager.argument((String)"number", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            int val = (Integer)ctx.getArgument("number", Integer.class);
            main.getPersistentValuesManager().getPersistentValues().setTotalKills(val);
            main.getPersistentValuesManager().saveValues();
            Utils.sendMessage(Translations.getMessage("commands.responses.sba.set.zealotCounter.totalZealotsSet", val));
            return 1;
        })));
        set.then(ClientCommandManager.literal((String)"eyes").then(ClientCommandManager.argument((String)"number", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> {
            int val = (Integer)ctx.getArgument("number", Integer.class);
            main.getPersistentValuesManager().getPersistentValues().setSummoningEyeCount(val);
            main.getPersistentValuesManager().saveValues();
            Utils.sendMessage(Translations.getMessage("commands.responses.sba.set.zealotCounter.eyesSet", val));
            return 1;
        })));
        builder.then((ArgumentBuilder)set);
        builder.then(ClientCommandManager.literal((String)"resetZealotCounter").executes(ctx -> {
            main.getPersistentValuesManager().resetZealotCounter();
            Utils.sendMessage(String.valueOf(ColorCode.GREEN) + Translations.getMessage("commands.responses.sba.resetZealotCounter.resetSuccess", new Object[0]));
            return 1;
        }));
        builder.then(ClientCommandManager.literal((String)"folder").executes(ctx -> {
            class_156.method_668().method_672(main.getUtils().getSBAFolder());
            return 1;
        }));
        builder.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"slayer").executes(ctx -> {
            StringBuilder bosses = new StringBuilder();
            for (int i = 0; i < SlayerBoss.values().length; ++i) {
                SlayerBoss slayerBoss = SlayerBoss.values()[i];
                bosses.append("'").append(slayerBoss.getMobType().toLowerCase(Locale.US)).append("'");
                if (i + 1 >= SlayerBoss.values().length) continue;
                bosses.append(", ");
            }
            Utils.sendErrorMessage(Translations.getMessage("commands.responses.sba.slayer.bossRequired", bosses.toString()));
            return 0;
        })).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"boss", (ArgumentType)StringArgumentType.word()).suggests((ctx, suggestionsBuilder) -> {
            String remaining = suggestionsBuilder.getRemaining();
            for (SlayerBoss boss : SlayerBoss.values()) {
                String bossType = boss.getMobType();
                if (!bossType.startsWith(remaining)) continue;
                suggestionsBuilder.suggest(bossType);
            }
            return suggestionsBuilder.buildFuture();
        }).executes(ctx -> {
            Utils.sendErrorMessage(Translations.getMessage("commands.responses.sba.slayer.bossRequired", Arrays.stream(SlayerBoss.values()).map(SlayerBoss::getMobType).toList()));
            return 1;
        })).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"stat", (ArgumentType)StringArgumentType.word()).suggests((ctx, suggestionsBuilder) -> {
            int lastSpace;
            int prevSpace;
            String boss;
            SlayerBoss slayerBoss;
            String input;
            String remaining = suggestionsBuilder.getRemaining();
            if ("reset_all".startsWith(remaining)) {
                suggestionsBuilder.suggest("reset_all");
            }
            if ("kills".startsWith(remaining)) {
                suggestionsBuilder.suggest("kills");
            }
            if (!(input = suggestionsBuilder.getInput()).isBlank() && (slayerBoss = SlayerBoss.getFromMobType(boss = input.substring((prevSpace = input.lastIndexOf(32, (lastSpace = input.lastIndexOf(32)) - 1)) + 1, lastSpace))) != null) {
                for (SlayerDrop drop : slayerBoss.getDrops()) {
                    String dropName = drop.name().toLowerCase(Locale.ENGLISH);
                    if (!dropName.startsWith(remaining)) continue;
                    suggestionsBuilder.suggest(drop.name().toLowerCase(Locale.ENGLISH));
                }
            }
            return suggestionsBuilder.buildFuture();
        }).executes(ctx -> {
            String boss = (String)ctx.getArgument("boss", String.class);
            String stat = (String)ctx.getArgument("stat", String.class);
            if ("reset_all".equalsIgnoreCase(stat)) {
                SlayerTracker.getInstance().resetAllStats(boss);
                return 1;
            }
            Utils.sendErrorMessage(Translations.getMessage("commands.responses.sba.slayer.statRequired", new Object[0]));
            return 0;
        })).then(ClientCommandManager.argument((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            String boss = (String)ctx.getArgument("boss", String.class);
            String stat = (String)ctx.getArgument("stat", String.class);
            int value = (Integer)ctx.getArgument("value", Integer.class);
            SlayerTracker.getInstance().setStatManually(boss, stat, value);
            return 1;
        })))));
        builder.then(ClientCommandManager.literal((String)"version").executes(ctx -> {
            String versionString = Translations.getMessage("messages.version", new Object[0]) + " v" + String.valueOf(SkyblockAddons.METADATA.getVersion());
            class_5250 versionText = class_2561.method_43470((String)versionString).method_27694(style -> style.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)(String.valueOf(ColorCode.AQUA) + Translations.getMessage("commands.responses.sba.version.hoverText", new Object[0]))))).method_10958((class_2558)new class_2558.class_10610(SkyblockAddons.METADATA.getVersion().toString())));
            Utils.sendMessage((class_2561)versionText, true);
            return 1;
        }));
        builder.then(ClientCommandManager.literal((String)"reload").executes(ctx -> {
            DevUtils.reloadAll();
            return 1;
        }));
        builder.then(ClientCommandManager.literal((String)"reloadConfig").executes(ctx -> {
            main.getConfigValuesManager().setFirstLoad(true);
            DevUtils.reloadConfig();
            return 1;
        }));
        builder.then(ClientCommandManager.literal((String)"reloadRes").executes(ctx -> {
            DevUtils.reloadResources();
            return 1;
        }));
        builder.then(ClientCommandManager.literal((String)"dev").executes(ctx -> {
            Feature.DEVELOPER_MODE.setEnabled(Feature.DEVELOPER_MODE.isDisabled());
            if (Feature.DEVELOPER_MODE.isEnabled()) {
                Utils.sendMessage(String.valueOf(ColorCode.GREEN) + Translations.getMessage("commands.responses.sba.dev.enabled", SkyblockKeyBinding.DEVELOPER_COPY_NBT.getKeyBinding().method_16007().getString()));
            } else {
                Utils.sendMessage(String.valueOf(ColorCode.RED) + Translations.getMessage("commands.responses.sba.dev.disabled", new Object[0]));
            }
            return 1;
        }));
        builder.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"brand").requires(rq -> Feature.DEVELOPER_MODE.isEnabled())).executes(ctx -> {
            String serverBrand = DevUtils.getServerBrand();
            if (serverBrand != null) {
                Utils.sendMessage(Translations.getMessage("commands.responses.sba.brand.brandOutput", serverBrand));
            } else {
                Utils.sendErrorMessage(Translations.getMessage("commands.responses.sba.brand.notFound", new Object[0]));
            }
            return 1;
        }));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"copyEntity").requires(rq -> Feature.DEVELOPER_MODE.isEnabled())).executes(ctx -> {
            DevUtils.setCopyMode(DevUtils.CopyMode.ENTITY);
            DevUtils.resetEntityCopyRadiusToDefault();
            DevUtils.resetEntityNamesToDefault();
            DevUtils.copyData();
            return 1;
        })).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"entityType", (ArgumentType)StringArgumentType.word()).suggests((ctx, suggestionsBuilder) -> {
            String remaining = suggestionsBuilder.getRemaining();
            DevUtils.ALL_ENTITIES.keySet().forEach(string -> {
                if (string.startsWith(remaining)) {
                    suggestionsBuilder.suggest(string);
                }
            });
            return suggestionsBuilder.buildFuture();
        }).executes(ctx -> {
            DevUtils.setCopyMode(DevUtils.CopyMode.ENTITY);
            DevUtils.setEntityNamesFromString((String)ctx.getArgument("entityType", String.class));
            DevUtils.resetEntityCopyRadiusToDefault();
            DevUtils.copyData();
            return 1;
        })).then(ClientCommandManager.argument((String)"radius", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> {
            DevUtils.setCopyMode(DevUtils.CopyMode.ENTITY);
            DevUtils.setEntityNamesFromString((String)ctx.getArgument("entityType", String.class));
            DevUtils.setEntityCopyRadius((Integer)ctx.getArgument("radius", Integer.class));
            DevUtils.copyData();
            return 1;
        }))));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"copySidebar").requires(rq -> Feature.DEVELOPER_MODE.isEnabled())).executes(ctx -> {
            DevUtils.setCopyMode(DevUtils.CopyMode.SIDEBAR);
            DevUtils.setSidebarFormatted(false);
            DevUtils.copyData();
            return 1;
        })).then(ClientCommandManager.argument((String)"formatted", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> {
            boolean formatted = BoolArgumentType.getBool((CommandContext)ctx, (String)"formatted");
            DevUtils.setSidebarFormatted(formatted);
            DevUtils.setCopyMode(DevUtils.CopyMode.SIDEBAR);
            DevUtils.copyData();
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"copyTabList").requires(rq -> Feature.DEVELOPER_MODE.isEnabled())).executes(ctx -> {
            DevUtils.setCopyMode(DevUtils.CopyMode.TAB_LIST);
            DevUtils.copyData();
            return 1;
        }));
        builder.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"copyBlock").requires(rq -> Feature.DEVELOPER_MODE.isEnabled())).executes(ctx -> {
            DevUtils.setCopyMode(DevUtils.CopyMode.BLOCK);
            DevUtils.copyData();
            return 1;
        }));
        builder.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"copyOpenGl").requires(rq -> Feature.DEVELOPER_MODE.isEnabled())).executes(ctx -> {
            DevUtils.copyOpenGLLogs();
            return 1;
        }));
        builder.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"pd").requires(rq -> Feature.DEVELOPER_MODE.isEnabled())).executes(ctx -> {
            Utils.sendMessage(String.valueOf(ColorCode.BOLD) + "Death Counts: ");
            Utils.sendMessage(String.valueOf(ColorCode.WHITE) + "Deaths: " + String.valueOf(ColorCode.GOLD) + main.getDungeonManager().getDeaths());
            Utils.sendMessage(String.valueOf(ColorCode.WHITE) + "Alt Deaths: " + String.valueOf(ColorCode.GOLD) + main.getDungeonManager().getAlternateDeaths());
            Utils.sendMessage(String.valueOf(ColorCode.WHITE) + "Tab Deaths: " + String.valueOf(ColorCode.GOLD) + main.getDungeonManager().getPlayerListInfoDeaths());
            return 1;
        }));
        builder.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"toggleActionBarLogging").requires(rq -> Feature.DEVELOPER_MODE.isEnabled())).executes(ctx -> {
            DevUtils.setLoggingActionBarMessages(!DevUtils.isLoggingActionBarMessages());
            if (DevUtils.isLoggingActionBarMessages()) {
                Utils.sendMessage(String.valueOf(ColorCode.GREEN) + Translations.getMessage("commands.responses.sba.toggleActionBarLogging.enabled", new Object[0]));
            } else {
                Utils.sendMessage(String.valueOf(ColorCode.RED) + Translations.getMessage("commands.responses.sba.toggleActionBarLogging.disabled", new Object[0]));
            }
            return 1;
        }));
        builder.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"toggleSlayerTrackerLogging").requires(rq -> Feature.DEVELOPER_MODE.isEnabled())).executes(ctx -> {
            DevUtils.setLoggingSlayerTracker(!DevUtils.isLoggingSlayerTracker());
            if (DevUtils.isLoggingSlayerTracker()) {
                Utils.sendMessage(String.valueOf(ColorCode.GREEN) + Translations.getMessage("commands.responses.sba.toggleSlayerTrackerLogging.enabled", new Object[0]));
            } else {
                Utils.sendMessage(String.valueOf(ColorCode.RED) + Translations.getMessage("commands.responses.sba.toggleSlayerTrackerLogging.disabled", new Object[0]));
            }
            return 1;
        }));
        builder.then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"toggleSkyBlockOreLogging").requires(rq -> Feature.DEVELOPER_MODE.isEnabled())).executes(ctx -> {
            DevUtils.setLoggingSkyBlockOre(!DevUtils.isLoggingSkyBlockOre());
            if (DevUtils.isLoggingSkyBlockOre()) {
                Utils.sendMessage(String.valueOf(ColorCode.GREEN) + Translations.getMessage("commands.responses.sba.toggleSkyBlockOreLogging.enabled", new Object[0]));
            } else {
                Utils.sendMessage(String.valueOf(ColorCode.RED) + Translations.getMessage("commands.responses.sba.toggleSkyBlockOreLogging.disabled", new Object[0]));
            }
            return 1;
        }));
        builder.then(ClientCommandManager.literal((String)"warp").executes(ctx -> {
            main.getRenderListener().setGuiToOpen(EnumUtils.GUIType.WARP);
            return 1;
        }));
        builder.then(ClientCommandManager.literal((String)"internal").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"command", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String command = (String)ctx.getArgument("command", String.class);
            if ("launchAutoUpdate".equalsIgnoreCase(command)) {
                main.getUpdater().launchAutoUpdate();
            }
            return 1;
        })).then(ClientCommandManager.argument((String)"arg", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> {
            String command = (String)ctx.getArgument("command", String.class);
            String arg = ((String)ctx.getArgument("arg", String.class)).toLowerCase(Locale.US);
            if ("copy".equalsIgnoreCase(command)) {
                DevUtils.copyStringToClipboard(arg, Translations.getMessage("messages.copied", new Object[0]), false);
            }
            return 1;
        }))));
        return builder;
    }

    public static class_2561 getCommandUsage() {
        StringBuilder builder = new StringBuilder(HEADER);
        for (Commands command : Commands.values()) {
            if (command.devMode && Feature.DEVELOPER_MODE.isDisabled()) continue;
            builder.append("\n").append(command.createMenuDescriptionLine());
        }
        builder.append("\n").append(FOOTER);
        return class_2561.method_43470((String)builder.toString());
    }

    public static class_2561 getSubCommandUsage(String subCommand) {
        for (String validSubCommand : SUBCOMMANDS) {
            if (!subCommand.equalsIgnoreCase(validSubCommand)) continue;
            subCommand = CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, validSubCommand);
        }
        return class_2561.method_43470((String)("\u00a77\u00a7m                \u00a77[ \u00a7b\u00a7lSkyblockAddons \u00a77]\u00a77\u00a7m                \u00a7r\n" + String.valueOf((Object)Commands.valueOf(subCommand)) + "\n\u00a77\u00a7m                                                     \u00a7r"));
    }

    private static enum Commands {
        BASE("/sba", "commands.usage.sba.base.help", null),
        HELP("/sba help [command]", "commands.usage.sba.help.help", Collections.singletonList(CommandOption.COMMAND)),
        EDIT("/sba edit", "commands.usage.sba.edit.help", null),
        SET("/sba set <zealots|eyes|totalZealots \u00a7eor\u00a7b total> <number>", "commands.usage.sba.set.zealotCounter.detailedHelp.description", Arrays.asList(CommandOption.ZEALOTS, CommandOption.EYES, CommandOption.TOTAL_ZEALOTS)),
        RESET_ZEALOT_COUNTER("/sba resetZealotCounter", "commands.usage.sba.resetZealotCounter.help", null),
        FOLDER("/sba folder", "commands.usage.sba.folder.help", null),
        SLAYER("/sba slayer <boss> <stat> <number>", "commands.usage.sba.slayer.detailedHelp.description", Arrays.asList(CommandOption.SLAYER_BOSS, CommandOption.SLAYER_STAT, CommandOption.SLAYER_NUMBER)),
        VERSION("/sba version", "commands.usage.sba.version.help", null),
        RELOAD("/sba reload", "commands.usage.sba.reload.help", null),
        RELOAD_CONFIG("/sba reloadConfig", "commands.usage.sba.reloadConfig.help", null),
        RELOAD_RES("/sba reloadRes", "commands.usage.sba.reloadRes.help", null),
        DEV("/sba dev", "commands.usage.sba.dev.detailedHelp.description", null),
        BRAND("/sba brand", "commands.usage.sba.brand.help", null, true),
        COPY_ENTITY("/sba copyEntity [entityNames] [radius: integer]", "commands.usage.sba.copyEntity.detailedHelp.description", Arrays.asList(CommandOption.ENTITY_NAMES, CommandOption.RADIUS), true),
        COPY_SIDEBAR("/sba copySidebar [formatted: boolean]", "commands.usage.sba.copySidebar.detailedHelp.description", Collections.singletonList(CommandOption.FORMATTED), true),
        COPY_TAB_LIST("/sba copyTabList", "commands.usage.sba.copyTabList.detailedHelp.description", null, true),
        COPY_OPENGL("/sba copyOpenGL", "commands.usage.sba.copyOpenGL.detailedHelp.description", null, true),
        COPY_BLOCK("/sba copyBlock", "commands.usage.sba.copyBlock.help", null, true),
        PD("/sba pd", "commands.usage.sba.printDeaths.help", null, true),
        TOGGLE_ACTION_BAR_LOGGING("/sba toggleActionBarLogging", "commands.usage.sba.toggleActionBarLogging.help", null, true),
        TOGGLE_SLAYER_TRACKER_LOGGING("/sba toggleSlayerTrackerLogging", "commands.usage.sba.toggleSlayerTrackerLogging.help", null, true),
        TOGGLE_SKYBLOCK_ORE_LOGGING("/sba toggleSkyBlockOreLogging", "commands.usage.sba.toggleSkyBlockOreLogging.help", null, true);

        private final String syntax;
        private final String descriptionTranslationKey;
        private final boolean devMode;
        private final List<CommandOption> options;

        private Commands(String syntax, String descriptionTranslationKey, List<CommandOption> options) {
            this(syntax, descriptionTranslationKey, options, false);
        }

        private Commands(String syntax, String descriptionTranslationKey, List<CommandOption> options, boolean devMode) {
            this.syntax = syntax;
            this.descriptionTranslationKey = descriptionTranslationKey;
            this.options = options;
            this.devMode = devMode;
        }

        public String createMenuDescriptionLine() {
            return "\u00a7b\u25cf " + this.syntax + " \u00a77-\u00a7r " + (String)(this.devMode ? "\u00a7e(" + Translations.getMessage("commands.usage.sba.dev.prefix", new Object[0]) + ")\u00a7r " : "") + Translations.getMessage(this.descriptionTranslationKey, new Object[0]);
        }

        public String toString() {
            StringBuilder usageBuilder = new StringBuilder("Usage: \u00a7b" + this.syntax + "\u00a7r\n\n\u00a7lDescription:\n\u00a77" + Translations.getMessage(this.descriptionTranslationKey, new Object[0]));
            if (this.options != null) {
                ListIterator<CommandOption> optionListIterator = this.options.listIterator();
                usageBuilder.append("\n").append("\n\u00a7lOptions:");
                while (optionListIterator.hasNext()) {
                    usageBuilder.append("\n");
                    usageBuilder.append((Object)optionListIterator.next());
                }
            }
            return usageBuilder.toString();
        }
    }

    private static enum CommandOption {
        COMMAND("Command", "commands.usage.sba.help.detailedHelp.options.command"),
        ZEALOTS("Zealots", "commands.usage.sba.set.zealotCounter.detailedHelp.options.zealots"),
        EYES("Eyes", "commands.usage.sba.set.zealotCounter.detailedHelp.options.eyes"),
        TOTAL_ZEALOTS("TotalZealots|Total", "commands.usage.sba.set.zealotCounter.detailedHelp.options.totalZealots"),
        FORMATTED("Formatted", "commands.usage.sba.copySidebar.detailedHelp.options.formatted"),
        ENTITY_NAMES("EntityNames", "commands.usage.sba.copyEntity.detailedHelp.options.entityNames"),
        RADIUS("Radius", "commands.usage.sba.copyEntity.detailedHelp.options.radius"),
        SLAYER_BOSS("Boss", "commands.usage.sba.slayer.detailedHelp.options.boss"),
        SLAYER_NUMBER("Number", "commands.usage.sba.slayer.detailedHelp.options.number"),
        SLAYER_STAT("Stat", "commands.usage.sba.slayer.detailedHelp.options.stat");

        private final String name;
        private final String descriptionTranslationKey;

        public String toString() {
            return "\u00a7b\u25cf " + this.name + " \u00a77- " + Translations.getMessage(this.descriptionTranslationKey, new Object[0]);
        }

        @Generated
        private CommandOption(String name, String descriptionTranslationKey) {
            this.name = name;
            this.descriptionTranslationKey = descriptionTranslationKey;
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }
}

