/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.config;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.SkyblockEquipment;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.features.PetManager;
import com.fix3dll.skyblockaddons.utils.Utils;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import org.apache.logging.log4j.Logger;

public class PetCacheManager {
    private static final Logger LOGGER = SkyblockAddons.getLogger();
    private static final ReentrantLock SAVE_LOCK = new ReentrantLock();
    private final File petCacheFile;
    private PetCache petCache = new PetCache();

    public PetCacheManager(File mainConfigDir) {
        this.petCacheFile = new File(mainConfigDir.getAbsolutePath(), "/skyblockaddons/petCache.json");
    }

    public void loadValues() {
        if (this.petCacheFile.exists()) {
            try (BufferedReader reader = Files.newBufferedReader(this.petCacheFile.toPath(), StandardCharsets.UTF_8);){
                this.petCache = SkyblockAddons.getGson().fromJson((Reader)reader, PetCache.class);
                if (this.petCache == null) {
                    this.petCache = new PetCache();
                }
            }
            catch (Exception ex) {
                LOGGER.error("Error while loading pet cache!", (Throwable)ex);
            }
        } else {
            this.saveValues();
        }
    }

    public void saveValues() {
        SkyblockAddons.runAsync(() -> {
            boolean isDevMode;
            block12: {
                if (!SAVE_LOCK.tryLock()) {
                    return;
                }
                isDevMode = Feature.DEVELOPER_MODE.isEnabled();
                if (isDevMode) {
                    LOGGER.info("Saving pet cache...");
                }
                try {
                    File tempFile = File.createTempFile(this.petCacheFile.getName(), ".tmp", this.petCacheFile.getParentFile());
                    try (BufferedWriter writer = Files.newBufferedWriter(tempFile.toPath(), StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                        SkyblockAddons.getGson().toJson((Object)this.petCache, (Appendable)writer);
                    }
                    Files.move(tempFile.toPath(), this.petCacheFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
                }
                catch (Exception ex) {
                    LOGGER.error("Error while saving pet cache!", (Throwable)ex);
                    if (class_310.method_1551().field_1724 == null) break block12;
                    Utils.sendErrorMessage("Error saving pet cache! Check log for more detail.");
                }
            }
            if (isDevMode) {
                LOGGER.info("Pet cache saved!");
            }
            SAVE_LOCK.unlock();
        });
    }

    public PetManager.Pet getCurrentPet() {
        return this.petCache.currentPet;
    }

    public void setCurrentPet(PetManager.Pet pet) {
        this.setCurrentPet(pet, true);
    }

    public void setCurrentPet(PetManager.Pet pet, boolean updateEquipment) {
        if (this.petCache.currentPet != pet) {
            this.petCache.currentPet = pet;
            this.saveValues();
        }
        if (updateEquipment) {
            SkyblockEquipment eq = SkyblockEquipment.PET;
            if (pet == null && !eq.isEmpty()) {
                eq.setItemStack(eq.getEmptyStack());
                SkyblockEquipment.saveEquipments();
            } else if (pet != null && !class_1799.method_31577((class_1799)pet.getItemStack(), (class_1799)eq.getItemStack())) {
                eq.setItemStack(pet.getItemStack());
                SkyblockEquipment.saveEquipments();
            }
        }
    }

    public PetManager.Pet getPet(int index) {
        return (PetManager.Pet)this.petCache.petMap.get(index);
    }

    public void putPet(int index, PetManager.Pet pet) {
        this.petCache.petMap.put(index, (Object)pet);
    }

    @Generated
    public void setPetCache(PetCache petCache) {
        this.petCache = petCache;
    }

    @Generated
    public File getPetCacheFile() {
        return this.petCacheFile;
    }

    @Generated
    public PetCache getPetCache() {
        return this.petCache;
    }

    public static class PetCache {
        private PetManager.Pet currentPet = null;
        private final Int2ObjectOpenHashMap<PetManager.Pet> petMap = new Int2ObjectOpenHashMap();

        @Generated
        public Int2ObjectOpenHashMap<PetManager.Pet> getPetMap() {
            return this.petMap;
        }
    }
}

