/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.core;

import com.fix3dll.skyblockaddons.utils.objects.RegistrableEnum;
import java.awt.Color;
import java.util.Locale;
import lombok.Generated;
import net.minecraft.class_9848;
import org.apache.commons.lang3.StringUtils;

public enum ColorCode implements RegistrableEnum
{
    BLACK('0', -16777216),
    DARK_BLUE('1', -16777046),
    DARK_GREEN('2', -16733696),
    DARK_AQUA('3', -16733526),
    DARK_RED('4', -5636096),
    DARK_PURPLE('5', -5635926),
    GOLD('6', -22016),
    GRAY('7', -5592406),
    DARK_GRAY('8', -11184811),
    BLUE('9', -11184641),
    GREEN('a', -11141291),
    AQUA('b', -11141121),
    RED('c', -43691),
    LIGHT_PURPLE('d', -43521),
    YELLOW('e', -171),
    WHITE('f', -1),
    MAGIC('k', true, "obfuscated"),
    BOLD('l', true),
    STRIKETHROUGH('m', true),
    UNDERLINE('n', true, "underlined"),
    ITALIC('o', true),
    RESET('r'),
    CHROMA('z', -2);

    public static final char COLOR_CHAR = '\u00a7';
    private final char code;
    private final boolean isFormat;
    private final String jsonName;
    private final int color;
    private final String toString;

    private ColorCode(char code) {
        this(code, -1);
    }

    private ColorCode(char code, int rgb) {
        this(code, false, rgb);
    }

    private ColorCode(char code, boolean isFormat) {
        this(code, isFormat, -1);
    }

    private ColorCode(char code, boolean isFormat, int rgb) {
        this(code, isFormat, null, rgb);
    }

    private ColorCode(char code, boolean isFormat, String jsonName) {
        this(code, isFormat, jsonName, -1);
    }

    private ColorCode(char code, boolean isFormat, String jsonName, int rgb) {
        this.code = code;
        this.isFormat = isFormat;
        this.jsonName = StringUtils.isEmpty((CharSequence)jsonName) ? this.name().toLowerCase(Locale.ENGLISH) : jsonName;
        this.color = rgb;
        this.toString = new String(new char[]{'\u00a7', code});
    }

    public static ColorCode getByChar(char code) {
        for (ColorCode color : ColorCode.values()) {
            if (color.code != code) continue;
            return color;
        }
        return null;
    }

    public static ColorCode getByARGB(int argb) {
        for (ColorCode color : ColorCode.values()) {
            if (color.color != argb) continue;
            return color;
        }
        return null;
    }

    public Color getColorObject() {
        return new Color(this.color);
    }

    public int getColor(int alpha) {
        return class_9848.method_61330((int)alpha, (int)this.color);
    }

    public boolean isColor() {
        return !this.isFormat() && this != RESET;
    }

    @Override
    public String toString() {
        return this.toString;
    }

    @Generated
    public char getCode() {
        return this.code;
    }

    @Generated
    public boolean isFormat() {
        return this.isFormat;
    }

    @Generated
    public String getJsonName() {
        return this.jsonName;
    }

    @Generated
    public int getColor() {
        return this.color;
    }
}

