/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.core;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.mixin.accessors.GameOptionsAccessor;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import net.minecraft.class_11908;
import net.minecraft.class_156;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3675;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.Logger;

public enum SkyblockKeyBinding {
    OPEN_SETTINGS(-1, "settings.settings"),
    OPEN_EDIT_GUI(-1, "settings.editLocations"),
    LOCK_SLOT(76, "settings.lockSlot"),
    FREEZE_BACKPACK(70, "settings.freezeBackpackPreview"),
    INCREASE_DUNGEON_MAP_ZOOM(334, "keyBindings.increaseDungeonMapZoom"),
    DECREASE_DUNGEON_MAP_ZOOM(333, "keyBindings.decreaseDungeonMapZoom"),
    ANSWER_ABIPHONE_OR_OPTION(-1, "keyBindings.answerAbiphoneOrOption"),
    DEVELOPER_COPY_NBT(class_156.method_668() == class_156.class_158.field_1137 ? 342 : 345, "keyBindings.developerCopyNBT");

    private static final Logger LOGGER;
    private final class_3675.class_306 defaultKey;
    private final String translationKey;
    private final class_304 keyBinding;
    private boolean registered = false;
    private boolean isFirstRegistration = true;
    private class_3675.class_306 previousKey = class_3675.field_16237;

    private SkyblockKeyBinding(int defaultKeyCode, String translationKey) {
        this.defaultKey = class_3675.method_15985((class_11908)new class_11908(defaultKeyCode, -1, -1));
        this.translationKey = translationKey;
        String key = "key.skyblockaddons." + this.name().toLowerCase(Locale.US);
        this.keyBinding = new class_304(key, defaultKeyCode, SkyblockAddons.CATEGORY);
    }

    public int getKeyCode() {
        return this.keyBinding.field_1655.method_1444();
    }

    public boolean consumeClick() {
        if (this.registered) {
            return this.keyBinding.method_1436();
        }
        return false;
    }

    public boolean isDown() {
        if (this.registered) {
            return this.keyBinding.method_1434();
        }
        return false;
    }

    public void register(class_315 options) {
        if (this.registered) {
            LOGGER.error("Tried to register a key binding with the name \"{}\" which is already registered.", (Object)this.name().toLowerCase(Locale.US));
            return;
        }
        GameOptionsAccessor accessor = (GameOptionsAccessor)options;
        accessor.sba$updateAllKeys((class_304[])ArrayUtils.add((Object[])accessor.sba$getAllKeys(), (Object)this.keyBinding));
        if (this.isFirstRegistration) {
            this.isFirstRegistration = false;
        } else if (this.previousKey != class_3675.field_16237) {
            this.keyBinding.method_1422(this.previousKey);
        }
        this.registered = true;
    }

    public void deRegister() {
        if (this.registered) {
            GameOptionsAccessor accessor = (GameOptionsAccessor)class_310.method_1551().field_1690;
            int index = ArrayUtils.indexOf((Object[])accessor.sba$getAllKeys(), (Object)this.keyBinding);
            if (index == -1) {
                LOGGER.error("Keybinding was registered but no longer exists in the registry. Something else must have removed it. This shouldn't happen; please inform an SBA developer.");
                this.registered = false;
                return;
            }
            accessor.sba$updateAllKeys((class_304[])ArrayUtils.remove((Object[])accessor.sba$getAllKeys(), (int)index));
            this.previousKey = this.keyBinding.field_1655;
            this.keyBinding.method_1422(class_3675.field_16237);
            this.registered = false;
        } else {
            LOGGER.error("Tried to de-register a key binding with the name \"{}\" which wasn't registered.", (Object)this.name().toLowerCase(Locale.US));
        }
    }

    public static void registerAllKeyBindings(class_315 options) {
        SkyblockKeyBinding.addCategory();
        for (SkyblockKeyBinding keybinding : SkyblockKeyBinding.values()) {
            if (!keybinding.isFirstRegistration()) continue;
            keybinding.register(options);
        }
    }

    private static void addCategory() {
        List sortOrder = class_304.class_11900.field_62925;
        if (!sortOrder.contains(SkyblockAddons.CATEGORY)) {
            sortOrder.addLast(SkyblockAddons.CATEGORY);
        }
    }

    @Generated
    public class_3675.class_306 getDefaultKey() {
        return this.defaultKey;
    }

    @Generated
    public String getTranslationKey() {
        return this.translationKey;
    }

    @Generated
    public class_304 getKeyBinding() {
        return this.keyBinding;
    }

    @Generated
    public boolean isRegistered() {
        return this.registered;
    }

    @Generated
    public boolean isFirstRegistration() {
        return this.isFirstRegistration;
    }

    @Generated
    public class_3675.class_306 getPreviousKey() {
        return this.previousKey;
    }

    static {
        LOGGER = SkyblockAddons.getLogger();
    }
}

