/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.core;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.Island;
import com.fix3dll.skyblockaddons.utils.LocationUtils;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;

public enum SkyblockOre {
    STONE(state -> state.method_27852(class_2246.field_10340), () -> !LocationUtils.isOnGlaciteTunnelsLocation() && !LocationUtils.isOn(Island.CRYSTAL_HOLLOWS, Island.MINESHAFT), BlockType.BLOCK),
    COBBLESTONE(state -> state.method_27852(class_2246.field_10445), () -> !LocationUtils.isOnGlaciteTunnelsLocation() && !LocationUtils.isOn(Island.MINESHAFT), BlockType.BLOCK),
    COAL_ORE(state -> state.method_27852(class_2246.field_10418), () -> LocationUtils.isOn(Island.GOLD_MINE, Island.DEEP_CAVERNS, Island.DWARVEN_MINES, Island.CRYSTAL_HOLLOWS) || LocationUtils.isOn("Coal Mine"), BlockType.ORE),
    IRON_ORE(state -> state.method_27852(class_2246.field_10212), () -> LocationUtils.isOn(Island.GOLD_MINE, Island.DEEP_CAVERNS, Island.DWARVEN_MINES, Island.CRYSTAL_HOLLOWS), BlockType.ORE),
    GOLD_ORE(state -> state.method_27852(class_2246.field_10571), () -> LocationUtils.isOn(Island.GOLD_MINE, Island.DEEP_CAVERNS, Island.DWARVEN_MINES, Island.CRYSTAL_HOLLOWS) || LocationUtils.isOn("Savanna Woodland"), BlockType.ORE),
    LAPIS_ORE(state -> state.method_27852(class_2246.field_10090), () -> LocationUtils.isOn(Island.DEEP_CAVERNS, Island.DWARVEN_MINES, Island.CRYSTAL_HOLLOWS), BlockType.ORE),
    REDSTONE_ORE(state -> state.method_27852(class_2246.field_10080), () -> LocationUtils.isOn(Island.DEEP_CAVERNS, Island.DWARVEN_MINES, Island.CRYSTAL_HOLLOWS), BlockType.ORE),
    EMERALD_ORE(state -> state.method_27852(class_2246.field_10013), () -> LocationUtils.isOn(Island.DEEP_CAVERNS, Island.DWARVEN_MINES, Island.CRYSTAL_HOLLOWS), BlockType.ORE),
    DIAMOND_ORE(state -> state.method_27852(class_2246.field_10442), () -> LocationUtils.isOn(Island.DEEP_CAVERNS, Island.DWARVEN_MINES, Island.CRYSTAL_HOLLOWS), BlockType.ORE),
    BLOCK_OF_DIAMOND(state -> state.method_27852(class_2246.field_10201), () -> LocationUtils.isOn(Island.DEEP_CAVERNS), BlockType.ORE),
    SULPHUR(state -> state.method_27852(class_2246.field_10258), () -> LocationUtils.isOn(Island.CRIMSON_ISLE), BlockType.ORE),
    QUARTZ_ORE(state -> state.method_27852(class_2246.field_10213), () -> LocationUtils.isOn(Island.CRIMSON_ISLE) || LocationUtils.isOn("Goblin Holdout"), BlockType.ORE),
    NETHERRACK(state -> state.method_27852(class_2246.field_10515), () -> LocationUtils.isOn(Island.CRIMSON_ISLE), BlockType.BLOCK),
    GLOWSTONE(state -> state.method_27852(class_2246.field_10171), () -> LocationUtils.isOn(Island.CRIMSON_ISLE), BlockType.BLOCK),
    MYCELIUM(state -> state.method_27852(class_2246.field_10402), () -> LocationUtils.isOn(Island.CRIMSON_ISLE), BlockType.BLOCK),
    RED_SAND(state -> state.method_27852(class_2246.field_10534), () -> LocationUtils.isOn(Island.CRIMSON_ISLE), BlockType.BLOCK),
    GRAVEL(state -> state.method_27852(class_2246.field_10255), () -> LocationUtils.isOn(Island.SPIDERS_DEN), BlockType.BLOCK),
    END_STONE(state -> state.method_27852(class_2246.field_10471), () -> LocationUtils.isOn(Island.THE_END), BlockType.BLOCK),
    OBSIDIAN(state -> state.method_27852(class_2246.field_10540), () -> LocationUtils.isOn(Island.DEEP_CAVERNS, Island.CRYSTAL_HOLLOWS, Island.THE_END), BlockType.BLOCK),
    ICE(state -> state.method_27852(class_2246.field_10295), () -> LocationUtils.isOn(Island.JERRYS_WORKSHOP), BlockType.BLOCK),
    HARD_STONE_HOLLOWS(SkyblockOre::isHardStoneHollows, () -> LocationUtils.isOn(Island.CRYSTAL_HOLLOWS), BlockType.BLOCK),
    HARD_STONE_GLACIAL(state -> state.method_27852(class_2246.field_10277) || state.method_27852(class_2246.field_10222), LocationUtils::isOnGlaciteTunnelsLocation, BlockType.BLOCK),
    HARD_STONE_MINESHAFT(state -> state.method_27852(class_2246.field_10340) || state.method_27852(class_2246.field_10222), () -> LocationUtils.isOn(Island.MINESHAFT), BlockType.BLOCK),
    PURE_COAL(state -> state.method_27852(class_2246.field_10381), () -> LocationUtils.isOn(Island.DWARVEN_MINES, Island.CRYSTAL_HOLLOWS), BlockType.ORE),
    PURE_IRON(state -> state.method_27852(class_2246.field_10085), () -> LocationUtils.isOn(Island.DWARVEN_MINES, Island.CRYSTAL_HOLLOWS), BlockType.ORE),
    PURE_GOLD(state -> state.method_27852(class_2246.field_10205), () -> LocationUtils.isOn(Island.DWARVEN_MINES, Island.CRYSTAL_HOLLOWS, Island.MINESHAFT), BlockType.ORE),
    PURE_LAPIS(state -> state.method_27852(class_2246.field_10441), () -> LocationUtils.isOn(Island.DWARVEN_MINES, Island.CRYSTAL_HOLLOWS), BlockType.ORE),
    PURE_REDSTONE(state -> state.method_27852(class_2246.field_10002), () -> LocationUtils.isOn(Island.DWARVEN_MINES, Island.CRYSTAL_HOLLOWS), BlockType.ORE),
    PURE_EMERALD(state -> state.method_27852(class_2246.field_10234), () -> LocationUtils.isOn(Island.DWARVEN_MINES, Island.CRYSTAL_HOLLOWS), BlockType.ORE),
    PURE_DIAMOND(state -> state.method_27852(class_2246.field_10201), () -> LocationUtils.isOn(Island.DWARVEN_MINES, Island.CRYSTAL_HOLLOWS), BlockType.ORE),
    PURE_QUARTZ(state -> state.method_27852(class_2246.field_10153), () -> LocationUtils.isOn(Island.DWARVEN_MINES), BlockType.ORE),
    RUBY(state -> state.method_27852(class_2246.field_10272) || state.method_27852(class_2246.field_10118), () -> LocationUtils.isOnGlaciteTunnelsLocation() || LocationUtils.isOn(Island.CRYSTAL_HOLLOWS, Island.MINESHAFT), BlockType.GEMSTONE),
    AMBER(state -> state.method_27852(class_2246.field_10227) || state.method_27852(class_2246.field_10496), () -> LocationUtils.isOnGlaciteTunnelsLocation() || LocationUtils.isOn(Island.CRYSTAL_HOLLOWS, Island.MINESHAFT), BlockType.GEMSTONE),
    AMETHYST(state -> state.method_27852(class_2246.field_10399) || state.method_27852(class_2246.field_10152), () -> LocationUtils.isOnGlaciteTunnelsLocation() || LocationUtils.isOn(Island.CRYSTAL_HOLLOWS, Island.MINESHAFT), BlockType.GEMSTONE),
    JADE(state -> state.method_27852(class_2246.field_10157) || state.method_27852(class_2246.field_10305), () -> LocationUtils.isOnGlaciteTunnelsLocation() || LocationUtils.isOn(Island.CRYSTAL_HOLLOWS, Island.MINESHAFT), BlockType.GEMSTONE),
    SAPPHIRE(state -> state.method_27852(class_2246.field_10271) || state.method_27852(class_2246.field_10193), () -> LocationUtils.isOnGlaciteTunnelsLocation() || LocationUtils.isOn(Island.CRYSTAL_HOLLOWS, Island.MINESHAFT), BlockType.GEMSTONE),
    TOPAZ(state -> state.method_27852(class_2246.field_10049) || state.method_27852(class_2246.field_10578), () -> LocationUtils.isOnGlaciteTunnelsLocation() || LocationUtils.isOn(Island.CRYSTAL_HOLLOWS, Island.MINESHAFT), BlockType.GEMSTONE),
    JASPER(state -> state.method_27852(class_2246.field_10574) || state.method_27852(class_2246.field_10469), () -> LocationUtils.isOnGlaciteTunnelsLocation() || LocationUtils.isOn(Island.CRYSTAL_HOLLOWS, Island.MINESHAFT), BlockType.GEMSTONE),
    OPAL(state -> state.method_27852(class_2246.field_10087) || state.method_27852(class_2246.field_9991), () -> LocationUtils.isOnGlaciteTunnelsLocation() || LocationUtils.isOn(Island.MINESHAFT, Island.CRIMSON_ISLE), BlockType.GEMSTONE),
    AQUAMARINE(state -> state.method_27852(class_2246.field_10060) || state.method_27852(class_2246.field_9982), () -> LocationUtils.isOnGlaciteTunnelsLocation() || LocationUtils.isOn(Island.MINESHAFT), BlockType.GEMSTONE),
    CITRINE(state -> state.method_27852(class_2246.field_10073) || state.method_27852(class_2246.field_10163), () -> LocationUtils.isOnGlaciteTunnelsLocation() || LocationUtils.isOn(Island.MINESHAFT), BlockType.GEMSTONE),
    ONYX(state -> state.method_27852(class_2246.field_9997) || state.method_27852(class_2246.field_10070), () -> LocationUtils.isOnGlaciteTunnelsLocation() || LocationUtils.isOn(Island.MINESHAFT), BlockType.GEMSTONE),
    PERIDOT(state -> state.method_27852(class_2246.field_10357) || state.method_27852(class_2246.field_10419), () -> LocationUtils.isOnGlaciteTunnelsLocation() || LocationUtils.isOn(Island.MINESHAFT), BlockType.GEMSTONE),
    LOW_TIER_MITHRIL(state -> state.method_27852(class_2246.field_10423) || state.method_27852(class_2246.field_10235), () -> LocationUtils.isOn(Island.DWARVEN_MINES, Island.MINESHAFT), BlockType.DWARVEN_METAL),
    MID_TIER_MITHRIL(state -> state.method_27852(class_2246.field_10135) || state.method_27852(class_2246.field_10006) || state.method_27852(class_2246.field_10297), () -> LocationUtils.isOn(Island.DWARVEN_MINES, Island.CRYSTAL_HOLLOWS, Island.MINESHAFT), BlockType.DWARVEN_METAL),
    HIGH_TIER_MITHRIL(state -> state.method_27852(class_2246.field_10294), () -> LocationUtils.isOn(Island.DWARVEN_MINES, Island.CRYSTAL_HOLLOWS, Island.MINESHAFT), BlockType.DWARVEN_METAL),
    TITANIUM(state -> state.method_27852(class_2246.field_10346), () -> LocationUtils.isOn(Island.DWARVEN_MINES, Island.MINESHAFT), BlockType.DWARVEN_METAL),
    LOW_TIER_UMBER(state -> state.method_27852(class_2246.field_10415) || state.method_27852(class_2246.field_10123), () -> LocationUtils.isOnGlaciteTunnelsLocation() || LocationUtils.isOn(Island.MINESHAFT), BlockType.DWARVEN_METAL),
    HIGH_TIER_UMBER(state -> state.method_27852(class_2246.field_10483), () -> LocationUtils.isOnGlaciteTunnelsLocation() || LocationUtils.isOn(Island.MINESHAFT), BlockType.DWARVEN_METAL),
    LOW_TIER_TUNGSTEN_GLACITE(state -> state.method_27852(class_2246.field_10492), LocationUtils::isOnGlaciteTunnelsLocation, BlockType.DWARVEN_METAL),
    LOW_TIER_TUNGSTEN_MINESHAFT(SkyblockOre::isLowTierTungstenMineshaft, () -> LocationUtils.isOn(Island.MINESHAFT), BlockType.DWARVEN_METAL),
    HIGH_TIER_TUNGSTEN(state -> state.method_27852(class_2246.field_10460), () -> LocationUtils.isOnGlaciteTunnelsLocation() || LocationUtils.isOn(Island.MINESHAFT), BlockType.DWARVEN_METAL),
    GLACITE(state -> state.method_27852(class_2246.field_10225), () -> LocationUtils.isOnGlaciteTunnelsLocation() || LocationUtils.isOn(Island.MINESHAFT), BlockType.DWARVEN_METAL);

    private final Function<class_2680, Boolean> checkBlock;
    private final Supplier<Boolean> checkArea;
    private final BlockType blockType;
    private static final ObjectOpenHashSet<class_2248> HOLLOWS_HARD_STONE_BLOCKS;

    private SkyblockOre(Function<class_2680, Boolean> checkBlock, Supplier<Boolean> checkArea, BlockType blockType) {
        this.checkBlock = checkBlock;
        this.checkArea = checkArea;
        this.blockType = blockType;
    }

    public static SkyblockOre getByStateOrNull(class_2680 state) {
        for (SkyblockOre ore : SkyblockOre.values()) {
            if (!ore.checkArea.get().booleanValue() || !ore.checkBlock.apply(state).booleanValue()) continue;
            return ore;
        }
        return null;
    }

    private static boolean isHardStoneHollows(class_2680 state) {
        return HOLLOWS_HARD_STONE_BLOCKS.contains((Object)state.method_26204());
    }

    private static boolean isLowTierTungstenMineshaft(class_2680 state) {
        if (state.method_27852(class_2246.field_10445)) {
            return true;
        }
        if (state.method_27852(class_2246.field_10596)) {
            return SkyblockAddons.getInstance().getUtils().getMineshaftID().startsWith("TUNG");
        }
        if (state.method_27852(class_2246.field_10351)) {
            return SkyblockAddons.getInstance().getUtils().getMineshaftID().startsWith("TUNG");
        }
        return false;
    }

    @Generated
    public BlockType getBlockType() {
        return this.blockType;
    }

    static {
        HOLLOWS_HARD_STONE_BLOCKS = ObjectOpenHashSet.of((Object[])new class_2248[]{class_2246.field_10423, class_2246.field_10170, class_2246.field_10235, class_2246.field_10123, class_2246.field_10349, class_2246.field_10626, class_2246.field_10014, class_2246.field_10526, class_2246.field_10409, class_2246.field_10328, class_2246.field_10590, class_2246.field_10460, class_2246.field_10056, class_2246.field_10340, class_2246.field_10474, class_2246.field_10508, class_2246.field_10115, class_2246.field_10289, class_2246.field_10346, class_2246.field_10093});
    }

    public static enum BlockType {
        ORE,
        BLOCK,
        DWARVEN_METAL,
        GEMSTONE;

    }
}

