/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.core;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.Language;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.minecraft.class_310;

public class Translations {
    private static JsonObject languageJson = new JsonObject();
    private static JsonObject defaultLangJson = null;
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("%[A-Za-z-]+%");

    public static String getMessage(String path, Object ... variables) {
        SkyblockAddons main = SkyblockAddons.getInstance();
        JsonObject langJson = null;
        if (main.getConfigValuesManager() != null) {
            langJson = languageJson;
        }
        if (langJson == null) {
            return path;
        }
        String text = Translations.getString(langJson, path);
        if (text.isEmpty()) {
            text = Translations.getString(defaultLangJson, path);
        }
        Matcher matcher = VARIABLE_PATTERN.matcher(text);
        ArrayDeque<Object> variablesDeque = new ArrayDeque<Object>(Arrays.asList(variables));
        while (matcher.find() && !variablesDeque.isEmpty()) {
            text = matcher.replaceFirst(Matcher.quoteReplacement(variablesDeque.pollFirst().toString()));
            matcher = VARIABLE_PATTERN.matcher(text);
        }
        Language currentLanguage = (Language)Feature.LANGUAGE.getValue();
        if (!(currentLanguage != Language.HEBREW && currentLanguage != Language.ARABIC || class_310.method_1551().field_1772.method_1726())) {
            text = class_310.method_1551().field_1772.method_1721(text);
        }
        return text;
    }

    private static String getString(JsonObject langJson, String path) {
        String[] pathSplit;
        if (langJson == null) {
            return "";
        }
        for (String pathPart : pathSplit = path.split(Pattern.quote("."))) {
            if (pathPart.isEmpty()) continue;
            JsonElement jsonElement = langJson.get(pathPart);
            if (jsonElement == null) {
                return "";
            }
            if (jsonElement.isJsonObject()) {
                langJson = langJson.getAsJsonObject(pathPart);
                continue;
            }
            return langJson.get(path.substring(path.lastIndexOf(pathPart))).getAsString();
        }
        return "";
    }

    private static String bidiReorder(String text) {
        try {
            Bidi bidi = new Bidi(new ArabicShaping(8).shape(text), 127);
            bidi.setReorderingMode(0);
            return bidi.writeReordered(2);
        }
        catch (ArabicShapingException ex) {
            return text;
        }
    }

    @Generated
    public static JsonObject getLanguageJson() {
        return languageJson;
    }

    @Generated
    public static void setLanguageJson(JsonObject languageJson) {
        Translations.languageJson = languageJson;
    }

    @Generated
    public static void setDefaultLangJson(JsonObject defaultLangJson) {
        Translations.defaultLangJson = defaultLangJson;
    }
}

