/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.core.feature;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.config.ConfigValuesManager;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.SkyblockKeyBinding;
import com.fix3dll.skyblockaddons.core.Translations;
import com.fix3dll.skyblockaddons.core.feature.FeatureData;
import com.fix3dll.skyblockaddons.core.feature.FeatureGuiData;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.core.render.chroma.ManualChromaManager;
import com.fix3dll.skyblockaddons.mixin.hooks.FontHook;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import com.fix3dll.skyblockaddons.utils.data.skyblockdata.OnlineData;
import com.fix3dll.skyblockaddons.utils.objects.Pair;
import com.fix3dll.skyblockaddons.utils.objects.RegistrableEnum;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeMap;
import lombok.Generated;
import lombok.NonNull;
import net.minecraft.class_1041;
import net.minecraft.class_310;
import net.minecraft.class_9848;
import org.apache.logging.log4j.Logger;

public enum Feature {
    DROP_CONFIRMATION(1, "settings.itemDropConfirmation", new FeatureGuiData(ColorCode.RED)),
    SHOW_BACKPACK_PREVIEW(3, "settings.showBackpackPreview", null),
    HIDE_BONES(4, "settings.hideSkeletonHatBones", null),
    SKELETON_BAR(5, "settings.skeletonHatBonesBar", new FeatureGuiData(EnumUtils.DrawType.SKELETON_BAR)),
    HIDE_FOOD_ARMOR_BAR(6, "settings.hideFoodAndArmor", null),
    FULL_INVENTORY_WARNING(7, "settings.fullInventoryWarning", new FeatureGuiData(ColorCode.RED)),
    SHOW_REFORGE_OVERLAY(10, "settings.showReforgeOverlay", null),
    MINION_STOP_WARNING(11, "settings.minionStopWarning", new FeatureGuiData(ColorCode.RED)),
    HIDE_HEALTH_BAR(13, "settings.hideHealthBar", null),
    MINION_FULL_WARNING(15, "settings.fullMinionWarning", new FeatureGuiData(ColorCode.RED)),
    MANA_BAR(19, "settings.manaBar", new FeatureGuiData(EnumUtils.DrawType.BAR, ColorCode.AQUA)),
    MANA_TEXT(20, "settings.manaNumber", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.AQUA)),
    HEALTH_BAR(21, "settings.healthBar", new FeatureGuiData(EnumUtils.DrawType.BAR, ColorCode.RED)),
    HEALTH_TEXT(22, "settings.healthNumber", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.RED)),
    DEFENCE_ICON(23, "settings.defenseIcon", new FeatureGuiData(EnumUtils.DrawType.DEFENCE_ICON)),
    DEFENCE_TEXT(24, "settings.defenseNumber", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.GREEN)),
    DEFENCE_PERCENTAGE(25, "settings.defensePercentage", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.GREEN)),
    HEALTH_UPDATES(26, "settings.healthUpdates", new FeatureGuiData(EnumUtils.DrawType.TEXT)),
    HIDE_PLAYERS_IN_LOBBY(27, "settings.hidePlayersInLobby", null),
    DARK_AUCTION_TIMER(28, "settings.darkAuctionTimer", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.GOLD)),
    ITEM_PICKUP_LOG(29, "settings.itemPickupLog", new FeatureGuiData(EnumUtils.DrawType.PICKUP_LOG)),
    DONT_RESET_CURSOR_INVENTORY(37, "settings.dontResetCursorInventory", null),
    LOCK_SLOTS(38, "settings.lockSlots", null),
    SUMMONING_EYE_ALERT(39, "settings.summoningEyeAlert", new FeatureGuiData(ColorCode.RED)),
    MAKE_ENDERCHESTS_GREEN_IN_END(40, "settings.makeEnderchestsInEndGreen", new FeatureGuiData(ColorCode.GREEN)),
    STOP_DROPPING_SELLING_RARE_ITEMS(42, "settings.stopDroppingSellingRareItems", new FeatureGuiData(ColorCode.RED)),
    REPLACE_ROMAN_NUMERALS_WITH_NUMBERS(45, "settings.replaceRomanNumeralsWithNumbers", null),
    MINION_DISABLE_LOCATION_WARNING(50, "settings.disableMinionLocationWarning", null),
    ENCHANTMENT_LORE_PARSING(52, "settings.enchantmentLoreParsing", null),
    SHOW_ITEM_COOLDOWNS(53, "settings.showItemCooldowns", null),
    SKILL_DISPLAY(54, "settings.collectionDisplay", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.AQUA)),
    SPEED_PERCENTAGE(55, "settings.speedPercentage", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.WHITE)),
    SLAYER_ARMOR_PROGRESS(57, "settings.revenantIndicator", new FeatureGuiData(EnumUtils.DrawType.SLAYER_ARMOR_PROGRESS, ColorCode.AQUA)),
    SPECIAL_ZEALOT_ALERT(58, "settings.specialZealotAlert", new FeatureGuiData(ColorCode.RED)),
    ENABLE_MESSAGE_WHEN_MINING_DEEP_CAVERNS(60, null),
    ENABLE_MESSAGE_WHEN_BREAKING_STEMS(61, null),
    ENABLE_MESSAGE_WHEN_MINING_NETHER(62, null),
    HIDE_PET_HEALTH_BAR(63, "settings.hidePetHealthBar", null),
    DISABLE_MAGICAL_SOUP_MESSAGES(64, "settings.disableMagicalSoupMessage", null),
    DEPLOYABLE_STATUS_DISPLAY(65, "settings.deployableDisplay", new FeatureGuiData(EnumUtils.DrawType.DEPLOYABLE_DISPLAY, null)),
    ZEALOT_COUNTER(66, "settings.zealotCounter", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.DARK_AQUA)),
    TICKER_CHARGES_DISPLAY(67, "settings.tickerChargesDisplay", new FeatureGuiData(EnumUtils.DrawType.TICKER, null)),
    NO_ARROWS_LEFT_ALERT(69, "settings.noArrowsLeftAlert", null),
    SBA_BUTTON_IN_PAUSE_MENU(76, "settings.skyblockAddonsButtonInPauseMenu", null),
    SHOW_TOTAL_ZEALOT_COUNT(77, "settings.showTotalZealotCount", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.DARK_AQUA)),
    SHOW_SUMMONING_EYE_COUNT(78, "settings.showSummoningEyeCount", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.DARK_AQUA)),
    SHOW_AVERAGE_ZEALOTS_PER_EYE(79, "settings.showZealotsPerEye", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.DARK_AQUA)),
    TURN_BOW_COLOR_WHEN_USING_ARROW_POISON(80, "settings.turnBowGreenWhenUsingToxicArrowPoison", null),
    BIRCH_PARK_RAINMAKER_TIMER(81, "settings.birchParkRainmakerTimer", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.DARK_AQUA)),
    DISCORD_RPC(83, "settings.discordRP", null),
    ENDSTONE_PROTECTOR_DISPLAY(84, "settings.endstoneProtectorDisplay", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.WHITE)),
    FANCY_WARP_MENU(85, "settings.fancyWarpMenu", null),
    LEGENDARY_SEA_CREATURE_WARNING(88, "settings.legendarySeaCreatureWarning", new FeatureGuiData(ColorCode.RED)),
    ENABLE_MESSAGE_WHEN_BREAKING_PARK(90, null),
    BOSS_APPROACH_ALERT(91, "settings.bossApproachAlert", null),
    DISABLE_TELEPORT_PAD_MESSAGES(92, "settings.disableTeleportPadMessages", null),
    BAIT_LIST(93, "settings.baitListDisplay", new FeatureGuiData(EnumUtils.DrawType.BAIT_LIST_DISPLAY, ColorCode.AQUA)),
    ZEALOT_COUNTER_EXPLOSIVE_BOW_SUPPORT(94, "settings.zealotCounterExplosiveBow", null),
    DISABLE_ENDERMAN_TELEPORTATION_EFFECT(95, "settings.disableEndermanTeleportation", null),
    CHANGE_ZEALOT_COLOR(96, "settings.changeZealotColor", new FeatureGuiData(ColorCode.LIGHT_PURPLE)),
    HIDE_SVEN_PUP_NAMETAGS(97, "settings.hideSvenPupNametags", null),
    DUNGEONS_MAP_DISPLAY(99, "settings.dungeonMapDisplay", new FeatureGuiData(EnumUtils.DrawType.DUNGEONS_MAP, ColorCode.BLACK)),
    MAKE_DROPPED_ITEMS_GLOW(102, "settings.glowingDroppedItems", null),
    SHOW_BASE_STAT_BOOST_PERCENTAGE(104, "settings.baseStatBoostPercentage", new FeatureGuiData(ColorCode.RED)),
    SHOW_HEALING_CIRCLE_WALL(107, "settings.showHealingCircleWall", new FeatureGuiData(ColorCode.GREEN)),
    SHOW_CRITICAL_DUNGEONS_TEAMMATES(108, "settings.showCriticalTeammates", null),
    SHOW_ITEM_DUNGEON_FLOOR(110, "settings.showItemDungeonFloor", new FeatureGuiData(ColorCode.RED)),
    SHOW_DUNGEON_MILESTONE(111, "settings.showDungeonMilestone", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.YELLOW)),
    DUNGEONS_COLLECTED_ESSENCES_DISPLAY(112, "settings.dungeonsCollectedEssencesDisplay", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.YELLOW)),
    STOP_BONZO_STAFF_SOUNDS(113, "settings.stopBonzoStaffSounds", null),
    REVENANT_SLAYER_TRACKER(116, "settings.revenantSlayerTracker", new FeatureGuiData(EnumUtils.DrawType.SLAYER_TRACKERS, ColorCode.WHITE)),
    TARANTULA_SLAYER_TRACKER(117, "settings.tarantulaSlayerTracker", new FeatureGuiData(EnumUtils.DrawType.SLAYER_TRACKERS, ColorCode.WHITE)),
    SVEN_SLAYER_TRACKER(118, "settings.svenSlayerTracker", new FeatureGuiData(EnumUtils.DrawType.SLAYER_TRACKERS, ColorCode.WHITE)),
    DRAGON_STATS_TRACKER(125, "settings.dragonStatsTracker", new FeatureGuiData(EnumUtils.DrawType.DRAGON_STATS_TRACKER, ColorCode.WHITE)),
    DUNGEON_DEATH_COUNTER(136, "settings.dungeonDeathCounter", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.RED)),
    ROCK_PET_TRACKER(138, "settings.rockPetTracker", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.GRAY)),
    DOLPHIN_PET_TRACKER(139, "settings.dolphinPetTracker", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.AQUA)),
    SHOW_DUNGEON_TEAMMATE_NAME_OVERLAY(140, "settings.dungeonsTeammateNameOverlay", null),
    SHOW_STACKING_ENCHANT_PROGRESS(141, "settings.stackingEnchantProgress", new FeatureGuiData(ColorCode.RED)),
    DUNGEONS_SECRETS_DISPLAY(142, "settings.dungeonsSecretsDisplay", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.GRAY)),
    SKILL_PROGRESS_BAR(143, "settings.skillProgressBar", new FeatureGuiData(EnumUtils.DrawType.BAR, ColorCode.GREEN)),
    DISABLE_MORT_MESSAGES(147, "settings.disableMortMessages", null),
    DISABLE_BOSS_MESSAGES(148, "settings.disableBossMessages", null),
    SHOW_SWORD_KILLS(149, "settings.showSwordKills", new FeatureGuiData(ColorCode.RED)),
    HIDE_OTHER_PLAYERS_PRESENTS(150, "settings.hideOtherPlayersPresents", null),
    COMPACT_TAB_LIST(152, "settings.compactTabList", null),
    CANDY_POINTS_COUNTER(155, "settings.candyPointsCounter", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.GOLD)),
    SHOW_EXPERIMENTATION_TABLE_TOOLTIPS(158, "settings.showExperimentationTableTooltips", null),
    DRILL_FUEL_BAR(160, "settings.drillFuelBar", new FeatureGuiData(EnumUtils.DrawType.BAR, ColorCode.DARK_GREEN)),
    DRILL_FUEL_TEXT(161, "settings.drillFuelNumber", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.DARK_GREEN)),
    REFORGE_FILTER(172, "settings.reforgeFilter", null),
    TREVOR_THE_TRAPPER_FEATURES(177, "settings.trevorTheTrapper.title", new FeatureGuiData(EnumUtils.DrawType.PROXIMITY_INDICATOR)),
    FETCHUR_TODAY(178, "settings.fetchurToday", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.GREEN)),
    STOP_RAT_SOUNDS(183, "settings.stopRatSounds", null),
    VOIDGLOOM_SLAYER_TRACKER(186, "settings.voidgloomSlayerTracker", new FeatureGuiData(EnumUtils.DrawType.SLAYER_TRACKERS, ColorCode.WHITE)),
    HIDE_PLAYERS_NEAR_NPCS(190, "settings.hidePlayersNearNPCs", null),
    OVERFLOW_MANA(191, "settings.showOverflowManaNumber", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.DARK_AQUA)),
    DISABLE_EMPTY_GLASS_PANES(195, "settings.hideMenuGlassPanes", null),
    ENTITY_OUTLINES(196, "settings.entityOutlines", null),
    EFFECTIVE_HEALTH_TEXT(197, "settings.effectiveHealthNumber", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.DARK_GREEN)),
    OTHER_DEFENCE_STATS(199, "settings.otherDefenseStats", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.GREEN)),
    PREVENT_MOVEMENT_ON_DEATH(200, "settings.preventMovementOnDeath", null),
    HIDE_SPAWN_POINT_PLAYERS(201, "settings.hideSpawnPointPlayers", null),
    SPIRIT_SCEPTRE_DISPLAY(202, "settings.showSpiritSceptreDisplay", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.GRAY)),
    FARM_EVENT_TIMER(204, "settings.jacobsContestTimer", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.GOLD)),
    OUTBID_ALERT_SOUND(206, "settings.outbidAlertSound", null),
    BROOD_MOTHER_ALERT(207, "settings.broodMotherWarning", null),
    BAL_BOSS_ALERT(208, "settings.balBossWarning", null),
    BACKPACK_OPENING_SOUND(211, "settings.backpackOpeningSound", null),
    DEVELOPER_MODE(212, "settings.devMode", null),
    SHOW_SKYBLOCK_ITEM_ID(213, "settings.showSkyblockItemId", null),
    PLAYER_SYMBOLS_IN_CHAT(216, "settings.showPlayerSymbolsInChat", null),
    CRIMSON_ARMOR_ABILITY_STACKS(217, "settings.crimsonArmorAbilityStacks", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.GOLD)),
    HIDE_TRUE_DEFENSE(218, "settings.hideTrueDefense", new FeatureGuiData(ColorCode.RED)),
    INFERNO_SLAYER_TRACKER(223, "settings.infernoSlayerTracker", new FeatureGuiData(EnumUtils.DrawType.SLAYER_TRACKERS, ColorCode.WHITE)),
    RIFTSTALKER_SLAYER_TRACKER(228, "settings.riftstalkerSlayerTracker", new FeatureGuiData(EnumUtils.DrawType.SLAYER_TRACKERS, ColorCode.WHITE)),
    FIRE_FREEZE_TIMER(238, "settings.fireFreezeTimer", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.YELLOW)),
    HIDE_HAUNTED_SKULLS(241, "settings.hideHauntedSkulls", null),
    THUNDER_BOTTLE_DISPLAY(242, "settings.thunderBottleDisplay", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.DARK_PURPLE)),
    PET_DISPLAY(246, "settings.petDisplay", new FeatureGuiData(EnumUtils.DrawType.PET_DISPLAY, ColorCode.GOLD)),
    PRESSURE_BAR(260, "settings.pressureBar.title", new FeatureGuiData(EnumUtils.DrawType.BAR, ColorCode.BLUE)),
    PRESSURE_TEXT(261, "settings.pressureText.title", new FeatureGuiData(EnumUtils.DrawType.TEXT, ColorCode.BLUE)),
    HIDE_EFFECTS_HUD(262, "settings.hideEffectsHud", null),
    EQUIPMENTS_IN_INVENTORY(263, "settings.equipmentsInInventory.title", new FeatureGuiData(ColorCode.WHITE)),
    COLORED_FISHING_PARTICLES(264, "settings.coloredFishingParticles.title", new FeatureGuiData(ColorCode.WHITE)),
    WARNING_TIME(-2, "settings.warningDuration"),
    LANGUAGE(-3, "language"),
    EDIT_LOCATIONS(-4, "settings.editLocations"),
    RESET_LOCATION(-5, "settings.resetLocations"),
    RESCALE_FEATURES(-6, "messages.rescaleFeatures"),
    GENERAL_SETTINGS(-7, "settings.tab.generalSettings"),
    TEXT_STYLE(-8, "settings.textStyle"),
    CHROMA_SPEED(-9, "settings.chromaSpeed"),
    CHROMA_MODE(-10, "settings.chromaMode"),
    CHROMA_SIZE(-11, "settings.chromaSize"),
    CHROMA_SATURATION(-12, "settings.chromaSaturation"),
    CHROMA_BRIGHTNESS(-13, "settings.chromaBrightness"),
    TURN_ALL_FEATURES_CHROMA(-14, "settings.turnAllFeaturesChroma"),
    NUMBER_SEPARATORS(221, "settings.numberSeparators"),
    TURN_ALL_TEXTS_CHROMA(243, "settings.turnAllTextsChroma"),
    ENABLE_FEATURE_SNAPPING(254, "messages.enableFeatureSnapping"),
    SHOW_COLOR_ICONS(256, "messages.showColorIcons"),
    AUTO_UPDATE(257, "settings.autoUpdate.title"),
    FULL_AUTO_UPDATE(258, "settings.fullAutoUpdate"),
    CHAT_MESSAGE_COPYING(259, "settings.chatMessageCopying");

    private static final LinkedHashSet<Feature> guiFeatures;
    private static final LinkedHashSet<Feature> generalTabFeatures;
    private static final LinkedHashSet<Feature> editGuiFeatures;
    private static final Logger LOGGER;
    private static final int ID_AT_PREVIOUS_UPDATE = 221;
    private final int id;
    private final FeatureGuiData featureGuiData;
    private final FeatureData<?> featureData;
    private final String translationKey;
    private static final String VERSION_X_Y_Z;

    private Feature(int id, String translationKey) {
        this(id, translationKey, null);
    }

    private Feature(int id, String translationKey, FeatureGuiData featureGuiData) {
        this.id = id;
        this.translationKey = translationKey;
        this.featureGuiData = featureGuiData;
        HashSet<Integer> registeredFeatureIDs = SkyblockAddons.getInstance().getRegisteredFeatureIDs();
        if (id != -1 && registeredFeatureIDs.contains(id)) {
            throw new RuntimeException("Multiple features have the same IDs!");
        }
        registeredFeatureIDs.add(id);
        this.featureData = new FeatureData(featureGuiData);
    }

    public void onToggle(boolean enabled) {
        if (this == DEVELOPER_MODE) {
            if (enabled) {
                SkyblockKeyBinding.DEVELOPER_COPY_NBT.register(class_310.method_1551().field_1690);
            } else {
                SkyblockKeyBinding.DEVELOPER_COPY_NBT.deRegister();
            }
        }
        if (this == TURN_ALL_TEXTS_CHROMA) {
            FontHook.setAllTextChroma(enabled);
        }
    }

    public void setEnabled(boolean enabled) {
        ConfigValuesManager cvm = SkyblockAddons.getInstance().getConfigValuesManager();
        Object value = this.getValue();
        if (!(value instanceof Boolean)) {
            cvm.restoreFeatureDefaultValue(this);
            throw new IllegalStateException(String.valueOf((Object)this) + " value is not a boolean! Type: " + String.valueOf(value));
        }
        this.setValue(enabled);
        this.onToggle(enabled);
        cvm.saveConfig();
    }

    public boolean isActualFeature() {
        return this.id != -1 && this.getMessage(new String[0]) != null;
    }

    public String getMessage(String ... variables) {
        if (this.translationKey != null) {
            return Translations.getMessage(this.translationKey, variables);
        }
        return null;
    }

    public static Feature fromId(int id) {
        for (Feature feature : Feature.values()) {
            if (feature.getId() != id) continue;
            return feature;
        }
        return null;
    }

    public boolean isGuiFeature() {
        return this.featureGuiData != null;
    }

    public static LinkedHashSet<Feature> getGuiFeatures() {
        if (guiFeatures.isEmpty()) {
            for (Feature feature : Feature.values()) {
                if (feature.featureGuiData == null) continue;
                guiFeatures.add(feature);
            }
        }
        return guiFeatures;
    }

    public boolean isColorFeature() {
        return this.isGuiFeature() && this.featureGuiData.getDefaultColor() != null;
    }

    public boolean couldBeXAllignment() {
        if (!this.isGuiFeature() || this.featureGuiData.getDrawType() == null) {
            return false;
        }
        return switch (this.featureGuiData.getDrawType()) {
            case EnumUtils.DrawType.TEXT, EnumUtils.DrawType.SLAYER_ARMOR_PROGRESS, EnumUtils.DrawType.DEPLOYABLE_DISPLAY, EnumUtils.DrawType.BAIT_LIST_DISPLAY, EnumUtils.DrawType.SLAYER_TRACKERS, EnumUtils.DrawType.DRAGON_STATS_TRACKER, EnumUtils.DrawType.PET_DISPLAY -> true;
            default -> false;
        };
    }

    public ColorCode getDefaultColor() {
        if (this.featureGuiData != null) {
            return this.featureGuiData.getDefaultColor();
        }
        return null;
    }

    public boolean isNew() {
        return this.id > 221;
    }

    public boolean isEnabled() {
        Object value = this.getValue();
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return bool != false && !this.isRemoteDisabled();
        }
        SkyblockAddons.getInstance().getConfigValuesManager().restoreFeatureDefaultValue(this);
        throw new IllegalStateException(String.valueOf((Object)this) + " is not a boolean! Type: " + String.valueOf(value));
    }

    public boolean isDisabled() {
        return !this.isEnabled();
    }

    public boolean isRemoteDisabled() {
        OnlineData onlineData = SkyblockAddons.getInstance().getOnlineData();
        if (onlineData == null) {
            return false;
        }
        HashMap<String, List<Integer>> disabledFeatures = onlineData.getDisabledFeatures();
        if (disabledFeatures.containsKey("all")) {
            List<Integer> allList = disabledFeatures.get("all");
            if (allList != null && allList.contains(this.getId())) {
                return true;
            }
            if (allList == null) {
                LOGGER.error("\"all\" key in disabled features map has value of null. Please fix online data.");
            }
        }
        if (disabledFeatures.containsKey(VERSION_X_Y_Z)) {
            List<Integer> versionList = disabledFeatures.get(VERSION_X_Y_Z);
            if (versionList != null && versionList.contains(this.getId())) {
                return true;
            }
            if (versionList == null) {
                LOGGER.error("\"{}\" key in disabled features map has value of null. Please fix online data.", (Object)VERSION_X_Y_Z);
            }
        }
        return false;
    }

    public Object getValue() {
        return this.featureData.getValue();
    }

    public Number numberValue() {
        Object value = this.getValue();
        if (value instanceof Number) {
            Number number = (Number)value;
            return number;
        }
        SkyblockAddons.getInstance().getConfigValuesManager().restoreFeatureDefaultValue(this);
        throw new IllegalStateException(String.valueOf((Object)this) + " value is not a number!");
    }

    public void setValue(Object value) {
        if (!FeatureData.isValidValue(value)) {
            SkyblockAddons.getInstance().getConfigValuesManager().restoreFeatureDefaultValue(this);
            throw new IllegalArgumentException(String.valueOf(value) + " is not valid for '" + String.valueOf((Object)this) + "'!");
        }
        this.featureData.setValue(value);
    }

    public EnumUtils.AnchorPoint getAnchorPoint() {
        EnumUtils.AnchorPoint anchorPoints = this.featureData.getAnchorPoint();
        if (anchorPoints != null) {
            return anchorPoints;
        }
        anchorPoints = ConfigValuesManager.DEFAULT_FEATURE_DATA.get((Object)this).getAnchorPoint();
        return anchorPoints == null ? EnumUtils.AnchorPoint.BOTTOM_MIDDLE : anchorPoints;
    }

    public void setClosestAnchorPoint() {
        float x1 = this.getActualX();
        float y1 = this.getActualY();
        class_1041 window = class_310.method_1551().method_22683();
        int maxX = window.method_4486();
        int maxY = window.method_4502();
        double shortestDistance = -1.0;
        EnumUtils.AnchorPoint closestAnchorPoint = EnumUtils.AnchorPoint.BOTTOM_MIDDLE;
        for (EnumUtils.AnchorPoint point : EnumUtils.AnchorPoint.values()) {
            double distance = Point2D.distance(x1, y1, point.getX(maxX), point.getY(maxY));
            if (shortestDistance != -1.0 && !(distance < shortestDistance)) continue;
            closestAnchorPoint = point;
            shortestDistance = distance;
        }
        if (this.getAnchorPoint() == closestAnchorPoint) {
            return;
        }
        float targetX = this.getActualX();
        float targetY = this.getActualY();
        float x = targetX - (float)closestAnchorPoint.getX(maxX);
        float y = targetY - (float)closestAnchorPoint.getY(maxY);
        this.featureData.setAnchorPoint(closestAnchorPoint);
        this.featureData.setCoords(x, y);
    }

    public float getActualX() {
        int maxX = class_310.method_1551().method_22683().method_4486();
        return (float)this.getAnchorPoint().getX(maxX) + this.getRelativeCoords().getLeft().floatValue();
    }

    public float getActualY() {
        int maxY = class_310.method_1551().method_22683().method_4502();
        return (float)this.getAnchorPoint().getY(maxY) + this.getRelativeCoords().getRight().floatValue();
    }

    public Pair<Float, Float> getRelativeCoords() {
        Pair<Float, Float> coords = this.featureData.getCoords();
        if (coords != null) {
            return coords;
        }
        SkyblockAddons.getInstance().getConfigValuesManager().putDefaultCoordinates(this);
        coords = this.featureData.getCoords();
        return coords == null ? new Pair<Float, Float>(Float.valueOf(0.0f), Float.valueOf(0.0f)) : coords;
    }

    public float getGuiScale() {
        return this.featureData.getGuiScale();
    }

    public void setGuiScale(float scale) {
        this.featureData.setGuiScale(Math.max(Math.min(scale, 5.0f), 0.5f));
    }

    public int getColor() {
        int color = this.featureData.getColor();
        if (this.isChroma()) {
            return ManualChromaManager.getChromaColor(0.0f, 0.0f, class_9848.method_61320((int)color));
        }
        return color;
    }

    public int getColor(int alpha) {
        int color = this.featureData.getColor();
        if (this.isChroma()) {
            return ManualChromaManager.getChromaColor(0.0f, 0.0f, alpha);
        }
        return class_9848.method_61330((int)alpha, (int)color);
    }

    public void setColor(int color) {
        this.featureData.setColor(color);
    }

    public ColorCode getRestrictedColor() {
        int featureColor = this.getColor();
        for (ColorCode colorCode : ColorCode.values()) {
            if (!colorCode.isColor() || colorCode.getColor() != featureColor) continue;
            return colorCode;
        }
        return this.getDefaultColor();
    }

    public boolean isChroma() {
        return this.featureData.isChroma();
    }

    public void setChroma(boolean chroma) {
        this.featureData.setChroma(chroma);
    }

    public boolean hasSettings() {
        return this.featureData.hasSettings();
    }

    public int settingsSize() {
        return this.hasSettings() ? this.featureData.getSettings().size() : 0;
    }

    public boolean isEnabled(FeatureSetting setting) {
        if (this.isDisabled()) {
            return false;
        }
        return Boolean.TRUE.equals(this.get(setting));
    }

    public boolean isDisabled(FeatureSetting setting) {
        return !this.isEnabled(setting);
    }

    @NonNull
    public Number getAsNumber(FeatureSetting setting) {
        Object value = this.get(setting);
        if (value instanceof Number) {
            Number number = (Number)value;
            return number;
        }
        SkyblockAddons.getInstance().getConfigValuesManager().setSettingToDefault(setting);
        throw new IllegalArgumentException("Setting " + String.valueOf((Object)setting) + " is not a number. Type: " + String.valueOf(value));
    }

    @NonNull
    public RegistrableEnum getAsEnum(FeatureSetting setting) {
        Object value = this.get(setting);
        if (value instanceof RegistrableEnum) {
            RegistrableEnum registrableEnum = (RegistrableEnum)value;
            return registrableEnum;
        }
        SkyblockAddons.getInstance().getConfigValuesManager().setSettingToDefault(setting);
        throw new IllegalArgumentException("Setting " + String.valueOf((Object)setting) + " is not a RegistrableEnum. Type: " + String.valueOf(value));
    }

    @NonNull
    public String getAsString(FeatureSetting setting) {
        Object value = this.get(setting);
        if (value instanceof String) {
            String string = (String)value;
            return string;
        }
        SkyblockAddons.getInstance().getConfigValuesManager().setSettingToDefault(setting);
        throw new IllegalArgumentException("Setting " + String.valueOf((Object)setting) + " is not a string. Type: " + String.valueOf(value));
    }

    @NonNull
    public Object get(FeatureSetting setting) {
        if (setting.getRelatedFeature() != this && !setting.isUniversal()) {
            throw new IllegalArgumentException(String.valueOf((Object)setting.getRelatedFeature()) + " is not related to " + String.valueOf((Object)this));
        }
        if (!this.hasSettings()) {
            if (setting.isUniversal()) {
                this.featureData.setSettings(new TreeMap<FeatureSetting, Object>());
            } else {
                SkyblockAddons.getInstance().getConfigValuesManager().setSettingToDefault(setting);
            }
        }
        return this.featureData.getSettings().get((Object)setting);
    }

    public <T> void set(FeatureSetting setting, T value) {
        if (setting.getRelatedFeature() != this && !setting.isUniversal()) {
            throw new IllegalArgumentException(String.valueOf((Object)setting.getRelatedFeature()) + " is not related to " + String.valueOf((Object)this));
        }
        this.featureData.setSetting(setting, value);
    }

    public boolean has(@NonNull FeatureSetting setting) {
        if (setting == null) {
            throw new NullPointerException("setting is marked non-null but is null");
        }
        if (this.featureData.getSettings() == null) {
            return false;
        }
        return this.featureData.getSettings().containsKey((Object)setting);
    }

    @Generated
    public int getId() {
        return this.id;
    }

    @Generated
    public FeatureGuiData getFeatureGuiData() {
        return this.featureGuiData;
    }

    @Generated
    public FeatureData<?> getFeatureData() {
        return this.featureData;
    }

    @Generated
    public String getTranslationKey() {
        return this.translationKey;
    }

    @Generated
    public static LinkedHashSet<Feature> getGeneralTabFeatures() {
        return generalTabFeatures;
    }

    @Generated
    public static LinkedHashSet<Feature> getEditGuiFeatures() {
        return editGuiFeatures;
    }

    static {
        guiFeatures = new LinkedHashSet();
        generalTabFeatures = new LinkedHashSet<Feature>(Arrays.asList(TEXT_STYLE, WARNING_TIME, CHROMA_SPEED, CHROMA_MODE, CHROMA_SIZE, TURN_ALL_FEATURES_CHROMA, CHROMA_SATURATION, CHROMA_BRIGHTNESS, NUMBER_SEPARATORS, DEVELOPER_MODE, TURN_ALL_TEXTS_CHROMA, SBA_BUTTON_IN_PAUSE_MENU, AUTO_UPDATE, FULL_AUTO_UPDATE, CHAT_MESSAGE_COPYING));
        editGuiFeatures = new LinkedHashSet<Feature>(Arrays.asList(RESET_LOCATION, RESCALE_FEATURES, SHOW_COLOR_ICONS, ENABLE_FEATURE_SNAPPING));
        LOGGER = SkyblockAddons.getLogger();
        VERSION_X_Y_Z = SkyblockAddons.METADATA.getVersion().toString().split("-")[0];
    }
}

