/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.core.render.chroma;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import com.fix3dll.skyblockaddons.utils.Utils;
import java.awt.Color;
import lombok.Generated;
import net.minecraft.class_310;
import net.minecraft.class_9848;

public class ManualChromaManager {
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    private static final class_310 MC = class_310.method_1551();
    private static final float[] defaultColorHSB = new float[]{0.0f, 0.75f, 0.9f};
    private static boolean coloringTextChroma;
    private static float featureScale;

    public static void renderingText(Feature feature) {
        if (Feature.CHROMA_MODE.getValue() == EnumUtils.ChromaMode.FADE && feature.isChroma()) {
            coloringTextChroma = true;
            featureScale = feature.getGuiScale();
        }
    }

    public static int getChromaColor(float x, float y, int alpha) {
        return ManualChromaManager.getChromaColor(x, y, defaultColorHSB, alpha);
    }

    public static int getChromaColor(float x, float y, float[] currentHSB, int alpha) {
        if (Feature.CHROMA_MODE.getValue() == EnumUtils.ChromaMode.ALL_SAME_COLOR) {
            x = 0.0f;
            y = 0.0f;
        }
        if (coloringTextChroma) {
            x *= featureScale;
            y *= featureScale;
        }
        int scale = MC.method_22683().method_4495();
        float chromaSize = Feature.CHROMA_SIZE.numberValue().floatValue() * ((float)MC.method_22683().method_4489() / 100.0f);
        float chromaSpeed = Feature.CHROMA_SPEED.numberValue().floatValue() / 360.0f;
        float ticks = (float)main.getScheduler().getTotalTicks() + Utils.getPartialTicks();
        float timeOffset = ticks * chromaSpeed;
        float newHue = (((x *= (float)scale) + (y *= (float)scale)) / chromaSize - timeOffset) % 1.0f;
        float saturation = Feature.CHROMA_SATURATION.numberValue().floatValue();
        float brightness = Feature.CHROMA_BRIGHTNESS.numberValue().floatValue() * currentHSB[2];
        return class_9848.method_61330((int)alpha, (int)Color.HSBtoRGB(newHue, saturation, brightness));
    }

    public static int getChromaColor(float x, float y, float z, int alpha) {
        if (Feature.CHROMA_MODE.getValue() == EnumUtils.ChromaMode.ALL_SAME_COLOR) {
            x = 0.0f;
            y = 0.0f;
            z = 0.0f;
        }
        float chromaSize = Feature.CHROMA_SIZE.numberValue().floatValue() * ((float)MC.method_22683().method_4489() / 100.0f);
        float chromaSpeed = Feature.CHROMA_SPEED.numberValue().floatValue() / 360.0f;
        float ticks = (float)main.getScheduler().getTotalTicks() + Utils.getPartialTicks();
        float timeOffset = ticks * chromaSpeed;
        float newHue = ((x - y + z) / (chromaSize / 20.0f) - timeOffset) % 1.0f;
        float saturation = Feature.CHROMA_SATURATION.numberValue().floatValue();
        float brightness = Feature.CHROMA_BRIGHTNESS.numberValue().floatValue();
        return class_9848.method_61330((int)alpha, (int)Color.HSBtoRGB(newHue, saturation, brightness));
    }

    public static void doneRenderingText() {
        coloringTextChroma = false;
        featureScale = 1.0f;
    }

    @Generated
    public static boolean isColoringTextChroma() {
        return coloringTextChroma;
    }

    @Generated
    public static void setColoringTextChroma(boolean coloringTextChroma) {
        ManualChromaManager.coloringTextChroma = coloringTextChroma;
    }

    @Generated
    public static float getFeatureScale() {
        return featureScale;
    }
}

