/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.core.scheduler;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import java.util.function.Consumer;
import lombok.Generated;

public class ScheduledTask {
    private static volatile int currentId = 1;
    private static final Object anchor = new Object();
    private final long creationTime = System.currentTimeMillis();
    private long startTick = SkyblockAddons.getInstance().getScheduler().getTotalTicks();
    private final int id;
    private int delay;
    private int period;
    private final boolean async;
    private boolean running;
    private boolean canceled;
    private boolean repeating;
    private Runnable task;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledTask(Consumer<ScheduledTask> task, int delay, int period, boolean async) {
        Object object = anchor;
        synchronized (object) {
            this.id = currentId++;
        }
        this.delay = delay;
        this.period = period;
        this.async = async;
        this.repeating = this.period > 0;
        this.task = () -> {
            this.running = true;
            task.accept(this);
            this.running = false;
        };
    }

    public final void cancel() {
        this.repeating = false;
        this.running = false;
        this.canceled = true;
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    public final long getStartTick() {
        return this.startTick;
    }

    public final int getId() {
        return this.id;
    }

    public final int getDelay() {
        return this.delay;
    }

    public boolean updateDelay(int delay) {
        return this.updateDelay(delay, false);
    }

    public boolean updateDelay(int delay, boolean force) {
        if (this.delay != delay || force) {
            this.startTick = SkyblockAddons.getInstance().getScheduler().getTotalTicks();
            this.delay = delay;
            return true;
        }
        return false;
    }

    public final int getPeriod() {
        return this.period;
    }

    public boolean updatePeriod(int period) {
        if (this.period != period) {
            this.period = period;
            this.repeating = period > 0;
            return true;
        }
        return false;
    }

    public void start() {
        if (this.isAsync()) {
            SkyblockAddons.runAsync(this.task);
        } else {
            this.task.run();
        }
    }

    public void updateTask(Consumer<ScheduledTask> task) {
        this.task = () -> {
            this.running = true;
            task.accept(this);
            this.running = false;
        };
    }

    @Generated
    public boolean isAsync() {
        return this.async;
    }

    @Generated
    public boolean isRunning() {
        return this.running;
    }

    @Generated
    public boolean isCanceled() {
        return this.canceled;
    }

    @Generated
    public boolean isRepeating() {
        return this.repeating;
    }
}

