/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.discordipc.entities;

import com.google.gson.JsonObject;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class Packet {
    private final OpCode op;
    private final JsonObject data;
    private final String encoding;

    public Packet(OpCode op, JsonObject data, String encoding) {
        this.op = op;
        this.data = data;
        this.encoding = encoding;
    }

    @Deprecated
    public Packet(OpCode op, JsonObject data) {
        this(op, data, "UTF-8");
    }

    public byte[] toBytes() {
        byte[] d;
        String s = this.data.toString();
        try {
            d = s.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            d = s.getBytes();
        }
        ByteBuffer packet = ByteBuffer.allocate(d.length + 8);
        packet.putInt(Integer.reverseBytes(this.op.ordinal()));
        packet.putInt(Integer.reverseBytes(d.length));
        packet.put(d);
        return packet.array();
    }

    public OpCode getOp() {
        return this.op;
    }

    public JsonObject getJson() {
        return this.data;
    }

    public String toString() {
        return "Pkt:" + (Object)((Object)this.getOp()) + this.getJson().toString();
    }

    public String toDecodedString() {
        try {
            return "Pkt:" + (Object)((Object)this.getOp()) + new String(this.getJson().toString().getBytes(this.encoding));
        }
        catch (UnsupportedEncodingException e) {
            return "Pkt:" + (Object)((Object)this.getOp()) + this.getJson().toString();
        }
    }

    public static enum OpCode {
        HANDSHAKE,
        FRAME,
        CLOSE,
        PING,
        PONG;

    }
}

