/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.events;

import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.render.chroma.ManualChromaManager;
import com.fix3dll.skyblockaddons.mixin.hooks.LevelRendererHook;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.function.Function;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1533;
import net.minecraft.class_310;
import net.minecraft.class_4604;
import net.minecraft.class_638;

public class RenderEntityOutlineEvent {
    public static final Event<RenderEntityOutline> EVENT = EventFactory.createArrayBacked(RenderEntityOutline.class, callbacks -> event -> {
        for (RenderEntityOutline callback : callbacks) {
            callback.onRenderEntityOutline(event);
        }
    });
    private final Type type;
    private Object2IntOpenHashMap<class_1297> entitiesToOutline = null;
    private ObjectOpenHashSet<class_1297> entitiesToChooseFrom;

    public RenderEntityOutlineEvent(Type theType, ObjectOpenHashSet<class_1297> potentialEntities) {
        this.type = theType;
        this.entitiesToChooseFrom = potentialEntities;
        if (potentialEntities != null) {
            this.entitiesToOutline = new Object2IntOpenHashMap(potentialEntities.size());
        }
    }

    public void queueEntitiesToOutline(Function<class_1297, Integer> outlineColor) {
        if (outlineColor == null) {
            return;
        }
        if (this.entitiesToChooseFrom == null) {
            this.computeAndCacheEntitiesToChooseFrom();
        }
        ObjectIterator itr = this.entitiesToChooseFrom.iterator();
        while (itr.hasNext()) {
            class_1297 e = (class_1297)itr.next();
            Integer color = outlineColor.apply(e);
            if (color == null) continue;
            int primitiveColor = color.intValue() == ColorCode.CHROMA.getColor() ? ManualChromaManager.getChromaColor(0.0f, 0.0f, 255) : color;
            this.entitiesToOutline.put((Object)e, primitiveColor);
            itr.remove();
        }
    }

    public void queueEntityToOutline(class_1297 entity, int outlineColor) {
        if (entity == null) {
            return;
        }
        if (this.entitiesToChooseFrom == null) {
            this.computeAndCacheEntitiesToChooseFrom();
        }
        if (!this.entitiesToChooseFrom.contains((Object)entity)) {
            return;
        }
        if (outlineColor == ColorCode.CHROMA.getColor()) {
            outlineColor = ManualChromaManager.getChromaColor(0.0f, 0.0f, 255);
        }
        this.entitiesToOutline.put((Object)entity, outlineColor);
        this.entitiesToChooseFrom.remove((Object)entity);
    }

    private void computeAndCacheEntitiesToChooseFrom() {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        Iterable entities = class_310.method_1551().field_1687.method_18112();
        this.entitiesToChooseFrom = new ObjectOpenHashSet();
        entities.forEach(e -> {
            if (e == null) {
                return;
            }
            class_4604 cullingFrustum = LevelRendererHook.getCullingFrustum();
            if (!cullingFrustum.method_23093(e.method_5829())) {
                return;
            }
            if (!(e instanceof class_1531 && e.method_5767() || e instanceof class_1533)) {
                this.entitiesToChooseFrom.add(e);
            }
        });
        this.entitiesToOutline = new Object2IntOpenHashMap(this.entitiesToChooseFrom.size());
    }

    @Generated
    public Type getType() {
        return this.type;
    }

    @Generated
    public Object2IntOpenHashMap<class_1297> getEntitiesToOutline() {
        return this.entitiesToOutline;
    }

    @Generated
    public ObjectOpenHashSet<class_1297> getEntitiesToChooseFrom() {
        return this.entitiesToChooseFrom;
    }

    public static enum Type {
        XRAY,
        NO_XRAY;

    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface RenderEntityOutline {
        public void onRenderEntityOutline(RenderEntityOutlineEvent var1);
    }
}

