/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.Island;
import com.fix3dll.skyblockaddons.core.Translations;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.core.render.state.BlitAbsoluteRenderState;
import com.fix3dll.skyblockaddons.events.ClientEvents;
import com.fix3dll.skyblockaddons.events.RenderEntityOutlineEvent;
import com.fix3dll.skyblockaddons.events.RenderEvents;
import com.fix3dll.skyblockaddons.features.cooldowns.CooldownManager;
import com.fix3dll.skyblockaddons.gui.buttons.feature.ButtonLocation;
import com.fix3dll.skyblockaddons.listeners.RenderListener;
import com.fix3dll.skyblockaddons.utils.LocationUtils;
import com.fix3dll.skyblockaddons.utils.TextUtils;
import com.fix3dll.skyblockaddons.utils.Utils;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_10017;
import net.minecraft.class_10730;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1428;
import net.minecraft.class_1429;
import net.minecraft.class_1452;
import net.minecraft.class_1463;
import net.minecraft.class_1472;
import net.minecraft.class_1498;
import net.minecraft.class_1531;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.joml.Matrix3x2f;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class TrevorTrapperTracker {
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    private static final class_310 MC = class_310.method_1551();
    private static final TrevorTrapperTracker instance = new TrevorTrapperTracker();
    private static final Pattern TRACKED_ANIMAL_NAME_PATTERN = Pattern.compile("\\[Lv[0-9]+](?: (?<mobType>[^a-zA-Z0-9]))? (?<rarity>[a-zA-Z]+) (?<animal>[a-zA-Z]+) .*\u2764");
    private static final Pattern TREVOR_FIND_ANIMAL_PATTERN = Pattern.compile("\\[NPC] Trevor: You can find your (?<rarity>[A-Z]+) animal near the [a-zA-Z ]+\\.");
    private static final Pattern ANIMAL_DIED_PATTERN = Pattern.compile("Your mob died randomly, you are rewarded [0-9]+ pelts?\\.");
    private static final Pattern ANIMAL_KILLED_PATTERN = Pattern.compile("Killing the animal rewarded you [0-9]+ pelts?\\.");
    private static final class_2960 TICKER_SYMBOL = SkyblockAddons.resourceLocation("tracker.png");
    private static TrackerRarity trackingAnimalRarity = null;
    private static TrackedEntity entityToOutline = null;
    private static int entityNameTagId = -1;

    public TrevorTrapperTracker() {
        ClientTickEvents.START_CLIENT_TICK.register(this::onClientTick);
        ClientEvents.LIVING_ENTITY_TICK.register(this::onEntityEvent);
        ClientReceiveMessageEvents.GAME_CANCELED.register(this::onChatReceived);
        ClientReceiveMessageEvents.ALLOW_GAME.register(this::onChatReceived);
        RenderEvents.SUBMIT_ENTITY_NAME_TAG.register(this::onSubmitEntityNameTag);
        RenderEntityOutlineEvent.EVENT.register(this::onRenderEntityOutlines);
    }

    public static void drawTrackerLocationIndicator(class_332 graphics, float scale, ButtonLocation buttonLocation) {
        Feature feature = Feature.TREVOR_THE_TRAPPER_FEATURES;
        if (feature.isEnabled(FeatureSetting.TREVOR_TRACKED_ENTITY_PROXIMITY_INDICATOR) && main.getUtils().isTrackingAnimal() || buttonLocation != null) {
            float x = feature.getActualX();
            float y = feature.getActualY();
            int height = 9;
            int width = 42;
            x = main.getRenderListener().transformX(x, width, scale, false);
            y = main.getRenderListener().transformY(y, height, scale);
            if (buttonLocation != null) {
                buttonLocation.checkHoveredAndDrawBox(graphics, x, x + (float)width, y, y + (float)height, scale);
            }
            int maxTickers = 4;
            int fullTickers = buttonLocation != null ? 3 : (entityToOutline == null ? TrevorTrapperTracker.getFlashingTickers() : (entityToOutline.getDistanceToPlayer() < 16.0 ? 4 : (entityToOutline.getDistanceToPlayer() < 32.0 ? 3 : (entityToOutline.getDistanceToPlayer() < 48.0 ? 2 : (entityToOutline.getDistanceToPlayer() < 64.0 ? 1 : TrevorTrapperTracker.getFlashingTickers())))));
            class_11231 textureSetup = RenderListener.textureSetup(TICKER_SYMBOL);
            for (int tickers = 0; tickers < maxTickers; ++tickers) {
                float uOffset = tickers < fullTickers ? 0.0f : 9.0f;
                graphics.field_59826.method_70919((class_11244)new BlitAbsoluteRenderState(class_10799.field_56883, textureSetup, (Matrix3x2f)graphics.method_51448(), x + (float)(tickers * 11), y, uOffset, 0.0f, 9.0f, 9.0f, 18.0f, 9.0f, -1, graphics.field_44659.method_70863()));
            }
        }
    }

    private static int getFlashingTickers() {
        if (CooldownManager.getRemainingCooldown("TREVOR_THE_TRAPPER_HUNT") % 2000L < 1000L) {
            return 0;
        }
        return 1;
    }

    public void onEntityEvent(class_1309 livingEntity) {
        if (!TrevorTrapperTracker.isTrackerConditionsMet()) {
            return;
        }
        if (trackingAnimalRarity != null && livingEntity instanceof class_1531) {
            class_1531 armorStand = (class_1531)livingEntity;
            class_2561 customName = livingEntity.method_5797();
            if (customName == null) {
                return;
            }
            Matcher m = TRACKED_ANIMAL_NAME_PATTERN.matcher(TextUtils.stripColor(customName.getString()));
            if (m.matches()) {
                TrackerRarity rarity = TrackerRarity.getFromString(m.group("rarity"));
                if (rarity == null || !rarity.equals((Object)trackingAnimalRarity)) {
                    return;
                }
                TrackerType animalType = TrackerType.getFromString(m.group("animal"));
                if (animalType != null && TrevorTrapperTracker.shouldTrackEntity()) {
                    TrackedEntity trackedEntity = new TrackedEntity(armorStand, animalType, rarity);
                    trackedEntity.attachAnimal(TrevorTrapperTracker.MC.field_1687.method_18467(class_1429.class, new class_238(armorStand.method_23317() - 2.0, armorStand.method_23318() - 2.0, armorStand.method_23321() - 2.0, armorStand.method_23317() + 2.0, armorStand.method_23318() + 2.0, armorStand.method_23321() + 2.0)));
                    if (trackedEntity.getAnimal() != null && TrevorTrapperTracker.MC.field_1724 != null) {
                        entityToOutline = trackedEntity;
                        entityNameTagId = trackedEntity.getAnimal().method_5767() || TrevorTrapperTracker.MC.field_1724.method_6059(class_1294.field_5919) ? -1 : armorStand.method_5628();
                    }
                }
            }
        }
    }

    private static boolean shouldTrackEntity() {
        return Feature.TREVOR_THE_TRAPPER_FEATURES.isEnabled(FeatureSetting.TREVOR_TRACKED_ENTITY_PROXIMITY_INDICATOR) || Feature.TREVOR_THE_TRAPPER_FEATURES.isEnabled(FeatureSetting.TREVOR_HIGHLIGHT_TRACKED_ENTITY) || Feature.TREVOR_THE_TRAPPER_FEATURES.isEnabled(FeatureSetting.TREVOR_BETTER_NAMETAG);
    }

    private boolean onChatReceived(class_2561 component, boolean actionBar) {
        if (LocationUtils.isOn(Island.THE_FARMING_ISLANDS) && !actionBar) {
            String stripped = TextUtils.stripColor(component.getString());
            Matcher matcher = TREVOR_FIND_ANIMAL_PATTERN.matcher(stripped);
            if (matcher.matches()) {
                Object rarity = matcher.group("rarity");
                rarity = ((String)rarity).charAt(0) + ((String)rarity).substring(1).toLowerCase(Locale.US);
                trackingAnimalRarity = TrackerRarity.getFromString((String)rarity);
                CooldownManager.put("TREVOR_THE_TRAPPER_HUNT", 600000L);
                if (main.getElectionData().isPerkActive("Pelt-pocalypse")) {
                    CooldownManager.put("TREVOR_THE_TRAPPER_RETURN", 16000L);
                } else {
                    CooldownManager.put("TREVOR_THE_TRAPPER_RETURN", 21000L);
                }
            } else if (ANIMAL_DIED_PATTERN.matcher(stripped).matches() || ANIMAL_KILLED_PATTERN.matcher(stripped).matches()) {
                CooldownManager.remove("TREVOR_THE_TRAPPER_HUNT");
                this.onQuestEnded();
            }
        }
        return true;
    }

    public void onClientTick(class_310 mc) {
        if (TrevorTrapperTracker.isTrackerConditionsMet()) {
            if (trackingAnimalRarity != null && CooldownManager.getRemainingCooldown("TREVOR_THE_TRAPPER_HUNT") == 0L) {
                this.onQuestEnded();
            } else if (entityToOutline != null) {
                entityToOutline.cacheDistanceToPlayer();
            }
        }
    }

    private void onRenderEntityOutlines(RenderEntityOutlineEvent e) {
        if (e.getType() == RenderEntityOutlineEvent.Type.NO_XRAY && TrevorTrapperTracker.isTrackerConditionsMet() && Feature.TREVOR_THE_TRAPPER_FEATURES.isEnabled(FeatureSetting.TREVOR_HIGHLIGHT_TRACKED_ENTITY) && trackingAnimalRarity != null && entityToOutline != null && entityToOutline.getAnimal() != null && !TrevorTrapperTracker.MC.field_1724.method_6059(class_1294.field_5919)) {
            e.queueEntityToOutline(entityToOutline.getAnimal(), entityToOutline.getRarity().getColorInt());
        }
    }

    private boolean onSubmitEntityNameTag(class_10017 state, class_4587 poseStack, class_11659 nodeCollector, class_12075 cameraRenderState, CallbackInfo ci) {
        String strippedEntityTag;
        class_243 vec3 = state.field_53338;
        class_2561 nameTag = state.field_53337;
        if (nameTag == null || vec3 == null || !TrevorTrapperTracker.isTrackerConditionsMet()) {
            return false;
        }
        Feature feature = Feature.TREVOR_THE_TRAPPER_FEATURES;
        if (feature.isEnabled(FeatureSetting.TREVOR_BETTER_NAMETAG)) {
            class_1297 entityNameTag = TrevorTrapperTracker.MC.field_1687.method_8469(entityNameTagId);
            class_1297 cameraEntity = MC.method_1560();
            if (entityNameTag != null && entityNameTag.method_16914() && Objects.equals(nameTag, entityNameTag.method_5476()) && cameraEntity != null) {
                float distanceScale = Math.max(1.0f, (float)cameraEntity.method_73189().method_1022(entityNameTag.method_73189()) / 5.0f);
                poseStack.method_22903();
                poseStack.method_22905(distanceScale, distanceScale, distanceScale);
                nodeCollector.method_73482(poseStack, vec3, 0, nameTag, true, 0xF000F0, state.field_53332, cameraRenderState);
                poseStack.method_22909();
                return true;
            }
        }
        if (feature.isEnabled(FeatureSetting.TREVOR_SHOW_QUEST_COOLDOWN) && CooldownManager.isOnCooldown("TREVOR_THE_TRAPPER_RETURN") && (strippedEntityTag = TextUtils.stripColor(nameTag.getString())).contains("Trevor")) {
            String str = Utils.MESSAGE_PREFIX_SHORT + Translations.getMessage("messages.worldRenderedCooldownTime", CooldownManager.getRemainingCooldown("TREVOR_THE_TRAPPER_RETURN") / 1000L);
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.25875f, 0.0f);
            nodeCollector.method_73482(poseStack, vec3, 0, (class_2561)class_2561.method_43470((String)str), true, 0xF000F0, state.field_53332, cameraRenderState);
            poseStack.method_22909();
        }
        return false;
    }

    private void onQuestEnded() {
        entityToOutline = null;
        trackingAnimalRarity = null;
        entityNameTagId = -1;
    }

    public static boolean isTrackerConditionsMet() {
        return TrevorTrapperTracker.MC.field_1687 != null && TrevorTrapperTracker.MC.field_1724 != null && main.getUtils().isOnSkyblock() && Feature.TREVOR_THE_TRAPPER_FEATURES.isEnabled() && LocationUtils.isOn(Island.THE_FARMING_ISLANDS);
    }

    @Generated
    public static TrevorTrapperTracker getInstance() {
        return instance;
    }

    @Generated
    public static int getEntityNameTagId() {
        return entityNameTagId;
    }

    private static class TrackedEntity {
        private final class_1531 armorStand;
        private final TrackerType type;
        private final TrackerRarity rarity;
        private class_1297 animal;
        private double distanceToPlayer;

        public TrackedEntity(class_1531 theArmorStand, TrackerType trackerType, TrackerRarity trackerRarity) {
            this.armorStand = theArmorStand;
            this.type = trackerType;
            this.rarity = trackerRarity;
            this.cacheDistanceToPlayer();
        }

        public void attachAnimal(List<class_1429> animalList) {
            if (animalList.isEmpty()) {
                this.animal = null;
            }
            double minDist = Double.MAX_VALUE;
            for (class_1297 class_12972 : animalList) {
                double horizDist = (class_12972.method_23317() - this.armorStand.method_23317()) * (class_12972.method_23317() - this.armorStand.method_23317()) + (class_12972.method_23321() - this.armorStand.method_23321()) * (class_12972.method_23321() - this.armorStand.method_23321());
                if (!(horizDist < minDist) || !(Math.abs(class_12972.method_23318() - this.armorStand.method_23318()) < 3.0)) continue;
                minDist = horizDist;
                this.animal = class_12972;
            }
        }

        public void cacheDistanceToPlayer() {
            if (TrevorTrapperTracker.MC.field_1724 == null) {
                return;
            }
            this.distanceToPlayer = this.animal != null ? (double)TrevorTrapperTracker.MC.field_1724.method_5739(this.animal) : (double)TrevorTrapperTracker.MC.field_1724.method_5739((class_1297)this.armorStand);
        }

        @Generated
        public class_1531 getArmorStand() {
            return this.armorStand;
        }

        @Generated
        public TrackerType getType() {
            return this.type;
        }

        @Generated
        public TrackerRarity getRarity() {
            return this.rarity;
        }

        @Generated
        public class_1297 getAnimal() {
            return this.animal;
        }

        @Generated
        public double getDistanceToPlayer() {
            return this.distanceToPlayer;
        }
    }

    private static enum TrackerRarity {
        TRACKABLE("Trackable", ColorCode.WHITE),
        UNTRACKABLE("Untrackable", ColorCode.DARK_GREEN),
        UNDETECTED("Undetected", ColorCode.DARK_BLUE),
        ENDANGERED("Endangered", ColorCode.DARK_PURPLE),
        ELUSIVE("Elusive", ColorCode.GOLD);

        private final String nameTagName;
        private final ColorCode colorCode;
        private final int colorInt;

        private TrackerRarity(String nameTag, ColorCode color) {
            this.nameTagName = nameTag;
            this.colorCode = color;
            this.colorInt = color.getColor();
        }

        public static TrackerRarity getFromString(String s) {
            for (TrackerRarity type : TrackerRarity.values()) {
                if (!type.nameTagName.equals(s)) continue;
                return type;
            }
            return null;
        }

        @Generated
        public String getNameTagName() {
            return this.nameTagName;
        }

        @Generated
        public ColorCode getColorCode() {
            return this.colorCode;
        }

        @Generated
        public int getColorInt() {
            return this.colorInt;
        }
    }

    private static enum TrackerType {
        COW("Cow", class_10730.class),
        PIG("Pig", class_1452.class),
        SHEEP("Sheep", class_1472.class),
        RABBIT("Rabbit", class_1463.class),
        CHICKEN("Chicken", class_1428.class),
        HORSE("Horse", class_1498.class);

        private final String name;
        private final Class<? extends class_1297> clazz;

        private TrackerType(String entityName, Class<? extends class_1297> entityClass) {
            this.name = entityName;
            this.clazz = entityClass;
        }

        public static TrackerType getFromString(String s) {
            for (TrackerType type : TrackerType.values()) {
                if (!type.name.equals(s)) continue;
                return type;
            }
            return null;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Class<? extends class_1297> getClazz() {
            return this.clazz;
        }
    }
}

