/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features.dragontracker;

import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.Translations;
import java.util.Locale;
import lombok.Generated;

public enum DragonType {
    PROTECTOR(ColorCode.DARK_BLUE),
    OLD(ColorCode.GRAY),
    WISE(ColorCode.BLUE),
    UNSTABLE(ColorCode.BLACK),
    YOUNG(ColorCode.WHITE),
    STRONG(ColorCode.RED),
    SUPERIOR(ColorCode.GOLD);

    private final ColorCode color;

    private DragonType(ColorCode color) {
        this.color = color;
    }

    public String getDisplayName() {
        return Translations.getMessage("dragonTracker." + this.name().toLowerCase(Locale.US), new Object[0]);
    }

    public static DragonType fromName(String name) {
        for (DragonType dragonType : DragonType.values()) {
            if (!dragonType.name().equals(name.toUpperCase(Locale.US))) continue;
            return dragonType;
        }
        return null;
    }

    @Generated
    public ColorCode getColor() {
        return this.color;
    }
}

