/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features.dungeonmap;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.core.render.chroma.ManualChromaManager;
import com.fix3dll.skyblockaddons.core.render.state.FillAbsoluteRenderState;
import com.fix3dll.skyblockaddons.features.dungeonmap.MapMarker;
import com.fix3dll.skyblockaddons.features.dungeons.DungeonPlayer;
import com.fix3dll.skyblockaddons.gui.buttons.feature.ButtonLocation;
import com.fix3dll.skyblockaddons.utils.DrawUtils;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.textures.GpuTextureView;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import lombok.Generated;
import net.minecraft.class_1058;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11241;
import net.minecraft.class_11244;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_21;
import net.minecraft.class_22;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_640;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_8030;
import net.minecraft.class_9209;
import net.minecraft.class_9334;
import net.minecraft.class_9428;
import net.minecraft.class_9848;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;

public class DungeonMapManager {
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    private static final class_310 MC = class_310.method_1551();
    private static final Logger LOGGER = SkyblockAddons.getLogger();
    public static final float MIN_ZOOM = 0.5f;
    public static final float MAX_ZOOM = 5.0f;
    private static final Feature feature = Feature.DUNGEONS_MAP_DISPLAY;
    private static final class_2960 DUNGEON_MAP = SkyblockAddons.resourceLocation("dungeonsmap.png");
    private static final Comparator<MapMarker> MAP_MARKER_COMPARATOR = (first, second) -> {
        boolean secondIsNull;
        boolean firstIsNull = first.getMapMarkerName() == null;
        boolean bl = secondIsNull = second.getMapMarkerName() == null;
        if (!Objects.equals(first.getDecorationType(), second.getDecorationType())) {
            int firstId = class_7923.field_50078.method_10206((Object)first.getDecorationType());
            int secondId = class_7923.field_50078.method_10206((Object)second.getDecorationType());
            return Integer.compare(firstId, secondId);
        }
        if (firstIsNull && secondIsNull) {
            return 0;
        }
        if (firstIsNull) {
            return 1;
        }
        if (secondIsNull) {
            return -1;
        }
        return second.getMapMarkerName().compareTo(first.getMapMarkerName());
    };
    private static final float COORDINATE_FACTOR = 1.33f;
    private static class_22 mapData;
    private static class_9209 mapId;
    private static double markerOffsetX;
    private static double markerOffsetZ;
    private static final NavigableMap<Long, class_243> previousLocations;
    private static final HashMap<String, PlayerSkinInfo> cachedSkinInfo;
    private static final LinkedHashMap<String, class_20> savedMapDecorations;

    public static void drawDungeonsMap(class_332 graphics, float scale, ButtonLocation buttonLocation) {
        boolean rotate;
        boolean isScoreSummary;
        class_1799 possibleMapItemStack;
        if (buttonLocation == null && !main.getUtils().isInDungeon()) {
            markerOffsetX = -1.0;
            markerOffsetZ = -1.0;
            mapData = null;
        }
        class_1799 class_17992 = possibleMapItemStack = DungeonMapManager.MC.field_1724 == null ? null : DungeonMapManager.MC.field_1724.method_31548().method_5438(8);
        if (buttonLocation == null && (possibleMapItemStack == null || possibleMapItemStack.method_7909() != class_1802.field_8204 || possibleMapItemStack.method_65130() == null) && mapData == null) {
            return;
        }
        if (buttonLocation == null && possibleMapItemStack != null && possibleMapItemStack.method_7909() == class_1802.field_8204) {
            String customName = possibleMapItemStack.method_65130().getString();
            isScoreSummary = customName.contains("Your Score Summary");
            if (!customName.contains("Magical Map") && !isScoreSummary) {
                return;
            }
        } else {
            isScoreSummary = false;
        }
        float x = Feature.DUNGEONS_MAP_DISPLAY.getActualX();
        float y = Feature.DUNGEONS_MAP_DISPLAY.getActualY();
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        int originalSize = 128;
        float initialScaleFactor = 0.5f;
        int size = 64;
        int scissorX = (int)(x - (float)size / 2.0f * scale);
        int scissorY = (int)(y - (float)size / 2.0f * scale);
        int widthHeight = (int)((float)size * scale);
        x = DungeonMapManager.transformXY(x, size, scale);
        y = DungeonMapManager.transformXY(y, size, scale);
        if (buttonLocation != null) {
            buttonLocation.checkHoveredAndDrawBox(graphics, x, x + (float)size, y, y + (float)size, scale);
        }
        graphics.field_59826.method_70919((class_11244)new FillAbsoluteRenderState(class_10799.field_56879, class_11231.method_70899(), (Matrix3x2f)graphics.method_51448(), x, y, x + (float)size, y + (float)size, 0x55000000, graphics.field_44659.method_70863()));
        ManualChromaManager.renderingText(feature);
        int color = feature.getColor();
        RenderPipeline renderType = feature.isChroma() && Feature.CHROMA_MODE.getValue() == EnumUtils.ChromaMode.FADE ? DrawUtils.CHROMA_STANDARD : class_10799.field_56879;
        DrawUtils.renderOutlineAbsolute(graphics, renderType, class_11231.method_70899(), x, y, size, size, 1, color);
        ManualChromaManager.doneRenderingText();
        graphics.field_44659.method_49700(new class_8030(scissorX, scissorY, widthHeight, widthHeight));
        float zoomScaleFactor = isScoreSummary ? 1.0f : DungeonMapManager.getMapZoom();
        float totalScaleFactor = 0.5f * zoomScaleFactor;
        float mapSize = 128.0f * totalScaleFactor;
        poseStack.scale(totalScaleFactor, totalScaleFactor);
        poseStack.translate(x /= totalScaleFactor, y /= totalScaleFactor);
        float rotationCenterX = 64.0f;
        float rotationCenterY = 64.0f;
        float centerOffset = -((mapSize - (float)size) / zoomScaleFactor);
        poseStack.translate(centerOffset, centerOffset);
        boolean rotateOnPlayer = feature.isEnabled(FeatureSetting.CENTER_ROTATION_ON_PLAYER);
        boolean bl = rotate = !isScoreSummary && feature.isEnabled(FeatureSetting.ROTATE_MAP);
        if (buttonLocation == null) {
            try {
                boolean foundMapData;
                class_9209 newMapId;
                class_22 newMapData;
                if (possibleMapItemStack != null) {
                    newMapData = class_1806.method_8001((class_1799)possibleMapItemStack, (class_1937)DungeonMapManager.MC.field_1687);
                    newMapId = (class_9209)possibleMapItemStack.method_58694(class_9334.field_49646);
                } else {
                    newMapData = null;
                    newMapId = null;
                }
                if (newMapData != null && newMapId != null) {
                    mapData = newMapData;
                    mapId = newMapId;
                    foundMapData = true;
                } else {
                    foundMapData = false;
                }
                if (mapData != null && mapId != null) {
                    class_243 lastSecondVector;
                    long now = System.currentTimeMillis();
                    previousLocations.entrySet().removeIf(entry -> (Long)entry.getKey() < now - 1000L);
                    class_243 currentVector = DungeonMapManager.MC.field_1724.method_73189();
                    previousLocations.put(now, currentVector);
                    double lastSecondTravel = -1.0;
                    Map.Entry<Long, class_243> closestEntry = previousLocations.ceilingEntry(now - 1000L);
                    if (closestEntry != null && (lastSecondVector = closestEntry.getValue()) != null) {
                        lastSecondTravel = lastSecondVector.method_1022(currentVector);
                    }
                    if (foundMapData && (markerOffsetX == -1.0 || markerOffsetZ == -1.0 || lastSecondTravel == 0.0)) {
                        mapData.method_32373().forEach(mapDecoration -> {
                            if (mapDecoration.comp_1842().comp_349() == class_21.field_95.comp_349()) {
                                markerOffsetX = DungeonMapManager.calculateMarkerOffset(DungeonMapManager.MC.field_1724.field_3926, mapDecoration.comp_1843());
                                markerOffsetZ = DungeonMapManager.calculateMarkerOffset(DungeonMapManager.MC.field_1724.field_3924, mapDecoration.comp_1844());
                            }
                        });
                    }
                    if (rotate && rotateOnPlayer) {
                        rotationCenterX = DungeonMapManager.toRenderCoordinate(DungeonMapManager.toMapCoordinate(DungeonMapManager.MC.field_1724.method_23317(), markerOffsetX));
                        rotationCenterY = DungeonMapManager.toRenderCoordinate(DungeonMapManager.toMapCoordinate(DungeonMapManager.MC.field_1724.method_23321(), markerOffsetZ));
                    }
                    if (rotate) {
                        if (rotateOnPlayer) {
                            poseStack.translate((float)size - rotationCenterX, (float)size - rotationCenterY);
                        }
                        float rotation = DungeonMapManager.MC.field_1724 != null ? 180.0f - class_3532.method_15393((float)DungeonMapManager.MC.field_1724.method_36454()) : 0.0f;
                        poseStack.rotateAbout((float)Math.toRadians(rotation), rotationCenterX, rotationCenterY);
                    }
                    DungeonMapManager.drawMap(graphics, mapData, mapId, isScoreSummary, zoomScaleFactor);
                }
            }
            catch (Exception ex) {
                LOGGER.error((Object)ex);
            }
        } else {
            if (rotate) {
                float ticks = (float)(System.currentTimeMillis() % 18000L) / 50.0f;
                poseStack.rotateAbout((float)Math.toRadians(ticks), rotationCenterX, rotationCenterY);
            }
            graphics.method_25290(class_10799.field_56883, DUNGEON_MAP, 0, 0, 0.0f, 0.0f, 128, 128, 128, 128);
        }
        graphics.method_44380();
        poseStack.popMatrix();
    }

    /*
     * WARNING - void declaration
     */
    private static void drawMap(class_332 graphics, class_22 mapData, class_9209 mapId, boolean isScoreSummary, float markerScale) {
        Collection onlinePlayersInfo;
        class_1060 textureManager = MC.method_1531();
        class_2960 texture = MC.method_61963().method_62624(mapId, mapData);
        GpuTextureView gpuTextureView = textureManager.method_4619(texture).method_71659();
        Matrix3x2fStack poseStack = graphics.method_51448();
        graphics.field_59826.method_70919((class_11244)new class_11241(class_10799.field_56883, class_11231.method_70900((GpuTextureView)gpuTextureView), new Matrix3x2f((Matrix3x2fc)poseStack), 0, 0, 128, 128, 0.0f, 1.0f, 0.0f, 1.0f, -1, graphics.field_44659.method_70863()));
        if (isScoreSummary) {
            return;
        }
        savedMapDecorations.clear();
        savedMapDecorations.putAll(mapData.field_117);
        ObjectOpenHashSet dontAddMarkerNames = new ObjectOpenHashSet();
        TreeSet<MapMarker> allMarkers = new TreeSet<MapMarker>(MAP_MARKER_COMPARATOR);
        HashMap<String, DungeonPlayer> teammates = main.getDungeonManager().getTeammates();
        for (class_742 class_7422 : DungeonMapManager.MC.field_1687.method_18456()) {
            DungeonPlayer dungeonTeammate = teammates.get(class_7422.method_7334().name());
            MapMarker playerMarker = dungeonTeammate != null ? DungeonMapManager.getMapMarkerForPlayer(dungeonTeammate, (class_1657)class_7422) : (class_7422 == DungeonMapManager.MC.field_1724 ? DungeonMapManager.getMapMarkerForPlayer(null, (class_1657)class_7422) : null);
            if (playerMarker == null) continue;
            if (playerMarker.getMapMarkerName() != null) {
                dontAddMarkerNames.add((Object)playerMarker.getMapMarkerName());
            }
            allMarkers.add(playerMarker);
        }
        for (Map.Entry entry : savedMapDecorations.entrySet()) {
            String decorationName = (String)entry.getKey();
            class_20 mapDecoration = (class_20)entry.getValue();
            if (dontAddMarkerNames.contains((Object)decorationName) || mapDecoration.comp_1842().comp_349() == class_21.field_95.comp_349()) continue;
            boolean linkedToPlayer = false;
            for (DungeonPlayer dungeonPlayer : teammates.values()) {
                String mapMarkerName;
                MapMarker mapMarker = dungeonPlayer.getMapMarker();
                if (mapMarker == null || (mapMarkerName = dungeonPlayer.getMapMarker().getMapMarkerName()) == null || !mapMarkerName.equals(decorationName)) continue;
                mapMarker.setX(mapDecoration.comp_1843());
                mapMarker.setY(mapDecoration.comp_1844());
                mapMarker.setRotation(mapDecoration.comp_1845());
                if (mapMarker.getPlayerName() == null) {
                    mapMarker.setPlayerName(dungeonPlayer.getName());
                }
                allMarkers.add(mapMarker);
                linkedToPlayer = true;
                break;
            }
            if (linkedToPlayer) continue;
            allMarkers.add(new MapMarker((class_9428)mapDecoration.comp_1842().comp_349(), mapDecoration.comp_1843(), mapDecoration.comp_1844(), mapDecoration.comp_1845()));
        }
        markerScale = 4.0f / markerScale;
        boolean showPlayerHead = Feature.DUNGEONS_MAP_DISPLAY.isEnabled(FeatureSetting.SHOW_PLAYER_HEADS_ON_MAP);
        if (showPlayerHead) {
            boolean bl = DungeonMapManager.unexpectedSkin();
            onlinePlayersInfo = MC.method_1562().method_2880();
        } else {
            boolean bl = false;
            onlinePlayersInfo = List.of();
        }
        for (MapMarker marker : allMarkers) {
            void var13_19;
            String markerPlayerName = marker.getPlayerName();
            PlayerSkinInfo markerSkinInfo = null;
            if (showPlayerHead && markerPlayerName != null && ((markerSkinInfo = cachedSkinInfo.get(markerPlayerName)) == null || var13_19 != false)) {
                for (class_640 playerInfo : onlinePlayersInfo) {
                    if (!markerPlayerName.equals(playerInfo.method_2966().name())) continue;
                    markerSkinInfo = cachedSkinInfo.put(markerPlayerName, new PlayerSkinInfo(playerInfo.method_65195(), playerInfo.method_52810().comp_1626().comp_3627()));
                    break;
                }
            }
            poseStack.pushMatrix();
            poseStack.translate(marker.getX() / 2.0f + 64.0f, marker.getY() / 2.0f + 64.0f);
            poseStack.rotate((float)Math.PI / 180 * marker.getRotation() * 360.0f / 16.0f);
            poseStack.scale(markerScale, markerScale);
            if (markerSkinInfo != null) {
                graphics.field_59826.method_70919((class_11244)new FillAbsoluteRenderState(class_10799.field_56879, class_11231.method_70899(), (Matrix3x2f)graphics.method_51448(), -1.2f, -1.2f, 1.2f, 1.2f, -16777216, graphics.field_44659.method_70863()));
                int color = -1;
                if (Feature.SHOW_CRITICAL_DUNGEONS_TEAMMATES.isEnabled() && teammates.containsKey(markerPlayerName)) {
                    DungeonPlayer dungeonPlayer = teammates.get(markerPlayerName);
                    if (dungeonPlayer.isLow()) {
                        color = class_9848.method_61318((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                    } else if (dungeonPlayer.isCritical()) {
                        color = class_9848.method_61318((float)1.0f, (float)1.0f, (float)0.5f, (float)0.5f);
                    }
                }
                poseStack.pushMatrix();
                poseStack.scale(0.25f, 0.25f);
                graphics.method_25293(class_10799.field_56883, markerSkinInfo.bodySkinPath, -4, -4, 8.0f, 8.0f, 8, 8, 8, 8, 64, 64, color);
                if (markerSkinInfo.showHat) {
                    graphics.method_25293(class_10799.field_56883, markerSkinInfo.bodySkinPath, -4, -4, 40.0f, 8.0f, 8, 8, 8, 8, 64, 64, color);
                }
                poseStack.popMatrix();
            } else {
                poseStack.translate(-0.125f, 0.125f);
                class_1058 textureAtlasSprite = marker.getDecorationType() != null ? DungeonMapManager.MC.method_61965().field_50036.method_4608(marker.getDecorationType().comp_2514()) : null;
                if (textureAtlasSprite != null) {
                    GpuTextureView atlasLocation = textureManager.method_4619(textureAtlasSprite.method_45852()).method_71659();
                    graphics.field_59826.method_70919((class_11244)new class_11241(class_10799.field_56883, class_11231.method_70900((GpuTextureView)atlasLocation), new Matrix3x2f((Matrix3x2fc)poseStack), -1, -1, 1, 1, textureAtlasSprite.method_4594(), textureAtlasSprite.method_4577(), textureAtlasSprite.method_4575(), textureAtlasSprite.method_4593(), -1, graphics.field_44659.method_70863()));
                }
            }
            poseStack.popMatrix();
        }
    }

    public static MapMarker getMapMarkerForPlayer(DungeonPlayer dungeonPlayer, class_1657 player) {
        MapMarker mapMarker;
        if (dungeonPlayer != null) {
            if (dungeonPlayer.getMapMarker() == null) {
                mapMarker = new MapMarker(player);
                dungeonPlayer.setMapMarker(mapMarker);
            } else {
                mapMarker = dungeonPlayer.getMapMarker();
                mapMarker.updateXZRot(player);
                if (mapMarker.getPlayerName() == null) {
                    mapMarker.setPlayerName(player.method_7334().name());
                }
            }
        } else {
            mapMarker = new MapMarker(player);
        }
        int duplicates = 0;
        Map.Entry<String, class_20> duplicate = null;
        for (Map.Entry<String, class_20> decoration : savedMapDecorations.entrySet()) {
            class_20 mapDecoration = decoration.getValue();
            if (mapDecoration.comp_1842().comp_349() != mapMarker.getDecorationType() || !(Math.abs((float)mapDecoration.comp_1843() - mapMarker.getX()) <= 5.0f) || !(Math.abs((float)mapDecoration.comp_1844() - mapMarker.getY()) <= 5.0f)) continue;
            ++duplicates;
            duplicate = decoration;
        }
        if (duplicates == 1) {
            mapMarker.setMapMarkerName((String)duplicate.getKey());
        }
        return mapMarker;
    }

    public static double calculateMarkerOffset(double playerCoordinate, int playerMarkerCoordinate) {
        return BigDecimal.valueOf((double)playerMarkerCoordinate - (double)1.33f * playerCoordinate).setScale(5, RoundingMode.HALF_UP).doubleValue();
    }

    public static float toMapCoordinate(double playerCoordinate, double markerOffset) {
        return BigDecimal.valueOf((double)1.33f * playerCoordinate + markerOffset).setScale(5, RoundingMode.HALF_UP).floatValue();
    }

    public static float toRenderCoordinate(float mapCoordinate) {
        return mapCoordinate / 2.0f + 64.0f;
    }

    public static void increaseZoomByStep() {
        DungeonMapManager.setMapZoom(DungeonMapManager.getMapZoom() + 0.1f);
    }

    public static void decreaseZoomByStep() {
        DungeonMapManager.setMapZoom(DungeonMapManager.getMapZoom() - 0.1f);
    }

    public static float getMapZoom() {
        return Feature.DUNGEONS_MAP_DISPLAY.getAsNumber(FeatureSetting.DUNGEON_MAP_ZOOM).floatValue();
    }

    public static void setMapZoom(float value) {
        Feature.DUNGEONS_MAP_DISPLAY.set(FeatureSetting.DUNGEON_MAP_ZOOM, Float.valueOf(Math.max(Math.min(value, 5.0f), 0.5f)));
        main.getConfigValuesManager().saveConfig();
    }

    public static void clearSkinCache() {
        cachedSkinInfo.clear();
    }

    private static float transformXY(float xy, int widthHeight, float scale) {
        float minecraftScale = MC.method_22683().method_4495();
        xy -= (float)widthHeight / 2.0f * scale;
        xy = (float)Math.round(xy * minecraftScale) / minecraftScale;
        return xy / scale;
    }

    private static boolean unexpectedSkin() {
        class_746 player = DungeonMapManager.MC.field_1724;
        if (player == null) {
            return true;
        }
        PlayerSkinInfo cachedPlayerSkinInfo = cachedSkinInfo.get(player.method_7334().name());
        if (cachedPlayerSkinInfo == null) {
            return true;
        }
        return player.method_52814().comp_1626().comp_3627() != cachedPlayerSkinInfo.bodySkinPath;
    }

    @Generated
    public static double getMarkerOffsetX() {
        return markerOffsetX;
    }

    @Generated
    public static double getMarkerOffsetZ() {
        return markerOffsetZ;
    }

    static {
        markerOffsetX = 0.0;
        markerOffsetZ = 0.0;
        previousLocations = new TreeMap<Long, class_243>();
        cachedSkinInfo = new HashMap(5);
        savedMapDecorations = Maps.newLinkedHashMap();
    }

    private record PlayerSkinInfo(boolean showHat, class_2960 bodySkinPath) {
    }
}

