/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features.dungeons;

import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import lombok.Generated;
import net.minecraft.class_1799;
import net.minecraft.class_1802;

public enum DungeonClass {
    HEALER(class_1802.field_8436.method_7854(), "Healer", ColorCode.LIGHT_PURPLE),
    ARCHER(class_1802.field_8102.method_7854(), "Archer", ColorCode.GOLD),
    TANK(class_1802.field_8577.method_7854(), "Tank", ColorCode.DARK_GREEN),
    MAGE(class_1802.field_8894.method_7854(), "Mage", ColorCode.AQUA),
    BERSERK(class_1802.field_8371.method_7854(), "Berserk", ColorCode.DARK_RED);

    private final char firstLetter = this.name().charAt(0);
    private final class_1799 item;
    private final String chatDisplayName;
    private final ColorCode defaultColor;

    private DungeonClass(class_1799 item, String chatDisplayName, ColorCode defaultColor) {
        this.item = item;
        this.chatDisplayName = chatDisplayName;
        this.defaultColor = defaultColor;
    }

    public static DungeonClass fromFirstLetter(char firstLetter) {
        for (DungeonClass dungeonClass : DungeonClass.values()) {
            if (dungeonClass.firstLetter != firstLetter) continue;
            return dungeonClass;
        }
        return null;
    }

    public static DungeonClass fromDisplayName(String name) {
        for (DungeonClass dungeonClass : DungeonClass.values()) {
            if (!dungeonClass.getChatDisplayName().equals(name)) continue;
            return dungeonClass;
        }
        return null;
    }

    public int getColor() {
        Feature feature = Feature.SHOW_DUNGEON_TEAMMATE_NAME_OVERLAY;
        if (feature.isEnabled()) {
            return switch (this.ordinal()) {
                case 0 -> feature.getAsNumber(FeatureSetting.HEALER_COLOR).intValue();
                case 3 -> feature.getAsNumber(FeatureSetting.MAGE_COLOR).intValue();
                case 4 -> feature.getAsNumber(FeatureSetting.BERSERK_COLOR).intValue();
                case 1 -> feature.getAsNumber(FeatureSetting.ARCHER_COLOR).intValue();
                case 2 -> feature.getAsNumber(FeatureSetting.TANK_COLOR).intValue();
                default -> this.defaultColor.getColor();
            };
        }
        return this.defaultColor.getColor();
    }

    @Generated
    public char getFirstLetter() {
        return this.firstLetter;
    }

    @Generated
    public class_1799 getItem() {
        return this.item;
    }

    @Generated
    public String getChatDisplayName() {
        return this.chatDisplayName;
    }

    @Generated
    public ColorCode getDefaultColor() {
        return this.defaultColor;
    }

    @Generated
    public String toString() {
        return "DungeonClass." + this.name() + "(firstLetter=" + this.getFirstLetter() + ", item=" + String.valueOf(this.getItem()) + ", chatDisplayName=" + this.getChatDisplayName() + ", defaultColor=" + String.valueOf(this.getDefaultColor()) + ")";
    }
}

