/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features.healingcircle;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.features.dungeons.DungeonClass;
import com.fix3dll.skyblockaddons.features.dungeons.DungeonPlayer;
import com.fix3dll.skyblockaddons.features.healingcircle.HealingCircleParticle;
import com.fix3dll.skyblockaddons.utils.objects.Pair;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;

public class HealingCircle {
    private static final float DEFAULT_DIAMETER = 12.0f;
    private static final float DEFAULT_RADIUS = 6.0f;
    private static final long DEFAULT_DURATION = 10000L;
    private static float radius = 0.0f;
    private static float diameter = 12.0f;
    private static long duration = 10000L;
    private List<HealingCircleParticle> healingCircleParticles = new ArrayList<HealingCircleParticle>();
    private long creation = System.currentTimeMillis();
    private Point2D.Double cachedCenterPoint = null;
    private double totalX;
    private double totalZ;
    private int totalParticles;

    public HealingCircle(HealingCircleParticle healingCircleParticle) {
        this.addPoint(healingCircleParticle);
        if (radius == 0.0f) {
            this.calculateRadius();
        }
    }

    public void addPoint(HealingCircleParticle healingCircleParticle) {
        ++this.totalParticles;
        this.totalX += healingCircleParticle.getPoint().getX();
        this.totalZ += healingCircleParticle.getPoint().getY();
        this.healingCircleParticles.add(healingCircleParticle);
    }

    public double getAverageX() {
        return this.totalX / (double)this.totalParticles;
    }

    public double getAverageZ() {
        return this.totalZ / (double)this.totalParticles;
    }

    public double getParticlesPerSecond() {
        int particlesPerSecond = 0;
        long now = System.currentTimeMillis();
        for (HealingCircleParticle healingCircleParticle : this.healingCircleParticles) {
            if (now - healingCircleParticle.getCreation() >= 1000L) continue;
            ++particlesPerSecond;
        }
        return particlesPerSecond;
    }

    public Point2D.Double getCircleCenter() {
        if (this.cachedCenterPoint != null) {
            return this.cachedCenterPoint;
        }
        if (this.healingCircleParticles.size() < 3) {
            return new Point2D.Double(Double.NaN, Double.NaN);
        }
        Point2D.Double middlePoint = this.healingCircleParticles.getFirst().getPoint();
        Point2D.Double firstPoint = null;
        for (HealingCircleParticle healingCircleParticle : this.healingCircleParticles) {
            Point2D.Double point = healingCircleParticle.getPoint();
            if (point == middlePoint || !(point.distance(middlePoint) > 2.0)) continue;
            firstPoint = point;
            break;
        }
        if (firstPoint == null) {
            return new Point2D.Double(Double.NaN, Double.NaN);
        }
        Point2D.Double secondPoint = null;
        for (HealingCircleParticle healingCircleParticle : this.healingCircleParticles) {
            double distanceToMiddle;
            Point2D.Double point = healingCircleParticle.getPoint();
            if (point == middlePoint || point == firstPoint || !((distanceToMiddle = point.distance(middlePoint)) > 2.0) || !(point.distance(firstPoint) > distanceToMiddle)) continue;
            secondPoint = point;
            break;
        }
        if (secondPoint == null) {
            return new Point2D.Double(Double.NaN, Double.NaN);
        }
        Point2D.Double double_ = new Point2D.Double((middlePoint.x + firstPoint.x) / 2.0, (middlePoint.y + firstPoint.y) / 2.0);
        Point2D.Double secondChordMidpoint = new Point2D.Double((middlePoint.x + secondPoint.x) / 2.0, (middlePoint.y + secondPoint.y) / 2.0);
        Point2D.Double firstChordFirst = HealingCircle.rotatePoint(middlePoint, double_, 90.0);
        Point2D.Double firstChordSecond = HealingCircle.rotatePoint(firstPoint, double_, 90.0);
        Point2D.Double secondChordFirst = HealingCircle.rotatePoint(middlePoint, secondChordMidpoint, 90.0);
        Point2D.Double secondChordSecond = HealingCircle.rotatePoint(secondPoint, secondChordMidpoint, 90.0);
        Point2D.Double center = HealingCircle.lineLineIntersection(firstChordFirst, firstChordSecond, secondChordFirst, secondChordSecond);
        this.checkIfCenterIsPerfect(center);
        return center;
    }

    public void checkIfCenterIsPerfect(Point2D.Double center) {
        if (this.totalParticles < 25) {
            return;
        }
        int perfectParticles = 0;
        for (HealingCircleParticle healingCircleParticle : this.healingCircleParticles) {
            Point2D.Double point = healingCircleParticle.getPoint();
            double distance = point.distance(center);
            if (!(distance > (double)((diameter - 1.0f) / 2.0f)) || !(distance < (double)((diameter + 1.0f) / 2.0f))) continue;
            ++perfectParticles;
        }
        float percentagePerfect = (float)perfectParticles / (float)this.totalParticles;
        if ((double)percentagePerfect > 0.75) {
            this.cachedCenterPoint = center;
        }
    }

    private static Point2D.Double rotatePoint(Point2D.Double point, Point2D.Double center, double degrees) {
        double radians = Math.toRadians(degrees);
        double newX = center.getX() + (point.getX() - center.getX()) * Math.cos(radians) - (point.getY() - center.getY()) * Math.sin(radians);
        double newY = center.getY() + (point.getX() - center.getX()) * Math.sin(radians) + (point.getY() - center.getY()) * Math.cos(radians);
        return new Point2D.Double(newX, newY);
    }

    private static Point2D.Double lineLineIntersection(Point2D.Double a, Point2D.Double b, Point2D.Double c, Point2D.Double d) {
        double a1 = b.y - a.y;
        double b1 = a.x - b.x;
        double c1 = a1 * a.x + b1 * a.y;
        double a2 = d.y - c.y;
        double b2 = c.x - d.x;
        double c2 = a2 * c.x + b2 * c.y;
        double determinant = a1 * b2 - a2 * b1;
        if (determinant == 0.0) {
            return new Point2D.Double(Double.NaN, Double.NaN);
        }
        double x = (b2 * c1 - b1 * c2) / determinant;
        double y = (a1 * c2 - a2 * c1) / determinant;
        return new Point2D.Double(x, y);
    }

    public void removeOldParticles() {
        Iterator<HealingCircleParticle> healingCircleParticleIterator = this.healingCircleParticles.iterator();
        while (healingCircleParticleIterator.hasNext()) {
            HealingCircleParticle healingCircleParticle = healingCircleParticleIterator.next();
            if (System.currentTimeMillis() - healingCircleParticle.getCreation() <= duration) continue;
            this.totalX -= healingCircleParticle.getPoint().getX();
            this.totalZ -= healingCircleParticle.getPoint().getY();
            --this.totalParticles;
            healingCircleParticleIterator.remove();
        }
    }

    public boolean hasCachedCenterPoint() {
        return this.cachedCenterPoint != null;
    }

    private void calculateRadius() {
        boolean isThePlayerHealer;
        SkyblockAddons main = SkyblockAddons.getInstance();
        HashMap<String, DungeonPlayer> teammates = main.getDungeonManager().getTeammates();
        Pair<DungeonClass, Integer> thePlayerClass = main.getDungeonManager().getThePlayerClass();
        boolean bl = isThePlayerHealer = thePlayerClass != null && thePlayerClass.getLeft() == DungeonClass.HEALER;
        if (teammates.isEmpty() && isThePlayerHealer) {
            int thePlayerClassLevel = thePlayerClass.getRight();
            radius = 5.5f + (float)Math.floor((float)thePlayerClassLevel / 5.0f) * 0.5f;
            diameter = radius * 2.0f;
            duration = (10L + (long)Math.floor((float)thePlayerClassLevel / 5.0f)) * 1000L;
        } else if (!teammates.isEmpty()) {
            int healerCounter = 0;
            DungeonPlayer healerData = null;
            for (DungeonPlayer teammateData : teammates.values()) {
                if (teammateData.getDungeonClass() != DungeonClass.HEALER) continue;
                ++healerCounter;
                healerData = teammateData;
            }
            if (healerCounter == 1 && !isThePlayerHealer) {
                int healerClassLevel = healerData.getClassLevel();
                radius = 5.5f + (float)Math.floor((float)healerClassLevel / 5.0f) * 0.5f;
                diameter = radius * 2.0f;
                duration = (10L + (long)Math.floor((float)healerClassLevel / 5.0f)) * 1000L;
            } else if (healerCounter == 0 && isThePlayerHealer) {
                int thePlayerClassLevel = thePlayerClass.getRight();
                radius = 5.5f + (float)Math.floor((float)thePlayerClassLevel / 5.0f) * 0.5f;
                diameter = radius * 2.0f;
                duration = (10L + (long)Math.floor((float)thePlayerClassLevel / 5.0f)) * 1000L;
            } else {
                radius = 6.0f;
                diameter = 12.0f;
                duration = 10000L;
            }
        } else {
            radius = 6.0f;
            diameter = 12.0f;
            duration = 10000L;
        }
    }

    @Generated
    public List<HealingCircleParticle> getHealingCircleParticles() {
        return this.healingCircleParticles;
    }

    @Generated
    public long getCreation() {
        return this.creation;
    }

    @Generated
    public Point2D.Double getCachedCenterPoint() {
        return this.cachedCenterPoint;
    }

    @Generated
    public double getTotalX() {
        return this.totalX;
    }

    @Generated
    public double getTotalZ() {
        return this.totalZ;
    }

    @Generated
    public int getTotalParticles() {
        return this.totalParticles;
    }

    @Generated
    public void setHealingCircleParticles(List<HealingCircleParticle> healingCircleParticles) {
        this.healingCircleParticles = healingCircleParticles;
    }

    @Generated
    public void setCreation(long creation) {
        this.creation = creation;
    }

    @Generated
    public void setCachedCenterPoint(Point2D.Double cachedCenterPoint) {
        this.cachedCenterPoint = cachedCenterPoint;
    }

    @Generated
    public void setTotalX(double totalX) {
        this.totalX = totalX;
    }

    @Generated
    public void setTotalZ(double totalZ) {
        this.totalZ = totalZ;
    }

    @Generated
    public void setTotalParticles(int totalParticles) {
        this.totalParticles = totalParticles;
    }

    @Generated
    public static float getRadius() {
        return radius;
    }

    @Generated
    public static void setRadius(float radius) {
        HealingCircle.radius = radius;
    }

    @Generated
    public static float getDiameter() {
        return diameter;
    }
}

