/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features.slayertracker;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.SkyblockRune;
import com.fix3dll.skyblockaddons.core.Translations;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.features.slayertracker.SlayerBoss;
import com.fix3dll.skyblockaddons.features.slayertracker.SlayerDrop;
import com.fix3dll.skyblockaddons.features.slayertracker.SlayerTrackerData;
import com.fix3dll.skyblockaddons.utils.DevUtils;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import com.fix3dll.skyblockaddons.utils.ItemUtils;
import com.fix3dll.skyblockaddons.utils.Utils;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import net.minecraft.class_2487;

public class SlayerTracker {
    private static final SlayerTracker instance = new SlayerTracker();
    private static final SkyblockAddons main = SkyblockAddons.getInstance();

    public int getSlayerKills(SlayerBoss slayerBoss) {
        SlayerTrackerData slayerTrackerData = main.getPersistentValuesManager().getPersistentValues().getSlayerTracker();
        return slayerTrackerData.getSlayerKills().getOrDefault((Object)slayerBoss, 0);
    }

    public int getDropCount(SlayerDrop slayerDrop) {
        SlayerTrackerData slayerTrackerData = main.getPersistentValuesManager().getPersistentValues().getSlayerTracker();
        return slayerTrackerData.getSlayerDropCounts().getOrDefault((Object)slayerDrop, 0);
    }

    public boolean isTrackerEnabled() {
        return Feature.REVENANT_SLAYER_TRACKER.isEnabled() || Feature.TARANTULA_SLAYER_TRACKER.isEnabled() || Feature.SVEN_SLAYER_TRACKER.isEnabled() || Feature.VOIDGLOOM_SLAYER_TRACKER.isEnabled() || Feature.INFERNO_SLAYER_TRACKER.isEnabled() || Feature.RIFTSTALKER_SLAYER_TRACKER.isEnabled();
    }

    public void completedSlayer(String slayerTypeText) {
        SlayerBoss slayerBoss = SlayerBoss.getFromMobType(slayerTypeText);
        if (slayerBoss != null) {
            SlayerTrackerData slayerTrackerData = main.getPersistentValuesManager().getPersistentValues().getSlayerTracker();
            slayerTrackerData.getSlayerKills().put(slayerBoss, slayerTrackerData.getSlayerKills().getOrDefault((Object)slayerBoss, 0) + 1);
            slayerTrackerData.setLastKilledBoss(slayerBoss);
            main.getPersistentValuesManager().saveValues();
        }
    }

    public void resetAllStats(String slayerType) {
        SlayerBoss slayerBoss = SlayerBoss.getFromMobType(slayerType);
        if (slayerBoss == null) {
            throw new IllegalArgumentException(Translations.getMessage("commandUsage.sba.slayer.invalidBoss", slayerType));
        }
        SlayerTrackerData slayerTrackerData = main.getPersistentValuesManager().getPersistentValues().getSlayerTracker();
        slayerTrackerData.getSlayerKills().put(slayerBoss, 0);
        for (SlayerDrop slayerDrop : slayerBoss.getDrops()) {
            slayerTrackerData.getSlayerDropCounts().put(slayerDrop, 0);
        }
        main.getPersistentValuesManager().saveValues();
        Utils.sendMessage(Translations.getMessage("commands.responses.sba.slayer.resetBossStats", slayerType));
    }

    public void setStatManually(String boss, String stat, int value) {
        SlayerDrop slayerDrop;
        SlayerBoss slayerBoss = SlayerBoss.getFromMobType(boss);
        if (slayerBoss == null) {
            throw new IllegalArgumentException(Translations.getMessage("commandUsage.sba.slayer.invalidBoss", boss));
        }
        SlayerTrackerData slayerTrackerData = main.getPersistentValuesManager().getPersistentValues().getSlayerTracker();
        if ("kills".equalsIgnoreCase(stat)) {
            slayerTrackerData.getSlayerKills().put(slayerBoss, value);
            Utils.sendMessage(Translations.getMessage("commandUsage.sba.slayer.killsSet", boss, value));
            main.getPersistentValuesManager().saveValues();
            return;
        }
        try {
            slayerDrop = SlayerDrop.valueOf(stat.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException ex) {
            slayerDrop = null;
        }
        if (slayerDrop != null) {
            slayerTrackerData.getSlayerDropCounts().put(slayerDrop, value);
            Utils.sendMessage(Translations.getMessage("commandUsage.sba.slayer.statSet", stat, boss, value));
            main.getPersistentValuesManager().saveValues();
            return;
        }
        throw new IllegalArgumentException(Translations.getMessage("commandUsage.sba.slayer.invalidStat", boss));
    }

    public void addToTrackerData(class_2487 ea, int amount, EnumUtils.SlayerQuest activeQuest) {
        SlayerTrackerData slayerTrackerData = main.getPersistentValuesManager().getPersistentValues().getSlayerTracker();
        for (SlayerDrop drop : activeQuest.getBoss().getDrops()) {
            SkyblockRune rune;
            if (!drop.getSkyblockID().equals(ItemUtils.getSkyblockItemID(ea)) || drop.getRuneID() != null && ((rune = ItemUtils.getRuneData(ea)) == null || rune.getType() == null || !rune.getType().equals(drop.getRuneID())) || drop.getAttributeNbtKey() != null && !ItemUtils.getAttributes(ea).containsKey(drop.getAttributeNbtKey())) continue;
            if (drop.getSkyblockID().equals("ENCHANTED_BOOK")) {
                Map<String, Integer> diffTag = ItemUtils.getEnchantments(ea);
                Map<String, Integer> dropTag = ItemUtils.getEnchantments(drop.getItemStack());
                if (!dropTag.equals(diffTag)) continue;
            }
            slayerTrackerData.getSlayerDropCounts().put(drop, slayerTrackerData.getSlayerDropCounts().getOrDefault((Object)drop, 0) + amount);
            if (!DevUtils.isLoggingSlayerTracker()) continue;
            Utils.sendMessage(String.format("\u00a7fx%d \u00a7%s%s", amount, Character.valueOf(drop.getRarity().getColorCode().getCode()), drop.getDisplayName()), true);
        }
    }

    @Generated
    public static SlayerTracker getInstance() {
        return instance;
    }
}

