/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.features.tablist;

import com.fix3dll.skyblockaddons.core.render.state.SbaTextRenderState;
import com.fix3dll.skyblockaddons.features.tablist.RenderColumn;
import com.fix3dll.skyblockaddons.features.tablist.TabLine;
import com.fix3dll.skyblockaddons.features.tablist.TabListParser;
import com.fix3dll.skyblockaddons.features.tablist.TabStringType;
import com.fix3dll.skyblockaddons.utils.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_11247;
import net.minecraft.class_2477;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_355;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_640;
import net.minecraft.class_7532;
import net.minecraft.class_8685;
import org.joml.Matrix3x2f;

public class TabListRenderer {
    public static final int MAX_LINES = 22;
    private static final int LINE_HEIGHT = 9;
    private static final int PADDING = 3;
    private static final int COLUMN_SPACING = 6;

    /*
     * WARNING - void declaration
     */
    public static void render(class_332 graphics) {
        void var6_11;
        int n;
        class_310 mc = class_310.method_1551();
        List<RenderColumn> columns = TabListParser.getRenderColumns().combinedRenderColumns();
        if (columns == null) {
            return;
        }
        List<class_640> playerInfos = TabListParser.getRenderColumns().vanillaPlayerInfos();
        int maxLines = 0;
        for (RenderColumn renderColumn : columns) {
            maxLines = Math.max(maxLines, renderColumn.getLines().size());
        }
        int totalWidth = 0;
        for (RenderColumn renderColumn : columns) {
            totalWidth += renderColumn.getMaxWidth() + 6;
        }
        totalWidth -= 6;
        int n2 = maxLines * 9;
        class_355 tabList = mc.field_1705.method_1750();
        ArrayList<String> header = null;
        if (tabList.field_2153 != null) {
            String legacyFormattedHeader = TextUtils.getFormattedText(tabList.field_2153);
            header = new ArrayList<String>(Arrays.asList(legacyFormattedHeader.split("\n")));
            header.removeIf(line -> !line.contains("HYPIXEL.NET"));
            n = n2 + (header.size() * 9 + 3);
        }
        ArrayList<String> footer = null;
        if (tabList.field_2154 != null) {
            String legacyFormatteFooter = TextUtils.getFormattedText(tabList.field_2154);
            footer = new ArrayList<String>(Arrays.asList(legacyFormatteFooter.split("\n")));
            footer.removeIf(line -> !line.contains("HYPIXEL.NET"));
            var6_11 = n + (footer.size() * 9 + 3);
        }
        int screenWidth = mc.method_22683().method_4486() / 2;
        int x = screenWidth - totalWidth / 2;
        int y = 10;
        graphics.method_25294(x - 6, y - 3, screenWidth + totalWidth / 2 + 6, 10 + var6_11 + 3, Integer.MIN_VALUE);
        int headerY = y;
        if (header != null) {
            for (String string : header) {
                class_5481 lineFcs = class_2477.method_10517().method_30934(class_5348.method_29430((String)string));
                graphics.field_59826.method_70921((class_11247)new SbaTextRenderState(lineFcs, (Matrix3x2f)graphics.method_51448(), (float)x + (float)totalWidth / 2.0f - (float)mc.field_1772.method_1727(string) / 2.0f, headerY, -1, 0, true, graphics.field_44659.method_70863()));
                headerY += 9;
            }
            headerY += 3;
        }
        int middleX = x;
        for (RenderColumn renderColumn : columns) {
            int middleY = headerY;
            graphics.method_25294(middleX - 3 + 1, middleY - 3 + 1, middleX + renderColumn.getMaxWidth() + 3 - 2, middleY + renderColumn.getLines().size() * 9 + 3 - 2, 0x20AAAAAA);
            for (TabLine tabLine : renderColumn.getLines()) {
                int savedX = middleX;
                if (tabLine.type() == TabStringType.PLAYER) {
                    if (tabLine.vanillaIndex() != -1 && tabLine.vanillaIndex() < playerInfos.size()) {
                        class_640 playerInfo = playerInfos.get(tabLine.vanillaIndex());
                        class_7532.method_52722((class_332)graphics, (class_8685)playerInfo.method_52810(), (int)middleX, (int)middleY, (int)8);
                    }
                    middleX += 10;
                }
                class_5481 tabLineTextFcs = class_2477.method_10517().method_30934(class_5348.method_29430((String)tabLine.text()));
                if (tabLine.type() == TabStringType.TITLE) {
                    graphics.field_59826.method_70921((class_11247)new SbaTextRenderState(tabLineTextFcs, (Matrix3x2f)graphics.method_51448(), (float)middleX + (float)renderColumn.getMaxWidth() / 2.0f - (float)tabLine.getWidth() / 2.0f, middleY, -1, 0, true, graphics.field_44659.method_70863()));
                } else {
                    graphics.field_59826.method_70921((class_11247)new SbaTextRenderState(tabLineTextFcs, (Matrix3x2f)graphics.method_51448(), middleX, middleY, -1, 0, true, graphics.field_44659.method_70863()));
                }
                middleY += 9;
                middleX = savedX;
            }
            middleX += renderColumn.getMaxWidth() + 6;
        }
        if (footer != null) {
            int n3 = y + var6_11 - footer.size() * 9;
            for (String line3 : footer) {
                void var15_25;
                class_5481 lineFcs = class_2477.method_10517().method_30934(class_5348.method_29430((String)line3));
                graphics.field_59826.method_70921((class_11247)new SbaTextRenderState(lineFcs, (Matrix3x2f)graphics.method_51448(), (float)x + (float)totalWidth / 2.0f - (float)mc.field_1772.method_1727(line3) / 2.0f, (float)var15_25, -1, 0, true, graphics.field_44659.method_70863()));
                var15_25 += 9;
            }
        }
    }
}

