/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.gui.buttons;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.gui.buttons.SkyblockAddonsButton;
import com.fix3dll.skyblockaddons.gui.screens.SettingsGui;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class ButtonCycling
extends SkyblockAddonsButton {
    private static final class_2960 ARROW_LEFT = SkyblockAddons.resourceLocation("gui/flatarrowleft.png");
    private static final class_2960 ARROW_RIGHT = SkyblockAddons.resourceLocation("gui/flatarrowright.png");
    private final List<SelectItem> itemList;
    private int index;
    private final int textWidth;
    private final Consumer<Integer> callback;
    private final boolean isSettingsGui;

    public ButtonCycling(int x, int y, int width, int height, List<SelectItem> items, int selectedIndex, Consumer<Integer> callback) {
        super(x, y, (class_2561)class_2561.method_43473());
        if (items == null || items.isEmpty()) {
            throw new IllegalArgumentException("Item list must have at least one element.");
        }
        if (callback == null) {
            throw new IllegalArgumentException("ButtonCycling's callback cannot be null!");
        }
        this.textWidth = width - 2 * height - 6;
        this.field_22758 = width;
        this.field_22759 = height;
        this.itemList = items;
        this.index = selectedIndex > 0 && selectedIndex < this.itemList.size() ? selectedIndex : 0;
        this.callback = callback;
        this.isSettingsGui = class_310.method_1551().field_1755 instanceof SettingsGui;
    }

    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        String trimmedName;
        int leftColor = main.getUtils().getDefaultColor(this.isOverLeftButton(mouseX, mouseY) ? 200.0f : 90.0f);
        int rightColor = main.getUtils().getDefaultColor(this.isOverRightButton(mouseX, mouseY) ? 200.0f : 90.0f);
        String name = this.itemList.get(this.index).getDisplayName();
        if (!name.equals(trimmedName = ButtonCycling.MC.field_1772.method_27523(name, this.textWidth))) {
            trimmedName = this.ellipsize(trimmedName);
        }
        String description = this.itemList.get(this.index).getDescription();
        graphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, main.getUtils().getDefaultColor(100.0f));
        graphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22759, this.method_46427() + this.field_22759, leftColor);
        graphics.method_25294(this.method_46426() + this.field_22758 - this.field_22759, this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, rightColor);
        graphics.method_25300(ButtonCycling.MC.field_1772, trimmedName, this.method_46426() + this.field_22758 / 2, this.method_46427() + this.field_22759 / 4, ColorCode.WHITE.getColor());
        graphics.method_25291(class_10799.field_56883, ARROW_LEFT, this.method_46426(), this.method_46427(), 0.0f, 0.0f, this.field_22759, this.field_22759, this.field_22759, this.field_22759, -1);
        graphics.method_25291(class_10799.field_56883, ARROW_RIGHT, this.method_46426() + this.field_22758 - this.field_22759, this.method_46427(), 0.0f, 0.0f, this.field_22759, this.field_22759, this.field_22759, this.field_22759, -1);
        if (!name.equals(trimmedName) && this.isOverText(mouseX, mouseY)) {
            graphics.method_51438(ButtonCycling.MC.field_1772, (class_2561)class_2561.method_43470((String)name), mouseX, mouseY);
        }
        if (description != null) {
            if (this.isSettingsGui) {
                graphics.method_25300(ButtonCycling.MC.field_1772, description, this.method_46426() + this.field_22758 / 2, this.method_46427() + this.field_22759 + 2, ColorCode.GRAY.getColor());
            } else if (this.isOverText(mouseX, mouseY)) {
                graphics.method_51438(ButtonCycling.MC.field_1772, (class_2561)class_2561.method_43470((String)description), mouseX, mouseY);
            }
        }
    }

    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        if (this.isOverLeftButton(event.comp_4798(), event.comp_4799())) {
            this.index = this.index == this.itemList.size() - 1 ? 0 : this.index + 1;
            this.callback.accept(this.index);
            this.method_25354(class_310.method_1551().method_1483());
            return true;
        }
        if (this.isOverRightButton(event.comp_4798(), event.comp_4799())) {
            this.index = this.index == 0 ? this.itemList.size() - 1 : this.index - 1;
            this.callback.accept(this.index);
            this.method_25354(class_310.method_1551().method_1483());
            return true;
        }
        return false;
    }

    private boolean isOverText(double mouseX, double mouseY) {
        return mouseX > (double)(this.method_46426() + this.field_22759) && mouseX < (double)(this.method_46426() + this.field_22758 - this.field_22759) && mouseY > (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759);
    }

    private boolean isOverLeftButton(double mouseX, double mouseY) {
        return mouseX > (double)this.method_46426() && mouseX < (double)(this.method_46426() + this.field_22759) && mouseY > (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759);
    }

    private boolean isOverRightButton(double mouseX, double mouseY) {
        return mouseX > (double)(this.method_46426() + this.field_22758 - this.field_22759) && mouseX < (double)(this.method_46426() + this.field_22758) && mouseY > (double)this.method_46427() && mouseY < (double)(this.method_46427() + this.field_22759);
    }

    private String ellipsize(String text) {
        return new StringBuilder(text).replace(text.length() - 1, text.length(), "\u2026").toString();
    }

    public static interface SelectItem {
        public String getDisplayName();

        public String getDescription();
    }
}

