/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.gui.buttons;

import com.fix3dll.skyblockaddons.gui.buttons.SkyblockAddonsButton;
import com.fix3dll.skyblockaddons.gui.buttons.UpdateCallback;
import com.fix3dll.skyblockaddons.utils.MathUtils;
import com.fix3dll.skyblockaddons.utils.TextUtils;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_9848;

public class ButtonSlider
extends SkyblockAddonsButton {
    private final float min;
    private final float max;
    private final float step;
    private final UpdateCallback<Float> sliderCallback;
    private String prefix = "";
    private boolean dragging;
    private float normalizedValue;
    private double previousDoubleMouseX = -1.0;

    public ButtonSlider(double x, double y, int width, int height, float value, float min, float max, float step, UpdateCallback<Float> sliderCallback) {
        super((int)x, (int)y, (class_2561)class_2561.method_43470((String)TextUtils.roundForString(value, 2)));
        this.field_22758 = width;
        this.field_22759 = height;
        this.sliderCallback = sliderCallback;
        this.min = min;
        this.max = max;
        this.step = step;
        this.normalizedValue = MathUtils.normalizeSliderValue(value, min, max, step);
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.field_22762 = this.isHovered(mouseX, mouseY);
        int boxAlpha = this.field_22762 ? 170 : 100;
        graphics.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, main.getUtils().getDefaultColor(boxAlpha));
        this.onDrag(graphics, mouseX, mouseY);
        int i = this.field_22763 ? 0xFFFFFF : 0xA0A0A0;
        this.method_49604(graphics, ButtonSlider.MC.field_1772, 2, i | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
    }

    protected void onDrag(class_332 graphics, double mouseX, double mouseY) {
        if (this.field_22764) {
            double doubleMouseX = ButtonSlider.MC.field_1729.method_1603() * (double)MC.method_22683().method_4486() / (double)MC.method_22683().method_4489();
            if (this.dragging && this.previousDoubleMouseX != doubleMouseX) {
                this.previousDoubleMouseX = doubleMouseX;
                this.normalizedValue = (float)((doubleMouseX - (double)(this.method_46426() + 4)) / (double)(this.field_22758 - 8));
                this.normalizedValue = class_3532.method_15363((float)this.normalizedValue, (float)0.0f, (float)1.0f);
                this.onUpdate();
            }
            graphics.method_52707(class_10799.field_56883, SPRITES.method_52729(this.field_22763, this.field_22762), this.method_46426() + (int)(this.normalizedValue * (float)(this.field_22758 - 8)) + 1, this.method_46427(), 6, this.method_25364(), class_9848.method_61317((float)this.field_22765));
        }
    }

    public void method_25357(class_11909 event) {
        this.dragging = false;
    }

    public void method_25348(class_11909 event, boolean isDoubleClick) {
        this.normalizedValue = (float)(event.comp_4798() - (double)(this.method_46426() + 4)) / (float)(this.field_22758 - 8);
        this.normalizedValue = class_3532.method_15363((float)this.normalizedValue, (float)0.0f, (float)1.0f);
        this.dragging = true;
        this.onUpdate();
    }

    public ButtonSlider setPrefix(String text) {
        this.prefix = text;
        this.updateDisplayString();
        return this;
    }

    private void onUpdate() {
        this.sliderCallback.onUpdate(Float.valueOf(this.denormalize()));
        this.updateDisplayString();
    }

    private void updateDisplayString() {
        this.method_25355((class_2561)class_2561.method_43470((String)(this.prefix + TextUtils.roundForString(this.denormalize(), 2))));
    }

    public float denormalize() {
        return MathUtils.denormalizeSliderValue(this.normalizedValue, this.min, this.max, this.step);
    }
}

