/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.gui.elements;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.render.state.BlitAbsoluteRenderState;
import com.fix3dll.skyblockaddons.listeners.RenderListener;
import com.fix3dll.skyblockaddons.utils.DrawUtils;
import com.fix3dll.skyblockaddons.utils.Utils;
import lombok.Generated;
import net.minecraft.class_10799;
import net.minecraft.class_11244;
import net.minecraft.class_11909;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;

public class CheckBox {
    private static final class_2960 ICONS = SkyblockAddons.resourceLocation("gui/checkbox.png");
    private static final int ICON_SIZE = 16;
    private final float scale;
    private final int x;
    private final int y;
    private final String text;
    private final int textWidth;
    private final int size;
    private boolean value;
    private OnToggleListener onToggleListener;

    public CheckBox(int x, int y, int size, String text, boolean value) {
        this(x, y, size, text);
        this.value = value;
    }

    CheckBox(int x, int y, int size, String text) {
        this.x = x;
        this.y = y;
        this.scale = (float)size / 16.0f;
        this.text = text;
        this.textWidth = class_310.method_1551().field_1772.method_1727(text);
        this.size = size;
    }

    public void draw(class_332 graphics) {
        int scaledX = Math.round((float)this.x / this.scale);
        int scaledY = Math.round((float)this.y / this.scale);
        Matrix3x2fStack poseStack = graphics.method_51448();
        poseStack.pushMatrix();
        poseStack.scale(this.scale, this.scale);
        int color = this.value ? ColorCode.WHITE.getColor() : ColorCode.GRAY.getColor();
        DrawUtils.drawText(graphics, this.text, scaledX + Math.round((float)this.size * 1.5f / this.scale), (float)scaledY + (float)this.size / 2.0f, color);
        float uOffset = this.value ? 16.0f : 0.0f;
        graphics.field_59826.method_70919((class_11244)new BlitAbsoluteRenderState(class_10799.field_56883, RenderListener.textureSetup(ICONS), (Matrix3x2f)graphics.method_51448(), scaledX, scaledY, uOffset, 0.0f, 16.0f, 16.0f, 32.0f, 16.0f, -1, graphics.field_44659.method_70863()));
        poseStack.popMatrix();
    }

    public void onMouseClick(class_11909 event, boolean isDoubleClick) {
        if (event.method_74245() == 0 && event.comp_4798() > (double)this.x && event.comp_4798() < (double)(this.x + this.size + this.textWidth) && event.comp_4799() > (double)this.y && event.comp_4799() < (double)(this.y + this.size)) {
            this.value = !this.value;
            Utils.playSound((class_3414)class_3417.field_15015.comp_349(), 0.25, 1.0);
            if (this.onToggleListener != null) {
                this.onToggleListener.onToggle(this.value);
            }
            Utils.blockNextClick = true;
        }
    }

    @Generated
    public boolean isValue() {
        return this.value;
    }

    @Generated
    public void setValue(boolean value) {
        this.value = value;
    }

    @Generated
    public void setOnToggleListener(OnToggleListener onToggleListener) {
        this.onToggleListener = onToggleListener;
    }

    @FunctionalInterface
    public static interface OnToggleListener {
        public void onToggle(boolean var1);
    }
}

