/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.gui.screens;

import com.fix3dll.skyblockaddons.core.ColorCode;
import com.fix3dll.skyblockaddons.core.SkyblockKeyBinding;
import com.fix3dll.skyblockaddons.core.Translations;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.feature.FeatureGuiData;
import com.fix3dll.skyblockaddons.core.feature.FeatureSetting;
import com.fix3dll.skyblockaddons.core.render.state.FillAbsoluteRenderState;
import com.fix3dll.skyblockaddons.features.dungeonmap.DungeonMapManager;
import com.fix3dll.skyblockaddons.gui.buttons.ButtonCycling;
import com.fix3dll.skyblockaddons.gui.buttons.feature.ButtonColorWheel;
import com.fix3dll.skyblockaddons.gui.buttons.feature.ButtonLocation;
import com.fix3dll.skyblockaddons.gui.buttons.feature.ButtonResize;
import com.fix3dll.skyblockaddons.gui.buttons.feature.ButtonSolid;
import com.fix3dll.skyblockaddons.gui.screens.SettingsGui;
import com.fix3dll.skyblockaddons.gui.screens.SkyblockAddonsScreen;
import com.fix3dll.skyblockaddons.utils.DrawUtils;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import com.fix3dll.skyblockaddons.utils.Utils;
import com.fix3dll.skyblockaddons.utils.objects.Pair;
import com.google.common.collect.Sets;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import net.minecraft.class_1041;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.joml.Matrix3x2f;

public class LocationEditGui
extends SkyblockAddonsScreen {
    private static final int BOX_HEIGHT = 20;
    private static final int SNAPPING_RADIUS = 120;
    private static final int SNAP_PULL = 1;
    private static EditMode editMode = EditMode.RESCALE_FEATURES;
    private Feature draggedFeature;
    private static boolean resizing;
    private ButtonResize.Corner resizingCorner;
    private float xOffset;
    private float yOffset;
    private final int lastPage;
    private final EnumUtils.GuiTab lastTab;
    private final Map<Feature, ButtonLocation> buttonLocations = new EnumMap<Feature, ButtonLocation>(Feature.class);
    private boolean closing = false;
    private static boolean tipShown;
    private class_332 guiGraphics;
    private boolean isMiddlePressed = false;

    public LocationEditGui(int lastPage, EnumUtils.GuiTab lastTab) {
        super((class_2561)class_2561.method_43473());
        this.lastPage = lastPage;
        this.lastTab = lastTab;
    }

    public void method_25426() {
        super.method_25426();
        for (Feature feature : Feature.getGuiFeatures()) {
            if (!feature.isGuiFeature() || !feature.isEnabled()) continue;
            ButtonLocation buttonLocation = new ButtonLocation(feature);
            this.method_37063((class_364)buttonLocation);
            this.buttonLocations.put(feature, buttonLocation);
        }
        if (editMode != EditMode.NONE) {
            this.addResizeButtons();
        }
        if (Feature.SHOW_COLOR_ICONS.isEnabled()) {
            this.addColorWheelsToAllFeatures();
        }
        class_1041 window = MC.method_22683();
        LinkedHashSet<Feature> guiFeatures = Feature.getEditGuiFeatures();
        guiFeatures.removeIf(Feature::isRemoteDisabled);
        int numButtons = guiFeatures.size();
        int y = window.method_4502() / 2;
        y = numButtons % 2 == 0 ? (y -= Math.round((float)numButtons / 2.0f * 25.0f) - 5) : (y -= Math.round((float)(numButtons - 1) / 2.0f * 25.0f) + 20);
        for (Feature feature : guiFeatures) {
            int boxWidth;
            String featureName = feature.getMessage(new String[0]);
            int n = boxWidth = feature == Feature.RESCALE_FEATURES ? 140 : LocationEditGui.MC.field_1772.method_1727(featureName) + 10;
            if (boxWidth > 140) {
                boxWidth = 140;
            }
            int x = window.method_4486() / 2 - boxWidth / 2;
            y += 25;
            if (feature == Feature.RESCALE_FEATURES) {
                this.method_37063((class_364)new ButtonCycling(x, y, boxWidth, 20, Arrays.asList(EditMode.values()), editMode.ordinal(), index -> {
                    editMode = EditMode.values()[index];
                    this.closing = true;
                    MC.method_1507((class_437)new LocationEditGui(this.lastPage, this.lastTab));
                    this.closing = false;
                    this.addResizeButtons();
                }));
                continue;
            }
            if (feature == Feature.RESET_LOCATION) {
                this.method_37063((class_364)new ButtonSolid(x, y, boxWidth, 20, featureName, feature, 0xFF7878, false));
                continue;
            }
            this.method_37063((class_364)new ButtonSolid(x, y, boxWidth, 20, featureName, feature, true));
        }
        if (LocationEditGui.MC.field_1724 != null && !tipShown) {
            tipShown = true;
            Utils.sendMessage(String.valueOf(ColorCode.GREEN) + Translations.getMessage("messages.locationEditGui.atOpening", new Object[0]));
        }
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.guiGraphics = graphics;
        Snap[] snaps = this.checkSnapping();
        this.onMouseMove(mouseX, mouseY, snaps);
        if (editMode != EditMode.NONE) {
            this.recalculateResizeButtons();
        }
        if (Feature.SHOW_COLOR_ICONS.isEnabled()) {
            this.recalculateColorWheels();
        }
        this.drawGradientBackground(graphics, 64, 128);
        Feature lastHoveredFeature = ButtonLocation.getLastHoveredFeature();
        for (EnumUtils.AnchorPoint anchorPoint : EnumUtils.AnchorPoint.values()) {
            int x = anchorPoint.getX(MC.method_22683().method_4486());
            int y = anchorPoint.getY(MC.method_22683().method_4502());
            int color = lastHoveredFeature != null && lastHoveredFeature.getAnchorPoint() == anchorPoint ? ColorCode.RED.getColor(127) : ColorCode.YELLOW.getColor(127);
            graphics.field_59826.method_70919((class_11244)new FillAbsoluteRenderState(class_10799.field_56879, class_11231.method_70899(), (Matrix3x2f)graphics.method_51448(), x - 4, y - 4, x + 4, y + 4, color, graphics.field_44659.method_70863()));
        }
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        if (snaps != null) {
            for (Snap snap : snaps) {
                if (snap == null) continue;
                float left = snap.getRectangle().get((Object)Edge.LEFT).floatValue();
                float top = snap.getRectangle().get((Object)Edge.TOP).floatValue();
                float right = snap.getRectangle().get((Object)Edge.RIGHT).floatValue();
                float bottom = snap.getRectangle().get((Object)Edge.BOTTOM).floatValue();
                if ((double)snap.getWidth() < 0.5) {
                    float averageX = (left + right) / 2.0f;
                    left = averageX - 0.25f;
                    right = averageX + 0.25f;
                }
                if ((double)snap.getHeight() < 0.5) {
                    float averageY = (top + bottom) / 2.0f;
                    top = averageY - 0.25f;
                    bottom = averageY + 0.25f;
                }
                int color = (double)(right - left) == 0.5 || (double)(bottom - top) == 0.5 ? -16711936 : -65536;
                graphics.field_59826.method_70919((class_11244)new FillAbsoluteRenderState(class_10799.field_56879, class_11231.method_70899(), (Matrix3x2f)graphics.method_51448(), left, top, right, bottom, color, graphics.field_44659.method_70863()));
            }
        }
        ButtonLocation lastHoveredButton = resizing ? this.buttonLocations.get((Object)this.draggedFeature) : this.getHoveredFeatureButton(mouseX, mouseY);
        this.drawFeatureCoords(graphics, lastHoveredButton);
        if (lastHoveredButton != null && this.isMiddlePressed) {
            this.closing = true;
            MC.method_1507((class_437)new SettingsGui(lastHoveredButton.feature, 1, this.lastPage, this.lastTab, EnumUtils.GUIType.EDIT_LOCATIONS));
        }
    }

    private void addResizeButtons() {
        this.clearAllResizeButtons();
        switch (editMode.ordinal()) {
            case 1: {
                for (Feature feature : Feature.getGuiFeatures()) {
                    FeatureGuiData guiFeatureData;
                    if (!feature.isEnabled() || (guiFeatureData = feature.getFeatureGuiData()) == null || guiFeatureData.getDrawType() != EnumUtils.DrawType.BAR) continue;
                    this.addResizeCorners(feature);
                }
                break;
            }
            case 0: {
                for (Feature feature : Feature.getGuiFeatures()) {
                    if (!feature.isEnabled()) continue;
                    this.addResizeCorners(feature);
                }
                break;
            }
        }
    }

    private void clearAllResizeButtons() {
        this.method_25396().removeIf(guiEventListener -> guiEventListener instanceof ButtonResize);
        this.field_33816.removeIf(renderable -> renderable instanceof ButtonResize);
    }

    private void clearAllColorWheelButtons() {
        this.method_25396().removeIf(guiEventListener -> guiEventListener instanceof ButtonColorWheel);
        this.field_33816.removeIf(renderable -> renderable instanceof ButtonColorWheel);
    }

    private void addColorWheelsToAllFeatures() {
        for (ButtonLocation buttonLocation : this.buttonLocations.values()) {
            Feature feature = buttonLocation.getFeature();
            if (feature.getFeatureGuiData() == null || feature.getFeatureGuiData().getDefaultColor() == null) continue;
            float scaleX = feature.getFeatureGuiData().getDrawType() == EnumUtils.DrawType.BAR ? feature.getFeatureData().getSizesX() : 1.0f;
            float scaleY = feature.getFeatureGuiData().getDrawType() == EnumUtils.DrawType.BAR ? feature.getFeatureData().getSizesY() : 1.0f;
            float boxXOne = buttonLocation.getBoxXOne() * scaleX;
            float boxXTwo = buttonLocation.getBoxXTwo() * scaleX;
            float boxYOne = buttonLocation.getBoxYOne() * scaleY;
            float boxYTwo = buttonLocation.getBoxYTwo() * scaleY;
            float y = boxYOne + (boxYTwo - boxYOne) / 2.0f - 5.0f;
            float x = feature.getAnchorPoint().isOnLeft() ? boxXTwo + 2.0f : boxXOne - 10.0f - 2.0f;
            this.method_37063((class_364)new ButtonColorWheel((float)Math.round(x), (float)Math.round(y), feature));
        }
    }

    private void addResizeCorners(Feature feature) {
        this.method_25396().removeIf(guiEventListener -> {
            ButtonResize buttonResize;
            return guiEventListener instanceof ButtonResize && (buttonResize = (ButtonResize)((Object)guiEventListener)).getFeature() == feature;
        });
        this.field_33816.removeIf(renderable -> {
            ButtonResize buttonResize;
            return renderable instanceof ButtonResize && (buttonResize = (ButtonResize)((Object)renderable)).getFeature() == feature;
        });
        ButtonLocation buttonLocation = this.buttonLocations.get((Object)feature);
        if (buttonLocation == null) {
            return;
        }
        float scale = buttonLocation.getScale();
        float scaledX1 = buttonLocation.getBoxXOne() * scale * buttonLocation.getScaleX();
        float scaledY1 = buttonLocation.getBoxYOne() * scale * buttonLocation.getScaleY();
        float scaledX2 = buttonLocation.getBoxXTwo() * scale * buttonLocation.getScaleX();
        float scaledY2 = buttonLocation.getBoxYTwo() * scale * buttonLocation.getScaleY();
        this.method_37063((class_364)new ButtonResize(scaledX1, scaledY1, feature, ButtonResize.Corner.TOP_LEFT));
        this.method_37063((class_364)new ButtonResize(scaledX2, scaledY1, feature, ButtonResize.Corner.TOP_RIGHT));
        this.method_37063((class_364)new ButtonResize(scaledX1, scaledY2, feature, ButtonResize.Corner.BOTTOM_LEFT));
        this.method_37063((class_364)new ButtonResize(scaledX2, scaledY2, feature, ButtonResize.Corner.BOTTOM_RIGHT));
    }

    private ButtonLocation getHoveredFeatureButton(double mouseX, double mouseY) {
        ButtonLocation lastHovered = null;
        for (ButtonLocation buttonLocation : this.buttonLocations.values()) {
            if (!buttonLocation.method_25405(mouseX, mouseY)) continue;
            lastHovered = buttonLocation;
        }
        return lastHovered;
    }

    private void recalculateResizeButtons() {
        this.field_33816.forEach(renderable -> {
            if (renderable instanceof ButtonResize) {
                ButtonResize buttonResize = (ButtonResize)((Object)renderable);
                ButtonResize.Corner corner = buttonResize.getCorner();
                Feature feature = buttonResize.getFeature();
                ButtonLocation buttonLocation = this.buttonLocations.get((Object)feature);
                if (buttonLocation == null) {
                    return;
                }
                float scaleX = feature.getFeatureGuiData().getDrawType() == EnumUtils.DrawType.BAR ? feature.getFeatureData().getSizesX() : 1.0f;
                float scaleY = feature.getFeatureGuiData().getDrawType() == EnumUtils.DrawType.BAR ? feature.getFeatureData().getSizesY() : 1.0f;
                float boxXOne = buttonLocation.getBoxXOne() * scaleX;
                float boxXTwo = buttonLocation.getBoxXTwo() * scaleX;
                float boxYOne = buttonLocation.getBoxYOne() * scaleY;
                float boxYTwo = buttonLocation.getBoxYTwo() * scaleY;
                if (corner == ButtonResize.Corner.TOP_LEFT) {
                    buttonResize.resizeX = boxXOne;
                    buttonResize.resizeY = boxYOne;
                } else if (corner == ButtonResize.Corner.TOP_RIGHT) {
                    buttonResize.resizeX = boxXTwo;
                    buttonResize.resizeY = boxYOne;
                } else if (corner == ButtonResize.Corner.BOTTOM_LEFT) {
                    buttonResize.resizeX = boxXOne;
                    buttonResize.resizeY = boxYTwo;
                } else if (corner == ButtonResize.Corner.BOTTOM_RIGHT) {
                    buttonResize.resizeX = boxXTwo;
                    buttonResize.resizeY = boxYTwo;
                }
            }
        });
    }

    private void recalculateColorWheels() {
        this.field_33816.forEach(renderable -> {
            if (renderable instanceof ButtonColorWheel) {
                ButtonColorWheel buttonColorWheel = (ButtonColorWheel)((Object)renderable);
                Feature feature = buttonColorWheel.getFeature();
                ButtonLocation buttonLocation = this.buttonLocations.get((Object)feature);
                if (buttonLocation == null) {
                    return;
                }
                float scaleX = feature.getFeatureGuiData().getDrawType() == EnumUtils.DrawType.BAR ? feature.getFeatureData().getSizesX() : 1.0f;
                float scaleY = feature.getFeatureGuiData().getDrawType() == EnumUtils.DrawType.BAR ? feature.getFeatureData().getSizesY() : 1.0f;
                float boxXOne = buttonLocation.getBoxXOne() * scaleX;
                float boxXTwo = buttonLocation.getBoxXTwo() * scaleX;
                float boxYOne = buttonLocation.getBoxYOne() * scaleY;
                float boxYTwo = buttonLocation.getBoxYTwo() * scaleY;
                float y = boxYOne + (boxYTwo - boxYOne) / 2.0f - 5.0f;
                float x = feature.getAnchorPoint().isOnLeft() ? boxXTwo + 2.0f : boxXOne - 10.0f - 2.0f;
                buttonColorWheel.colorWheelX = x;
                buttonColorWheel.colorWheelY = y;
            }
        });
    }

    public Snap[] checkSnapping() {
        if (Feature.ENABLE_FEATURE_SNAPPING.isDisabled()) {
            return null;
        }
        if (this.draggedFeature != null) {
            ButtonLocation thisButton = this.buttonLocations.get((Object)this.draggedFeature);
            if (thisButton == null) {
                return null;
            }
            Snap horizontalSnap = null;
            Snap verticalSnap = null;
            for (Map.Entry<Feature, ButtonLocation> buttonLocationEntry : this.buttonLocations.entrySet()) {
                Snap thisSnap;
                ButtonLocation otherButton = buttonLocationEntry.getValue();
                if (otherButton == thisButton) continue;
                for (Edge otherEdge : Edge.getHorizontalEdges()) {
                    for (Edge thisEdge : Edge.getHorizontalEdges()) {
                        float bottomY;
                        float topY;
                        float deltaX = otherEdge.getCoordinate(otherButton) - thisEdge.getCoordinate(thisButton);
                        if (!(Math.abs(deltaX) <= 1.0f)) continue;
                        float deltaY = Edge.TOP.getCoordinate(otherButton) - Edge.TOP.getCoordinate(thisButton);
                        if (deltaY > 0.0f) {
                            topY = Edge.BOTTOM.getCoordinate(thisButton);
                            bottomY = Edge.TOP.getCoordinate(otherButton);
                        } else {
                            topY = Edge.BOTTOM.getCoordinate(otherButton);
                            bottomY = Edge.TOP.getCoordinate(thisButton);
                        }
                        float snapX = otherEdge.getCoordinate(otherButton);
                        thisSnap = new Snap(otherEdge.getCoordinate(otherButton), topY, thisEdge.getCoordinate(thisButton), bottomY, thisEdge, otherEdge, snapX);
                        if (!(thisSnap.getHeight() < 120.0f) || horizontalSnap != null && !(thisSnap.getHeight() < horizontalSnap.getHeight())) continue;
                        if (Feature.DEVELOPER_MODE.isEnabled() && this.guiGraphics != null) {
                            this.guiGraphics.field_59826.method_70919((class_11244)new FillAbsoluteRenderState(class_10799.field_56879, class_11231.method_70899(), (Matrix3x2f)this.guiGraphics.method_51448(), snapX - 0.5f, 0.0f, snapX + 0.5f, MC.method_22683().method_4506(), -16776961, this.guiGraphics.field_44659.method_70863()));
                        }
                        horizontalSnap = thisSnap;
                    }
                }
                for (Edge otherEdge : Edge.getVerticalEdges()) {
                    for (Edge thisEdge : Edge.getVerticalEdges()) {
                        float rightX;
                        float leftX;
                        float deltaY = otherEdge.getCoordinate(otherButton) - thisEdge.getCoordinate(thisButton);
                        if (!(Math.abs(deltaY) <= 1.0f)) continue;
                        float deltaX = Edge.LEFT.getCoordinate(otherButton) - Edge.LEFT.getCoordinate(thisButton);
                        if (deltaX > 0.0f) {
                            leftX = Edge.RIGHT.getCoordinate(thisButton);
                            rightX = Edge.LEFT.getCoordinate(otherButton);
                        } else {
                            leftX = Edge.RIGHT.getCoordinate(otherButton);
                            rightX = Edge.LEFT.getCoordinate(thisButton);
                        }
                        float snapY = otherEdge.getCoordinate(otherButton);
                        thisSnap = new Snap(leftX, otherEdge.getCoordinate(otherButton), rightX, thisEdge.getCoordinate(thisButton), thisEdge, otherEdge, snapY);
                        if (!(thisSnap.getWidth() < 120.0f) || verticalSnap != null && !(thisSnap.getWidth() < verticalSnap.getWidth())) continue;
                        if (Feature.DEVELOPER_MODE.isEnabled() && this.guiGraphics != null) {
                            this.guiGraphics.field_59826.method_70919((class_11244)new FillAbsoluteRenderState(class_10799.field_56879, class_11231.method_70899(), (Matrix3x2f)this.guiGraphics.method_51448(), 0.0f, snapY - 0.5f, MC.method_22683().method_4489(), snapY + 0.5f, -16776961, this.guiGraphics.field_44659.method_70863()));
                        }
                        verticalSnap = thisSnap;
                    }
                }
            }
            return new Snap[]{horizontalSnap, verticalSnap};
        }
        return null;
    }

    protected void onMouseMove(int mouseX, int mouseY, Snap[] snaps) {
        ButtonLocation buttonLocation = this.buttonLocations.get((Object)this.draggedFeature);
        if (buttonLocation == null) {
            return;
        }
        float floatMouseX = (float)LocationEditGui.MC.field_1729.method_68879(MC.method_22683());
        float floatMouseY = (float)LocationEditGui.MC.field_1729.method_68883(MC.method_22683());
        float scale = buttonLocation.getScale();
        float scaledX1 = buttonLocation.getBoxXOne() * scale * buttonLocation.getScaleX();
        float scaledY1 = buttonLocation.getBoxYOne() * scale * buttonLocation.getScaleY();
        float scaledX2 = buttonLocation.getBoxXTwo() * scale * buttonLocation.getScaleX();
        float scaledY2 = buttonLocation.getBoxYTwo() * scale * buttonLocation.getScaleY();
        float scaledWidth = scaledX2 - scaledX1;
        float scaledHeight = scaledY2 - scaledY1;
        if (resizing) {
            float scaledMiddleX = (scaledX1 + scaledX2) / 2.0f;
            float scaledMiddleY = (scaledY1 + scaledY2) / 2.0f;
            if (editMode == EditMode.RESIZE_BARS) {
                float scaleX = (floatMouseX - scaledMiddleX) / (this.xOffset - scaledMiddleX);
                float scaleY = (floatMouseY - scaledMiddleY) / (this.yOffset - scaledMiddleY);
                scaleX = Math.max(Math.min(scaleX, 5.0f), 0.25f);
                scaleY = Math.max(Math.min(scaleY, 5.0f), 0.25f);
                this.draggedFeature.getFeatureData().getBarSizes().setLeft(Float.valueOf(scaleX));
                this.draggedFeature.getFeatureData().getBarSizes().setRight(Float.valueOf(scaleY));
                if (this.guiGraphics != null) {
                    buttonLocation.method_48579(this.guiGraphics, mouseX, mouseY, 0.0f);
                }
            } else if (editMode == EditMode.RESCALE_FEATURES) {
                float xOffset = floatMouseX - this.xOffset * scale * buttonLocation.getScaleX() - scaledMiddleX;
                float yOffset = floatMouseY - this.yOffset * scale * buttonLocation.getScaleY() - scaledMiddleY;
                if (this.resizingCorner == ButtonResize.Corner.TOP_LEFT) {
                    xOffset *= -1.0f;
                    yOffset *= -1.0f;
                } else if (this.resizingCorner == ButtonResize.Corner.TOP_RIGHT) {
                    yOffset *= -1.0f;
                } else if (this.resizingCorner == ButtonResize.Corner.BOTTOM_LEFT) {
                    xOffset *= -1.0f;
                }
                float width = buttonLocation.getBoxXTwo() - buttonLocation.getBoxXOne();
                float height = buttonLocation.getBoxYTwo() - buttonLocation.getBoxYOne();
                float newWidth = xOffset * 2.0f;
                float newHeight = yOffset * 2.0f;
                float scaleX = newWidth / width;
                float scaleY = newHeight / height;
                float oldScale = this.draggedFeature.getGuiScale();
                float newScale = Math.max(scaleX, scaleY);
                if (Math.abs(newScale - oldScale) > 0.01f) {
                    this.draggedFeature.setGuiScale(newScale);
                    if (this.guiGraphics != null) {
                        buttonLocation.method_48579(this.guiGraphics, mouseX, mouseY, 0.0f);
                    }
                }
            }
        } else if (this.draggedFeature != null) {
            float snapOffset;
            Snap horizontalSnap = null;
            Snap verticalSnap = null;
            if (snaps != null) {
                horizontalSnap = snaps[0];
                verticalSnap = snaps[1];
            }
            class_1041 window = MC.method_22683();
            float x = floatMouseX - (float)this.draggedFeature.getAnchorPoint().getX(window.method_4486());
            float y = floatMouseY - (float)this.draggedFeature.getAnchorPoint().getY(window.method_4502());
            boolean xSnapped = false;
            boolean ySnapped = false;
            if (horizontalSnap != null) {
                float snapX = horizontalSnap.getSnapValue();
                if (horizontalSnap.getThisSnapEdge() == Edge.LEFT) {
                    snapOffset = Math.abs(floatMouseX - this.xOffset - (snapX + scaledWidth / 2.0f));
                    if (snapOffset <= (float)(1 * window.method_4495())) {
                        xSnapped = true;
                        x = snapX - (float)this.draggedFeature.getAnchorPoint().getX(window.method_4486()) + scaledWidth / 2.0f;
                    }
                } else if (horizontalSnap.getThisSnapEdge() == Edge.RIGHT) {
                    snapOffset = Math.abs(floatMouseX - this.xOffset - (snapX - scaledWidth / 2.0f));
                    if (snapOffset <= (float)(1 * window.method_4495())) {
                        xSnapped = true;
                        x = snapX - (float)this.draggedFeature.getAnchorPoint().getX(window.method_4486()) - scaledWidth / 2.0f;
                    }
                } else if (horizontalSnap.getThisSnapEdge() == Edge.VERTICAL_MIDDLE && (snapOffset = Math.abs(floatMouseX - this.xOffset - snapX)) <= (float)(1 * window.method_4495())) {
                    xSnapped = true;
                    x = snapX - (float)this.draggedFeature.getAnchorPoint().getX(window.method_4486());
                }
            }
            if (verticalSnap != null) {
                float snapY = verticalSnap.getSnapValue();
                if (verticalSnap.getThisSnapEdge() == Edge.TOP) {
                    snapOffset = Math.abs(floatMouseY - this.yOffset - (snapY + scaledHeight / 2.0f));
                    if (snapOffset <= (float)(1 * window.method_4495())) {
                        ySnapped = true;
                        y = snapY - (float)this.draggedFeature.getAnchorPoint().getY(window.method_4502()) + scaledHeight / 2.0f;
                    }
                } else if (verticalSnap.getThisSnapEdge() == Edge.BOTTOM) {
                    snapOffset = Math.abs(floatMouseY - this.yOffset - (snapY - scaledHeight / 2.0f));
                    if (snapOffset <= (float)(1 * window.method_4495())) {
                        ySnapped = true;
                        y = snapY - (float)this.draggedFeature.getAnchorPoint().getY(window.method_4502()) - scaledHeight / 2.0f;
                    }
                } else if (verticalSnap.getThisSnapEdge() == Edge.HORIZONTAL_MIDDLE && (snapOffset = Math.abs(floatMouseY - this.yOffset - snapY)) <= (float)(1 * window.method_4495())) {
                    ySnapped = true;
                    y = snapY - (float)this.draggedFeature.getAnchorPoint().getY(window.method_4502());
                }
            }
            if (!xSnapped) {
                x -= this.xOffset;
            }
            if (!ySnapped) {
                y -= this.yOffset;
            }
            if (xSnapped || ySnapped) {
                Pair<Float, Float> relativeCoords = this.draggedFeature.getRelativeCoords();
                float xChange = Math.abs(relativeCoords.getLeft().floatValue() - x);
                float yChange = Math.abs(relativeCoords.getRight().floatValue() - y);
                if ((double)xChange < 0.001 && (double)yChange < 0.001) {
                    return;
                }
            }
            this.draggedFeature.getFeatureData().setCoords(x, y);
            this.draggedFeature.setClosestAnchorPoint();
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        ButtonLocation lastHoveredButton = resizing ? this.buttonLocations.get((Object)this.draggedFeature) : this.getHoveredFeatureButton(mouseX, mouseY);
        this.rescaleWithScroll(lastHoveredButton, scrollX, scrollY);
        return super.method_25401(mouseX, mouseY, scrollX, scrollY);
    }

    private void rescaleWithScroll(ButtonLocation lastHoveredButton, double scrollX, double scrollY) {
        if (lastHoveredButton == null || editMode != EditMode.RESCALE_FEATURES) {
            return;
        }
        Feature lastHoveredFeature = lastHoveredButton.getFeature();
        if (lastHoveredFeature == null) {
            return;
        }
        float oldScale = lastHoveredFeature.getGuiScale();
        if (scrollX > 0.0 || scrollY > 0.0) {
            float newScale = oldScale + (class_3675.method_15987((class_1041)MC.method_22683(), (int)340) ? 1.0f : 0.1f);
            lastHoveredFeature.setGuiScale(newScale);
            this.recalculateResizeButtons();
        } else if (scrollX < 0.0 || scrollY < 0.0) {
            float newScale = oldScale - (class_3675.method_15987((class_1041)MC.method_22683(), (int)340) ? 1.0f : 0.1f);
            lastHoveredFeature.setGuiScale(newScale);
            this.recalculateResizeButtons();
        }
    }

    private void drawFeatureCoords(class_332 graphics, ButtonLocation lastHoveredButton) {
        if (editMode != EditMode.NONE) {
            FeatureGuiData guiFeatureData;
            class_1041 window = MC.method_22683();
            double x = (double)window.method_4486() / 2.0;
            double y = (double)window.method_4502() / 2.0;
            int boxCount = (int)Math.ceil((double)Feature.getEditGuiFeatures().size() / 2.0);
            if (Feature.DEVELOPER_MODE.isEnabled()) {
                String mouse = String.format("mouseX: %.0f, mouseY: %.0f", LocationEditGui.MC.field_1729.method_1603(), LocationEditGui.MC.field_1729.method_1604());
                DrawUtils.drawText(graphics, mouse, (int)(x - (double)((float)LocationEditGui.MC.field_1772.method_1727(mouse) / 2.0f)), (int)(y - (double)(boxCount * 20) - 37.0), ColorCode.RED.getColor(), true);
            }
            if (lastHoveredButton == null) {
                return;
            }
            Feature lastHoveredButtonFeature = lastHoveredButton.getFeature();
            Object featureName = lastHoveredButtonFeature.getMessage(new String[0]);
            if (Feature.DEVELOPER_MODE.isEnabled()) {
                featureName = (String)featureName + " (" + lastHoveredButtonFeature.getId() + ")";
            }
            DrawUtils.drawText(graphics, (String)featureName, (int)(x - (double)((float)LocationEditGui.MC.field_1772.method_1727((String)featureName) / 2.0f)), (int)(y - (double)(boxCount * 20) - 25.0), ColorCode.AQUA.getColor(), true);
            String info = String.format("x=%.0f, y=%.0f, scale=%.2f", Float.valueOf(lastHoveredButtonFeature.getActualX() * 2.0f), Float.valueOf(lastHoveredButtonFeature.getActualY() * 2.0f), Float.valueOf(lastHoveredButton.getScale()));
            DrawUtils.drawText(graphics, info, (int)(x - (double)((float)LocationEditGui.MC.field_1772.method_1727(info) / 2.0f)), (int)(y - (double)(boxCount * 20) - 12.0), ColorCode.YELLOW.getColor(), true);
            if (lastHoveredButtonFeature.isGuiFeature() && (guiFeatureData = lastHoveredButtonFeature.getFeatureGuiData()).getDrawType() == EnumUtils.DrawType.BAR) {
                String barScales = String.format("scaleX = %.2f, scaleY = %.2f", Float.valueOf(lastHoveredButton.getScaleX()), Float.valueOf(lastHoveredButton.getScaleY()));
                DrawUtils.drawText(graphics, barScales, (int)(x - (double)((float)LocationEditGui.MC.field_1772.method_1727(barScales) / 2.0f)), (int)(y - (double)(boxCount * 20)), ColorCode.YELLOW.getColor(), true);
            }
        }
    }

    private void actionPerformed(class_364 eventListener, class_11909 event) {
        class_364 class_3642 = eventListener;
        Objects.requireNonNull(class_3642);
        class_364 class_3643 = class_3642;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ButtonLocation.class, ButtonSolid.class, ButtonResize.class}, (Object)class_3643, n)) {
                case 0: {
                    ButtonLocation buttonLocation = (ButtonLocation)class_3643;
                    this.draggedFeature = buttonLocation.getFeature();
                    if (this.draggedFeature == null) break block5;
                    this.xOffset = (float)event.comp_4798() - this.draggedFeature.getActualX();
                    this.yOffset = (float)event.comp_4799() - this.draggedFeature.getActualY();
                    break block5;
                }
                case 1: {
                    ButtonSolid buttonSolid = (ButtonSolid)class_3643;
                    Feature feature = buttonSolid.getFeature();
                    if (feature == Feature.RESET_LOCATION) {
                        main.getConfigValuesManager().setAllCoordinatesToDefault();
                        main.getConfigValuesManager().putDefaultBarSizes();
                        break block5;
                    }
                    if (feature == Feature.SHOW_COLOR_ICONS) {
                        Feature.SHOW_COLOR_ICONS.setEnabled(!Feature.SHOW_COLOR_ICONS.isEnabled());
                        if (Feature.SHOW_COLOR_ICONS.isEnabled()) {
                            this.addColorWheelsToAllFeatures();
                            break block5;
                        }
                        this.clearAllColorWheelButtons();
                        break block5;
                    }
                    if (feature != Feature.ENABLE_FEATURE_SNAPPING) break block5;
                    Feature.ENABLE_FEATURE_SNAPPING.setEnabled(!Feature.ENABLE_FEATURE_SNAPPING.isEnabled());
                    break block5;
                }
                case 2: {
                    ButtonResize buttonResize = (ButtonResize)class_3643;
                    if (editMode == EditMode.NONE) {
                        n = 3;
                        continue block5;
                    }
                    this.draggedFeature = buttonResize.getFeature();
                    resizing = true;
                    if (editMode == EditMode.RESCALE_FEATURES) {
                        float scale = this.draggedFeature.getGuiScale();
                        this.xOffset = ((float)event.comp_4798() - buttonResize.resizeX * scale) / scale;
                        this.yOffset = ((float)event.comp_4799() - buttonResize.resizeY * scale) / scale;
                    } else {
                        this.xOffset = (float)event.comp_4798();
                        this.yOffset = (float)event.comp_4799();
                    }
                    this.resizingCorner = buttonResize.getCorner();
                    break block5;
                }
            }
            break;
        }
    }

    @Override
    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        Optional<class_364> optional;
        this.isMiddlePressed = false;
        if (event.method_74245() == 1) {
            ButtonLocation lastHoveredButton;
            ButtonLocation buttonLocation = lastHoveredButton = resizing ? this.buttonLocations.get((Object)this.draggedFeature) : this.getHoveredFeatureButton(event.comp_4798(), event.comp_4799());
            if (lastHoveredButton != null) {
                main.getConfigValuesManager().putDefaultGuiScale(lastHoveredButton.getFeature());
            }
        } else if (event.method_74245() == 2) {
            this.isMiddlePressed = true;
        }
        if (Feature.DUNGEONS_MAP_DISPLAY.isEnabled(FeatureSetting.CHANGE_DUNGEON_MAP_ZOOM_WITH_KEYBOARD)) {
            if (SkyblockKeyBinding.DECREASE_DUNGEON_MAP_ZOOM.isDown()) {
                DungeonMapManager.decreaseZoomByStep();
            } else if (SkyblockKeyBinding.INCREASE_DUNGEON_MAP_ZOOM.isDown()) {
                DungeonMapManager.increaseZoomByStep();
            }
        }
        if ((optional = this.method_19355(event.comp_4798(), event.comp_4799())).isEmpty()) {
            return false;
        }
        class_364 guiEventListener = optional.get();
        if (guiEventListener.method_25402(event, isDoubleClick)) {
            this.method_25395(guiEventListener);
            if (event.method_74245() == 0) {
                this.method_25398(true);
            }
            this.actionPerformed(guiEventListener, event);
        }
        return true;
    }

    public boolean method_25404(class_11908 event) {
        Feature hoveredFeature = ButtonLocation.getLastHoveredFeature();
        if (hoveredFeature != null) {
            int xOffset = 0;
            int yOffset = 0;
            switch (event.comp_4795()) {
                case 263: {
                    --xOffset;
                    break;
                }
                case 265: {
                    --yOffset;
                    break;
                }
                case 262: {
                    ++xOffset;
                    break;
                }
                case 264: {
                    ++yOffset;
                    break;
                }
                case 65: {
                    xOffset -= 10;
                    break;
                }
                case 87: {
                    yOffset -= 10;
                    break;
                }
                case 68: {
                    xOffset += 10;
                    break;
                }
                case 83: {
                    yOffset += 10;
                }
            }
            Pair<Float, Float> relativeCoords = hoveredFeature.getRelativeCoords();
            hoveredFeature.getFeatureData().setCoords(relativeCoords.getLeft().floatValue() + (float)xOffset, relativeCoords.getRight().floatValue() + (float)yOffset);
        }
        if (Feature.DUNGEONS_MAP_DISPLAY.isEnabled(FeatureSetting.CHANGE_DUNGEON_MAP_ZOOM_WITH_KEYBOARD)) {
            if (event.comp_4795() == SkyblockKeyBinding.DECREASE_DUNGEON_MAP_ZOOM.getKeyCode()) {
                DungeonMapManager.decreaseZoomByStep();
            } else if (event.comp_4795() == SkyblockKeyBinding.INCREASE_DUNGEON_MAP_ZOOM.getKeyCode()) {
                DungeonMapManager.increaseZoomByStep();
            }
        }
        return super.method_25404(event);
    }

    public boolean method_25406(class_11909 event) {
        if (event.method_74245() == 0 && this.method_25397()) {
            this.draggedFeature = null;
            resizing = false;
            this.method_25398(false);
            if (this.method_25399() != null) {
                return this.method_25399().method_25406(event);
            }
        }
        return this.method_19355(event.comp_4798(), event.comp_4799()).filter(guiEventListener -> guiEventListener.method_25406(event)).isPresent();
    }

    public void method_25432() {
        main.getConfigValuesManager().saveConfig();
        if (this.lastTab != null && !this.closing) {
            main.getRenderListener().setGuiToOpen(EnumUtils.GUIType.MAIN, this.lastPage, this.lastTab);
        }
    }

    @Generated
    public static EditMode getEditMode() {
        return editMode;
    }

    @Generated
    public static boolean isResizing() {
        return resizing;
    }

    @Generated
    public int getLastPage() {
        return this.lastPage;
    }

    @Generated
    public EnumUtils.GuiTab getLastTab() {
        return this.lastTab;
    }

    @Generated
    public void setClosing(boolean closing) {
        this.closing = closing;
    }

    static {
        tipShown = false;
    }

    public static enum EditMode implements ButtonCycling.SelectItem
    {
        RESCALE_FEATURES("messages.rescaleFeatures"),
        RESIZE_BARS("messages.resizeBars"),
        NONE("messages.none");

        private final String TRANSLATION_KEY;

        private EditMode(String translationKey) {
            this.TRANSLATION_KEY = translationKey;
        }

        @Override
        public String getDisplayName() {
            return Translations.getMessage(this.TRANSLATION_KEY, new Object[0]);
        }

        @Override
        public String getDescription() {
            return null;
        }
    }

    public static class Snap {
        private final Edge thisSnapEdge;
        private final Edge otherSnapEdge;
        private final float snapValue;
        private final Map<Edge, Float> rectangle = new EnumMap<Edge, Float>(Edge.class);

        public Snap(float left, float top, float right, float bottom, Edge thisSnapEdge, Edge otherSnapEdge, float snapValue) {
            this.rectangle.put(Edge.LEFT, Float.valueOf(left));
            this.rectangle.put(Edge.TOP, Float.valueOf(top));
            this.rectangle.put(Edge.RIGHT, Float.valueOf(right));
            this.rectangle.put(Edge.BOTTOM, Float.valueOf(bottom));
            this.rectangle.put(Edge.HORIZONTAL_MIDDLE, Float.valueOf(top + this.getHeight() / 2.0f));
            this.rectangle.put(Edge.VERTICAL_MIDDLE, Float.valueOf(left + this.getWidth() / 2.0f));
            this.otherSnapEdge = otherSnapEdge;
            this.thisSnapEdge = thisSnapEdge;
            this.snapValue = snapValue;
        }

        public float getHeight() {
            return this.rectangle.get((Object)Edge.BOTTOM).floatValue() - this.rectangle.get((Object)Edge.TOP).floatValue();
        }

        public float getWidth() {
            return this.rectangle.get((Object)Edge.RIGHT).floatValue() - this.rectangle.get((Object)Edge.LEFT).floatValue();
        }

        @Generated
        public Edge getThisSnapEdge() {
            return this.thisSnapEdge;
        }

        @Generated
        public Edge getOtherSnapEdge() {
            return this.otherSnapEdge;
        }

        @Generated
        public float getSnapValue() {
            return this.snapValue;
        }

        @Generated
        public Map<Edge, Float> getRectangle() {
            return this.rectangle;
        }
    }

    public static enum Edge {
        LEFT,
        TOP,
        RIGHT,
        BOTTOM,
        HORIZONTAL_MIDDLE,
        VERTICAL_MIDDLE;

        private static final Set<Edge> verticalEdges;
        private static final Set<Edge> horizontalEdges;

        public float getCoordinate(ButtonLocation button) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> button.getBoxXOne() * button.getScale() * button.getScaleX();
                case 1 -> button.getBoxYOne() * button.getScale() * button.getScaleY();
                case 2 -> button.getBoxXTwo() * button.getScale() * button.getScaleX();
                case 3 -> button.getBoxYTwo() * button.getScale() * button.getScaleY();
                case 4 -> TOP.getCoordinate(button) + (BOTTOM.getCoordinate(button) - TOP.getCoordinate(button)) / 2.0f;
                case 5 -> LEFT.getCoordinate(button) + (RIGHT.getCoordinate(button) - LEFT.getCoordinate(button)) / 2.0f;
            };
        }

        @Generated
        public static Set<Edge> getVerticalEdges() {
            return verticalEdges;
        }

        @Generated
        public static Set<Edge> getHorizontalEdges() {
            return horizontalEdges;
        }

        static {
            verticalEdges = Sets.newHashSet((Object[])new Edge[]{TOP, BOTTOM, HORIZONTAL_MIDDLE});
            horizontalEdges = Sets.newHashSet((Object[])new Edge[]{LEFT, RIGHT, VERTICAL_MIDDLE});
        }
    }
}

