/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.libautoupdate;

import com.fix3dll.skyblockaddons.libautoupdate.JsonUpdateSource;
import com.fix3dll.skyblockaddons.libautoupdate.UpdateData;
import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

public final class GistSource
extends JsonUpdateSource {
    @NonNull
    private final String owner;
    @NonNull
    private final String gistId;
    private static final String GIST_RAW_URL = "https://gist.githubusercontent.com/%s/%s/raw/%s.json";

    @Override
    public CompletableFuture<UpdateData> checkUpdate(String updateStream) {
        return this.getJsonFromURL(String.format(GIST_RAW_URL, this.owner, this.gistId, updateStream), (Type)((Object)UpdateData.class));
    }

    public GistSource(@NonNull String owner, @NonNull String gistId) {
        if (owner == null) {
            throw new NullPointerException("owner is marked non-null but is null");
        }
        if (gistId == null) {
            throw new NullPointerException("gistId is marked non-null but is null");
        }
        this.owner = owner;
        this.gistId = gistId;
    }

    @NonNull
    public String getOwner() {
        return this.owner;
    }

    @NonNull
    public String getGistId() {
        return this.gistId;
    }

    public String toString() {
        return "GistSource(owner=" + this.getOwner() + ", gistId=" + this.getGistId() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GistSource)) {
            return false;
        }
        GistSource other = (GistSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$gistId = this.getGistId();
        String other$gistId = other.getGistId();
        return !(this$gistId == null ? other$gistId != null : !this$gistId.equals(other$gistId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GistSource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $gistId = this.getGistId();
        result = result * 59 + ($gistId == null ? 43 : $gistId.hashCode());
        return result;
    }
}

