/*
 * Decompiled with CFR 0.152.
 */
package com.fix3dll.skyblockaddons.listeners;

import com.fix3dll.skyblockaddons.SkyblockAddons;
import com.fix3dll.skyblockaddons.core.Island;
import com.fix3dll.skyblockaddons.core.feature.Feature;
import com.fix3dll.skyblockaddons.core.scheduler.ScheduledTask;
import com.fix3dll.skyblockaddons.events.PacketEvents;
import com.fix3dll.skyblockaddons.events.SkyblockEvents;
import com.fix3dll.skyblockaddons.features.slayertracker.SlayerTracker;
import com.fix3dll.skyblockaddons.utils.EnumUtils;
import com.fix3dll.skyblockaddons.utils.ItemUtils;
import com.fix3dll.skyblockaddons.utils.LocationUtils;
import com.fix3dll.skyblockaddons.utils.Utils;
import com.fix3dll.skyblockaddons.utils.data.DataUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.hypixel.data.type.GameType;
import net.hypixel.modapi.HypixelModAPI;
import net.hypixel.modapi.packet.impl.clientbound.event.ClientboundLocationPacket;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_2596;
import net.minecraft.class_2775;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_638;
import org.apache.logging.log4j.Logger;

public class NetworkListener {
    private static final Logger LOGGER = SkyblockAddons.getLogger();
    private static final SkyblockAddons main = SkyblockAddons.getInstance();
    private ScheduledTask updateHealth;
    private final Cache<Integer, Integer> collectedCache = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.SECONDS).build();

    public NetworkListener() {
        SkyblockEvents.JOINED.register(this::onSkyblockJoined);
        SkyblockEvents.LEFT.register(this::onSkyblockLeft);
        ClientPlayConnectionEvents.DISCONNECT.register(this::onPlayDisconnect);
        PacketEvents.READ.register(this::onPacketRead);
    }

    private void onSkyblockJoined() {
        LOGGER.info("Detected joining skyblock!");
        main.getUtils().setOnSkyblock(true);
        if (Feature.DISCORD_RPC.isEnabled()) {
            main.getDiscordRPCManager().start();
        }
        this.updateHealth = main.getScheduler().scheduleTask(scheduledTask -> main.getPlayerListener().updateLastSecondHealth(), 0, 20);
        DataUtils.onSkyblockJoined();
    }

    private void onSkyblockLeft() {
        LOGGER.info("Detected leaving skyblock!");
        main.getUtils().setOnSkyblock(false);
        main.getUtils().setProfileName("Unknown");
        if (main.getDiscordRPCManager().isActive()) {
            main.getDiscordRPCManager().stop();
        }
        if (this.updateHealth != null) {
            this.updateHealth.cancel();
            this.updateHealth = null;
        }
    }

    private void onPacketRead(ChannelHandlerContext channelHandlerContext, class_2596<?> packet) {
        class_638 level = class_310.method_1551().field_1687;
        if (!main.getUtils().isOnSkyblock() || level == null) {
            return;
        }
        if (packet instanceof class_2775) {
            class_2775 takeItemPacket = (class_2775)packet;
            if (!SlayerTracker.getInstance().isTrackerEnabled()) {
                return;
            }
            EnumUtils.SlayerQuest activeQuest = main.getUtils().getSlayerQuest();
            if (activeQuest == null || !LocationUtils.isOnSlayerLocation(activeQuest)) {
                return;
            }
            int entityID = takeItemPacket.method_11915();
            class_1297 entity = level.method_8469(entityID);
            if (!(entity instanceof class_1542)) {
                return;
            }
            class_1542 itemEntity = (class_1542)entity;
            if (this.collectedCache.getIfPresent((Object)entityID) != null) {
                return;
            }
            this.collectedCache.put((Object)entityID, (Object)0);
            class_1799 itemStack = itemEntity.method_6983();
            SlayerTracker.getInstance().addToTrackerData(ItemUtils.getExtraAttributes(itemStack), itemStack.method_7947(), activeQuest);
        }
    }

    private void onPlayDisconnect(class_634 clientPacketListener, class_310 minecraft) {
        ((SkyblockEvents.SkyblockLeft)SkyblockEvents.LEFT.invoker()).onSkyblockLeft();
    }

    public static void setupModAPI() {
        HypixelModAPI modApi = HypixelModAPI.getInstance();
        modApi.createHandler(ClientboundLocationPacket.class, packet -> {
            if (Feature.DEVELOPER_MODE.isEnabled()) {
                LOGGER.info(packet.toString());
            }
            String mode = packet.getMode().orElse("null");
            main.getUtils().setMode(mode);
            main.getUtils().setMap(Island.getByMode(mode));
            main.getUtils().setServerID(packet.getServerName());
            if (packet.getServerType().orElse(null) == GameType.SKYBLOCK) {
                if (Feature.DISCORD_RPC.isEnabled() && !main.getDiscordRPCManager().isActive()) {
                    main.getDiscordRPCManager().start();
                }
            } else if (main.getUtils().isOnSkyblock()) {
                ((SkyblockEvents.SkyblockLeft)SkyblockEvents.LEFT.invoker()).onSkyblockLeft();
            }
        }).onError(reason -> {
            Utils utils = SkyblockAddons.getInstance().getUtils();
            Utils.sendMessage("ModAPI packet failed: " + String.valueOf(reason));
            utils.setMap(Island.UNKNOWN);
            utils.setMode("null");
        });
        modApi.subscribeToEventPacket(ClientboundLocationPacket.class);
    }
}

